/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIBEAST {
    public static AISTATE[] beastIdle = new AISTATE[2];
    public static AISTATE[] beastSearch = new AISTATE[2];
    public static AISTATE[] beastGoto = new AISTATE[2];
    public static AISTATE[] beastDodge = new AISTATE[2];
    public static AISTATE[] beastChase = new AISTATE[2];
    public static AISTATE[] beastRecoil = new AISTATE[2];
    public static AISTATE[] beastHack = new AISTATE[2];
    public static AISTATE beastRTesla;
    public static AISTATE beastStomps;
    public static AISTATE beastTransforming;
    public static AISTATE beastTransform;
    public static AISTATE beastUp;

    public static void Init() {
        AIBEAST.beastIdle[0] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIBEAST.beastIdle[1] = new AISTATE(AISTATEFUNC.Type.idle, 9, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIBEAST.beastChase[0] = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkChase(sprite, xsprite);
            }
        };
        AIBEAST.beastChase[1] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForwardWater(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkChaseWater(sprite, xsprite);
            }
        };
        AIBEAST.beastDodge[0] = new AISTATE(AISTATEFUNC.Type.other, 8, null, 60, false, true, false, beastChase[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIBEAST.beastDodge[1] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 90, false, true, false, beastChase[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIBEAST.beastGoto[0] = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 600, false, true, true, beastIdle[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkGoto(sprite, xsprite);
            }
        };
        AIBEAST.beastGoto[1] = new AISTATE(AISTATEFUNC.Type.tgoto, 9, null, 600, false, true, true, beastIdle[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkGotoWater(sprite, xsprite);
            }
        };
        AIBEAST.beastHack[0] = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIBEAST.HackCallback(nXSprite);
            }
        }, 120, false, false, false, beastChase[0]);
        AIBEAST.beastHack[1] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 120, false, false, true, beastChase[1]){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkChaseWater(sprite, xsprite);
            }
        };
        beastStomps = new AISTATE(AISTATEFUNC.Type.other, 7, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIBEAST.StompsCallback(nXSprite);
            }
        }, 120, false, false, false, beastChase[0]);
        AIBEAST.beastSearch[0] = new AISTATE(AISTATEFUNC.Type.search, 8, null, 120, false, true, true, beastIdle[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkSearch(sprite, xsprite);
            }
        };
        AIBEAST.beastSearch[1] = new AISTATE(AISTATEFUNC.Type.search, 9, null, 120, false, true, true, beastIdle[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkSearch(sprite, xsprite);
            }
        };
        AIBEAST.beastRecoil[0] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, beastDodge[0]);
        AIBEAST.beastRecoil[1] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, beastDodge[1]);
        beastRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, beastDodge[0]);
        beastTransform = new AISTATE(AISTATEFUNC.Type.other, -1, null, 0, true, false, false, beastIdle[0]){

            @Override
            public void enter(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkTransform(sprite, xsprite);
            }
        };
        beastTransforming = new AISTATE(AISTATEFUNC.Type.other, 2576, null, 0, false, false, false, beastTransform);
        beastUp = new AISTATE(AISTATEFUNC.Type.other, 9, null, 0, false, true, true, beastChase[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.myMoveTarget(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBEAST.thinkChaseWater(sprite, xsprite);
            }
        };
    }

    private static void myMoveTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            pSprite.ang = (short)(pSprite.ang + 512 & 0x7FF);
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(8192) || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long vel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            vel = (vel >> 1) + (long)Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            int z1 = 0;
            if (pXSprite.target != -1) {
                SPRITE pTarget = Engine.sprite[pXSprite.target];
                z1 = pTarget.z;
                if (Actor.IsDudeSprite(pTarget)) {
                    z1 += DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight;
                }
            }
            int z2 = pSprite.z + pDudeInfo.eyeHeight;
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = 8 * (z1 - z2);
        }
    }

    private static void myMoveForward(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (Main.engine.qdist(dx, dy) > 1024L || Gameutils.Random(64) >= 32) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            short s = pSprite.xvel;
            Actor.sprXVel[s] = Actor.sprXVel[s] + (long)Pragmas.mulscale(cos, pDudeInfo.frontSpeed, 30);
            short s2 = pSprite.xvel;
            Actor.sprYVel[s2] = Actor.sprYVel[s2] + (long)Pragmas.mulscale(sin, pDudeInfo.frontSpeed, 30);
        }
    }

    private static void myMoveForwardWater(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.target == -1) {
            pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (Gameutils.Random(64) >= 32 || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            vel = pXSprite.target == -1 ? (vel += (long)fvel) : (vel += (long)(fvel >> 2));
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
        }
    }

    private static void HackCallback(int nXSprite) {
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        int nSprite = DB.xsprite[nXSprite].reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pXSprite.target == -1) {
            return;
        }
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int dz = pSprite.z - Engine.sprite[pXSprite.target].z;
        Actor.actFireVector(pSprite, 0, 0, dx += Gameutils.BiRandom2(4000 - 700 * Globals.pGameInfo.nDifficulty), dy += Gameutils.BiRandom2(4000 - 700 * Globals.pGameInfo.nDifficulty), dz, 13);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 13);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 13);
        SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 9012, -1, 0);
    }

    private static void StompsCallback(int nXSprite) {
        SPRITE pTarget;
        int nSprite = DB.xsprite[nXSprite].reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        int radius = 6400;
        int minDamage = 2 * Globals.pGameInfo.nDifficulty + 5;
        int maxDamage = 30 * Globals.pGameInfo.nDifficulty + 25;
        Actor.gSectorExp[0] = -1;
        Actor.gWallExp[0] = -1;
        Gameutils.NearSectors(pSprite.sectnum, pSprite.x, pSprite.y, 400, Actor.gSectorExp, Actor.gSpriteExp, Actor.gWallExp);
        short nTarget = Engine.headspritestat[6];
        while (nTarget >= 0) {
            if (nTarget != nSprite) {
                pTarget = Engine.sprite[nTarget];
                short nXTarget = pTarget.extra;
                if (nXTarget > 0 && nXTarget < 2048 && pTarget.lotag != 251 && (pTarget.hitag & 0x20) == 0 && (Actor.gSpriteExp[pTarget.sectnum >> 3] & 1 << (pTarget.sectnum & 7)) != 0 && Gameutils.CheckProximity(pTarget, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, radius)) {
                    int dist;
                    Gameutils.GetSpriteExtents(pSprite);
                    if (Gameutils.extents_zBot - Engine.sector[pSprite.sectnum].floorz == 0 && (dist = Main.engine.ksqrt((pSprite.x - pTarget.x) * (pSprite.x - pTarget.x) + (pSprite.y - pTarget.y) * (pSprite.y - pTarget.y))) <= radius) {
                        int damage = minDamage + maxDamage;
                        if (dist != 0) {
                            damage = minDamage + maxDamage * (radius - dist) / radius;
                        }
                        if (Gameutils.IsPlayerSprite(pTarget)) {
                            PLAYER pPlayer = Globals.gPlayer[pTarget.lotag - 231];
                            pPlayer.quakeTime += damage << 2;
                        }
                        Actor.actDamageSprite(nSprite, pTarget, 0, damage << 4);
                    }
                }
            }
            nTarget = Engine.nextspritestat[nTarget];
        }
        nTarget = Engine.headspritestat[4];
        while (nTarget >= 0) {
            int dist;
            pTarget = Engine.sprite[nTarget];
            if ((pTarget.hitag & 0x20) == 0 && (Actor.gSpriteExp[pTarget.sectnum >> 3] & 1 << (pTarget.sectnum & 7)) != 0 && DB.xsprite[pTarget.extra].Locked == 0 && Gameutils.CheckProximity(pTarget, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, radius) && (dist = Main.engine.ksqrt((pSprite.x - pTarget.x) * (pSprite.x - pTarget.x) + (pSprite.y - pTarget.y) * (pSprite.y - pTarget.y))) <= radius) {
                int damage = minDamage + maxDamage;
                if (dist != 0) {
                    damage = minDamage + maxDamage * (radius - dist) / radius;
                }
                Actor.actDamageSprite(nSprite, pTarget, 0, damage << 4);
            }
            nTarget = Engine.nextspritestat[nTarget];
        }
        SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 9015, -1, 0);
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        short nXSector = Engine.sector[pSprite.sectnum].extra;
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[0]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGotoWater(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkTransform(SPRITE pSprite, XSPRITE pXSPrite) {
        Actor.actHealDude(pXSPrite, DudeInfo.dudeInfo[51].startHealth, DudeInfo.dudeInfo[51].startHealth);
        pSprite.lotag = (short)251;
    }

    private static void thinkChaseWater(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                if (Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.target);
                    if (dist < 1024 && Pragmas.klabs(losAngle) < 85) {
                        Ai.aiNewState(pSprite, pXSprite, beastHack[1]);
                        short nXSprite = pSprite.extra;
                        if (!DEMO.IsOriginalDemo() && SeqHandling.seqFrame(3, nXSprite) == 1) {
                            AIBEAST.HackCallback(nXSprite);
                        }
                        return;
                    }
                    Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 9009, 1, -1);
                    Ai.aiNewState(pSprite, pXSprite, beastUp);
                    return;
                }
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastUp);
            }
        } else {
            Ai.aiNewState(pSprite, pXSprite, beastGoto[1]);
            pXSprite.target = -1;
        }
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        short nXSector = Engine.sector[pSprite.sectnum].extra;
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
        }
        if (pXSprite.target == -1) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[0]);
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[0]);
            }
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[0]);
            }
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                if (Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.target);
                    short nXSprite = Engine.sprite[pXSprite.reference].extra;
                    if (dist > 0) {
                        Ai.gDudeSlope[nXSprite] = Pragmas.divscale(pTarget.z - pSprite.z, dist, 10);
                    }
                    int hitType = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                    if (dist < 5120 && dist > 2560 && Pragmas.klabs(losAngle) < 85 && (pTarget.hitag & 2) != 0 && Gameutils.IsPlayerSprite(pTarget) && Gameutils.Chance(16384) && pXTarget.health > DudeInfo.gPlayerTemplate[0].startHealth / 2) {
                        if (hitType == 3 && Engine.sprite[Engine.pHitInfo.hitsprite].lotag == pSprite.lotag) {
                            if (pXSector != null && pXSector.Underwater) {
                                Ai.aiNewState(pSprite, pXSprite, beastDodge[1]);
                            } else {
                                Ai.aiNewState(pSprite, pXSprite, beastDodge[0]);
                            }
                            return;
                        }
                        if (pXSector == null || !pXSector.Underwater) {
                            Ai.aiNewState(pSprite, pXSprite, beastStomps);
                        }
                    }
                    if (dist < 921 && Pragmas.klabs(losAngle) < 28) {
                        if (hitType == 3 && Engine.sprite[Engine.pHitInfo.hitsprite].lotag == pSprite.lotag) {
                            if (pXSector != null && pXSector.Underwater) {
                                Ai.aiNewState(pSprite, pXSprite, beastDodge[1]);
                            } else {
                                Ai.aiNewState(pSprite, pXSprite, beastDodge[0]);
                            }
                            return;
                        }
                        if (pXSector != null && pXSector.Underwater) {
                            Ai.aiNewState(pSprite, pXSprite, beastHack[1]);
                        } else {
                            Ai.aiNewState(pSprite, pXSprite, beastHack[0]);
                        }
                    }
                }
                return;
            }
        }
        if (pXSector != null && pXSector.Underwater) {
            Ai.aiNewState(pSprite, pXSprite, beastGoto[1]);
        } else {
            Ai.aiNewState(pSprite, pXSprite, beastGoto[0]);
        }
        pXSprite.target = -1;
    }
}

