/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIGILLBEAST {
    public static AISTATE[] gillBeastIdle = new AISTATE[2];
    public static AISTATE[] gillBeastChase = new AISTATE[2];
    public static AISTATE[] gillBeastSearch = new AISTATE[2];
    public static AISTATE[] gillBeastGoto = new AISTATE[2];
    public static AISTATE[] gillBeastDodge = new AISTATE[2];
    public static AISTATE[] gillBeastHack = new AISTATE[2];
    public static AISTATE[] gillBeastRecoil = new AISTATE[2];
    public static AISTATE gillBeastAttack;

    public static void Init() {
        AIGILLBEAST.gillBeastIdle[0] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastChase[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkLandChase(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastDodge[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 90, false, true, false, gillBeastChase[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastGoto[0] = new AISTATE(AISTATEFUNC.Type.tgoto, 9, null, 600, false, true, true, gillBeastIdle[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkLandGoto(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastHack[0] = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIGILLBEAST.HackCallback(nXSprite);
            }
        }, 120, false, false, false, gillBeastChase[0]);
        AIGILLBEAST.gillBeastSearch[0] = new AISTATE(AISTATEFUNC.Type.search, 9, null, 120, false, true, true, gillBeastIdle[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkSearch(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastRecoil[0] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, gillBeastDodge[0]);
        AIGILLBEAST.gillBeastIdle[1] = new AISTATE(AISTATEFUNC.Type.idle, 10, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastChase[1] = new AISTATE(AISTATEFUNC.Type.other, 10, null, 600, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.aiMoveChase(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkWaterChase(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastDodge[1] = new AISTATE(AISTATEFUNC.Type.other, 10, null, 90, false, true, false, gillBeastChase[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastGoto[1] = new AISTATE(AISTATEFUNC.Type.tgoto, 10, null, 600, false, true, true, gillBeastIdle[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkWaterGoto(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastSearch[1] = new AISTATE(AISTATEFUNC.Type.search, 10, null, 120, false, true, true, gillBeastIdle[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkSearch(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastHack[1] = new AISTATE(AISTATEFUNC.Type.other, 7, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIGILLBEAST.HackCallback(nXSprite);
            }
        }, 0, false, false, true, gillBeastChase[1]){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkWaterChase(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastRecoil[1] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, gillBeastDodge[1]);
        gillBeastAttack = new AISTATE(AISTATEFUNC.Type.other, 10, null, 0, false, true, true, gillBeastChase[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.myMoveTarget(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkWaterChase(sprite, xsprite);
            }
        };
    }

    private static void myMoveTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            pSprite.ang = (short)(pSprite.ang + 512 & 0x7FF);
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(8192) || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long vel = Globals.kFrameTicks * (pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 27) / 120);
            vel = (vel >> 1) + (long)Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            int z1 = 0;
            if (pXSprite.target != -1) {
                SPRITE pTarget = Engine.sprite[pXSprite.target];
                z1 = pTarget.z;
                if (Actor.IsDudeSprite(pTarget)) {
                    z1 += DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight;
                }
            }
            int z2 = pSprite.z + pDudeInfo.eyeHeight;
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = 8 * (z1 - z2);
        }
    }

    private static void aiMoveChase(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.target == -1) {
            pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (Gameutils.Random(64) >= 32 || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long fvel = Globals.kFrameTicks * (pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 27) / 120);
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            vel = pXSprite.target == -1 ? (vel += fvel) : (vel += fvel >> 2);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
        }
    }

    private static void thinkLandGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            XSECTOR pXSector;
            XSECTOR xSECTOR = pXSector = Engine.sector[pSprite.sectnum].extra > 0 ? DB.xsector[Engine.sector[pSprite.sectnum].extra] : null;
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[0]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkLandChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        XSECTOR pXSector;
        XSECTOR xSECTOR = pXSector = Engine.sector[pSprite.sectnum].extra > 0 ? DB.xsector[Engine.sector[pSprite.sectnum].extra] : null;
        if (pXSprite.target == -1) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[0]);
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[0]);
            }
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[0]);
            }
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    int tan;
                    Ai.aiSetTarget(pXSprite, pXSprite.target);
                    int dz = pTarget.z - pSprite.z;
                    Ai.gDudeSlope[pSprite.extra] = tan = Pragmas.divscale(dz, dist, 10);
                    if (dist < 921 && Pragmas.klabs(losAngle) < 28) {
                        int nInfo = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                        if (nInfo == 3 && pSprite.lotag == Engine.sprite[Engine.pHitInfo.hitsprite].lotag) {
                            if (pXSector != null && pXSector.Underwater) {
                                Ai.aiNewState(pSprite, pXSprite, gillBeastDodge[1]);
                            } else {
                                Ai.aiNewState(pSprite, pXSprite, gillBeastDodge[0]);
                            }
                            return;
                        }
                        if (pXSector != null && pXSector.Underwater) {
                            Ai.aiNewState(pSprite, pXSprite, gillBeastHack[1]);
                        } else {
                            Ai.aiNewState(pSprite, pXSprite, gillBeastHack[0]);
                        }
                    }
                }
                return;
            }
        }
        if (pXSector != null && pXSector.Underwater) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastGoto[1]);
        } else {
            Ai.aiNewState(pSprite, pXSprite, gillBeastGoto[0]);
        }
        SOUND.sfxStart3DSound(pSprite, 1701, -1, 0);
        pXSprite.target = -1;
    }

    private static void thinkWaterChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastGoto[1]);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, -eyeAboveZ, pSprite.sectnum)) {
                if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.target);
                    if (dist < 1024 && Pragmas.klabs(losAngle) < 85) {
                        Ai.aiNewState(pSprite, pXSprite, gillBeastHack[1]);
                        return;
                    }
                    Ai.aiPlaySound(pSprite, 1700, 1, -1);
                    Ai.aiNewState(pSprite, pXSprite, gillBeastAttack);
                }
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastAttack);
            }
            return;
        }
        Ai.aiNewState(pSprite, pXSprite, gillBeastGoto[1]);
        pXSprite.target = -1;
    }

    private static void thinkWaterGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void HackCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int dz = pSprite.z;
        if (pXSprite.target != -1) {
            SPRITE pTarget = Engine.sprite[pXSprite.target];
            dz -= pTarget.z;
        }
        Actor.actFireVector(pSprite, 0, 0, dx += Gameutils.BiRandom2(2000), dy += Gameutils.BiRandom2(2000), dz, 8);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 8);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 8);
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }
}

