/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.WeaponAim;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AITCHERNOBOG {
    public static AISTATE tchernobogIdle;
    public static AISTATE tchernobogSearch;
    public static AISTATE tchernobogChase;
    public static AISTATE tchernobogDodge;
    public static AISTATE tchernobogRecoil;
    public static AISTATE tchernobogGoto;
    public static AISTATE tchernobogTurn;
    public static AISTATE tchernobogBurn;
    public static AISTATE tchernobogShoot;
    public static AISTATE tchernobogShootTarget;
    private static WeaponAim gMissileData;

    static {
        gMissileData = new WeaponAim(65536, 65536, 256, 85, 0x100000);
    }

    public static void Init() {
        tchernobogIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AITCHERNOBOG.myThinkTarget(sprite, xsprite);
            }
        };
        tchernobogSearch = new AISTATE(AISTATEFUNC.Type.search, 8, null, 1800, false, true, true, tchernobogIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AITCHERNOBOG.thinkSearch(sprite, xsprite);
            }
        };
        tchernobogChase = new AISTATE(AISTATEFUNC.Type.other, 8, null, 1800, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AITCHERNOBOG.thinkChase(sprite, xsprite);
            }
        };
        tchernobogRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, tchernobogSearch);
        tchernobogGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 600, false, true, true, tchernobogIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AITCHERNOBOG.thinkGoto(sprite, xsprite);
            }
        };
        tchernobogShoot = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AITCHERNOBOG.ShootCallback(nXSprite);
            }
        }, 60, false, false, false, tchernobogChase);
        tchernobogShootTarget = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AITCHERNOBOG.ShootTargetCallback(nXSprite);
            }
        }, 60, false, false, false, tchernobogChase);
        tchernobogBurn = new AISTATE(AISTATEFUNC.Type.other, 7, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AITCHERNOBOG.BurnCallback(nXSprite);
            }
        }, 60, false, false, false, tchernobogChase);
        tchernobogTurn = new AISTATE(AISTATEFUNC.Type.other, 8, null, 60, false, true, false, tchernobogChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }
        };
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, tchernobogGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, tchernobogSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, tchernobogSearch);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (Pragmas.klabs(losAngle) < 85) {
                    if (dist > 1280 && dist < 2816) {
                        Ai.aiNewState(pSprite, pXSprite, tchernobogShoot);
                    } else if (dist > 2816 && dist < 3328) {
                        Ai.aiNewState(pSprite, pXSprite, tchernobogShootTarget);
                    } else if (dist > 3328 && dist < 7936) {
                        Ai.aiNewState(pSprite, pXSprite, tchernobogBurn);
                    }
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, tchernobogGoto);
        pXSprite.target = -1;
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < 512 && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, tchernobogSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void myThinkTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (Ai.aiActive[pSprite.xvel] != 0) {
            if (Ai.aiThinkTime[pSprite.xvel] >= 10) {
                pXSprite.goalAng += 256;
                Vector3 kSprite = Trigger.ksprite[pSprite.xvel];
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                Ai.aiNewState(pSprite, pXSprite, tchernobogTurn);
                return;
            }
            short s = pSprite.xvel;
            Ai.aiThinkTime[s] = Ai.aiThinkTime[s] + 1;
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.health != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int eyeAboveZ;
                int x = pPlayer.pSprite.x;
                int y = pPlayer.pSprite.y;
                int z = pPlayer.pSprite.z;
                short nSector = pPlayer.pSprite.sectnum;
                int dx = x - pSprite.x;
                int dy = y - pSprite.y;
                int dist = (int)Main.engine.qdist(dx, dy);
                if ((dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) && Main.engine.cansee(x, y, z, nSector, pSprite.x, pSprite.y, pSprite.z - (eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2), pSprite.sectnum)) {
                    short nAngle = Main.engine.getangle(dx, dy);
                    int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
                    if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                        Ai.aiThinkTime[pSprite.xvel] = 0;
                        Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                    if (dist < pDudeInfo.hearDist) {
                        Ai.aiThinkTime[pSprite.xvel] = 0;
                        Ai.aiSetTarget(pXSprite, x, y, z);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    private static void BurnCallback(int nXIndex) {
        XSPRITE pXTarget;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pXSprite.target == -1) {
            return;
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE xSPRITE = pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        if (pXTarget == null) {
            return;
        }
        if (pXTarget.burnTime == 0) {
            EVENT.evPostCallback(pXSprite.target, 3, 0L, 0);
        }
        int burnTime = pTarget.statnum == 6 ? 2400 : 1200;
        pXTarget.burnTime = Gameutils.ClipHigh(pXTarget.burnTime + 40, burnTime);
        pXTarget.burnSource = Actor.actSetBurnSource(nSprite);
        if (Gameutils.Chance(12288)) {
            Ai.aiNewState(pSprite, pXSprite, tchernobogShootTarget);
        }
    }

    private static void ShootCallback(int nXIndex) {
        int ay;
        int ax;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
        int x = pSprite.x;
        int y = pSprite.y;
        int x2 = ax = Trig.Cos(pSprite.ang) >> 16;
        int y2 = ay = Trig.Sin(pSprite.ang) >> 16;
        int az = Ai.gDudeSlope[nXIndex];
        int closest = Integer.MAX_VALUE;
        short nDude = Engine.headspritestat[6];
        while (nDude >= 0) {
            SPRITE pDude = Engine.sprite[nDude];
            if (pDude != pSprite && (pDude.hitag & 8) != 0) {
                int tx = pDude.x;
                int ty = pDude.y;
                int tz = pDude.z;
                int dist = (int)Main.engine.qdist(tx - x, ty - y);
                if (dist != 0 && dist <= 10240) {
                    short ang;
                    int dy;
                    int dx;
                    int dist2;
                    if (AITCHERNOBOG.gMissileData.kSeeker != 0) {
                        int k = (dist << 12) / AITCHERNOBOG.gMissileData.kSeeker;
                        tx = (int)((long)tx + ((long)k * Actor.sprXVel[nDude] >> 12));
                        ty = (int)((long)ty + ((long)k * Actor.sprYVel[nDude] >> 12));
                        tz = (int)((long)tz + ((long)k * Actor.sprZVel[nDude] >> 8));
                    }
                    int z1 = Pragmas.mulscale(dist, Ai.gDudeSlope[nXIndex], 10) + eyeAboveZ;
                    int z2 = Pragmas.mulscale(9460L, dist, 10);
                    Gameutils.GetSpriteExtents(pDude);
                    if (z1 - z2 <= Gameutils.extents_zBot && z1 + z2 >= Gameutils.extents_zTop && (dist2 = Main.engine.ksqrt(((dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.ang), 30) + x) - tx >> 4) * (dx - tx >> 4) + ((dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.ang), 30) + y) - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) < closest && Pragmas.klabs(((ang = Main.engine.getangle(tx - x, ty - y)) - pSprite.ang + 1024 & 0x7FF) - 1024) <= AITCHERNOBOG.gMissileData.kDudeAngle) {
                        int dz = pDude.z - pSprite.z;
                        if (Main.engine.cansee(x, y, eyeAboveZ, pSprite.sectnum, tx, ty, tz, pDude.sectnum)) {
                            closest = dist2;
                            ax = Trig.Cos(ang) >> 16;
                            ay = Trig.Sin(ang) >> 16;
                            az = Pragmas.divscale(dz, dist, 10);
                        } else {
                            az = dz;
                        }
                    }
                }
            }
            nDude = Engine.nextspritestat[nDude];
        }
        Actor.actFireMissile(pSprite, 350, 0, ax, ay, -az, 314);
        Actor.actFireMissile(pSprite, -350, 0, x2, y2, 0, 314);
    }

    private static void ShootTargetCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
        int x = pSprite.x;
        int y = pSprite.y;
        int ax = Trig.Cos(pSprite.ang) >> 16;
        int ay = Trig.Sin(pSprite.ang) >> 16;
        int az = Ai.gDudeSlope[nXIndex];
        int closest = Integer.MAX_VALUE;
        short nDude = Engine.headspritestat[6];
        while (nDude >= 0) {
            SPRITE pDude = Engine.sprite[nDude];
            if (pDude != pSprite && (pDude.hitag & 8) != 0) {
                int tx = pDude.x;
                int ty = pDude.y;
                int tz = pDude.z;
                int dist = (int)Main.engine.qdist(tx - x, ty - y);
                if (dist != 0 && dist <= 10240) {
                    short ang;
                    int dy;
                    int dx;
                    int dist2;
                    if (AITCHERNOBOG.gMissileData.kSeeker != 0) {
                        int k = (dist << 12) / AITCHERNOBOG.gMissileData.kSeeker;
                        tx = (int)((long)tx + ((long)k * Actor.sprXVel[nDude] >> 12));
                        ty = (int)((long)ty + ((long)k * Actor.sprYVel[nDude] >> 12));
                        tz = (int)((long)tz + ((long)k * Actor.sprZVel[nDude] >> 8));
                    }
                    int z1 = Pragmas.mulscale(dist, Ai.gDudeSlope[nXIndex], 10) + eyeAboveZ;
                    int z2 = Pragmas.mulscale(9460L, dist, 10);
                    Gameutils.GetSpriteExtents(pDude);
                    if (z1 - z2 <= Gameutils.extents_zBot && z1 + z2 >= Gameutils.extents_zTop && (dist2 = Main.engine.ksqrt(((dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.ang), 30) + x) - tx >> 4) * (dx - tx >> 4) + ((dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.ang), 30) + y) - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) < closest && Pragmas.klabs(((ang = Main.engine.getangle(tx - x, ty - y)) - pSprite.ang + 1024 & 0x7FF) - 1024) <= AITCHERNOBOG.gMissileData.kDudeAngle) {
                        int dz = pDude.z - pSprite.z;
                        if (Main.engine.cansee(x, y, eyeAboveZ, pSprite.sectnum, tx, ty, tz, pDude.sectnum)) {
                            closest = dist2;
                            ax = Trig.Cos(ang) >> 16;
                            ay = Trig.Sin(ang) >> 16;
                            az = Pragmas.divscale(dz, dist, 10);
                        } else {
                            az = dz;
                        }
                    }
                }
            }
            nDude = Engine.nextspritestat[nDude];
        }
        Actor.actFireMissile(pSprite, -350, 0, ax, ay, az, 314);
        Actor.actFireMissile(pSprite, 350, 0, ax, ay, az, 314);
    }
}

