/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector2;
import java.util.Arrays;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class Gameutils {
    public static int extents_zTop;
    public static int extents_zBot;
    public static Vector2 normal;
    private static short[] handled;
    public static short foundSector;
    public static int clipm_px;
    public static int clipm_py;
    public static int clipm_pz;
    public static int clipm_pnsectnum;
    public static boolean clipmove_error;
    public static int gz_ceilZ;
    public static int gz_ceilHit;
    public static int gz_floorZ;
    public static int gz_floorHit;
    public static int bseed;
    public static int vseed;
    private static char[] buf;

    static {
        normal = new Vector2();
        handled = new short[Globals.kMaxSectors + 7 >> 3];
        vseed = 1;
        buf = new char[80];
    }

    public static int M2Z(double n) {
        return (int)(n * 8192.0);
    }

    public static int M2X(double n) {
        return (int)(n * 512.0);
    }

    public static void GetSpriteExtents(SPRITE pSprite) {
        extents_zTop = extents_zBot = pSprite.z;
        short nTile = pSprite.picnum;
        if (nTile == -1 || (pSprite.cstat & 0x30) == 32) {
            return;
        }
        BloodTile pic = Main.engine.getTile(nTile);
        extents_zTop -= (pic.getOffsetY() + pic.getHeight() / 2) * (pSprite.yrepeat << 2);
        extents_zBot += (pic.getHeight() - (pic.getHeight() / 2 + pic.getOffsetY())) * (pSprite.yrepeat << 2);
    }

    public static Engine.Point RotatePoint(int x, int y, int daang, int xpivot, int ypivot) {
        return Main.engine.rotatepoint(xpivot, ypivot, x, y, (short)daang);
    }

    public static boolean IsPlayerSprite(SPRITE pSprite) {
        return pSprite != null && pSprite.lotag >= 231 && pSprite.lotag <= 238;
    }

    public static int ClipRange(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static int ClipLow(int value, int min) {
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static int ClipHigh(int value, int max) {
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static float ClipLow(float value, int min) {
        if (value < (float)min) {
            value = min;
        }
        return value;
    }

    public static float ClipHigh(float value, int max) {
        if (value > (float)max) {
            value = max;
        }
        return value;
    }

    public static int GetWallAngle(int nWall) {
        int dx = Engine.wall[Engine.wall[nWall].point2].x - Engine.wall[nWall].x;
        int dy = Engine.wall[Engine.wall[nWall].point2].y - Engine.wall[nWall].y;
        return Main.engine.getangle(dx, dy);
    }

    public static void GetWallNormal(int nWall) {
        int ny;
        int nx;
        int length;
        if (nWall < 0 || nWall >= Globals.kMaxWalls) {
            Main.game.dassert("nWall >= 0 && nWall < kMaxWalls");
        }
        if ((length = Main.engine.ksqrt((nx = -(Engine.wall[Engine.wall[nWall].point2].y - Engine.wall[nWall].y) >> 4) * nx + (ny = Engine.wall[Engine.wall[nWall].point2].x - Engine.wall[nWall].x >> 4) * ny)) <= 0) {
            length = 1;
        }
        normal.set(Pragmas.divscale(nx, length, 16), Pragmas.divscale(ny, length, 16));
    }

    private static boolean checkDistance(int nPoint2, int x, int y, int distance) {
        int x1 = Engine.wall[nPoint2].x;
        int y1 = Engine.wall[nPoint2].y;
        nPoint2 = Engine.wall[nPoint2].point2;
        int x2 = Engine.wall[nPoint2].x;
        int y2 = Engine.wall[nPoint2].y;
        int dist2 = (distance *= 16) * distance;
        int dwx = x2 - x1;
        int dwy = y2 - y1;
        int dsx1 = x - x1;
        int dsx2 = x - x2;
        int dsy1 = y - y1;
        int dsy2 = y - y2;
        if (x1 >= x2) {
            if (x <= x2 - distance || x >= x1 + distance) {
                return false;
            }
            if (x1 == x2) {
                if (y1 >= y2) {
                    if (y <= y2 - distance || y >= y1 + distance) {
                        return false;
                    }
                    if (y < y2) {
                        return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
                    }
                    if (y > y1) {
                        return dsy1 * dsy1 + dsx1 * dsx1 < dist2;
                    }
                } else {
                    if (y <= y1 - distance || y >= y2 + distance) {
                        return false;
                    }
                    if (y < y1) {
                        return dsy1 * dsy1 + dsx1 * dsx1 < dist2;
                    }
                    if (y > y2) {
                        return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
                    }
                }
                return true;
            }
        } else if (x <= x1 - distance || x >= x2 + distance) {
            return false;
        }
        if (y2 <= y1) {
            if (y <= y2 - distance || y >= y1 + distance) {
                return false;
            }
            if (y1 == y2) {
                if (x1 >= x2) {
                    if (x <= x2 - distance || x >= x1 + distance) {
                        return false;
                    }
                    if (x < x2) {
                        return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
                    }
                    if (x > x1) {
                        return dsy2 * dsy2 + dsx1 * dsx1 < dist2;
                    }
                } else {
                    if (x <= x1 - distance || x >= x2 + distance) {
                        return false;
                    }
                    if (x < x1) {
                        return dsy2 * dsy2 + dsx1 * dsx1 < dist2;
                    }
                    if (x > x2) {
                        return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
                    }
                }
            }
        } else if (y <= y1 - distance || y >= y2 + distance) {
            return false;
        }
        if (dsy2 * dwy + dwx * dsx2 >= 0) {
            return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
        }
        if (dsy1 * dwy + dwx * dsx1 <= 0) {
            return dsy1 * dsy1 + dsx1 * dsx1 < dist2;
        }
        return (dwy * dsx1 - dsy1 * dwx) * (dwy * dsx1 - dsy1 * dwx) < dist2 * (dwx * dwx + dwy * dwy);
    }

    public static void NearSectors(int nSector, int x, int y, int distance, int[] pSectors, byte[] pSprites, int[] pWalls) {
        if (pSectors == null) {
            Main.game.dassert("pSectors != null");
        }
        int sectorcount = 1;
        int nextsectnum = 1;
        pSectors[0] = nSector;
        Arrays.fill(handled, (short)0);
        int n = nSector >> 3;
        handled[n] = (short)(handled[n] | 1 << (nSector & 7));
        int secIndex = 0;
        int xwallcount = 0;
        if (pSprites != null) {
            Arrays.fill(pSprites, (byte)0);
            int n2 = nSector >> 3;
            pSprites[n2] = (byte)(pSprites[n2] | 1 << (nSector & 7));
        }
        while (secIndex < sectorcount) {
            int cursect = pSectors[secIndex];
            if (Engine.sector[cursect] == null) {
                ++secIndex;
                continue;
            }
            int startwall = Engine.sector[cursect].wallptr;
            int endwall = startwall + Engine.sector[cursect].wallnum;
            if (startwall < 0 || endwall < 0) {
                ++secIndex;
                continue;
            }
            WALL pWall = Engine.wall[startwall];
            while (startwall < endwall) {
                if (pWall == null) {
                    ++startwall;
                    continue;
                }
                short nextsector = pWall.nextsector;
                if (nextsector >= 0 && (handled[nextsector >> 3] & 1 << (nextsector & 7)) == 0) {
                    int n3 = nextsector >> 3;
                    handled[n3] = (short)(handled[n3] | 1 << (nextsector & 7));
                    short nPoint2 = Engine.wall[startwall].point2;
                    if (Gameutils.checkDistance(nPoint2, x, y, distance)) {
                        short nXWall;
                        if (pSprites != null) {
                            int n4 = nextsector >> 3;
                            pSprites[n4] = (byte)(pSprites[n4] | 1 << (nextsector & 7));
                        }
                        pSectors[sectorcount++] = nextsector;
                        ++nextsectnum;
                        if (pWalls != null && (nXWall = pWall.extra) > 0) {
                            XWALL pXWall = DB.xwall[nXWall];
                            if (pXWall.triggerVector && pXWall.state == 0 && !pXWall.isTriggered) {
                                pWalls[xwallcount++] = startwall;
                            }
                        }
                    }
                }
                pWall = Engine.wall[++startwall];
            }
            ++secIndex;
        }
        pSectors[nextsectnum] = -1;
        if (pWalls != null) {
            pWalls[xwallcount] = -1;
        }
    }

    public static int HitScan(SPRITE pSprite, int z, int dx, int dy, int dz, Hitscan hitInfo, int clipmask, int dist) {
        if (pSprite == null) {
            return -1;
        }
        hitInfo.hitsect = (short)-1;
        hitInfo.hitwall = (short)-1;
        hitInfo.hitsprite = (short)-1;
        int x = pSprite.x;
        int y = pSprite.y;
        short nSector = pSprite.sectnum;
        short oldcstat = pSprite.cstat;
        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFF);
        if (dist != 0) {
            Engine.hitscangoalx = x + Pragmas.mulscale(dist << 4, Trig.Cos(pSprite.ang), 30);
            Engine.hitscangoaly = y + Pragmas.mulscale(dist << 4, Trig.Sin(pSprite.ang), 30);
        } else {
            Engine.hitscangoaly = 0x1FFFFFFF;
            Engine.hitscangoalx = 0x1FFFFFFF;
        }
        Main.engine.hitscan(x, y, z, nSector, dx, dy, dz << 4, hitInfo, clipmask);
        Engine.hitscangoaly = 0x1FFFFFFF;
        Engine.hitscangoalx = 0x1FFFFFFF;
        pSprite.cstat = oldcstat;
        if (hitInfo.hitsprite >= 0) {
            return 3;
        }
        if (hitInfo.hitwall >= 0) {
            short nNextSector = Engine.wall[hitInfo.hitwall].nextsector;
            if (nNextSector == -1) {
                return 0;
            }
            Main.engine.getzsofslope(nNextSector, hitInfo.hitx, hitInfo.hity, Globals.zofslope);
            if (hitInfo.hitz <= Globals.zofslope[0] || hitInfo.hitz >= Globals.zofslope[1]) {
                return 0;
            }
            return 4;
        }
        if (hitInfo.hitsect >= 0) {
            return hitInfo.hitz > z ? 2 : 1;
        }
        return -1;
    }

    public static int VectorScan(SPRITE pActor, int xoffset, int zoffset, int dx, int dy, int dz, int dist, int flags) {
        SECTOR hitsect = null;
        SECTOR nextsect = null;
        if (pActor == null) {
            Main.game.dassert("pSprite != null");
        }
        Engine.pHitInfo.hitsect = (short)-1;
        Engine.pHitInfo.hitwall = (short)-1;
        Engine.pHitInfo.hitsprite = (short)-1;
        int x = pActor.x + Pragmas.mulscale(xoffset, Trig.Cos(pActor.ang + 512), 30);
        int y = pActor.y + Pragmas.mulscale(xoffset, Trig.Sin(pActor.ang + 512), 30);
        int z = pActor.z + zoffset;
        short oldcstat = pActor.cstat;
        pActor.cstat = (short)(pActor.cstat & 0xFFFFFEFF);
        if (dist != 0) {
            Engine.hitscangoalx = x + Pragmas.mulscale(dist << 4, Trig.Cos(pActor.ang), 30);
            Engine.hitscangoaly = y + Pragmas.mulscale(dist << 4, Trig.Sin(pActor.ang), 30);
        } else {
            Engine.hitscangoaly = 0x1FFFFFFF;
            Engine.hitscangoalx = 0x1FFFFFFF;
        }
        Main.engine.hitscan(x, y, z, pActor.sectnum, dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
        pActor.cstat = oldcstat;
        int hitcount = 256;
        block3: while (hitcount != -1) {
            int hy;
            int hx;
            --hitcount;
            if (Engine.pHitInfo.hitsprite >= Globals.kMaxSprites || Engine.pHitInfo.hitwall >= Globals.kMaxWalls || Engine.pHitInfo.hitsect >= Globals.kMaxSectors) {
                return -1;
            }
            if (dist != 0 && Main.engine.qdist(hx = Engine.pHitInfo.hity - pActor.y, hy = Engine.pHitInfo.hitx - pActor.x) > (long)dist) {
                return -1;
            }
            if (Engine.pHitInfo.hitsprite >= 0) {
                SPRITE pSprite = Engine.sprite[Engine.pHitInfo.hitsprite];
                if ((pSprite.hitag & 8) != 0 && (flags & 1) == 0) {
                    return 3;
                }
                switch (pSprite.cstat & 0x30) {
                    case 0: {
                        short nTile = pSprite.picnum;
                        BloodTile pic = Main.engine.getTile(nTile);
                        if (pic.getWidth() == 0 || pic.getHeight() == 0) {
                            return 3;
                        }
                        int height = pic.getHeight() * pSprite.yrepeat << 2;
                        int zBot = pSprite.z;
                        if ((pSprite.cstat & 0x80) != 0) {
                            zBot += height / 2;
                        }
                        if (pic.getOffsetY() != 0) {
                            zBot -= pic.getOffsetY() * pSprite.yrepeat << 2;
                        }
                        if (height <= 0) {
                            Main.game.dassert("height > 0");
                        }
                        int texy = Pragmas.muldiv(zBot - Engine.pHitInfo.hitz, pic.getHeight(), height);
                        if ((pSprite.cstat & 8) == 0) {
                            texy = pic.getHeight() - texy;
                        }
                        if (texy >= 0 && texy < pic.getHeight()) {
                            byte[] pTile;
                            int texel;
                            int width = pSprite.xrepeat * pic.getWidth() >> 2;
                            width = width * 3 / 4;
                            int top = dx * (y - pSprite.y) - dy * (x - pSprite.x);
                            int bot = Main.engine.ksqrt(dx * dx + dy * dy);
                            if (width <= 0) {
                                Main.game.dassert("width > 0");
                            }
                            int texx = Pragmas.muldiv(top / bot, pic.getWidth(), width);
                            if ((texx += pic.getWidth() / 2 + pic.getOffsetX()) >= 0 && texx < pic.getWidth() && (texel = (pTile = Main.engine.loadtile(nTile))[texx * pic.getHeight() + texy] & 0xFF) != 255) {
                                return 3;
                            }
                        }
                        oldcstat = pSprite.cstat;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFF);
                        Engine.pHitInfo.hitsect = (short)-1;
                        Engine.pHitInfo.hitwall = (short)-1;
                        Engine.pHitInfo.hitsprite = (short)-1;
                        x = Engine.pHitInfo.hitx;
                        y = Engine.pHitInfo.hity;
                        z = Engine.pHitInfo.hitz;
                        Main.engine.hitscan(x, y, z, pSprite.sectnum, dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
                        pSprite.cstat = oldcstat;
                        continue block3;
                    }
                    default: {
                        return 3;
                    }
                }
            }
            if (Engine.pHitInfo.hitwall >= 0) {
                boolean ynice;
                WALL pWall = Engine.wall[Engine.pHitInfo.hitwall];
                short nextSector = pWall.nextsector;
                if (nextSector == -1) {
                    return 0;
                }
                hitsect = Engine.sector[Engine.pHitInfo.hitsect];
                nextsect = Engine.sector[nextSector];
                Main.engine.getzsofslope(nextSector, Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Globals.zofslope);
                if (Engine.pHitInfo.hitz <= Globals.zofslope[0]) {
                    return 0;
                }
                if (Engine.pHitInfo.hitz >= Globals.zofslope[1]) {
                    if (hitsect != null && (hitsect.floorstat & 1) == 0 || nextsect != null && (nextsect.floorstat & 1) == 0) {
                        return 0;
                    }
                    return 2;
                }
                if ((pWall.cstat & 0x30) == 0) {
                    return 0;
                }
                int zOrg = (pWall.cstat & 4) != 0 ? Gameutils.ClipHigh(hitsect.floorz, nextsect.floorz) : Gameutils.ClipLow(hitsect.ceilingz, nextsect.ceilingz);
                int zOff = Engine.pHitInfo.hitz - zOrg >> 8;
                if ((pWall.cstat & 0x100) != 0) {
                    zOff = -zOff;
                }
                short nTile = pWall.overpicnum;
                BloodTile pic = Main.engine.getTile(nTile);
                int tsizx = pic.getWidth();
                int tsizy = pic.getHeight();
                boolean xnice = 1 << (Engine.picsiz[nTile] & 0xF) == tsizx;
                boolean bl = ynice = 1 << (Engine.picsiz[nTile] >> 4) == tsizy;
                if (tsizx == 0 || tsizy == 0) {
                    return 0;
                }
                int texy = zOff * pWall.yrepeat / 8 + pWall.ypanning * tsizy / 256;
                int len = (int)Main.engine.qdist(pWall.x - Engine.wall[pWall.point2].x, pWall.y - Engine.wall[pWall.point2].y);
                int distance = (pWall.cstat & 8) != 0 ? (int)Main.engine.qdist(Engine.pHitInfo.hitx - Engine.wall[pWall.point2].x, Engine.pHitInfo.hity - Engine.wall[pWall.point2].y) : (int)Main.engine.qdist(Engine.pHitInfo.hitx - pWall.x, Engine.pHitInfo.hity - pWall.y);
                int texx = distance * pWall.xrepeat * 8 / len + pWall.xpanning;
                texx = xnice ? (texx &= tsizx - 1) : (texx %= tsizx);
                texy = ynice ? (texy &= tsizy - 1) : (texy %= tsizy);
                byte[] pTile = Main.engine.loadtile(nTile);
                int texel = ynice ? pTile[(texx << (Engine.picsiz[nTile] >> 4)) + texy] & 0xFF : (texx * pic.getHeight() + texy >= 0 ? pTile[texx * pic.getHeight() + texy] & 0xFF : 0);
                if (texel == 255) {
                    short oldcstat1 = pWall.cstat;
                    pWall.cstat = (short)(pWall.cstat & 0xFFFFFFBF);
                    short oldcstat2 = Engine.wall[pWall.nextwall].cstat;
                    Engine.wall[pWall.nextwall].cstat = (short)(Engine.wall[pWall.nextwall].cstat & 0xFFFFFFBF);
                    Engine.pHitInfo.hitsect = (short)-1;
                    Engine.pHitInfo.hitwall = (short)-1;
                    Engine.pHitInfo.hitsprite = (short)-1;
                    x = Engine.pHitInfo.hitx;
                    y = Engine.pHitInfo.hity;
                    z = Engine.pHitInfo.hitz;
                    Main.engine.hitscan(x, y, z, pWall.nextsector, dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
                    pWall.cstat = oldcstat1;
                    Engine.wall[pWall.nextwall].cstat = oldcstat2;
                    continue;
                }
                return 4;
            }
            if (Engine.pHitInfo.hitsect >= 0) {
                if (dz <= 0) {
                    int nLower = Warp.gLowerLink[Engine.pHitInfo.hitsect];
                    if (nLower < 0) {
                        return 1;
                    }
                    short nUpper = Engine.sprite[nLower].owner;
                    if (nUpper < 0) {
                        return 1;
                    }
                    Engine.pHitInfo.hitsect = (short)-1;
                    Engine.pHitInfo.hitwall = (short)-1;
                    Engine.pHitInfo.hitsprite = (short)-1;
                    x = Engine.pHitInfo.hitx + Engine.sprite[nUpper].x - Engine.sprite[nLower].x;
                    y = Engine.pHitInfo.hity + Engine.sprite[nUpper].y - Engine.sprite[nLower].y;
                    z = Engine.pHitInfo.hitz + Engine.sprite[nUpper].z - Engine.sprite[nLower].z;
                    Main.engine.hitscan(x, y, z, Engine.sprite[nUpper].sectnum, dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
                    continue;
                }
                int nUpper = Warp.gUpperLink[Engine.pHitInfo.hitsect];
                if (nUpper < 0) {
                    return 2;
                }
                short nLower = Engine.sprite[nUpper].owner;
                if (nLower < 0) {
                    return 2;
                }
                Engine.pHitInfo.hitsect = (short)-1;
                Engine.pHitInfo.hitwall = (short)-1;
                Engine.pHitInfo.hitsprite = (short)-1;
                x = Engine.pHitInfo.hitx + Engine.sprite[nLower].x - Engine.sprite[nUpper].x;
                y = Engine.pHitInfo.hity + Engine.sprite[nLower].y - Engine.sprite[nUpper].y;
                z = Engine.pHitInfo.hitz + Engine.sprite[nLower].z - Engine.sprite[nUpper].z;
                Main.engine.hitscan(x, y, z, Engine.sprite[nLower].sectnum, dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
                continue;
            }
            return -1;
        }
        return -1;
    }

    public static boolean FindSector(int x, int y, int z, short nSector) {
        foundSector = nSector;
        if (Main.engine.inside(x, y, nSector) != 0) {
            Main.engine.getzsofslope(nSector, x, y, Globals.zofslope);
            if (z >= Globals.zofslope[0] && z <= Globals.zofslope[1]) {
                return true;
            }
        }
        int wallid = Engine.sector[nSector].wallptr;
        int i = Engine.sector[nSector].wallnum;
        while (i > 0) {
            short j = Engine.wall[wallid].nextsector;
            if (j >= 0 && Main.engine.inside(x, y, j) != 0) {
                Main.engine.getzsofslope(j, x, y, Globals.zofslope);
                if (z >= Globals.zofslope[0] && z <= Globals.zofslope[1]) {
                    foundSector = nSector = j;
                    return true;
                }
            }
            --i;
            ++wallid;
        }
        i = 0;
        while (i < Engine.numsectors) {
            if (Main.engine.inside(x, y, (short)i) != 0) {
                Main.engine.getzsofslope((short)i, x, y, Globals.zofslope);
                if (z >= Globals.zofslope[0] && z <= Globals.zofslope[1]) {
                    foundSector = nSector = (short)i;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static int ClipMove(int px, int py, int pz, short pnSector, long dx, long dy, int wallDist, int ceilDist, int floorDist, int clipType) {
        clipmove_error = false;
        int ccode = Main.engine.clipmove(px, py, pz, pnSector, dx << 14, dy << 14, wallDist, ceilDist, floorDist, clipType);
        clipm_px = Engine.clipmove_x;
        clipm_py = Engine.clipmove_y;
        clipm_pz = Engine.clipmove_z;
        clipm_pnsectnum = Engine.clipmove_sectnum;
        if (Engine.clipmove_sectnum == -1) {
            clipmove_error = true;
            clipm_px = px;
            clipm_py = py;
            clipm_pz = pz;
            clipm_pnsectnum = pnSector;
        }
        return ccode;
    }

    public static void GetZRange(SPRITE pSprite, int clipdist, int cliptype) {
        int nUpper;
        int sectnum;
        if (pSprite == null) {
            Main.game.dassert("pSprite != null");
        }
        short oldcstat = pSprite.cstat;
        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
        Main.engine.getzrange(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, clipdist, cliptype);
        gz_ceilZ = Engine.zr_ceilz;
        gz_ceilHit = Engine.zr_ceilhit;
        gz_floorZ = Engine.zr_florz;
        gz_floorHit = Engine.zr_florhit;
        if ((gz_floorHit & 0xE000) == 16384) {
            short nLower;
            short nXSector;
            sectnum = gz_floorHit & 0x1FFF;
            if ((cliptype & 0x2000) == 0 && (Engine.sector[sectnum].floorstat & 1) != 0) {
                gz_floorZ = Integer.MAX_VALUE;
            }
            if ((nXSector = Engine.sector[sectnum].extra) > 0) {
                gz_floorZ += DB.xsector[nXSector].Depth << 10;
            }
            if ((nUpper = Warp.gUpperLink[sectnum]) >= 0 && (nLower = Engine.sprite[nUpper].owner) >= 0) {
                Main.engine.getzrange(pSprite.x + Engine.sprite[nLower].x - Engine.sprite[nUpper].x, pSprite.y + Engine.sprite[nLower].y - Engine.sprite[nUpper].y, pSprite.z + Engine.sprite[nLower].z - Engine.sprite[nUpper].z, Engine.sprite[nLower].sectnum, clipdist, cliptype);
                gz_floorZ = Engine.zr_florz;
                gz_floorHit = Engine.zr_florhit;
                gz_floorZ -= Engine.sprite[nLower].z - Engine.sprite[nUpper].z;
            }
        }
        if ((gz_ceilHit & 0xE000) == 16384) {
            int nLower;
            sectnum = gz_ceilHit & 0x1FFF;
            if ((cliptype & 0x1000) == 0 && (Engine.sector[sectnum].ceilingstat & 1) != 0) {
                gz_ceilZ = Integer.MIN_VALUE;
            }
            if ((nLower = Warp.gLowerLink[sectnum]) >= 0 && (nUpper = (int)Engine.sprite[nLower].owner) >= 0) {
                Main.engine.getzrange(pSprite.x + Engine.sprite[nUpper].x - Engine.sprite[nLower].x, pSprite.y + Engine.sprite[nUpper].y - Engine.sprite[nLower].y, pSprite.z + Engine.sprite[nUpper].z - Engine.sprite[nLower].z, Engine.sprite[nUpper].sectnum, clipdist, cliptype);
                gz_ceilZ = Engine.zr_ceilz;
                gz_ceilHit = Engine.zr_ceilhit;
                gz_ceilZ -= Engine.sprite[nUpper].z - Engine.sprite[nLower].z;
            }
        }
        pSprite.cstat = oldcstat;
    }

    public static void GetZRange(int x, int y, int z, short nSector, int clipdist, int cliptype) {
        int nUpper;
        int sectnum;
        Main.engine.getzrange(x, y, z, nSector, clipdist, cliptype);
        gz_ceilZ = Engine.zr_ceilz;
        gz_ceilHit = Engine.zr_ceilhit;
        gz_floorZ = Engine.zr_florz;
        gz_floorHit = Engine.zr_florhit;
        if ((gz_floorHit & 0xE000) == 16384) {
            short nLower;
            short nXSector;
            sectnum = gz_floorHit & 0x1FFF;
            if ((cliptype & 0x2000) == 0 && (Engine.sector[sectnum].floorstat & 1) != 0) {
                gz_floorZ = Integer.MAX_VALUE;
            }
            if ((nXSector = Engine.sector[sectnum].extra) > 0) {
                gz_floorZ += DB.xsector[nXSector].Depth << 10;
            }
            if ((nUpper = Warp.gUpperLink[sectnum]) >= 0 && (nLower = Engine.sprite[nUpper].owner) >= 0) {
                Main.engine.getzrange(x + Engine.sprite[nLower].x - Engine.sprite[nUpper].x, y + Engine.sprite[nLower].y - Engine.sprite[nUpper].y, z + Engine.sprite[nLower].z - Engine.sprite[nUpper].z, Engine.sprite[nLower].sectnum, clipdist, cliptype);
                gz_floorZ = Engine.zr_florz;
                gz_floorHit = Engine.zr_florhit;
                gz_floorZ -= Engine.sprite[nLower].z - Engine.sprite[nUpper].z;
            }
        }
        if ((gz_ceilHit & 0xE000) == 16384) {
            int nLower;
            sectnum = gz_ceilHit & 0x1FFF;
            if ((cliptype & 0x1000) == 0 && (Engine.sector[sectnum].ceilingstat & 1) != 0) {
                gz_ceilZ = Integer.MIN_VALUE;
            }
            if ((nLower = Warp.gLowerLink[sectnum]) >= 0 && (nUpper = (int)Engine.sprite[nLower].owner) >= 0) {
                Main.engine.getzrange(x + Engine.sprite[nUpper].x - Engine.sprite[nLower].x, y + Engine.sprite[nUpper].y - Engine.sprite[nLower].y, z + Engine.sprite[nUpper].z - Engine.sprite[nLower].z, Engine.sprite[nUpper].sectnum, clipdist, cliptype);
                gz_ceilZ = Engine.zr_ceilz;
                gz_ceilHit = Engine.zr_ceilhit;
                gz_ceilZ -= Engine.sprite[nUpper].z - Engine.sprite[nLower].z;
            }
        }
    }

    public static boolean CheckProximity(SPRITE pSprite, int x, int y, int z, int nSector, int dist) {
        long dz;
        long dy;
        long dx;
        if (pSprite == null) {
            Main.game.dassert("pSprite != null");
        }
        if ((dx = (long)(Pragmas.klabs(x - pSprite.x) >> 4)) < (long)dist && (dy = (long)(Pragmas.klabs(y - pSprite.y) >> 4)) < (long)dist && (dz = (long)(Pragmas.klabs(z - pSprite.z) >> 8)) < (long)dist && Main.engine.qdist(dx, dy) < (long)dist) {
            Gameutils.GetSpriteExtents(pSprite);
            if (Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, x, y, z, (short)nSector)) {
                return true;
            }
            if (Main.engine.cansee(pSprite.x, pSprite.y, extents_zTop, pSprite.sectnum, x, y, z, (short)nSector)) {
                return true;
            }
            if (Main.engine.cansee(pSprite.x, pSprite.y, extents_zBot, pSprite.sectnum, x, y, z, (short)nSector)) {
                return true;
            }
        }
        return false;
    }

    public static int Dist3d(int dx, int dy, int dz) {
        return Main.engine.ksqrt((dx >>= 4) * dx + (dy >>= 4) * dy + (dz >>= 8) * dz);
    }

    public static void sRandom(long set) {
        bseed = (int)set;
    }

    public static int bRandom() {
        bseed = bseed * 1103515245 + 12345;
        return bseed >> 16 & Short.MAX_VALUE;
    }

    public static int vRandom() {
        int var = 2 * vseed;
        if ((byte)vseed > (byte)vseed + (byte)vseed) {
            var = var ^ 0x20000004 | 1;
        }
        vseed = var;
        return var & Short.MAX_VALUE;
    }

    public static int ViRandom(int var) {
        return Pragmas.mulscale(var, Gameutils.vRandom(), 14) - var;
    }

    public static boolean Chance(int var) {
        return Gameutils.bRandom() < var;
    }

    public static int BiRandom(int var) {
        return Pragmas.mulscale(var, Gameutils.bRandom(), 14) - var;
    }

    public static int BiRandom2(int var) {
        return Pragmas.mulscale(var, Gameutils.bRandom() + Gameutils.bRandom(), 15) - var;
    }

    public static int Random(int var) {
        return Pragmas.mulscale(var, Gameutils.bRandom(), 15);
    }

    public static char[] toCharArray(String ... text) {
        Strhandler.buildString(buf, 0, text);
        return buf;
    }
}

