/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Menus;

import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.BLUserContent;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.EpisodeInfo;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;

public class MenuNetwork
extends BuildMenu {
    private int mGameType = 1;
    private int mEpisodeId = 0;
    private int mLevelId = 0;
    private int mDifficulty = 2;
    private int mMonsters = 0;
    private int mWeapons = 1;
    private int mItems = 1;
    private short mFFire = 0;
    private short[] mFfireShift;
    private boolean mRevive;
    private int mFragLimit;
    private Object currentFile;
    private int mTeam;
    private String mContent;
    private EpisodeInfo[] netEpisodeInfo;
    private Main app;
    private MenuProc mLevelsUpdate;
    private MenuConteiner mMenuLevel;
    private MenuConteiner mMenuEpisode;

    public MenuNetwork(final Main app) {
        short[] sArray = new short[5];
        sArray[1] = 32;
        sArray[2] = 64;
        sArray[3] = 128;
        sArray[4] = 256;
        this.mFfireShift = sArray;
        this.mRevive = true;
        this.mFragLimit = 0;
        this.mTeam = 0;
        this.netEpisodeInfo = new EpisodeInfo[6];
        this.app = app;
        final BloodMenuHandler menu = app.menu;
        this.addItem(new MenuTitle(app.pEngine, "NETWORK GAME", app.getFont(1), 160, 20, 2038), false);
        MenuConteiner mMenuGame = new MenuConteiner("GAME", app.getFont(1), 20, 35, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mGameType = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "Cooperative".toCharArray();
                    this.list[1] = "Bloodbath".toCharArray();
                    this.list[2] = "Teams".toCharArray();
                }
                int n = Globals.pNetInfo.nGameType - 1;
                MenuNetwork.this.mGameType = n;
                this.num = n;
            }
        };
        int i = 0;
        while (i < 6) {
            this.netEpisodeInfo[i] = new EpisodeInfo();
            ++i;
        }
        this.mLevelsUpdate = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                EpisodeInfo pEpisode = MenuNetwork.this.netEpisodeInfo[MenuNetwork.this.mEpisodeId];
                if (item.list == null || item.list.length != pEpisode.nMaps) {
                    item.list = new char[pEpisode.nMaps][];
                }
                int i = 0;
                while (i < pEpisode.nMaps) {
                    if (pEpisode.gMapInfo[i].Title != null) {
                        item.list[i] = pEpisode.gMapInfo[i].Title.toCharArray();
                    }
                    ++i;
                }
                item.num = 0;
                MenuNetwork.this.mLevelId = 0;
            }
        };
        this.mMenuLevel = new MenuConteiner("LEVEL", app.getFont(3), 20, 80, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mLevelId = item.num;
            }
        }){

            @Override
            public void open() {
                this.num = MenuNetwork.this.mLevelId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.currentFile instanceof BloodIniFile);
                super.draw(handler);
            }
        };
        this.mMenuEpisode = new MenuConteiner("EPISODE", app.getFont(3), 20, 70, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mEpisodeId = item.num;
                MenuNetwork.this.mLevelsUpdate.run(menu, MenuNetwork.this.mMenuLevel);
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[LEVELS.nEpisodeCount][];
                    int i = 0;
                    while (i < LEVELS.nEpisodeCount) {
                        EpisodeInfo pEpisode = MenuNetwork.this.netEpisodeInfo[i];
                        if (pEpisode.Title != null) {
                            this.list[i] = pEpisode.Title.toCharArray();
                        }
                        ++i;
                    }
                }
                this.num = MenuNetwork.this.mEpisodeId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.currentFile instanceof BloodIniFile);
                super.draw(handler);
            }
        };
        MenuConteiner pItem = new MenuConteiner("Content", app.getFont(1), 20, 50, 280, new String[]{""}, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                BLUserContent usercont = (BLUserContent)menu.mMenus[16];
                if (!usercont.showmain) {
                    usercont.setShowMain(true);
                }
                handler.mOpen(usercont, -1);
            }
        }){

            @Override
            public void open() {
                if (!app.isCurrentScreen(Main.gGameScreen)) {
                    MenuNetwork.this.setEpisode(Globals.MainINI);
                }
            }

            @Override
            public void draw(MenuHandler handler) {
                this.list[0] = Strhandler.toCharArray(MenuNetwork.this.mContent);
                super.draw(handler);
            }
        };
        int pos = 80;
        MenuConteiner mMenuDifficulty = new MenuConteiner("DIFFICULTY", app.getFont(3), 20, pos += 10, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mDifficulty = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[5][];
                    this.list[0] = "STILL KICKING".toCharArray();
                    this.list[1] = "PINK ON THE INSIDE".toCharArray();
                    this.list[2] = "LIGHTLY BROILED".toCharArray();
                    this.list[3] = "WELL DONE".toCharArray();
                    this.list[4] = "EXTRA CRISPY".toCharArray();
                }
                this.num = MenuNetwork.this.mDifficulty;
            }
        };
        MenuConteiner mMenuMonsters = new MenuConteiner("MONSTERS", app.getFont(3), 20, pos += 10, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mMonsters = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "None".toCharArray();
                    this.list[1] = "Bring'em on".toCharArray();
                    this.list[2] = "Respawn".toCharArray();
                }
                this.num = MenuNetwork.this.mMonsters;
            }
        };
        MenuConteiner mMenuWeapons = new MenuConteiner("WEAPONS", app.getFont(3), 20, pos += 10, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mWeapons = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[4][];
                    this.list[0] = "Do not respawn".toCharArray();
                    this.list[1] = "Are permanent".toCharArray();
                    this.list[2] = "Respawn".toCharArray();
                    this.list[3] = "Respawn with markers".toCharArray();
                }
                this.num = MenuNetwork.this.mWeapons;
            }
        };
        MenuConteiner mMenuItems = new MenuConteiner("Items", app.getFont(3), 20, pos += 10, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mItems = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "Do not respawn".toCharArray();
                    this.list[1] = "Respawn".toCharArray();
                    this.list[2] = "Respawn with markers".toCharArray();
                }
                this.num = MenuNetwork.this.mItems;
            }
        };
        MenuConteiner mMenuFFire = new MenuConteiner("Friendly Fire", app.getFont(3), 20, pos += 10, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mFFire = (short)item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[5][];
                    this.list[0] = "No damage".toCharArray();
                    this.list[1] = "1/8 damage".toCharArray();
                    this.list[2] = "1/4 damage".toCharArray();
                    this.list[3] = "1/2 damage".toCharArray();
                    this.list[4] = "Full damage".toCharArray();
                }
                this.num = MenuNetwork.this.mFFire;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType + 1 == 1 || MenuNetwork.this.mGameType + 1 == 3);
                super.draw(handler);
            }
        };
        MenuSwitch mMenuRevive = new MenuSwitch("Revive mode:", app.getFont(3), 20, pos += 10, 280, this.mRevive, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuNetwork.this.mRevive = sw.value;
            }
        }, "Yes", "No"){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType + 1 == 1);
                super.draw(handler);
            }
        };
        MenuConteiner mMenuTeam = new MenuConteiner("Team:", app.getFont(3), 20, pos += 10, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mTeam = (short)item.num;
                app.net.ChangeTeam(Mmulti.myconnectindex, MenuNetwork.this.mTeam);
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "Auto".toCharArray();
                    this.list[1] = "Blue".toCharArray();
                    this.list[2] = "Red".toCharArray();
                }
                this.num = MenuNetwork.this.mTeam;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType + 1 == 3);
                super.draw(handler);
            }
        };
        MenuTextField mLimit = new MenuTextField("Frag limit:", "" + this.mFragLimit, app.getFont(3), 20, pos += 10, 280, 2, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuTextField item = (MenuTextField)pItem;
                if (item.typed.length() < 8) {
                    MenuNetwork.this.mFragLimit = Integer.parseInt(item.typed);
                } else {
                    System.arraycopy(item.otypingBuf, 0, item.typingBuf, 0, 16);
                    item.inputlen = item.oinputlen;
                }
            }
        }){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType + 1 >= 2);
                super.draw(handler);
            }
        };
        MenuProc mNetStart = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                Globals.pNetInfo.nGameType = MenuNetwork.this.mGameType + 1;
                Globals.pNetInfo.nEpisode = MenuNetwork.this.mEpisodeId;
                Globals.pNetInfo.nLevel = MenuNetwork.this.mLevelId;
                Globals.pNetInfo.nDifficulty = MenuNetwork.this.mDifficulty;
                Globals.pNetInfo.nMonsterSettings = MenuNetwork.this.mMonsters;
                Globals.pNetInfo.nWeaponSettings = MenuNetwork.this.mWeapons;
                Globals.pNetInfo.nItemSettings = MenuNetwork.this.mItems;
                Globals.pNetInfo.nFriendlyFire = MenuNetwork.this.mFfireShift[MenuNetwork.this.mFFire];
                Globals.pNetInfo.nReviveMode = MenuNetwork.this.mRevive;
                Globals.pNetInfo.nFragLimit = MenuNetwork.this.mFragLimit;
                System.err.println("nNetType " + Globals.pNetInfo.nGameType);
                System.err.println("nNetDifficulty " + Globals.pNetInfo.nDifficulty);
                System.err.println("nNetMonsters " + Globals.pNetInfo.nMonsterSettings);
                System.err.println("nNetWeapons " + Globals.pNetInfo.nWeaponSettings);
                System.err.println("nNetItems " + Globals.pNetInfo.nItemSettings);
                System.err.println("nNetFFire " + Globals.pNetInfo.nFriendlyFire);
                System.err.println("nNetRevive " + Globals.pNetInfo.nReviveMode);
                System.err.println("nNetFragLimit " + Globals.pNetInfo.nFragLimit);
                if (Mmulti.numplayers >= 2) {
                    byte[] packbuf = app.net.packbuf;
                    packbuf[0] = -4;
                    int ptr = 1;
                    LittleEndian.putInt(packbuf, ptr, Mmulti.myconnectindex);
                    LittleEndian.putInt(packbuf, ptr += 4, app.net.nNetVersion);
                    LittleEndian.putByte(packbuf, ptr += 4, VERSION.GAMEVER);
                    System.arraycopy(Globals.pNetInfo.getBytes(), 0, packbuf, ++ptr, Globals.pNetInfo.sizeof);
                    ptr += Globals.pNetInfo.sizeof;
                    short i = Mmulti.connecthead;
                    while (i >= 0) {
                        if (i != Mmulti.myconnectindex) {
                            Mmulti.sendpacket(i, packbuf, ptr);
                        }
                        if (Mmulti.myconnectindex != Mmulti.connecthead) break;
                        i = Mmulti.connectpoint2[i];
                    }
                }
                if (app.net.WaitForAllPlayers(0)) {
                    Main.gGameScreen.newgame(true, MenuNetwork.this.currentFile, MenuNetwork.this.mEpisodeId, MenuNetwork.this.mLevelId, MenuNetwork.this.mDifficulty, MenuNetwork.this.mDifficulty, MenuNetwork.this.mDifficulty, false);
                }
            }
        };
        MenuButton mStart = new MenuButton("START GAME", app.getFont(1), 20, pos += 15, 280, 0, 0, null, -1, mNetStart, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(Mmulti.myconnectindex == Mmulti.connecthead && MenuNetwork.this.currentFile != null);
                super.draw(handler);
            }
        };
        mStart.fontShadow = true;
        this.addItem(mMenuGame, true);
        this.addItem(pItem, false);
        this.addItem(this.mMenuEpisode, false);
        this.addItem(this.mMenuLevel, false);
        this.addItem(mMenuDifficulty, false);
        this.addItem(mMenuMonsters, false);
        this.addItem(mMenuWeapons, false);
        this.addItem(mMenuItems, false);
        this.addItem(mMenuFFire, false);
        this.addItem(mMenuRevive, false);
        this.addItem(mMenuTeam, false);
        this.addItem(mLimit, false);
        this.addItem(mStart, false);
        this.addItem(menu.addMenuBlood(), false);
    }

    public Object getFile() {
        return this.currentFile;
    }

    public void setEpisode(BloodIniFile ini) {
        if (ini == null || this.currentFile == ini) {
            return;
        }
        String path = ini.getFile().getPath();
        if (ini.isPackage()) {
            path = String.valueOf(path) + ":" + ini.getName();
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(path, 0)) {
            String msg = "";
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] == 0) {
                    msg = String.valueOf(msg) + this.app.net.getPlayerName(i) + ", ";
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.valueOf(msg) + " haven't " + ini.getName();
            Console.Println(msg, Console.OSDTEXT_RED);
            if (!Console.IsShown()) {
                Console.toggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = ini;
        this.mContent = ini.getName();
        this.mEpisodeId = 0;
        this.mMenuEpisode.num = 0;
        int nEpisodes = LEVELS.getEpisodeInfo(this.netEpisodeInfo, ini);
        this.mLevelsUpdate.run(this.app.pMenu, this.mMenuLevel);
        if (this.mMenuEpisode.list == null || this.mMenuEpisode.list.length != nEpisodes) {
            this.mMenuEpisode.list = new char[nEpisodes][];
        }
        int i = 0;
        while (i < nEpisodes) {
            EpisodeInfo pEpisode = this.netEpisodeInfo[i];
            if (pEpisode.Title != null) {
                this.mMenuEpisode.list[i] = pEpisode.Title.toCharArray();
            }
            ++i;
        }
    }

    public void setMap(FileEntry map) {
        if (map == null || this.currentFile == map) {
            return;
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(map.getPath(), 0)) {
            String msg = "";
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] == 0) {
                    msg = String.valueOf(msg) + this.app.net.getPlayerName(i) + ", ";
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.valueOf(msg) + " haven't " + map.getName();
            Console.Println(msg, Console.OSDTEXT_RED);
            if (!Console.IsShown()) {
                Console.toggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = map;
        this.mContent = map.getName();
        if (this.mMenuEpisode.list != null) {
            this.mMenuEpisode.list[0] = "None".toCharArray();
        }
        this.mMenuEpisode.num = 0;
        this.mEpisodeId = 0;
        if (this.mMenuLevel.list != null) {
            this.mMenuLevel.list[0] = "Usermap".toCharArray();
        }
        this.mMenuLevel.num = 0;
        this.mLevelId = 0;
    }
}

