/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;

public class SECTORFX {
    public static short[] shadeList = new short[512];
    public static short[] panList = new short[512];
    public static int shadeCount = 0;
    public static int panCount = 0;
    public static short[] wallPanList = new short[512];
    public static int wallPanCount = 0;
    public static final int kPanScale = 10;
    public static final int kWaveNone = 0;
    public static final int kWaveSquare = 1;
    public static final int kWaveSaw = 2;
    public static final int kWaveRampup = 3;
    public static final int kWaveRampdown = 4;
    public static final int kWaveSine = 5;
    public static final int kWaveFlicker1 = 6;
    public static final int kWaveFlicker2 = 7;
    public static final int kWaveFlicker3 = 8;
    public static final int kWaveFlicker4 = 9;
    public static final int kWaveStrobe = 10;
    public static final int kWaveSearch = 11;
    public static final int[] flicker1;
    public static final int[] flicker2;
    public static final int[] flicker3;
    public static final int[] flicker4;
    public static final int[] strobe;

    static {
        int[] nArray = new int[64];
        nArray[2] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[12] = 1;
        nArray[14] = 1;
        nArray[16] = 1;
        nArray[17] = 1;
        nArray[19] = 1;
        nArray[22] = 1;
        nArray[23] = 1;
        nArray[25] = 1;
        nArray[26] = 1;
        nArray[28] = 1;
        nArray[31] = 1;
        nArray[34] = 1;
        nArray[35] = 1;
        nArray[37] = 1;
        nArray[38] = 1;
        nArray[39] = 1;
        nArray[40] = 1;
        nArray[41] = 1;
        nArray[42] = 1;
        nArray[43] = 1;
        nArray[44] = 1;
        nArray[47] = 1;
        nArray[54] = 1;
        nArray[56] = 1;
        nArray[57] = 1;
        nArray[60] = 1;
        nArray[61] = 1;
        nArray[63] = 1;
        flicker1 = nArray;
        int[] nArray2 = new int[64];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 2;
        nArray2[4] = 3;
        nArray2[5] = 4;
        nArray2[6] = 3;
        nArray2[7] = 2;
        nArray2[10] = 1;
        nArray2[11] = 2;
        nArray2[12] = 4;
        nArray2[13] = 3;
        nArray2[14] = 2;
        nArray2[16] = 2;
        nArray2[17] = 1;
        nArray2[19] = 1;
        nArray2[21] = 2;
        nArray2[22] = 3;
        nArray2[23] = 4;
        nArray2[24] = 3;
        nArray2[25] = 2;
        nArray2[26] = 1;
        nArray2[27] = 1;
        nArray2[28] = 2;
        nArray2[31] = 1;
        nArray2[32] = 1;
        nArray2[33] = 2;
        nArray2[34] = 3;
        nArray2[35] = 4;
        nArray2[36] = 4;
        nArray2[37] = 3;
        nArray2[38] = 2;
        nArray2[39] = 1;
        nArray2[40] = 2;
        nArray2[41] = 3;
        nArray2[42] = 4;
        nArray2[43] = 4;
        nArray2[44] = 2;
        nArray2[45] = 1;
        nArray2[47] = 1;
        nArray2[52] = 1;
        nArray2[53] = 2;
        nArray2[54] = 3;
        nArray2[55] = 4;
        nArray2[56] = 3;
        nArray2[57] = 2;
        nArray2[58] = 1;
        nArray2[59] = 2;
        nArray2[60] = 3;
        nArray2[61] = 4;
        nArray2[62] = 3;
        nArray2[63] = 2;
        flicker2 = nArray2;
        int[] nArray3 = new int[64];
        nArray3[0] = 4;
        nArray3[1] = 4;
        nArray3[2] = 4;
        nArray3[3] = 4;
        nArray3[4] = 3;
        nArray3[5] = 4;
        nArray3[6] = 4;
        nArray3[7] = 4;
        nArray3[8] = 4;
        nArray3[9] = 4;
        nArray3[10] = 4;
        nArray3[11] = 2;
        nArray3[12] = 4;
        nArray3[13] = 3;
        nArray3[14] = 4;
        nArray3[15] = 4;
        nArray3[16] = 4;
        nArray3[17] = 4;
        nArray3[18] = 2;
        nArray3[19] = 1;
        nArray3[20] = 3;
        nArray3[21] = 3;
        nArray3[22] = 3;
        nArray3[23] = 4;
        nArray3[24] = 3;
        nArray3[25] = 4;
        nArray3[26] = 4;
        nArray3[27] = 4;
        nArray3[28] = 4;
        nArray3[29] = 4;
        nArray3[30] = 2;
        nArray3[31] = 4;
        nArray3[32] = 4;
        nArray3[33] = 4;
        nArray3[34] = 3;
        nArray3[35] = 4;
        nArray3[36] = 4;
        nArray3[37] = 4;
        nArray3[38] = 4;
        nArray3[39] = 4;
        nArray3[40] = 4;
        nArray3[41] = 4;
        nArray3[42] = 4;
        nArray3[43] = 4;
        nArray3[44] = 2;
        nArray3[45] = 1;
        nArray3[47] = 1;
        nArray3[49] = 1;
        nArray3[51] = 1;
        nArray3[53] = 2;
        nArray3[54] = 3;
        nArray3[55] = 4;
        nArray3[56] = 4;
        nArray3[57] = 4;
        nArray3[58] = 4;
        nArray3[59] = 4;
        nArray3[60] = 4;
        nArray3[61] = 4;
        nArray3[62] = 3;
        nArray3[63] = 4;
        flicker3 = nArray3;
        int[] nArray4 = new int[64];
        nArray4[16] = 4;
        nArray4[19] = 3;
        nArray4[21] = 1;
        nArray4[23] = 1;
        nArray4[25] = 4;
        nArray4[26] = 4;
        nArray4[27] = 4;
        nArray4[28] = 4;
        nArray4[29] = 4;
        nArray4[30] = 2;
        nArray4[35] = 4;
        nArray4[36] = 4;
        nArray4[37] = 3;
        nArray4[38] = 2;
        nArray4[39] = 1;
        nArray4[47] = 1;
        nArray4[53] = 2;
        nArray4[54] = 1;
        nArray4[55] = 2;
        nArray4[56] = 1;
        nArray4[57] = 2;
        nArray4[58] = 1;
        nArray4[59] = 2;
        nArray4[60] = 1;
        nArray4[61] = 4;
        nArray4[62] = 3;
        nArray4[63] = 2;
        flicker4 = nArray4;
        int[] nArray5 = new int[64];
        nArray5[0] = 64;
        nArray5[1] = 64;
        nArray5[2] = 64;
        nArray5[3] = 48;
        nArray5[4] = 36;
        nArray5[5] = 27;
        nArray5[6] = 20;
        nArray5[7] = 15;
        nArray5[8] = 11;
        nArray5[9] = 9;
        nArray5[10] = 6;
        nArray5[11] = 5;
        nArray5[12] = 4;
        nArray5[13] = 3;
        nArray5[14] = 2;
        nArray5[15] = 2;
        nArray5[16] = 1;
        nArray5[17] = 1;
        nArray5[18] = 1;
        strobe = nArray5;
    }

    public static void InitSectorFX() {
        shadeCount = 0;
        panCount = 0;
        wallPanCount = 0;
        int i = 0;
        while (i < Engine.numsectors) {
            short nXSector = Engine.sector[i].extra;
            if (nXSector > 0) {
                XSECTOR pXSector = DB.xsector[nXSector];
                if (pXSector.amplitude != 0) {
                    SECTORFX.shadeList[SECTORFX.shadeCount++] = nXSector;
                }
                if (pXSector.panVel != 0) {
                    SECTORFX.panList[SECTORFX.panCount++] = nXSector;
                }
            }
            ++i;
        }
        i = 0;
        while (i < Engine.numwalls) {
            short nXWall = Engine.wall[i].extra;
            if (nXWall > 0) {
                XWALL pXWall = DB.xwall[nXWall];
                if (pXWall.panXVel != 0 || pXWall.panYVel != 0) {
                    SECTORFX.wallPanList[SECTORFX.wallPanCount++] = nXWall;
                }
            }
            ++i;
        }
    }

    public static void DoSectorPanning() {
        int i = 0;
        while (i < panCount) {
            short nXSector = panList[i];
            XSECTOR pXSector = DB.xsector[nXSector];
            int nSector = pXSector.reference;
            if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
            }
            SECTOR pSector = Engine.sector[nSector];
            if (pSector.extra != nXSector) {
                Main.game.dassert("pSector.extra == nXSector");
            }
            if (pXSector.panAlways || pXSector.busy != 0) {
                int panY;
                int panX;
                short nTile;
                int panAngle = pXSector.panAngle + 1024;
                int panVel = (pXSector.panVel & 0xFF) << 10;
                if (!pXSector.panAlways && (pXSector.busy & 0xFFFF) != 0) {
                    panVel = Pragmas.mulscale(panVel, pXSector.busy, 16);
                }
                if (pXSector.panFloor) {
                    nTile = pSector.floorpicnum;
                    if ((pSector.floorstat & 0x40) != 0) {
                        panAngle -= 512;
                    }
                    panX = (pSector.floorxpanning << 8) + pXSector.floorxpanFrac;
                    panY = (pSector.floorypanning << 8) + pXSector.floorypanFrac;
                    int n = (pSector.floorstat & 8) != 0 ? 1 : 0;
                    pSector.floorxpanning = (byte)((panX += Pragmas.mulscale(Globals.kFrameTicks * panVel, Trig.Cos(panAngle), 30) >> (Engine.picsiz[nTile] & 0xF) - ((pSector.floorstat & 8) != 0 ? 1 : 0)) >> 8);
                    pSector.floorypanning = (byte)((panY -= Pragmas.mulscale(Globals.kFrameTicks * panVel, Trig.Sin(panAngle), 30) >> Engine.picsiz[nTile] / 16 - n) >> 8);
                    pXSector.floorxpanFrac = panX & 0xFF;
                    pXSector.floorypanFrac = panY & 0xFF;
                }
                if (pXSector.panCeiling) {
                    nTile = pSector.ceilingpicnum;
                    if ((pSector.ceilingstat & 0x40) != 0) {
                        panAngle -= 512;
                    }
                    panX = (pSector.ceilingxpanning << 8) + pXSector.ceilxpanFrac;
                    panY = (pSector.ceilingypanning << 8) + pXSector.ceilypanFrac;
                    int n = (pSector.ceilingstat & 8) != 0 ? 1 : 0;
                    pSector.ceilingxpanning = (byte)((panX += Pragmas.mulscale(Globals.kFrameTicks * panVel, Trig.Cos(panAngle), 30) >> (Engine.picsiz[nTile] & 0xF) - ((pSector.ceilingstat & 8) != 0 ? 1 : 0)) >> 8);
                    pSector.ceilingypanning = (byte)((panY += Pragmas.mulscale(Globals.kFrameTicks * panVel, Trig.Sin(panAngle), 30) >> Engine.picsiz[nTile] / 16 - n) >> 8);
                    pXSector.ceilxpanFrac = panX & 0xFF;
                    pXSector.ceilypanFrac = panY & 0xFF;
                }
            }
            ++i;
        }
        i = 0;
        while (i < wallPanCount) {
            short nXWall = wallPanList[i];
            XWALL pXWall = DB.xwall[nXWall];
            int nWall = pXWall.reference;
            if (Engine.wall[nWall].extra != nXWall) {
                Main.game.dassert("wall[nWall].extra == nXWall");
            }
            if (pXWall.panAlways || pXWall.busy != 0) {
                int panXVel = pXWall.panXVel << 10;
                int panYVel = pXWall.panYVel << 10;
                if (!pXWall.panAlways && (pXWall.busy & 0xFFFF) != 0) {
                    panXVel = Pragmas.mulscale(panXVel, pXWall.busy, 16);
                    panYVel = Pragmas.mulscale(panYVel, pXWall.busy, 16);
                }
                short nTile = Engine.wall[nWall].picnum;
                int panX = (Engine.wall[nWall].xpanning << 8) + pXWall.xpanFrac;
                int panY = (Engine.wall[nWall].ypanning << 8) + pXWall.ypanFrac;
                Engine.wall[nWall].xpanning = (byte)((panX += Globals.kFrameTicks * panXVel >> (Engine.picsiz[nTile] & 0xF)) >> 8);
                Engine.wall[nWall].ypanning = (byte)((panY += Globals.kFrameTicks * panYVel >> Engine.picsiz[nTile] / 16) >> 8);
                pXWall.xpanFrac = panX & 0xFF;
                pXWall.ypanFrac = panY & 0xFF;
            }
            ++i;
        }
    }

    public static int GetWaveValue(int nWave, long time, int freq, int amplitude) {
        switch (nWave) {
            case 0: {
                return amplitude;
            }
            case 1: {
                return (int)((time * (long)freq >> 10 & 1L) * (long)amplitude);
            }
            case 2: {
                return (int)(Pragmas.klabs(128L - (time * (long)freq >> 3 & 0xFFL)) * (long)amplitude >> 7);
            }
            case 3: {
                return (int)((time * (long)freq >> 3 & 0xFFL) * (long)amplitude >> 8);
            }
            case 4: {
                return (int)((255L - (time * (long)freq >> 3 & 0xFFL)) * (long)amplitude >> 8);
            }
            case 5: {
                return amplitude + Pragmas.mulscale(amplitude, Trig.Sin((int)(time * (long)freq)), 30) >> 1;
            }
            case 6: {
                return flicker1[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude;
            }
            case 7: {
                return flicker2[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 8: {
                return flicker3[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 9: {
                return flicker4[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 10: {
                return strobe[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 6;
            }
            case 11: {
                int phi = (int)((time * (long)freq & 0x7FFL) << 2);
                if (phi > 2048) {
                    return 0;
                }
                return amplitude - Pragmas.mulscale(amplitude, Trig.Cos(phi), 30) >> 1;
            }
        }
        return 0;
    }

    public static void DoSectorLighting() {
        int i = 0;
        while (i < shadeCount) {
            int nWall;
            int endwall;
            int startwall;
            short ceilingpal;
            short pal;
            short floorpal;
            int value;
            short nXSector = shadeList[i];
            XSECTOR pXSector = DB.xsector[nXSector];
            int nSector = pXSector.reference;
            if (Engine.sector[nSector].extra != nXSector) {
                Main.game.dassert("sector[nSector].extra == nXSector");
            }
            if (pXSector.shade != 0) {
                value = pXSector.shade;
                if (pXSector.shadeFloor) {
                    Engine.sector[nSector].floorshade = (byte)(Engine.sector[nSector].floorshade - value);
                    if (pXSector.color) {
                        floorpal = pXSector.floorpal;
                        pXSector.floorpal = pal = Engine.sector[nSector].floorpal;
                        Engine.sector[nSector].floorpal = floorpal;
                    }
                }
                if (pXSector.shadeCeiling) {
                    Engine.sector[nSector].ceilingshade = (byte)(Engine.sector[nSector].ceilingshade - value);
                    if (pXSector.color) {
                        ceilingpal = pXSector.ceilpal;
                        pXSector.ceilpal = pal = Engine.sector[nSector].ceilingpal;
                        Engine.sector[nSector].ceilingpal = ceilingpal;
                    }
                }
                if (pXSector.shadeWalls) {
                    startwall = Engine.sector[nSector].wallptr;
                    endwall = startwall + Engine.sector[nSector].wallnum - 1;
                    nWall = startwall;
                    while (nWall <= endwall) {
                        Engine.wall[nWall].shade = (byte)(Engine.wall[nWall].shade - value);
                        if (pXSector.color) {
                            Engine.wall[nWall].pal = Engine.sector[nSector].floorpal;
                        }
                        ++nWall;
                    }
                }
                pXSector.shade = 0;
            }
            if (pXSector.shadeAlways || pXSector.busy != 0) {
                short freq = pXSector.freq;
                short nWave = pXSector.wave;
                int amplitude = pXSector.amplitude;
                if (!pXSector.shadeAlways && pXSector.busy != 0) {
                    amplitude = Pragmas.mulscale(amplitude, pXSector.busy, 16);
                }
                value = SECTORFX.GetWaveValue(nWave, Engine.totalclock + pXSector.phase, freq, amplitude);
                if (pXSector.shadeFloor) {
                    Engine.sector[nSector].floorshade = (byte)Gameutils.ClipRange(Engine.sector[nSector].floorshade + value, -128, 127);
                    if (pXSector.color && value != 0) {
                        floorpal = pXSector.floorpal;
                        pXSector.floorpal = pal = Engine.sector[nSector].floorpal;
                        Engine.sector[nSector].floorpal = floorpal;
                    }
                }
                if (pXSector.shadeCeiling) {
                    Engine.sector[nSector].ceilingshade = (byte)Gameutils.ClipRange(Engine.sector[nSector].ceilingshade + value, -128, 127);
                    if (pXSector.color && value != 0) {
                        ceilingpal = pXSector.ceilpal;
                        pXSector.ceilpal = pal = Engine.sector[nSector].ceilingpal;
                        Engine.sector[nSector].ceilingpal = ceilingpal;
                    }
                }
                if (pXSector.shadeWalls) {
                    startwall = Engine.sector[nSector].wallptr;
                    endwall = startwall + Engine.sector[nSector].wallnum - 1;
                    nWall = startwall;
                    while (nWall <= endwall) {
                        Engine.wall[nWall].shade = (byte)Gameutils.ClipRange(Engine.wall[nWall].shade + value, -128, 127);
                        if (pXSector.color && value != 0) {
                            Engine.wall[nWall].pal = Engine.sector[nSector].floorpal;
                        }
                        ++nWall;
                    }
                }
                pXSector.shade = value;
            }
            ++i;
        }
    }
}

