/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import java.nio.ByteBuffer;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.StringUtils;
import ru.m210projects.Build.Types.LittleEndian;

public class SFX {
    public int relVol;
    public int pitch;
    public int pitchrange;
    public int format;
    public int loopStart;
    public String rawName;
    public ByteBuffer hResource;
    public int size;

    public SFX(Resource bb) {
        this.relVol = bb.readInt();
        this.pitch = bb.readInt();
        this.pitchrange = bb.readInt();
        this.format = bb.readInt();
        if (this.format == -1) {
            this.format = 0;
        }
        this.loopStart = bb.readInt();
        this.rawName = bb.readString(bb.size() - bb.position());
        this.rawName = StringUtils.toUnicode(this.rawName);
    }

    public SFX(int relVol, int pitch, int pitchrange, int format, int loopStart, String rawName) {
        this.relVol = relVol;
        this.pitch = pitch;
        this.pitchrange = pitchrange;
        if (format == -1) {
            format = 0;
        }
        this.format = format;
        this.loopStart = loopStart;
        this.rawName = StringUtils.toUnicode(rawName);
    }

    public byte[] getBytes() {
        byte[] buf = new byte[21 + this.rawName.length()];
        int ptr = 0;
        LittleEndian.putInt(buf, ptr, this.relVol);
        LittleEndian.putInt(buf, ptr += 4, this.pitch);
        LittleEndian.putInt(buf, ptr += 4, this.pitchrange);
        LittleEndian.putInt(buf, ptr += 4, this.format);
        LittleEndian.putInt(buf, ptr += 4, this.loopStart);
        System.arraycopy(this.rawName.getBytes(), 0, buf, ptr += 4, this.rawName.length());
        return buf;
    }
}

