/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import ru.m210projects.Blood.Main;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.Types.FadeEffect;
import ru.m210projects.Build.Render.Types.GL10;

public class ScreenEffect {
    public static final String damagefade = "DAMAGE";
    public static final String drownfade = "DROWN";
    public static final String blindfade = "BLIND";
    public static final String pickupfade = "PICKUP";

    public static void FadeInit() {
        Console.Println("Initializing fade effects", 0);
        Main.engine.registerFade(damagefade, new FadeEffect(774, 771){
            private int intensive;

            @Override
            public void update(int intensive) {
                this.intensive = intensive;
                if (intensive > 0) {
                    this.r = 3 * (intensive + 32);
                    this.a = 2 * (intensive + 32);
                } else {
                    this.a = 0;
                    this.r = 0;
                }
                if (this.r > 255) {
                    this.r = 255;
                }
                if (this.a > 255) {
                    this.a = 255;
                }
            }

            @Override
            public void draw(GL10 gl) {
                gl.glBlendFunc(this.sfactor, this.dfactor);
                gl.glColor4ub(this.r, this.g, this.b, this.a);
                gl.glBegin(4);
                gl.glVertex2f(-2.5f, 1.0f);
                gl.glVertex2f(2.5f, 1.0f);
                gl.glVertex2f(0.0f, -2.5f);
                gl.glEnd();
                int multiple = this.intensive / 2;
                if (multiple > 170) {
                    multiple = 170;
                }
                gl.glBlendFunc(771, 771);
                gl.glColor4ub(multiple, 0, 0, 0);
                gl.glBegin(4);
                gl.glVertex2f(-2.5f, 1.0f);
                gl.glVertex2f(2.5f, 1.0f);
                gl.glVertex2f(0.0f, -2.5f);
                gl.glEnd();
            }
        });
        Main.engine.registerFade(drownfade, new FadeEffect(774, 771){
            private int intensive;

            @Override
            public void update(int intensive) {
                this.intensive = intensive;
                if ((intensive >>= 5) < 128) {
                    this.r = this.b = 3 * intensive;
                    this.a = 0;
                } else {
                    this.b = 255;
                    this.r = 255;
                    this.a = 2 * (intensive - 128);
                }
                if (this.r > 255) {
                    this.r = 255;
                }
                if (this.b > 255) {
                    this.b = 255;
                }
                if (this.a > 255) {
                    this.a = 255;
                }
            }

            @Override
            public void draw(GL10 gl) {
                gl.glBlendFunc(this.sfactor, this.dfactor);
                gl.glColor4ub(this.r, this.g, this.b, this.a);
                gl.glBegin(4);
                gl.glVertex2f(-2.5f, 1.0f);
                gl.glVertex2f(2.5f, 1.0f);
                gl.glVertex2f(0.0f, -2.5f);
                gl.glEnd();
                if (this.intensive > 0) {
                    int kintensive = this.intensive >> 6;
                    int attenuation = 128 - kintensive;
                    if (attenuation < 0) {
                        attenuation = 0;
                    }
                    gl.glBlendFunc(774, 774);
                    gl.glColor4ub(attenuation, attenuation, attenuation, 0);
                    gl.glBegin(4);
                    gl.glVertex2f(-2.5f, 1.0f);
                    gl.glVertex2f(2.5f, 1.0f);
                    gl.glVertex2f(0.0f, -2.5f);
                    if (this.intensive > 2000) {
                        gl.glVertex2f(-2.5f, 1.0f);
                        gl.glVertex2f(2.5f, 1.0f);
                        gl.glVertex2f(0.0f, -2.5f);
                    }
                    gl.glEnd();
                    int multiple = this.intensive / 10;
                    if (multiple > 160) {
                        multiple = 160;
                    }
                    gl.glBlendFunc(771, 771);
                    gl.glColor4ub(0, 0, 0, multiple);
                    gl.glBegin(4);
                    gl.glVertex2f(-2.5f, 1.0f);
                    gl.glVertex2f(2.5f, 1.0f);
                    gl.glVertex2f(0.0f, -2.5f);
                    gl.glEnd();
                }
            }
        });
        Main.engine.registerFade(blindfade, new FadeEffect(774, 774){
            private int intensive;

            @Override
            public void update(int intensive) {
                this.intensive = intensive;
            }

            @Override
            public void draw(GL10 gl) {
                if (this.intensive > 0) {
                    int attenuation = 128 - this.intensive;
                    if (attenuation < 0) {
                        attenuation = 0;
                    }
                    gl.glBlendFunc(this.sfactor, this.dfactor);
                    gl.glColor4ub(attenuation, attenuation, attenuation, 0);
                    gl.glBegin(4);
                    gl.glVertex2f(-2.5f, 1.0f);
                    gl.glVertex2f(2.5f, 1.0f);
                    gl.glVertex2f(0.0f, -2.5f);
                    gl.glVertex2f(-2.5f, 1.0f);
                    gl.glVertex2f(2.5f, 1.0f);
                    gl.glVertex2f(0.0f, -2.5f);
                    gl.glEnd();
                    int multiple = this.intensive;
                    if (multiple > 255) {
                        multiple = 255;
                    }
                    gl.glBlendFunc(771, 771);
                    gl.glColor4ub(0, 0, 0, multiple);
                    gl.glBegin(4);
                    gl.glVertex2f(-2.5f, 1.0f);
                    gl.glVertex2f(2.5f, 1.0f);
                    gl.glVertex2f(0.0f, -2.5f);
                    gl.glEnd();
                }
            }
        });
        Main.engine.registerFade(pickupfade, new FadeEffect(774, 771){
            private int intensive;

            @Override
            public void update(int intensive) {
                this.intensive = intensive;
                if (intensive > 0) {
                    this.g = this.r = 4 * intensive;
                    this.a = intensive + 32;
                } else {
                    this.a = 0;
                    this.r = 0;
                    this.g = 0;
                }
                if (this.r > 255) {
                    this.r = 255;
                }
                if (this.g > 255) {
                    this.g = 255;
                }
                if (this.a > 255) {
                    this.a = 255;
                }
            }

            @Override
            public void draw(GL10 gl) {
                gl.glBlendFunc(this.sfactor, this.dfactor);
                gl.glColor4ub(this.r, this.g, this.b, this.a);
                gl.glBegin(4);
                gl.glVertex2f(-2.5f, 1.0f);
                gl.glVertex2f(2.5f, 1.0f);
                gl.glVertex2f(0.0f, -2.5f);
                gl.glEnd();
                if (this.intensive > 0) {
                    int multiple = this.intensive;
                    if (multiple > 255) {
                        multiple = 255;
                    }
                    gl.glBlendFunc(771, 771);
                    gl.glColor4ub(multiple, multiple, 0, 0);
                    gl.glBegin(4);
                    gl.glVertex2f(-2.5f, 1.0f);
                    gl.glVertex2f(2.5f, 1.0f);
                    gl.glVertex2f(0.0f, -2.5f);
                    gl.glEnd();
                }
            }
        });
    }

    public static void resetEffects() {
        Main.engine.updateFade(damagefade, 0);
        Main.engine.updateFade(drownfade, 0);
        Main.engine.updateFade(blindfade, 0);
        Main.engine.updateFade(pickupfade, 0);
    }
}

