/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.DataResource;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Strhandler;

public abstract class Group {
    protected boolean debug = false;
    protected static final byte DYNAMIC = 1;
    protected static final byte REMOVABLE = 2;
    public Cache1D.PackageType type;
    public byte flags;
    public String name;
    public int numfiles;
    protected HashMap<String, Integer> lookup = new HashMap();
    protected List<GroupResource> filelist = new ArrayList<GroupResource>();
    protected HashSet<String> fmtlist = new HashSet();

    protected void add(GroupResource res) {
        this.lookup.put(res.filenamext, this.filelist.size());
        this.filelist.add(res);
        this.fmtlist.add(res.fileformat);
    }

    public void setFlags(boolean dynamic, boolean removable) {
        this.flags = removable ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
        this.flags = dynamic ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean isRemovable() {
        return (this.flags & 2) != 0;
    }

    public boolean isDynamic() {
        return (this.flags & 1) != 0;
    }

    public boolean contains(String filename) {
        Integer out;
        return filename != null && (out = this.lookup.get(Strhandler.toLowerCase(filename))) != null;
    }

    public boolean contains(int fileid, String type) {
        if (type == null) {
            return false;
        }
        if (!this.containsType(type = Strhandler.toLowerCase(type))) {
            return false;
        }
        for (GroupResource res : this.filelist) {
            if (!type.equals(res.fileformat) || fileid != res.fileid) continue;
            return true;
        }
        return false;
    }

    public GroupResource open(String filename) {
        GroupResource res;
        Integer out;
        if (filename != null && !filename.isEmpty() && (out = this.lookup.get(Strhandler.toLowerCase(filename))) != null && this.open(res = this.filelist.get(out))) {
            return res;
        }
        return null;
    }

    public GroupResource open(int fileid, String type) {
        if (type == null) {
            Console.Println("type == null");
            return null;
        }
        if (!this.containsType(type = Strhandler.toLowerCase(type))) {
            return null;
        }
        for (GroupResource res : this.filelist) {
            if (!type.equals(res.fileformat) || fileid != res.fileid || !this.open(res)) continue;
            return res;
        }
        return null;
    }

    protected abstract boolean open(GroupResource var1);

    public List<GroupResource> getList() {
        ArrayList<GroupResource> list = new ArrayList<GroupResource>();
        list.addAll(this.filelist);
        return list;
    }

    public boolean containsType(String type) {
        if (type == null) {
            return false;
        }
        return this.fmtlist.contains(Strhandler.toLowerCase(type));
    }

    public abstract int position();

    public void dispose() {
        for (GroupResource res : this.filelist) {
            if (res.isClosed()) continue;
            res.close();
        }
        this.filelist.clear();
        this.fmtlist.clear();
    }

    public boolean add(String filename, byte[] data, int fileid) {
        if (filename == null || data == null) {
            return false;
        }
        DataResource file = new DataResource(this, filename, fileid, data);
        this.add(file);
        ++this.numfiles;
        return true;
    }

    public String toString() {
        String txt = "Group name: " + this.name + "\r\n";
        txt = String.valueOf(txt) + "Num files: " + this.numfiles + "\r\n";
        txt = String.valueOf(txt) + "File list: \r\n";
        for (GroupResource res : this.filelist) {
            txt = String.valueOf(txt) + res.toString();
        }
        return txt;
    }
}

