/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Loader.MD3;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.FloatBuffer;
import java.util.HashMap;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Loader.MD3.MD3Frame;
import ru.m210projects.Build.Loader.MD3.MD3Header;
import ru.m210projects.Build.Loader.MD3.MD3Model;
import ru.m210projects.Build.Loader.MD3.MD3Shader;
import ru.m210projects.Build.Loader.MD3.MD3Surface;
import ru.m210projects.Build.Loader.MD3.MD3Vertice;
import ru.m210projects.Build.Loader.Model;

public class MD3Loader {
    private static int maxtris = 0;
    private static int maxverts = 0;

    public static Model load(Resource bb) {
        MD3Header header = MD3Loader.loadHeader(bb);
        if (header.ident != 860898377 || header.version != 15) {
            return null;
        }
        MD3Frame[] frames = MD3Loader.loadFrames(header, bb);
        HashMap<String, Matrix4>[] tags = MD3Loader.loadTags(header, bb);
        MD3Surface[] surfaces = MD3Loader.loadSurfaces(header, bb);
        MD3Model m = new MD3Model();
        m.mdnum = 3;
        m.scale = 0.01f;
        m.head = header;
        m.numskins = header.numSkins;
        m.numframes = header.numFrames;
        m.frames = frames;
        m.tags = tags;
        m.surfaces = surfaces;
        m.indicesBuffer = BufferUtils.newShortBuffer(maxtris * 3);
        m.verticesBuffer = BufferUtils.newFloatBuffer(maxverts * 3);
        return m;
    }

    private static MD3Header loadHeader(Resource bb) {
        MD3Header header = new MD3Header();
        header.ident = bb.readInt();
        header.version = bb.readInt();
        header.filename = MD3Loader.readString(bb, 64);
        header.flags = bb.readInt();
        header.numFrames = bb.readInt();
        header.numTags = bb.readInt();
        header.numSurfaces = bb.readInt();
        header.numSkins = bb.readInt();
        header.offsetFrames = bb.readInt();
        header.offsetTags = bb.readInt();
        header.offsetSurfaces = bb.readInt();
        header.offsetEnd = bb.readInt();
        return header;
    }

    private static MD3Frame[] loadFrames(MD3Header header, Resource bb) {
        bb.seek(header.offsetFrames, Resource.Whence.Set);
        MD3Frame[] out = new MD3Frame[header.numFrames];
        int i = 0;
        while (i < header.numFrames) {
            MD3Frame frame = new MD3Frame();
            frame.min = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
            frame.max = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
            frame.origin = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
            frame.radius = bb.readFloat();
            frame.name = MD3Loader.readString(bb, 16);
            out[i] = frame;
            ++i;
        }
        return out;
    }

    private static HashMap<String, Matrix4>[] loadTags(MD3Header header, Resource bb) {
        bb.seek(header.offsetTags, Resource.Whence.Set);
        HashMap[] out = new HashMap[header.numFrames];
        int k = 0;
        while (k < header.numFrames) {
            out[k] = new HashMap();
            int i = 0;
            while (i < header.numTags) {
                String tagName = MD3Loader.readString(bb, 64);
                Vector3 pos = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
                Vector3 xAxis = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
                Vector3 yAxis = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
                Vector3 zAxis = new Vector3(bb.readFloat().floatValue(), bb.readFloat().floatValue(), bb.readFloat().floatValue());
                Matrix4 mat = new Matrix4();
                mat.set(xAxis, yAxis, zAxis, pos);
                out[k].put(tagName, mat);
                ++i;
            }
            ++k;
        }
        return out;
    }

    private static MD3Surface[] loadSurfaces(MD3Header header, Resource bb) {
        int offsetSurfaces = header.offsetSurfaces;
        MD3Surface[] out = new MD3Surface[header.numSurfaces];
        int i = 0;
        while (i < header.numSurfaces) {
            bb.seek(offsetSurfaces, Resource.Whence.Set);
            MD3Surface surf = new MD3Surface();
            surf.id = bb.readInt();
            surf.nam = MD3Loader.readString(bb, 64);
            surf.flags = bb.readInt();
            surf.numframes = bb.readInt();
            surf.numshaders = bb.readInt();
            surf.numverts = bb.readInt();
            surf.numtris = bb.readInt();
            surf.ofstris = bb.readInt();
            surf.ofsshaders = bb.readInt();
            surf.ofsuv = bb.readInt();
            surf.ofsxyzn = bb.readInt();
            surf.ofsend = bb.readInt();
            surf.tris = MD3Loader.loadTriangles(surf, offsetSurfaces, bb);
            surf.shaders = MD3Loader.loadShaders(surf, offsetSurfaces, bb);
            surf.uv = MD3Loader.loadUVs(surf, offsetSurfaces, bb);
            surf.xyzn = MD3Loader.loadVertices(surf, offsetSurfaces, bb);
            maxtris = Math.max(maxtris, surf.numtris);
            maxverts = Math.max(maxtris, surf.numverts);
            offsetSurfaces += surf.ofsend;
            out[i] = surf;
            ++i;
        }
        return out;
    }

    private static int[][] loadTriangles(MD3Surface surf, int offsetSurfaces, Resource bb) {
        bb.seek(offsetSurfaces + surf.ofstris, Resource.Whence.Set);
        int[][] out = new int[surf.numtris][3];
        int i = 0;
        while (i < surf.numtris) {
            out[i][0] = bb.readInt();
            out[i][1] = bb.readInt();
            out[i][2] = bb.readInt();
            ++i;
        }
        return out;
    }

    private static FloatBuffer loadUVs(MD3Surface surf, int offsetSurfaces, Resource bb) {
        bb.seek(offsetSurfaces + surf.ofsuv, Resource.Whence.Set);
        FloatBuffer out = BufferUtils.newFloatBuffer(2 * surf.numverts);
        int i = 0;
        while (i < surf.numverts) {
            out.put(bb.readFloat().floatValue());
            out.put(bb.readFloat().floatValue());
            ++i;
        }
        out.flip();
        return out;
    }

    private static MD3Vertice[] loadVertices(MD3Surface surf, int offsetSurfaces, Resource bb) {
        bb.seek(offsetSurfaces + surf.ofsxyzn, Resource.Whence.Set);
        MD3Vertice[] out = new MD3Vertice[surf.numframes * surf.numverts];
        int i = 0;
        while (i < out.length) {
            MD3Vertice xyzn = new MD3Vertice();
            xyzn.x = bb.readShort();
            xyzn.y = bb.readShort();
            xyzn.z = bb.readShort();
            xyzn.nlat = (short)(bb.readByte() & 0xFF);
            xyzn.nlng = (short)(bb.readByte() & 0xFF);
            out[i] = xyzn;
            ++i;
        }
        return out;
    }

    private static MD3Shader[] loadShaders(MD3Surface surf, int offsetSurfaces, Resource bb) {
        bb.seek(offsetSurfaces + surf.ofsshaders, Resource.Whence.Set);
        MD3Shader[] out = new MD3Shader[surf.numshaders];
        int i = 0;
        while (i < surf.numshaders) {
            MD3Shader shader = new MD3Shader();
            shader.name = MD3Loader.readString(bb, 64);
            shader.index = bb.readInt();
            out[i] = shader;
            ++i;
        }
        return out;
    }

    private static String readString(Resource bb, int len) {
        byte[] buf = new byte[len];
        bb.read(buf);
        int i = 0;
        while (i < buf.length) {
            if (buf[i] == 0) {
                return new String(buf, 0, i);
            }
            ++i;
        }
        return new String(buf);
    }
}

