/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Loader.Voxels;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ShortArray;
import java.util.Arrays;
import java.util.HashMap;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Loader.Voxels.VOXModel;
import ru.m210projects.Build.Loader.Voxels.Voxel;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.TextureHandle.GLTile;

public class KVXLoader {
    private static int xsiz;
    private static int ysiz;
    private static int zsiz;
    private static int yzsiz;
    private static HashMap<Integer, Byte> vcol;
    private static Vector2[] shp;
    private static int[] shcntmal;
    private static int shcnt;
    private static int shcntp;
    private static int mytexo5;
    private static int[] zbit;
    private static int gmaxx;
    private static int gmaxy;
    private static int garea;
    private static int[] pow2m1;
    private static FloatArray vertices;
    private static ShortArray indicies;
    private static FloatArray uvs;
    private static int[] pal;

    public static Voxel load(Resource buffer) {
        vertices = new FloatArray();
        indicies = new ShortArray();
        uvs = new FloatArray();
        try {
            Voxel vox = new Voxel(buffer);
            pal = KVXLoader.getPalette(buffer);
            int voxmip = 0;
            VOXModel vm = KVXLoader.vox2poly(vox, voxmip);
            if (vm != null) {
                vm.mdnum = 1;
                vm.bscale = 1.0f;
                vm.scale = 1.0f;
                vm.xsiz = xsiz;
                vm.ysiz = ysiz;
                vm.zsiz = zsiz;
                vm.xpiv = (float)vox.xpiv[voxmip] / 256.0f;
                vm.ypiv = (float)vox.ypiv[voxmip] / 256.0f;
                vm.zpiv = (float)vox.zpiv[voxmip] / 256.0f;
                vm.is8bit = 1;
                vm.texid = new GLTile[256];
                vm.verticesBuffer = BufferUtils.newFloatBuffer(KVXLoader.vertices.size);
                vm.indicesBuffer = BufferUtils.newShortBuffer(KVXLoader.indicies.size);
                vm.uv = BufferUtils.newFloatBuffer(KVXLoader.uvs.size);
                vm.verticesBuffer.put(vertices.toArray());
                vm.indicesBuffer.put(indicies.toArray());
                vm.uv.put(uvs.toArray());
                vm.verticesBuffer.flip();
                vm.indicesBuffer.flip();
                vm.uv.flip();
                vox.model = vm;
            }
            KVXLoader.dispose();
            return vox;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Voxel load(String filepath) {
        Resource res = BuildGdx.cache.open(filepath, 0);
        if (res == null) {
            return null;
        }
        Voxel m = KVXLoader.load(res);
        res.close();
        return m;
    }

    private static int[] getPalette(Resource dat) {
        int[] pal = new int[256];
        dat.seek(dat.size() - 768, Resource.Whence.Set);
        byte[] buf = new byte[768];
        dat.read(buf);
        int i = 0;
        while (i < 256) {
            pal[i] = (buf[3 * i + 0] << 18) + (buf[3 * i + 1] << 10) + (buf[3 * i + 2] << 2) + (i << 24);
            ++i;
        }
        return pal;
    }

    private static void putvox(int x, int y, int z, byte col) {
        vcol.put(z += x * yzsiz + y * zsiz, col);
    }

    private static byte getvox(int x, int y, int z) {
        Byte col = vcol.get(z += x * yzsiz + y * zsiz);
        if (col == null) {
            return 0;
        }
        return (byte)(((long)pal[col & 0xFF] & 0xFFFFFFFFL) >> 24);
    }

    private static void setzrange1(int[] lptr, int z0, int z1) {
        if (((z0 ^ z1) & 0xFFFFFFE0) == 0) {
            int n = z0 >> 5;
            lptr[n] = lptr[n] | ~(-1 << (z1 & 0x1F)) & -1 << (z0 & 0x1F);
            return;
        }
        int z = z0 >> 5;
        int ze = z1 >> 5;
        int n = z++;
        lptr[n] = lptr[n] | -1 << (z0 & 0x1F);
        while (z < ze) {
            lptr[z] = -1;
            ++z;
        }
        int n2 = z;
        lptr[n2] = lptr[n2] | ~(-1 << (z1 & 0x1F));
    }

    /*
     * Unable to fully structure code
     */
    private static void setrect(int x0, int y0, int dx, int dy) {
        block3: {
            i = y0 * KVXLoader.mytexo5 + (x0 >> 5);
            c = ((dx += x0 - 1) >> 5) - (x0 >> 5);
            m = ~KVXLoader.pow2m1[x0 & 31];
            m1 = KVXLoader.pow2m1[(dx & 31) + 1];
            if (c != 0) ** GOTO lbl25
            m &= m1;
            while (dy != 0) {
                v0 = i;
                KVXLoader.zbit[v0] = KVXLoader.zbit[v0] | m;
                --dy;
                i += KVXLoader.mytexo5;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                v1 = i;
                KVXLoader.zbit[v1] = KVXLoader.zbit[v1] | m;
                x = 1;
                while (x < c) {
                    KVXLoader.zbit[i + x] = -1;
                    ++x;
                }
                v2 = i + x;
                KVXLoader.zbit[v2] = KVXLoader.zbit[v2] | m1;
                --dy;
                i += KVXLoader.mytexo5;
lbl25:
                // 2 sources

                ** while (dy != 0)
            }
        }
    }

    private static int isolid(int[] vbit, int x, int y, int z) {
        if (((long)x & 0xFFFFFFFFL) >= ((long)xsiz & 0xFFFFFFFFL)) {
            return 0;
        }
        if (((long)y & 0xFFFFFFFFL) >= ((long)ysiz & 0xFFFFFFFFL)) {
            return 0;
        }
        if (((long)z & 0xFFFFFFFFL) >= ((long)zsiz & 0xFFFFFFFFL)) {
            return 0;
        }
        return vbit[(z += x * yzsiz + y * zsiz) >> 5] & 1 << (z & 0x1F);
    }

    private static void daquad(VOXModel gvox, int i, int x0, int y0, int z0, int x1, int y1, int z1, int x2, int y2, int z2, int face) {
        if (i == 0) {
            KVXLoader.cntquad(gvox, x0, y0, z0, x1, y1, z1, x2, y2, z2, face);
        } else {
            KVXLoader.addquad(gvox, x0, y0, z0, x1, y1, z1, x2, y2, z2, face);
        }
    }

    private static void cntquad(VOXModel gvox, int x0, int y0, int z0, int x1, int y1, int z1, int x2, int y2, int z2, int face) {
        int x = Pragmas.klabs(x2 - x0);
        int y = Pragmas.klabs(y2 - y0);
        int z = Pragmas.klabs(z2 - z0);
        if (x == 0) {
            x = z;
        } else if (y == 0) {
            y = z;
        }
        if (x < y) {
            z = x;
            x = y;
            y = z;
        }
        int n = shcnt + y * shcntp + x;
        shcntmal[n] = shcntmal[n] + 1;
        if (x > gmaxx) {
            gmaxx = x;
        }
        if (y > gmaxy) {
            gmaxy = y;
        }
        garea += x * y;
        ++gvox.qcnt;
    }

    private static void addquad(VOXModel gvox, int x0, int y0, int z0, int x1, int y1, int z1, int x2, int y2, int z2, int face) {
        int i;
        int nx = 0;
        int ny = 0;
        int nz = 0;
        int x = Pragmas.klabs(x2 - x0);
        int y = Pragmas.klabs(y2 - y0);
        int z = Pragmas.klabs(z2 - z0);
        if (x == 0) {
            x = y;
            y = z;
            i = 0;
        } else if (y == 0) {
            y = z;
            i = 1;
        } else {
            i = 2;
        }
        if (x < y) {
            z = x;
            x = y;
            y = z;
            i += 3;
        }
        int n = shcnt + y * shcntp + x;
        int n2 = shcntmal[n];
        shcntmal[n] = n2 + 1;
        z = n2;
        int lptr = (int)(KVXLoader.shp[z].y * (float)gvox.mytexx + KVXLoader.shp[z].x);
        switch (face) {
            case 0: {
                ny = y1;
                x2 = x0;
                x0 = x1;
                x1 = x2;
                break;
            }
            case 1: {
                ny = y0++;
                ++y1;
                ++y2;
                break;
            }
            case 2: {
                nz = z1++;
                y0 = y2;
                y2 = y1;
                y1 = y0;
                ++z0;
                ++z2;
                break;
            }
            case 3: {
                nz = z0;
                break;
            }
            case 4: {
                nx = x1++;
                y2 = y0;
                y0 = y1;
                y1 = y2;
                ++x0;
                ++x2;
                break;
            }
            case 5: {
                nx = x0;
            }
        }
        int yy = 0;
        while (yy < y) {
            int xx = 0;
            while (xx < x) {
                switch (face) {
                    case 0: {
                        if (i < 3) {
                            nx = x1 + x - 1 - xx;
                            nz = z1 + yy;
                            break;
                        }
                        nx = x1 + y - 1 - yy;
                        nz = z1 + xx;
                        break;
                    }
                    case 1: {
                        if (i < 3) {
                            nx = x0 + xx;
                            nz = z0 + yy;
                            break;
                        }
                        nx = x0 + yy;
                        nz = z0 + xx;
                        break;
                    }
                    case 2: {
                        if (i < 3) {
                            nx = x1 - x + xx;
                            ny = y1 - 1 - yy;
                            break;
                        }
                        nx = x1 - 1 - yy;
                        ny = y1 - 1 - xx;
                        break;
                    }
                    case 3: {
                        if (i < 3) {
                            nx = x0 + xx;
                            ny = y0 + yy;
                            break;
                        }
                        nx = x0 + yy;
                        ny = y0 + xx;
                        break;
                    }
                    case 4: {
                        if (i < 3) {
                            ny = y1 + x - 1 - xx;
                            nz = z1 + yy;
                            break;
                        }
                        ny = y1 + y - 1 - yy;
                        nz = z1 + xx;
                        break;
                    }
                    case 5: {
                        if (i < 3) {
                            ny = y0 + xx;
                            nz = z0 + yy;
                            break;
                        }
                        ny = y0 + yy;
                        nz = z0 + xx;
                    }
                }
                gvox.mytex[lptr + xx] = KVXLoader.getvox(nx, ny, nz);
                ++xx;
            }
            ++yy;
            lptr += gvox.mytexx;
        }
        VOXModel.voxrect_t qptr = gvox.quad[gvox.qcnt];
        qptr.v[0].x = x0;
        qptr.v[0].y = y0;
        qptr.v[0].z = z0;
        qptr.v[1].x = x1;
        qptr.v[1].y = y1;
        qptr.v[1].z = z1;
        qptr.v[2].x = x2;
        qptr.v[2].y = y2;
        qptr.v[2].z = z2;
        int j = 0;
        while (j < 3) {
            qptr.v[j].u = (int)KVXLoader.shp[z].x;
            qptr.v[j].v = (int)KVXLoader.shp[z].y;
            ++j;
        }
        if (i < 3) {
            qptr.v[1].u += x;
        } else {
            qptr.v[1].v += y;
        }
        qptr.v[2].u += x;
        qptr.v[2].v += y;
        qptr.v[3].u = qptr.v[0].u - qptr.v[1].u + qptr.v[2].u;
        qptr.v[3].v = qptr.v[0].v - qptr.v[1].v + qptr.v[2].v;
        qptr.v[3].x = qptr.v[0].x - qptr.v[1].x + qptr.v[2].x;
        qptr.v[3].y = qptr.v[0].y - qptr.v[1].y + qptr.v[2].y;
        qptr.v[3].z = qptr.v[0].z - qptr.v[1].z + qptr.v[2].z;
        if (gvox.qfacind[face] < 0) {
            gvox.qfacind[face] = gvox.qcnt;
        }
        int vertexOffset = KVXLoader.vertices.size / 3;
        i = 0;
        while (i < 4) {
            vertices.addAll(qptr.v[i].x, qptr.v[i].y, qptr.v[i].z);
            uvs.addAll((float)qptr.v[i].u / (float)gvox.mytexx, (float)qptr.v[i].v / (float)gvox.mytexy);
            ++i;
        }
        indicies.addAll((short)vertexOffset, (short)(1 + vertexOffset), (short)(2 + vertexOffset), (short)(3 + vertexOffset));
        ++gvox.qcnt;
    }

    private static VOXModel vox2poly(Voxel vox, int mip) {
        int z;
        int j;
        int y;
        int oz = 0;
        xsiz = vox.xsiz[mip];
        ysiz = vox.ysiz[mip];
        zsiz = vox.zsiz[mip];
        yzsiz = ysiz * zsiz;
        int[] vbit = new int[(xsiz * yzsiz + 31 >> 3) + 1];
        vcol = new HashMap();
        pow2m1 = new int[33];
        int cptr = 0;
        int x = 0;
        while (x < xsiz) {
            y = 0;
            j = x * yzsiz;
            while (y < ysiz) {
                int voxptr = vox.xyoffs[mip][x][y];
                short voxend = vox.xyoffs[mip][x][y + 1];
                int z1 = 0;
                while (voxptr < voxend) {
                    int ztop = vox.data[mip][cptr] & 0xFF;
                    int zleng = vox.data[mip][cptr + 1] & 0xFF;
                    if ((vox.data[mip][cptr + 2] & 0x10) == 0) {
                        KVXLoader.setzrange1(vbit, j + z1, j + ztop);
                    }
                    z1 = ztop + zleng;
                    KVXLoader.setzrange1(vbit, j + ztop, j + z1);
                    cptr += 3;
                    z = ztop;
                    while (z < z1) {
                        if (cptr >= vox.data[mip].length) break;
                        KVXLoader.putvox(x, y, z, vox.data[mip][cptr++]);
                        ++z;
                    }
                    voxptr += zleng + 3;
                }
                ++y;
                j += zsiz;
            }
            ++x;
        }
        VOXModel gvox = new VOXModel();
        x = xsiz;
        y = ysiz;
        z = zsiz;
        if (x < y && x < z) {
            x = z;
        } else if (y < z) {
            y = z;
        }
        if (x < y) {
            z = x;
            x = y;
            y = z;
        }
        shcntp = x;
        int i = x * y;
        shcntmal = new int[i];
        shcnt = -shcntp - 1;
        garea = 0;
        gmaxy = 0;
        gmaxx = 0;
        if (pow2m1[32] != -1) {
            i = 0;
            while (i < 32) {
                KVXLoader.pow2m1[i] = (1 << i) - 1;
                ++i;
            }
            KVXLoader.pow2m1[32] = -1;
        }
        i = 0;
        while (i < 7) {
            gvox.qfacind[i] = -1;
            ++i;
        }
        i = Math.max(ysiz, zsiz) + 1 << 2;
        int[] bx0 = new int[i << 1];
        int[] by0 = new int[i << 1];
        int cnt = 0;
        while (cnt < 2) {
            int ov;
            gvox.qcnt = 0;
            Arrays.fill(by0, -1);
            int v = 0;
            i = -1;
            while (i <= 1) {
                y = 0;
                while (y < ysiz) {
                    x = 0;
                    while (x <= xsiz) {
                        z = 0;
                        while (z <= zsiz) {
                            ov = v;
                            int n = v = KVXLoader.isolid(vbit, x, y, z) != 0 && KVXLoader.isolid(vbit, x, y + i, z) == 0 ? 1 : 0;
                            if (by0[z] >= 0 && (by0[z] != oz || v >= ov)) {
                                KVXLoader.daquad(gvox, cnt, bx0[z], y, by0[z], x, y, by0[z], x, y, z, i >= 0 ? 1 : 0);
                                by0[z] = -1;
                            }
                            if (v > ov) {
                                oz = z;
                            } else if (v < ov && by0[z] != oz) {
                                bx0[z] = x;
                                by0[z] = oz;
                            }
                            ++z;
                        }
                        ++x;
                    }
                    ++y;
                }
                i += 2;
            }
            i = -1;
            while (i <= 1) {
                z = 0;
                while (z < zsiz) {
                    x = 0;
                    while (x <= xsiz) {
                        y = 0;
                        while (y <= ysiz) {
                            ov = v;
                            int n = v = KVXLoader.isolid(vbit, x, y, z) != 0 && KVXLoader.isolid(vbit, x, y, z - i) == 0 ? 1 : 0;
                            if (by0[y] >= 0 && (by0[y] != oz || v >= ov)) {
                                KVXLoader.daquad(gvox, cnt, bx0[y], by0[y], z, x, by0[y], z, x, y, z, (i >= 0 ? 1 : 0) + 2);
                                by0[y] = -1;
                            }
                            if (v > ov) {
                                oz = y;
                            } else if (v < ov && by0[y] != oz) {
                                bx0[y] = x;
                                by0[y] = oz;
                            }
                            ++y;
                        }
                        ++x;
                    }
                    ++z;
                }
                i += 2;
            }
            i = -1;
            while (i <= 1) {
                x = 0;
                while (x < xsiz) {
                    y = 0;
                    while (y <= ysiz) {
                        z = 0;
                        while (z <= zsiz) {
                            ov = v;
                            int n = v = KVXLoader.isolid(vbit, x, y, z) != 0 && KVXLoader.isolid(vbit, x - i, y, z) == 0 ? 1 : 0;
                            if (by0[z] >= 0 && (by0[z] != oz || v >= ov)) {
                                KVXLoader.daquad(gvox, cnt, x, bx0[z], by0[z], x, y, by0[z], x, y, z, (i >= 0 ? 1 : 0) + 4);
                                by0[z] = -1;
                            }
                            if (v > ov) {
                                oz = z;
                            } else if (v < ov && by0[z] != oz) {
                                bx0[z] = y;
                                by0[z] = oz;
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                i += 2;
            }
            if (cnt == 0) {
                shp = new Vector2[gvox.qcnt];
                int vc = 0;
                while (vc < gvox.qcnt) {
                    KVXLoader.shp[vc] = new Vector2();
                    ++vc;
                }
                int sc = 0;
                y = gmaxy;
                while (y != 0) {
                    x = gmaxx;
                    while (x >= y) {
                        i = shcntmal[shcnt + y * shcntp + x];
                        KVXLoader.shcntmal[KVXLoader.shcnt + y * KVXLoader.shcntp + x] = sc;
                        while (i > 0) {
                            KVXLoader.shp[sc].x = x;
                            KVXLoader.shp[sc].y = y;
                            ++sc;
                            --i;
                        }
                        --x;
                    }
                    --y;
                }
                gvox.mytexx = 32;
                while (gvox.mytexx < gmaxx) {
                    gvox.mytexx <<= 1;
                }
                gvox.mytexy = 32;
                while (gvox.mytexy < gmaxy) {
                    gvox.mytexy <<= 1;
                }
                while (gvox.mytexx * gvox.mytexy * 8 < garea * 9) {
                    if (gvox.mytexx <= gvox.mytexy) {
                        gvox.mytexx <<= 1;
                        continue;
                    }
                    gvox.mytexy <<= 1;
                }
                mytexo5 = gvox.mytexx >> 5;
                i = gvox.mytexx * gvox.mytexy + 31 >> 5 << 2;
                zbit = new int[i];
                v = gvox.mytexx * gvox.mytexy;
                z = 0;
                while (z < sc) {
                    block56: {
                        int y0;
                        int x0;
                        int dx = (int)KVXLoader.shp[z].x;
                        int dy = (int)KVXLoader.shp[z].y;
                        i = v;
                        do {
                            int a = (int)(Math.random() * 32767.0);
                            int b = (int)(Math.random() * 32767.0);
                            x0 = a * (gvox.mytexx + 1 - dx) >> 15;
                            y0 = b * (gvox.mytexy + 1 - dy) >> 15;
                            if (--i >= 0) continue;
                            Arrays.fill(zbit, 0);
                            j = 0;
                            y = gmaxy;
                            while (y != 0) {
                                x = gmaxx;
                                while (x >= y) {
                                    i = shcntmal[shcnt + y * shcntp + x];
                                    while (j < i) {
                                        KVXLoader.shp[j].x = x0;
                                        KVXLoader.shp[j].y = y0;
                                        ++j;
                                    }
                                    x0 = x--;
                                    y0 = y;
                                }
                                --y;
                            }
                            while (j < sc) {
                                KVXLoader.shp[j].x = x0;
                                KVXLoader.shp[j].y = y0;
                                ++j;
                            }
                            if (gvox.mytexx <= gvox.mytexy) {
                                gvox.mytexx <<= 1;
                            } else {
                                gvox.mytexy <<= 1;
                            }
                            mytexo5 = gvox.mytexx >> 5;
                            i = gvox.mytexx * gvox.mytexy + 31 >> 5 << 2;
                            v = gvox.mytexx * gvox.mytexy;
                            z = -1;
                            break block56;
                        } while (KVXLoader.isrectfree(x0, y0, dx, dy) == 0);
                        while (y0 != 0 && KVXLoader.isrectfree(x0, y0 - 1, dx, 1) != 0) {
                            --y0;
                        }
                        while (x0 != 0 && KVXLoader.isrectfree(x0 - 1, y0, 1, dy) != 0) {
                            --x0;
                        }
                        KVXLoader.setrect(x0, y0, dx, dy);
                        KVXLoader.shp[z].x = x0;
                        KVXLoader.shp[z].y = y0;
                    }
                    ++z;
                }
                gvox.quad = new VOXModel.voxrect_t[gvox.qcnt];
                gvox.initQuads();
                gvox.mytex = new byte[gvox.mytexx * gvox.mytexy];
            }
            ++cnt;
        }
        return gvox;
    }

    /*
     * Unable to fully structure code
     */
    private static int isrectfree(int x0, int y0, int dx, int dy) {
        block7: {
            i = y0 * KVXLoader.mytexo5 + (x0 >> 5);
            c = ((dx += x0 - 1) >> 5) - (x0 >> 5);
            m = ~KVXLoader.pow2m1[x0 & 31];
            m1 = KVXLoader.pow2m1[(dx & 31) + 1];
            if (c != 0) ** GOTO lbl26
            m &= m1;
            while (dy != 0) {
                if ((KVXLoader.zbit[i] & m) != 0) {
                    return 0;
                }
                --dy;
                i += KVXLoader.mytexo5;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                if ((KVXLoader.zbit[i] & m) != 0) {
                    return 0;
                }
                x = 1;
                while (x < c) {
                    if (KVXLoader.zbit[i + x] != 0) {
                        return 0;
                    }
                    ++x;
                }
                if ((KVXLoader.zbit[i + x] & m1) != 0) {
                    return 0;
                }
                --dy;
                i += KVXLoader.mytexo5;
lbl26:
                // 2 sources

                ** while (dy != 0)
            }
        }
        return 1;
    }

    private static void dispose() {
        vertices = null;
        indicies = null;
        uvs = null;
        vcol = null;
        shp = null;
        zbit = null;
        shcntmal = null;
        pow2m1 = null;
        pal = null;
    }
}

