/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Loader.Voxels;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Iterator;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Loader.Model;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.TextureBuffer;
import ru.m210projects.Build.Settings.GLSettings;

public class VOXModel
extends Model {
    public GLTile[] texid;
    public voxrect_t[] quad;
    public int qcnt;
    public int[] qfacind = new int[7];
    public int mytexx;
    public int mytexy;
    public byte[] mytex;
    public int xsiz;
    public int ysiz;
    public int zsiz;
    public float xpiv;
    public float ypiv;
    public float zpiv;
    public int is8bit;
    public FloatBuffer uv;

    public void initQuads() {
        int vx = 0;
        while (vx < this.qcnt) {
            this.quad[vx] = new voxrect_t();
            ++vx;
        }
    }

    public GLTile loadskin(int dapal, boolean bit8texture) {
        if (Engine.palookup[dapal] == null || bit8texture) {
            dapal = 0;
        }
        if (this.texid[dapal] != null) {
            return this.texid[dapal];
        }
        VoxTileData dat = new VoxTileData(this, dapal, bit8texture);
        this.texid[dapal] = new GLTile(dat, dapal, false);
        this.texid[dapal].setupTextureFilter(GLSettings.glfiltermodes[0], 1);
        return this.texid[dapal];
    }

    public GLTile bindSkin(TextureManager textureCache, int pal, int shade, float alpha) {
        GLTile tile;
        int dapal = pal;
        if (textureCache.getShader() != null) {
            pal = 0;
        }
        if (this.texid[pal] == null) {
            this.loadskin(pal, textureCache.getShader() != null);
        }
        if ((tile = textureCache.bind(this.texid[pal])).isRequireShader()) {
            textureCache.getShader().setShaderParams(dapal, shade);
            textureCache.getShader().shaderDrawLastIndex(true);
            textureCache.getShader().shaderTransparent(alpha);
        }
        return tile;
    }

    @Override
    public Iterator<GLTile[]> getSkins() {
        Iterator<GLTile[]> it = new Iterator<GLTile[]>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public GLTile[] next() {
                return VOXModel.this.texid;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    @Override
    public void clearSkins() {
        int i = 0;
        while (i < this.texid.length) {
            GLTile tex = this.texid[i];
            if (tex != null) {
                tex.delete();
                this.texid[i] = null;
            }
            ++i;
        }
    }

    private static class VoxTileData
    extends TileData {
        public final TextureBuffer data;
        public final int width;
        public final int height;
        public final boolean indexed;

        public VoxTileData(VOXModel vox, int dapal, boolean indexed) {
            this.width = vox.mytexx;
            this.height = vox.mytexy;
            this.indexed = indexed;
            TextureBuffer buffer = VoxTileData.getTmpBuffer(indexed ? this.width * this.height : this.width * this.height * 4);
            buffer.clear();
            if (!indexed) {
                int y = 0;
                while (y < this.height) {
                    int wpptr = y * this.width;
                    int x = 0;
                    while (x < this.width) {
                        int wp = wpptr << 2;
                        int dacol = vox.mytex[wpptr] & 0xFF;
                        dacol = Engine.palookup[dapal][dacol] & 0xFF;
                        buffer.putInt(wp, Engine.curpalette.getRGB(dacol) + -16777216);
                        ++x;
                        ++wpptr;
                    }
                    ++y;
                }
            } else {
                buffer.putBytes(vox.mytex, 0, this.width * this.height);
            }
            this.data = buffer;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public ByteBuffer getPixels() {
            return this.data.getBuffer();
        }

        @Override
        public int getGLType() {
            return 5121;
        }

        @Override
        public int getGLInternalFormat() {
            return 6408;
        }

        @Override
        public int getGLFormat() {
            return this.indexed ? 6409 : 6408;
        }

        @Override
        public TileData.PixelFormat getPixelFormat() {
            return this.indexed ? TileData.PixelFormat.Pal8 : TileData.PixelFormat.Rgba;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isClamped() {
            return true;
        }

        @Override
        public boolean isHighTile() {
            return false;
        }
    }

    public class vert_t {
        public int x;
        public int y;
        public int z;
        public int u;
        public int v;
    }

    public class voxrect_t {
        public vert_t[] v = new vert_t[4];

        public voxrect_t() {
            int i = 0;
            while (i < 4) {
                this.v[i] = new vert_t();
                ++i;
            }
        }
    }
}

