/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Loader.Voxels;

import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Loader.Voxels.VOXModel;

public class Voxel {
    public static final int MAXVOXMIPS = 5;
    public int[] xsiz;
    public int[] ysiz;
    public int[] zsiz;
    public int[] xpiv;
    public int[] ypiv;
    public int[] zpiv;
    public short[][][] xyoffs;
    public int[][] slabxoffs;
    public byte[][] data;
    public int scale = 65536;
    public VOXModel model;

    public Voxel(Resource dat) throws Exception {
        int mip = 0;
        this.xsiz = new int[5];
        this.ysiz = new int[5];
        this.zsiz = new int[5];
        this.xpiv = new int[5];
        this.ypiv = new int[5];
        this.zpiv = new int[5];
        this.xyoffs = new short[5][][];
        this.slabxoffs = new int[5][];
        this.data = new byte[5][];
        while (dat.position() < dat.size() - 768) {
            int mip1leng = dat.readInt();
            int xs = this.xsiz[mip] = dat.readInt().intValue();
            int ys = this.ysiz[mip] = dat.readInt().intValue();
            this.zsiz[mip] = dat.readInt();
            this.xpiv[mip] = dat.readInt();
            this.ypiv[mip] = dat.readInt();
            this.zpiv[mip] = dat.readInt();
            int offset = (xs + 1 << 2) + (xs * (ys + 1) << 1);
            this.slabxoffs[mip] = new int[xs + 1];
            int i = 0;
            while (i <= xs) {
                this.slabxoffs[mip][i] = dat.readInt() - offset;
                ++i;
            }
            this.xyoffs[mip] = new short[xs][ys + 1];
            i = 0;
            while (i < xs) {
                int j = 0;
                while (j <= ys) {
                    this.xyoffs[mip][i][j] = dat.readShort();
                    ++j;
                }
                ++i;
            }
            i = dat.size() - dat.position() - 768;
            if (i < mip1leng - (24 + offset)) break;
            this.data[mip] = new byte[mip1leng - (24 + offset)];
            dat.read(this.data[mip]);
            ++mip;
        }
        if (mip == 0) {
            throw new Exception("Can't load voxel");
        }
    }

    public VOXModel getModel() {
        return this.model;
    }
}

