/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.Input.ButtonMap;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class MenuJoyList
extends MenuKeyboardList {
    private final BuildControllers gpmanager;
    public int menupal;

    public MenuJoyList(BuildGame app, BuildFont font, int x, int y, int width, int len, MenuProc callback) {
        super(app.pSlider, app.pCfg, font, x, y, width, len, callback);
        this.gpmanager = app.pInput.ctrlGetGamepadManager();
        this.len += this.cfg.joymap.length;
    }

    @Override
    public void draw(MenuHandler handler) {
        int px = this.x;
        int py = this.y;
        boolean offset = false;
        int i = this.l_nMin;
        while (i >= 0 && i < this.l_nMin + this.nListItems && i < this.len) {
            String text;
            int pal = this.pal_left;
            int pal2 = this.pal_right;
            int shade = handler.getShade(i == this.l_nFocus ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            if (i < this.cfg.joymap.length) {
                text = this.cfg.joymap[i].getName();
                pal = this.menupal;
            } else {
                text = this.keynames[i - this.cfg.joymap.length].getName();
                if (i - this.cfg.joymap.length == BuildConfig.GameKeys.Menu_Toggle.getNum()) {
                    pal = this.menupal;
                }
            }
            if (this.l_nMin < this.cfg.joymap.length && i == this.cfg.joymap.length) {
                py += this.mFontOffset();
                offset = true;
            }
            if (i == this.l_nFocus) {
                pal2 = pal = handler.getPal(this.font, this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            }
            if (offset && i >= this.l_nMin + this.nListItems - 1) break;
            String key = i < this.cfg.joymap.length ? ButtonMap.buttonName(this.cfg.gJoyMenukeys[((BuildConfig.MenuKeys)this.cfg.joymap[i]).getJoyNum()]) : (this.cfg.keymap[i - this.cfg.joymap.length] instanceof BuildConfig.MenuKeys ? ButtonMap.buttonName(this.cfg.gJoyMenukeys[((BuildConfig.MenuKeys)this.cfg.keymap[i - this.cfg.joymap.length]).getJoyNum()]) : (this.cfg.gpadkeys[i - this.cfg.joymap.length] >= 0 ? ButtonMap.buttonName(this.cfg.gpadkeys[i - this.cfg.joymap.length]) : "N/A"));
            if (i == this.l_nFocus && this.l_set == 1 && (Engine.totalclock & 0x20) != 0) {
                key = "____";
            }
            char[] k = key.toCharArray();
            this.font.drawText(px, py, text.toCharArray(), shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
            this.font.drawText(this.x + this.width - this.slider.getScrollerWidth() - 2 - this.font.getWidth(k), py, k, shade, pal2, BuildFont.TextAlign.Left, 2, this.fontShadow);
            py += this.mFontOffset();
            ++i;
        }
        this.scrollerHeight = this.nListItems * this.mFontOffset();
        int nList = Gameutils.BClipLow(this.len - this.nListItems, 1);
        int posy = this.y + (this.scrollerHeight - this.slider.getScrollerHeight()) * this.l_nMin / nList;
        this.scrollerX = this.x + this.width - this.slider.getScrollerWidth() + 5;
        this.slider.drawScrollerBackground(this.scrollerX, this.y, this.scrollerHeight, 0, 0);
        this.slider.drawScroller(this.scrollerX, posy, handler.getShade(this.isTouched ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null), 0);
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.l_set == 0) {
            switch (opt) {
                case MWUP: {
                    if (this.l_nMin > 0) {
                        --this.l_nMin;
                    }
                    return false;
                }
                case MWDW: {
                    if (this.l_nMin < this.len - this.nListItems) {
                        ++this.l_nMin;
                    }
                    return false;
                }
                case UP: {
                    --this.l_nFocus;
                    if (this.l_nFocus >= 0 && this.l_nFocus < this.l_nMin) {
                        --this.l_nMin;
                    }
                    if (this.l_nFocus < 0) {
                        this.l_nFocus = this.len - 1;
                        this.l_nMin = this.len - this.nListItems;
                    }
                    return false;
                }
                case DW: {
                    ++this.l_nFocus;
                    if (this.l_nFocus >= this.l_nMin + this.nListItems && this.l_nFocus < this.len) {
                        ++this.l_nMin;
                    }
                    if (this.l_nFocus >= this.len) {
                        this.l_nFocus = 0;
                        this.l_nMin = 0;
                    }
                    if (this.l_nMin < this.cfg.joymap.length && this.l_nFocus == this.l_nMin + this.nListItems - 1) {
                        ++this.l_nMin;
                    }
                    return false;
                }
                case ENTER: 
                case LMB: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    if (opt == MenuHandler.MenuOpt.LMB && this.isTouched) {
                        if (this.len <= this.nListItems) {
                            return false;
                        }
                        int nList = Gameutils.BClipLow(this.len - this.nListItems, 1);
                        int nRange = this.scrollerHeight;
                        int py = this.y;
                        this.l_nFocus = -1;
                        this.l_nMin = Gameutils.BClipRange((this.touchY - py) * nList / nRange, 0, nList);
                        return false;
                    }
                    if (this.l_nFocus != -1 && this.callback != null) {
                        this.callback.run(handler, this);
                    }
                    Engine.getInput().resetKeyStatus();
                    return false;
                }
                case DELETE: {
                    if (this.l_nFocus == -1) {
                        return false;
                    }
                    if (this.l_nFocus < this.cfg.joymap.length) {
                        this.cfg.gJoyMenukeys[((BuildConfig.MenuKeys)this.cfg.joymap[this.l_nFocus]).getJoyNum()] = -1;
                    } else {
                        int focus = this.l_nFocus - this.cfg.joymap.length;
                        this.cfg.gpadkeys[focus] = -1;
                        if (focus == BuildConfig.GameKeys.Show_Console.getNum()) {
                            Console.setCaptureKey(-1, 3);
                        }
                    }
                    return false;
                }
                case PGUP: {
                    this.l_nFocus -= this.nListItems - 1;
                    if (this.l_nFocus >= 0 && this.l_nFocus < this.l_nMin && this.l_nMin > 0) {
                        this.l_nMin -= this.nListItems - 1;
                    }
                    if (this.l_nFocus < 0 || this.l_nMin < 0) {
                        this.l_nFocus = 0;
                        this.l_nMin = 0;
                    }
                    return false;
                }
                case PGDW: {
                    this.l_nFocus += this.nListItems - 1;
                    if (this.l_nFocus >= this.l_nMin + this.nListItems && this.l_nFocus < this.len) {
                        this.l_nMin += this.nListItems - 1;
                    }
                    if (this.l_nFocus >= this.len || this.l_nMin > this.len - this.nListItems) {
                        this.l_nFocus = this.len - 1;
                        this.l_nMin = this.len >= this.nListItems ? this.len - this.nListItems : this.len - 1;
                    }
                    return false;
                }
                case HOME: {
                    this.l_nFocus = 0;
                    this.l_nMin = 0;
                    return false;
                }
                case END: {
                    this.l_nFocus = this.len - 1;
                    this.l_nMin = this.len >= this.nListItems ? this.len - this.nListItems : this.len - 1;
                    return false;
                }
            }
            return this.m_pMenu.mNavigation(opt);
        }
        this.l_pressedId = opt;
        if ((this.flags & 4) != 0 && this.callback != null) {
            this.callback.run(handler, this);
        }
        if (this.l_nFocus == BuildConfig.GameKeys.Menu_Toggle.getNum()) {
            this.gpmanager.resetButtonStatus();
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.l_set != 0) {
            return false;
        }
        if (!BuildGdx.input.isTouched()) {
            this.isTouched = false;
        }
        this.touchY = my;
        if (mx > this.scrollerX && mx < this.scrollerX + this.slider.getScrollerWidth()) {
            this.isTouched = BuildGdx.input.isTouched();
            return true;
        }
        if (!this.isTouched) {
            int py = this.y;
            int i = this.l_nMin;
            while (i >= 0 && i < this.l_nMin + this.nListItems && i < this.len) {
                if (my >= py && my < py + this.font.getHeight()) {
                    if (this.l_nMin < this.cfg.joymap.length && i == this.cfg.joymap.length) {
                        return false;
                    }
                    this.l_nFocus = i;
                    if (this.l_nMin < this.cfg.joymap.length && i > this.cfg.joymap.length) {
                        --this.l_nFocus;
                    }
                    return true;
                }
                py += this.mFontOffset();
                ++i;
            }
        }
        return false;
    }
}

