/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;

public abstract class LoadingAdapter
extends ScreenAdapter {
    protected Runnable toLoad;
    protected int frames;
    private String title;
    public BuildNet net;
    public Engine engine;
    protected BuildGame game;
    protected MenuHandler menu;

    public LoadingAdapter(BuildGame game) {
        this.game = game;
        this.engine = game.pEngine;
        this.net = game.pNet;
        this.menu = game.pMenu;
    }

    @Override
    public void show() {
        this.net.ready2send = false;
        this.frames = 0;
    }

    @Override
    public void hide() {
        this.title = null;
    }

    public ScreenAdapter init(Runnable toLoad) {
        this.toLoad = toLoad;
        return this;
    }

    public ScreenAdapter setTitle(String title) {
        this.title = title;
        return this;
    }

    protected abstract void draw(String var1, float var2);

    @Override
    public void render(float delta) {
        this.engine.clearview(0);
        this.draw(this.title, delta);
        if (this.toLoad != null && this.frames > 10) {
            BuildGdx.app.postRunnable(this.toLoad);
            this.toLoad = null;
        }
        this.engine.sampletimer();
        this.engine.nextpage();
        ++this.frames;
    }

    @Override
    public void pause() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        this.game.updateColorCorrection();
    }
}

