/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GdxRender.GdxBatch;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.TileFont;

public class GdxOrphoRen
extends OrphoRenderer {
    protected final TextureManager textureCache;
    protected final GdxBatch batch;
    protected final ShapeRenderer shape;

    public GdxOrphoRen(Engine engine, TextureManager textureCache) {
        super(engine);
        this.textureCache = textureCache;
        this.batch = new GdxBatch();
        this.shape = new ShapeRenderer();
    }

    @Override
    public void init() {
    }

    @Override
    public void uninit() {
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
    }

    @Override
    public void printext(TileFont font, int xpos, int ypos, char[] text, int col, int shade, Renderer.Transparent bit, float scale) {
    }

    @Override
    public void printext(int xpos, int ypos, int col, int backcol, char[] text, int fontsize, float scale) {
        BuildGdx.gl.glDisable(3008);
        BuildGdx.gl.glDepthMask(false);
        BuildGdx.gl.glEnable(3042);
        int xsiz = fontsize != 0 ? 4 : 8;
        int ysiz = fontsize != 0 ? 6 : 8;
        xpos <<= 16;
        ypos <<= 16;
        this.bindBatch();
        if (backcol >= 0) {
            this.batch.setColor((float)Engine.curpalette.getRed(backcol) / 255.0f, (float)Engine.curpalette.getGreen(backcol) / 255.0f, (float)Engine.curpalette.getBlue(backcol) / 255.0f, 1.0f);
        }
        int oxpos = xpos;
        int c = 0;
        int line = 0;
        this.batch.setColor((float)Engine.curpalette.getRed(col) / 255.0f, (float)Engine.curpalette.getGreen(col) / 255.0f, (float)Engine.curpalette.getBlue(col) / 255.0f, 1.0f);
        while (c < text.length && text[c] != '\u0000') {
            if (text[c] == '\n') {
                text[c] = '\u0000';
                ++line;
                xpos = oxpos - (int)(scale * (float)(8 >> fontsize));
            }
            if (text[c] == '\r') {
                text[c] = '\u0000';
            }
            int yoffs = (int)(scale * (float)line * (float)(8 >> fontsize));
            xpos = (int)((float)xpos + scale * (float)(xsiz << 16));
            ++c;
        }
        BuildGdx.gl.glDepthMask(true);
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        col = Engine.palookup[0][col] & 0xFF;
        this.shape.begin(ShapeRenderer.ShapeType.Line);
        this.shape.setColor(Engine.curpalette.getRed(col), Engine.curpalette.getGreen(col), Engine.curpalette.getBlue(col), 255.0f);
        this.shape.line((float)x1 / 4096.0f, (float)Engine.ydim - (float)y1 / 4096.0f, (float)x2 / 4096.0f, (float)Engine.ydim - (float)y2 / 4096.0f);
        this.shape.end();
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        GLTile pth;
        if (picnum >= Engine.MAXTILES) {
            return;
        }
        if (cx1 > cx2 || cy1 > cy2) {
            return;
        }
        if (z <= 16) {
            return;
        }
        Tile pic = this.engine.getTile(picnum);
        if (pic.getType() != Tile.AnimType.None) {
            picnum += this.engine.animateoffs(picnum, 49152);
        }
        if (!pic.hasSize()) {
            return;
        }
        int method = 0;
        if ((dastat & 0x40) == 0) {
            method = 1;
            if ((dastat & 1) != 0) {
                method = (dastat & 0x20) == 0 ? 2 : 3;
            }
        } else {
            method |= 0x100;
        }
        method |= 4;
        int xsiz = pic.getWidth();
        int ysiz = pic.getHeight();
        int xoff = 0;
        int yoff = 0;
        if ((dastat & 0x10) == 0) {
            xoff = pic.getOffsetX() + (xsiz >> 1);
            yoff = pic.getOffsetY() + (ysiz >> 1);
        }
        if ((dastat & 4) != 0) {
            yoff = ysiz - yoff;
        }
        if (picnum >= Engine.MAXTILES) {
            picnum = 0;
        }
        if (Engine.palookup[dapalnum & 0xFF] == null) {
            dapalnum = 0;
        }
        this.engine.setgotpic(picnum);
        if (pic.data == null) {
            this.engine.loadtile(picnum);
        }
        if ((pth = this.textureCache.bind(picnum, dapalnum, dashade, 0, method)) == null) {
            return;
        }
        if ((method & 3) == 0) {
            this.batch.disableBlending();
        } else {
            this.batch.enableBlending();
        }
        float shade = (float)(Engine.numshades - Math.min(Math.max(dashade, 0), Engine.numshades)) / (float)Engine.numshades;
        float alpha = 1.0f;
        switch (method & 3) {
            case 2: {
                alpha = Engine.TRANSLUSCENT1;
                break;
            }
            case 3: {
                alpha = Engine.TRANSLUSCENT2;
            }
        }
        this.bindBatch();
        this.batch.setColor(shade, shade, shade, alpha);
    }

    private void bindBatch() {
        if (!this.batch.isDrawing()) {
            this.batch.begin();
        }
    }

    @Override
    public void nextpage() {
        if (this.batch.isDrawing()) {
            this.batch.end();
        }
    }
}

