/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Polymost;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Loader.MD2.MD2Frame;
import ru.m210projects.Build.Loader.MD2.MD2Model;
import ru.m210projects.Build.Loader.MD3.MD3Model;
import ru.m210projects.Build.Loader.MD3.MD3Surface;
import ru.m210projects.Build.Loader.MD3.MD3Vertice;
import ru.m210projects.Build.Loader.MDModel;
import ru.m210projects.Build.Loader.MDSkinmap;
import ru.m210projects.Build.Loader.Model;
import ru.m210projects.Build.Loader.Voxels.VOXModel;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.Types.GL10;
import ru.m210projects.Build.Render.Types.Palette;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;

public class PolymostModelRenderer {
    private Polymost parent;
    private final TextureManager textureCache;
    private Engine engine;
    private GL10 gl;
    private final Color polyColor = new Color();
    private final float[][] matrix = new float[4][4];
    private final float[] dvoxphack = new float[2];
    private final float[] dvoxclut = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private final Vector3 dvoxfp = new Vector3();
    private final Vector3 dvoxm0 = new Vector3();
    private final Vector3 modela0 = new Vector3();
    private Vector3 cScale = new Vector3();
    private Vector3 nScale = new Vector3();

    public PolymostModelRenderer(Polymost parent) {
        this.parent = parent;
        this.textureCache = parent.textureCache;
        this.engine = parent.engine;
        this.gl = parent.gl;
    }

    public int voxdraw(VOXModel m, SPRITE tspr) {
        if (m == null) {
            return 0;
        }
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
            return 0;
        }
        int globalorientation = this.parent.globalorientation;
        boolean xflip = (globalorientation & 4) != 0;
        boolean yflip = (globalorientation & 8) != 0;
        this.dvoxm0.x = m.scale;
        this.dvoxm0.y = m.scale;
        this.dvoxm0.z = m.scale;
        this.modela0.y = 0.0f;
        this.modela0.x = 0.0f;
        this.modela0.z = (yflip ? -m.zadd : m.zadd) * m.scale;
        float f = (float)tspr.xrepeat * 0.8f / 64.0f * m.bscale;
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 16) {
            f *= 1.25f;
        }
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
            f *= 1.25f;
        }
        this.dvoxm0.x *= f;
        this.modela0.x *= f;
        f = -f;
        this.dvoxm0.y *= f;
        this.modela0.y *= f;
        f = (float)tspr.yrepeat / 64.0f * m.bscale;
        this.dvoxm0.z *= f;
        this.modela0.z *= f;
        float x0 = tspr.x;
        float k0 = tspr.z;
        float xoff = tspr.xoffset;
        float yoff = tspr.yoffset;
        xflip = (globalorientation & 4) != 0;
        yflip = (globalorientation & 8) != 0;
        if (yflip) {
            yoff = -yoff;
        }
        if ((globalorientation & 0x80) == 0) {
            k0 -= (float)(m.zsiz * tspr.yrepeat << 1);
        }
        if (yflip && (globalorientation & 0x10) == 0) {
            k0 += ((float)this.engine.getTile(tspr.picnum).getHeight() * 0.5f - m.zpiv) * (float)tspr.yrepeat * 8.0f;
        }
        f = 3.3554432E7f / (float)(Engine.xdimen * Engine.viewingrange);
        float g = 32.0f / (float)((double)Engine.xdimen * this.parent.gxyaspect);
        this.dvoxm0.y *= f;
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
            this.dvoxm0.y *= -1.0f;
        }
        this.modela0.y = ((x0 - (float)Engine.globalposx) / 1024.0f + this.modela0.y) * f;
        this.dvoxm0.x *= -f;
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
            this.dvoxm0.x *= -1.0f;
        }
        if (xflip) {
            this.dvoxm0.x *= -1.0f;
        }
        this.modela0.x = ((float)(tspr.y - Engine.globalposy) / -1024.0f + this.modela0.x) * -f;
        this.dvoxm0.z *= g;
        if (yflip) {
            this.dvoxm0.z *= -1.0f;
        }
        this.modela0.z = ((k0 - (float)Engine.globalposz) / -16384.0f + this.modela0.z) * g;
        if (this.parent.grhalfxdown10x >= 0.0f ^ yflip ^ xflip) {
            this.gl.glFrontFace(2304);
        } else {
            this.gl.glFrontFace(2305);
        }
        this.gl.glEnable(2884);
        this.gl.glCullFace(1029);
        this.gl.glEnable(3553);
        this.polyColor.g = this.polyColor.b = ((float)Engine.numshades - Math.min(Math.max((float)Engine.globalshade * this.parent.shadescale + (float)m.shadeoff, 0.0f), (float)Engine.numshades)) / (float)Engine.numshades;
        this.polyColor.r = this.polyColor.b;
        if (this.parent.defs != null) {
            Palette p = this.parent.defs.texInfo.getTints(Engine.globalpal);
            this.polyColor.r *= (float)p.r / 255.0f;
            this.polyColor.g *= (float)p.g / 255.0f;
            this.polyColor.b *= (float)p.b / 255.0f;
        }
        this.polyColor.a = (tspr.cstat & 2) != 0 ? ((tspr.cstat & 0x200) == 0 ? Engine.TRANSLUSCENT1 : Engine.TRANSLUSCENT2) : 1.0f;
        if ((tspr.cstat & 2) != 0) {
            this.gl.glEnable(3042);
        }
        this.gl.glMatrixMode(5888);
        boolean newmatrix = false;
        if (!newmatrix) {
            this.md3_vox_calcmat_common(tspr, this.modela0, f, this.matrix);
        } else {
            this.md3_vox_calcmat_common(tspr, this.modela0);
        }
        if (!newmatrix) {
            this.matrix[2][3] = 0.0f;
            this.matrix[1][3] = 0.0f;
            this.matrix[0][3] = 0.0f;
            this.matrix[3][3] = 1.0f;
            this.gl.glLoadMatrixf(this.matrix);
        }
        this.gl.glScalef(this.dvoxm0.x / 64.0f, this.dvoxm0.z / 64.0f, this.dvoxm0.y / 64.0f);
        this.gl.glTranslatef(-xoff, yoff, 0.0f);
        if ((m.flags & 2) != 0) {
            this.gl.glRotatef(Engine.totalclock % 360, 0.0f, 1.0f, 0.0f);
        }
        if ((tspr.cstat & 0x30) == 32) {
            this.gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            this.gl.glTranslatef(-m.xpiv, -m.ypiv, -m.zpiv);
            this.gl.glRotatef(90.0f, -1.0f, 0.0f, 0.0f);
            this.gl.glTranslatef(0.0f, -m.ypiv, -m.zpiv);
        } else {
            this.gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            this.gl.glTranslatef(-m.xpiv, -m.ypiv, -m.zpiv);
        }
        float ru = 1.0f / (float)m.mytexx;
        float rv = 1.0f / (float)m.mytexy;
        this.dvoxphack[0] = 0.0f;
        this.dvoxphack[1] = 0.00390625f;
        m.bindSkin(this.textureCache, Engine.globalpal, Engine.globalshade, this.polyColor.a);
        if (this.textureCache.isUseShader()) {
            this.textureCache.getShader().setVisibility((int)this.parent.globalfog.combvis);
        }
        this.parent.globalfog.apply();
        if (Polymost.r_vertexarrays != 0) {
            this.gl.glColor4f(this.polyColor.r, this.polyColor.g, this.polyColor.b, this.polyColor.a);
            this.gl.glEnableClientState(32888);
            this.gl.glTexCoordPointer(2, 5126, 0, m.uv);
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(3, 5126, 0, m.verticesBuffer);
            this.gl.glDrawElements(7, 0, 5123, m.indicesBuffer);
        } else {
            this.gl.glBegin(7);
            int i = 0;
            int fi = 0;
            while (i < m.qcnt) {
                if (i == m.qfacind[fi]) {
                    f = this.dvoxclut[fi++];
                    this.gl.glColor4f(this.polyColor.r * f, this.polyColor.g * f, this.polyColor.b * f, this.polyColor.a * f);
                }
                int xx = m.quad[i].v[0].x + m.quad[i].v[2].x;
                int yy = m.quad[i].v[0].y + m.quad[i].v[2].y;
                int zz = m.quad[i].v[0].z + m.quad[i].v[2].z;
                int j = 0;
                while (j < 4) {
                    this.gl.glTexCoord2d((float)m.quad[i].v[j].u * ru, (float)m.quad[i].v[j].v * rv);
                    this.dvoxfp.x = (float)m.quad[i].v[j].x - this.dvoxphack[xx > m.quad[i].v[j].x * 2 ? 1 : 0] + this.dvoxphack[xx < m.quad[i].v[j].x * 2 ? 1 : 0];
                    this.dvoxfp.y = (float)m.quad[i].v[j].y - this.dvoxphack[yy > m.quad[i].v[j].y * 2 ? 1 : 0] + this.dvoxphack[yy < m.quad[i].v[j].y * 2 ? 1 : 0];
                    this.dvoxfp.z = (float)m.quad[i].v[j].z - this.dvoxphack[zz > m.quad[i].v[j].z * 2 ? 1 : 0] + this.dvoxphack[zz < m.quad[i].v[j].z * 2 ? 1 : 0];
                    this.gl.glVertex3d(this.dvoxfp.x, this.dvoxfp.y, this.dvoxfp.z);
                    ++j;
                }
                ++i;
            }
            this.gl.glEnd();
        }
        if (Polymost.r_vertexarrays != 0) {
            this.gl.glDisableClientState(32884);
            this.gl.glDisableClientState(32888);
        }
        this.gl.glDisable(2884);
        this.gl.glLoadIdentity();
        return 1;
    }

    private void modelPrepare(MDModel m, SPRITE tspr, int xoff, int yoff) {
        Tile pic = this.engine.getTile(tspr.picnum);
        float f = m.interpol;
        float g = 1.0f - f;
        if (m.mdnum == 2) {
            this.cScale.set(m.scale, m.scale, m.scale);
        } else {
            this.cScale.set(m.scale, -m.scale, m.scale);
        }
        this.cScale.scl(g, g, g);
        if (m.mdnum == 2) {
            this.nScale.set(m.scale, m.scale, m.scale);
        } else {
            this.nScale.set(m.scale, -m.scale, m.scale);
        }
        this.nScale.scl(f, f, f);
        int globalorientation = this.parent.globalorientation;
        this.modela0.y = 0.0f;
        this.modela0.x = 0.0f;
        this.modela0.z = ((globalorientation & 8) != 0 ? -m.zadd : m.zadd) * m.scale;
        float x0 = tspr.x;
        float k0 = tspr.z;
        if ((globalorientation & 0x80) != 0 && (globalorientation & 0x30) != 32) {
            k0 += (float)(pic.getHeight() * tspr.yrepeat << 1);
        }
        if ((globalorientation & 8) != 0) {
            yoff = -yoff;
            this.cScale.scl(1.0f, -1.0f, 1.0f);
            this.nScale.scl(1.0f, -1.0f, 1.0f);
            this.modela0.z = -this.modela0.z;
            k0 -= (float)(pic.getHeight() * tspr.yrepeat << 2);
        }
        if ((globalorientation & 4) != 0) {
            xoff = -xoff;
            this.cScale.scl(1.0f, 1.0f, -1.0f);
            this.nScale.scl(1.0f, 1.0f, -1.0f);
            this.modela0.y = -this.modela0.y;
        }
        x0 += (float)(xoff * (tspr.xrepeat >> 2));
        k0 -= (float)(yoff * tspr.yrepeat << 2);
        this.modela0.z += m.yoffset * m.scale;
        f = (float)tspr.xrepeat / 64.0f * m.bscale;
        this.cScale.scl(-f, f, f);
        this.nScale.scl(-f, f, f);
        this.modela0.scl(f, -f, (float)tspr.yrepeat / 64.0f * m.bscale);
        float k1 = tspr.y;
        if ((globalorientation & 0x30) == 32) {
            this.cScale.scl(1.0f, -1.0f, -1.0f);
            this.nScale.scl(1.0f, -1.0f, -1.0f);
            this.modela0.z = -this.modela0.z;
            this.modela0.y = -this.modela0.y;
            f = this.modela0.x;
            this.modela0.x = this.modela0.z;
            this.modela0.z = f;
            k1 += (float)(pic.getHeight() * tspr.yrepeat >> 3);
        }
        f = 3.3554432E7f / (float)(Engine.xdimen * Engine.viewingrange);
        g = (float)(32.0 / ((double)Engine.xdimen * this.parent.gxyaspect));
        this.cScale.scl(f, -f, g);
        this.nScale.scl(f, -f, g);
        this.modela0.y = ((x0 - (float)Engine.globalposx) / 1024.0f + this.modela0.y) * f;
        this.modela0.x = ((k1 - (float)Engine.globalposy) / 1024.0f + this.modela0.x) * f;
        this.modela0.z = ((k0 - (float)Engine.globalposz) / -16384.0f + this.modela0.z) * g;
        this.md3_vox_calcmat_common(tspr, this.modela0, f, this.matrix);
        if ((globalorientation & 0x30) == 32) {
            f = this.matrix[1][0];
            this.matrix[1][0] = this.matrix[2][0] * 16.0f;
            this.matrix[2][0] = -f * 0.0625f;
            f = this.matrix[1][1];
            this.matrix[1][1] = this.matrix[2][1] * 16.0f;
            this.matrix[2][1] = -f * 0.0625f;
            f = this.matrix[1][2];
            this.matrix[1][2] = this.matrix[2][2] * 16.0f;
            this.matrix[2][2] = -f * 0.0625f;
        }
        this.matrix[2][3] = 0.0f;
        this.matrix[1][3] = 0.0f;
        this.matrix[0][3] = 0.0f;
        this.matrix[3][3] = 1.0f;
        this.gl.glMatrixMode(5888);
        this.gl.glLoadMatrixf(this.matrix);
        this.gl.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        if ((m.flags & 2) != 0) {
            this.gl.glRotatef(Engine.totalclock % 360, 0.0f, 1.0f, 0.0f);
        }
        if (this.parent.grhalfxdown10x >= 0.0f ^ (globalorientation & 8) != 0 ^ (globalorientation & 4) != 0) {
            this.gl.glFrontFace(2304);
        } else {
            this.gl.glFrontFace(2305);
        }
        this.gl.glEnable(2884);
        if (m.mdnum == 2) {
            this.gl.glCullFace(1028);
        } else {
            this.gl.glCullFace(1029);
        }
        this.gl.glEnable(3553);
        this.polyColor.g = this.polyColor.b = ((float)Engine.numshades - Math.min(Math.max((float)Engine.globalshade * this.parent.shadescale + (float)m.shadeoff, 0.0f), (float)Engine.numshades)) / (float)Engine.numshades;
        this.polyColor.r = this.polyColor.b;
        DefScript defs = this.parent.defs;
        if (defs != null && ((m.flags & 1) == 0 || tspr.owner < Engine.MAXSPRITES && Engine.sector[Engine.sprite[tspr.owner].sectnum].floorpal != 0)) {
            Palette p = defs.texInfo.getTints(Engine.globalpal);
            this.polyColor.r *= (float)p.r / 255.0f;
            this.polyColor.g *= (float)p.g / 255.0f;
            this.polyColor.b *= (float)p.b / 255.0f;
            Palette pdetail = defs.texInfo.getTints(255);
            if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                this.polyColor.r *= (float)pdetail.r / 255.0f;
                this.polyColor.g *= (float)pdetail.g / 255.0f;
                this.polyColor.b *= (float)pdetail.b / 255.0f;
            }
        }
        this.polyColor.a = (tspr.cstat & 2) != 0 ? ((tspr.cstat & 0x200) == 0 ? Engine.TRANSLUSCENT1 : Engine.TRANSLUSCENT2) : 1.0f;
        if (m.usesalpha) {
            float al = 0.0f;
            if (this.parent.alphahackarray[tspr.picnum] != 0.0f) {
                al = this.parent.alphahackarray[tspr.picnum];
            }
            this.gl.glEnable(3042);
            this.gl.glEnable(3008);
            this.gl.glAlphaFunc(516, al);
        } else if ((tspr.cstat & 2) != 0) {
            this.gl.glEnable(3042);
        }
        this.gl.glColor4f(this.polyColor.r, this.polyColor.g, this.polyColor.b, this.polyColor.a);
    }

    public int md2draw(MD2Model m, SPRITE tspr, int xoff, int yoff) {
        DefScript defs = this.parent.defs;
        m.updateanimation(defs, tspr);
        this.modelPrepare(m, tspr, xoff, yoff);
        int rendered = 0;
        int skinnum = defs.mdInfo.getParams((int)tspr.picnum).skinnum;
        GLTile texid = m.loadskin(defs, skinnum, Engine.globalpal, 0);
        if (texid != null) {
            this.textureCache.bind(texid);
            texid = Console.Geti("r_detailmapping") != 0 ? m.loadskin(defs, skinnum, 255, 0) : null;
            int texunits = 33984;
            if (texid != null) {
                BuildGdx.gl.glActiveTexture(++texunits);
                BuildGdx.gl.glEnable(3553);
                texid.setupTextureDetail();
                MDSkinmap sk = m.getSkin(255, skinnum, 0);
                if (sk != null) {
                    float f = sk.param;
                    this.gl.glMatrixMode(5890);
                    this.gl.glLoadIdentity();
                    this.gl.glScalef(f, f, 1.0f);
                    this.gl.glMatrixMode(5888);
                }
            }
            if ((texid = Console.Geti("r_glowmapping") != 0 ? m.loadskin(defs, skinnum, 254, 0) : null) != null) {
                BuildGdx.gl.glActiveTexture(++texunits);
                BuildGdx.gl.glEnable(3553);
                texid.setupTextureGlow();
            }
            MD2Frame cframe = m.frames[m.cframe];
            MD2Frame nframe = m.frames[m.nframe];
            this.parent.globalfog.apply();
            if (Polymost.r_vertexarrays != 0) {
                m.verticesBuffer.clear();
                int i = 0;
                while (i < m.tris.length) {
                    int j = 0;
                    while (j < 3) {
                        short idx = m.tris[i].vertices[j];
                        float x = cframe.vertices[idx][0] * this.cScale.x + nframe.vertices[idx][0] * this.nScale.x;
                        float y = cframe.vertices[idx][1] * this.cScale.y + nframe.vertices[idx][1] * this.nScale.y;
                        float z = cframe.vertices[idx][2] * this.cScale.z + nframe.vertices[idx][2] * this.nScale.z;
                        m.verticesBuffer.put(x);
                        m.verticesBuffer.put(z);
                        m.verticesBuffer.put(y);
                        ++j;
                    }
                    ++i;
                }
                m.verticesBuffer.flip();
                int l = 33984;
                do {
                    this.gl.glClientActiveTexture(l++);
                    this.gl.glEnableClientState(32888);
                    this.gl.glTexCoordPointer(2, 5126, 0, m.uv);
                } while (l <= texunits);
                this.gl.glEnableClientState(32884);
                this.gl.glVertexPointer(3, 5126, 0, m.verticesBuffer);
                this.gl.glDrawElements(4, 0, 5123, m.indicesBuffer);
            } else {
                int cmd;
                int c = 0;
                while ((cmd = m.glcmds[c++]) != 0) {
                    if (cmd < 0) {
                        this.gl.glBegin(6);
                        cmd = -cmd;
                    } else {
                        this.gl.glBegin(5);
                    }
                    while (cmd > 0) {
                        float s = Float.intBitsToFloat(m.glcmds[c + 0]);
                        float t = Float.intBitsToFloat(m.glcmds[c + 1]);
                        float x = cframe.vertices[m.glcmds[c + 2]][0] * this.cScale.x + nframe.vertices[m.glcmds[c + 2]][0] * this.nScale.x;
                        float y = cframe.vertices[m.glcmds[c + 2]][1] * this.cScale.y + nframe.vertices[m.glcmds[c + 2]][1] * this.nScale.y;
                        float z = cframe.vertices[m.glcmds[c + 2]][2] * this.cScale.z + nframe.vertices[m.glcmds[c + 2]][2] * this.nScale.z;
                        this.gl.glTexCoord2d(s, t);
                        this.gl.glVertex3d(x, z, y);
                        --cmd;
                        c += 3;
                    }
                    this.gl.glEnd();
                }
            }
            while (texunits > 33984) {
                this.gl.glMatrixMode(5890);
                this.gl.glLoadIdentity();
                this.gl.glMatrixMode(5888);
                this.gl.glTexEnvf(8960, 34163, 1.0f);
                this.gl.glDisable(3553);
                if (Polymost.r_vertexarrays != 0) {
                    this.gl.glDisableClientState(32888);
                    this.gl.glClientActiveTexture(texunits - 1);
                }
                this.gl.glActiveTexture(--texunits);
            }
            rendered = 1;
        }
        if (m.usesalpha) {
            this.gl.glDisable(3008);
        }
        this.gl.glDisable(2884);
        this.gl.glLoadIdentity();
        return rendered;
    }

    public int md3draw(MD3Model m, SPRITE tspr, int xoff, int yoff) {
        DefScript defs = this.parent.defs;
        m.updateanimation(defs, tspr);
        this.modelPrepare(m, tspr, xoff, yoff);
        this.cScale.scl(0.015625f);
        this.nScale.scl(0.015625f);
        int rendered = 0;
        int skinnum = -1;
        int surfi = 0;
        while (surfi < m.head.numSurfaces) {
            int i;
            MD3Surface s = m.surfaces[surfi];
            m.verticesBuffer.clear();
            int i2 = 0;
            while (i2 < s.numverts) {
                MD3Vertice v0 = s.xyzn[m.cframe * s.numverts + i2];
                MD3Vertice v1 = s.xyzn[m.nframe * s.numverts + i2];
                m.verticesBuffer.put((float)v0.x * this.cScale.x + (float)v1.x * this.nScale.x);
                m.verticesBuffer.put((float)v0.z * this.cScale.z + (float)v1.z * this.nScale.z);
                m.verticesBuffer.put((float)v0.y * this.cScale.y + (float)v1.y * this.nScale.y);
                ++i2;
            }
            m.verticesBuffer.flip();
            skinnum = defs.mdInfo.getParams((int)tspr.picnum).skinnum;
            GLTile texid = m.loadskin(defs, skinnum, Engine.globalpal, surfi);
            if (texid == null) break;
            this.textureCache.bind(texid);
            texid = Console.Geti("r_detailmapping") != 0 ? m.loadskin(defs, skinnum, 255, surfi) : null;
            int texunits = 33984;
            if (texid != null) {
                BuildGdx.gl.glActiveTexture(++texunits);
                BuildGdx.gl.glEnable(3553);
                texid.setupTextureDetail();
                MDSkinmap sk = m.getSkin(255, skinnum, surfi);
                if (sk != null) {
                    float f = sk.param;
                    this.gl.glMatrixMode(5890);
                    this.gl.glLoadIdentity();
                    this.gl.glScalef(f, f, 1.0f);
                    this.gl.glMatrixMode(5888);
                }
            }
            if ((texid = Console.Geti("r_glowmapping") != 0 ? m.loadskin(defs, skinnum, 254, surfi) : null) != null) {
                BuildGdx.gl.glActiveTexture(++texunits);
                BuildGdx.gl.glEnable(3553);
                texid.setupTextureGlow();
            }
            this.parent.globalfog.apply();
            if (Polymost.r_vertexarrays != 0) {
                m.indicesBuffer.clear();
                i = s.numtris - 1;
                while (i >= 0) {
                    int j = 0;
                    while (j < 3) {
                        m.indicesBuffer.put((short)s.tris[i][j]);
                        ++j;
                    }
                    --i;
                }
                m.indicesBuffer.flip();
                int l = 33984;
                do {
                    this.gl.glClientActiveTexture(l++);
                    this.gl.glEnableClientState(32888);
                    this.gl.glTexCoordPointer(2, 5126, 0, s.uv);
                } while (l <= texunits);
                this.gl.glEnableClientState(32884);
                this.gl.glVertexPointer(3, 5126, 0, m.verticesBuffer);
                this.gl.glDrawElements(4, 0, 5123, m.indicesBuffer);
            } else {
                this.gl.glBegin(4);
                i = s.numtris - 1;
                while (i >= 0) {
                    int j = 0;
                    while (j < 3) {
                        int k = s.tris[i][j];
                        if (texunits > 33984) {
                            int l = 33984;
                            while (l <= texunits) {
                                this.gl.glMultiTexCoord2d(l++, s.uv.get(2 * k), s.uv.get(2 * k + 1));
                            }
                        } else {
                            this.gl.glTexCoord2f(s.uv.get(2 * k), s.uv.get(2 * k + 1));
                        }
                        float x = m.verticesBuffer.get(3 * k);
                        float y = m.verticesBuffer.get(3 * k + 1);
                        float z = m.verticesBuffer.get(3 * k + 2);
                        this.gl.glVertex3d(x, y, z);
                        ++j;
                    }
                    --i;
                }
                this.gl.glEnd();
            }
            while (texunits > 33984) {
                this.gl.glMatrixMode(5890);
                this.gl.glLoadIdentity();
                this.gl.glMatrixMode(5888);
                this.gl.glTexEnvf(8960, 34163, 1.0f);
                this.gl.glDisable(3553);
                if (Polymost.r_vertexarrays != 0) {
                    this.gl.glDisableClientState(32888);
                    this.gl.glClientActiveTexture(texunits - 1);
                }
                this.gl.glActiveTexture(--texunits);
            }
            if (Polymost.r_vertexarrays != 0) {
                this.gl.glDisableClientState(32884);
            }
            rendered = 1;
            ++surfi;
        }
        if (m.usesalpha) {
            this.gl.glDisable(3008);
        }
        this.gl.glDisable(2884);
        this.gl.glLoadIdentity();
        return rendered;
    }

    public int mddraw(SPRITE tspr, int xoff, int yoff) {
        Model vm;
        Model model = vm = this.parent.defs != null ? this.parent.defs.mdInfo.getModel(tspr.picnum) : null;
        if (vm == null) {
            return 0;
        }
        try {
            if (vm.mdnum == 1) {
                return this.voxdraw((VOXModel)vm, tspr);
            }
            if (vm.mdnum == 2) {
                return this.md2draw((MD2Model)vm, tspr, xoff, yoff);
            }
            if (vm.mdnum == 3) {
                return this.md3draw((MD3Model)vm, tspr, xoff, yoff);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.Println("Removing model of sprite " + tspr.picnum + " due to errors.", Console.OSDTEXT_RED);
            this.parent.defs.mdInfo.removeModelInfo(vm);
        }
        return 0;
    }

    public void md3_vox_calcmat_common(SPRITE tspr, Vector3 a0, float f, float[][] mat) {
        float gcosang2 = this.parent.gcosang2;
        float gsinang2 = this.parent.gsinang2;
        float gshang = this.parent.gshang;
        float gstang = this.parent.gstang;
        float gctang = this.parent.gctang;
        float gchang = this.parent.gchang;
        float gsinang = this.parent.gsinang;
        float gcosang = this.parent.gcosang;
        float k0 = (float)(tspr.x - Engine.globalposx) * f / 1024.0f;
        float k1 = (float)(tspr.y - Engine.globalposy) * f / 1024.0f;
        f = gcosang2 * gshang;
        float g = gsinang2 * gshang;
        float k4 = (float)Engine.sintable[tspr.ang + Engine.spriteext[tspr.owner].angoff + 1024 & 0x7FF] / 16384.0f;
        float k5 = (float)Engine.sintable[tspr.ang + Engine.spriteext[tspr.owner].angoff + 512 & 0x7FF] / 16384.0f;
        float k2 = k0 * (1.0f - k4) + k1 * k5;
        float k3 = k1 * (1.0f - k4) - k0 * k5;
        float k6 = f * gstang - gsinang * gctang;
        float k7 = g * gstang + gcosang * gctang;
        if (this.parent.grhalfxdown10x < 0.0f) {
            k6 = -k6;
            k7 = -k7;
        }
        mat[0][0] = k4 * k6 + k5 * k7;
        mat[1][0] = gchang * gstang;
        mat[2][0] = k4 * k7 - k5 * k6;
        mat[3][0] = k2 * k6 + k3 * k7;
        k6 = f * gctang + gsinang * gstang;
        k7 = g * gctang - gcosang * gstang;
        mat[0][1] = k4 * k6 + k5 * k7;
        mat[1][1] = gchang * gctang;
        mat[2][1] = k4 * k7 - k5 * k6;
        mat[3][1] = k2 * k6 + k3 * k7;
        k6 = gcosang2 * gchang;
        k7 = gsinang2 * gchang;
        mat[0][2] = k4 * k6 + k5 * k7;
        mat[1][2] = -gshang;
        mat[2][2] = k4 * k7 - k5 * k6;
        mat[3][2] = k2 * k6 + k3 * k7;
        float[] fArray = mat[3];
        fArray[0] = fArray[0] + (a0.y * mat[0][0] + a0.z * mat[1][0] + a0.x * mat[2][0]);
        float[] fArray2 = mat[3];
        fArray2[1] = fArray2[1] + (a0.y * mat[0][1] + a0.z * mat[1][1] + a0.x * mat[2][1]);
        float[] fArray3 = mat[3];
        fArray3[2] = fArray3[2] + (a0.y * mat[0][2] + a0.z * mat[1][2] + a0.x * mat[2][2]);
    }

    public void md3_vox_calcmat_common(SPRITE tspr, Vector3 a0, float f, Matrix4 mat) {
        float yaw = Engine.globalang / 5.688889f - 90.0f;
        float roll = this.parent.gtang * 57.3f;
        float spriteang = (float)(tspr.ang + Engine.spriteext[tspr.owner].angoff + 512 & 0x7FF) / 5.688889f;
        mat.idt();
        mat.rotate(0.0f, 0.0f, -1.0f, roll);
        mat.rotate(-1.0f, 0.0f, 0.0f, Engine.pitch);
        mat.rotate(0.0f, -1.0f, 0.0f, yaw);
        mat.scale(-0.0625f, 1.0f, 0.0625f);
        mat.translate(a0.y, a0.z, a0.x);
        mat.rotate(0.0f, -1.0f, 0.0f, spriteang);
    }

    public void md3_vox_calcmat_common(SPRITE tspr, Vector3 a0) {
        float yaw = Engine.globalang / 5.688889f - 90.0f;
        float roll = this.parent.gtang * 57.3f;
        float spriteang = (float)(tspr.ang + Engine.spriteext[tspr.owner].angoff + 512 & 0x7FF) / 5.688889f;
        this.gl.glLoadIdentity();
        this.gl.glRotatef(roll, 0.0f, 0.0f, -1.0f);
        this.gl.glRotatef(Engine.pitch, -1.0f, 0.0f, 0.0f);
        this.gl.glRotatef(yaw, 0.0f, -1.0f, 0.0f);
        this.gl.glScalef(-0.0625f, 1.0f, 0.0625f);
        this.gl.glTranslatef(a0.y, a0.z, a0.x);
        this.gl.glRotatef(spriteang, 0.0f, -1.0f, 0.0f);
    }
}

