/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.PixmapTileData;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Settings.GLSettings;

public class GLTile
implements Comparable<GLTile> {
    protected int glHandle = BuildGdx.gl.glGenTexture();
    protected final int glTarget;
    protected int width;
    protected int height;
    private boolean isRequireShader;
    protected int flags;
    protected byte skyface;
    protected Hicreplctyp hicr;
    protected float scalex;
    protected float scaley;
    protected int palnum;
    protected GLTile next;

    public GLTile(int width, int height) {
        this.glTarget = 3553;
        this.width = width;
        this.height = height;
        this.isRequireShader = false;
    }

    public GLTile(TileData pic, int palnum, boolean useMipMaps) {
        this(pic.getWidth(), pic.getHeight());
        this.palnum = palnum;
        this.alloc(pic);
        if (useMipMaps) {
            this.generateMipmap(pic, true);
        }
        this.setClamped(pic.isClamped());
        this.setHasAlpha(pic.hasAlpha());
        this.scaley = 1.0f;
        this.scalex = 1.0f;
    }

    protected void alloc(TileData pic) {
        this.isRequireShader = false;
        if (pic.getPixelFormat() == TileData.PixelFormat.Pal8 || pic.getPixelFormat() == TileData.PixelFormat.Pal8A) {
            this.isRequireShader = true;
        }
        BuildGdx.gl.glBindTexture(this.glTarget, this.glHandle);
        BuildGdx.gl.glPixelStorei(3317, 1);
        BuildGdx.gl.glTexImage2D(this.glTarget, 0, pic.getGLInternalFormat(), pic.getWidth(), pic.getHeight(), 0, pic.getGLFormat(), pic.getGLType(), pic.getPixels());
        this.setupTextureFilter(GLSettings.textureFilter.get(), GLSettings.textureAnisotropy.get());
        this.setupTextureWrap(!pic.isClamped() ? 10497 : (GLInfo.clamptoedge ? 33071 : 10496));
    }

    public void setColor(float r, float g, float b, float a) {
        BuildGdx.gl.glColor4f(r, g, b, a);
    }

    public void update(TileData pic, boolean useMipMaps) {
        BuildGdx.gl.glBindTexture(this.glTarget, this.glHandle);
        int width = pic.getWidth();
        int height = pic.getHeight();
        if (pic instanceof PixmapTileData) {
            width = ((PixmapTileData)pic).getTileWidth();
            height = ((PixmapTileData)pic).getTileHeight();
        }
        if (this.getWidth() != width || this.getHeight() != height) {
            this.delete();
            this.glHandle = BuildGdx.gl.glGenTexture();
            this.width = pic.getWidth();
            this.height = pic.getHeight();
            this.alloc(pic);
        } else {
            BuildGdx.gl.glTexSubImage2D(this.glTarget, 0, 0, 0, pic.getWidth(), pic.getHeight(), pic.getGLFormat(), 5121, pic.getPixels());
        }
        if (useMipMaps) {
            this.generateMipmap(pic, false);
        }
        pic.dispose();
    }

    protected int calcMipLevel(int xsiz, int ysiz, int maxsize) {
        int mipLevel = 0;
        while (xsiz >> mipLevel > 1 << maxsize || ysiz >> mipLevel > 1 << maxsize) {
            ++mipLevel;
        }
        return mipLevel;
    }

    protected void generateMipmap(TileData data, boolean doalloc) {
        if (GLInfo.supportsGenerateMipmaps) {
            BuildGdx.gl.glGenerateMipmap(this.glTarget);
            return;
        }
        int mipLevel = this.calcMipLevel(data.getWidth(), data.getHeight(), GLInfo.gltexmaxsize);
        int x2 = data.getWidth();
        int y2 = data.getHeight();
        ByteBuffer pic = data.getPixels();
        int j = 1;
        while (x2 > 1 || y2 > 1) {
            int x3 = Math.max(1, x2 >> 1);
            int y3 = Math.max(1, y2 >> 1);
            int y = 0;
            while (y < y3) {
                int wpptr = y * x3;
                int rpptr = (y << 1) * x2;
                int x = 0;
                while (x < x3) {
                    block18: {
                        int rgb;
                        int wp = wpptr << 2;
                        int rp = rpptr << 2;
                        int k = 0;
                        int a = 0;
                        int b = 0;
                        int g = 0;
                        int r = 0;
                        int index = rp;
                        if (pic.get(index + 3) != 0) {
                            r += pic.get(index + 0) & 0xFF;
                            g += pic.get(index + 1) & 0xFF;
                            b += pic.get(index + 2) & 0xFF;
                            a += pic.get(index + 3) & 0xFF;
                            ++k;
                        }
                        index = rp + 4;
                        if ((x << 1) + 1 < x2 && pic.get(index + 3) != 0) {
                            r += pic.get(index + 0) & 0xFF;
                            g += pic.get(index + 1) & 0xFF;
                            b += pic.get(index + 2) & 0xFF;
                            a += pic.get(index + 3) & 0xFF;
                            ++k;
                        }
                        if ((y << 1) + 1 < y2) {
                            index = rp + (x2 << 2);
                            if (pic.get(index + 3) != 0) {
                                r += pic.get(index + 0) & 0xFF;
                                g += pic.get(index + 1) & 0xFF;
                                b += pic.get(index + 2) & 0xFF;
                                a += pic.get(index + 3) & 0xFF;
                                ++k;
                            }
                            index = rp + (x2 + 1 << 2);
                            if ((x << 1) + 1 < x2 && pic.get(index + 3) != 0) {
                                r += pic.get(index + 0) & 0xFF;
                                g += pic.get(index + 1) & 0xFF;
                                b += pic.get(index + 2) & 0xFF;
                                a += pic.get(index + 3) & 0xFF;
                                ++k;
                            }
                        }
                        switch (k) {
                            case 0: 
                            case 1: {
                                rgb = (a << 24) + (b << 16) + (g << 8) + (r << 0);
                                break;
                            }
                            case 2: {
                                rgb = (a + 1 >> 1 << 24) + (b + 1 >> 1 << 16) + (g + 1 >> 1 << 8) + (r + 1 >> 1 << 0);
                                break;
                            }
                            case 3: {
                                rgb = (a * 85 + 128 >> 8 << 24) + (b * 85 + 128 >> 8 << 16) + (g * 85 + 128 >> 8 << 8) + (r * 85 + 128 >> 8 << 0);
                                break;
                            }
                            case 4: {
                                rgb = (a + 2 >> 2 << 24) + (b + 2 >> 2 << 16) + (g + 2 >> 2 << 8) + (r + 2 >> 2 << 0);
                                break;
                            }
                            default: {
                                break block18;
                            }
                        }
                        pic.putInt(wp, rgb);
                    }
                    ++x;
                    ++wpptr;
                    rpptr += 2;
                }
                ++y;
            }
            if (j >= mipLevel) {
                if (doalloc) {
                    BuildGdx.gl.glTexImage2D(3553, j - mipLevel, data.getGLInternalFormat(), x3, y3, 0, data.getGLFormat(), 5121, pic);
                } else {
                    BuildGdx.gl.glTexSubImage2D(3553, j - mipLevel, 0, 0, x3, y3, data.getGLFormat(), 5121, pic);
                }
            }
            x2 = x3;
            y2 = y3;
            ++j;
        }
    }

    public void setupTextureWrap(int wrap) {
        BuildGdx.gl.glTexParameteri(this.glTarget, 10242, wrap);
        BuildGdx.gl.glTexParameteri(this.glTarget, 10243, wrap);
    }

    public void setupTextureWrapS(int wrap) {
        BuildGdx.gl.glTexParameteri(this.glTarget, 10242, wrap);
    }

    public void setupTextureWrapT(int wrap) {
        BuildGdx.gl.glTexParameteri(this.glTarget, 10243, wrap);
    }

    public void setupTextureFilter(GLFilter filter, int anisotropy) {
        if (this.isRequireShader) {
            BuildGdx.gl.glTexParameteri(this.glTarget, 10241, 9728);
            BuildGdx.gl.glTexParameteri(this.glTarget, 10240, 9728);
            BuildGdx.gl.glTexParameteri(this.glTarget, 34046, 1);
            return;
        }
        BuildGdx.gl.glTexParameteri(this.glTarget, 10241, filter.min);
        BuildGdx.gl.glTexParameteri(this.glTarget, 10240, filter.mag);
        if (anisotropy >= 1) {
            BuildGdx.gl.glTexParameteri(this.glTarget, 34046, anisotropy);
        }
    }

    public void setupTextureGlow() {
        if (!this.isGlowTexture()) {
            return;
        }
        BuildGdx.gl.glTexEnvf(8960, 8704, 34160.0f);
        BuildGdx.gl.glTexEnvf(8960, 34161, 34165.0f);
        BuildGdx.gl.glTexEnvf(8960, 34176, 34168.0f);
        BuildGdx.gl.glTexEnvf(8960, 34192, 768.0f);
        BuildGdx.gl.glTexEnvf(8960, 34177, 5890.0f);
        BuildGdx.gl.glTexEnvf(8960, 34193, 768.0f);
        BuildGdx.gl.glTexEnvf(8960, 34178, 5890.0f);
        BuildGdx.gl.glTexEnvf(8960, 34194, 771.0f);
        BuildGdx.gl.glTexEnvf(8960, 34162, 7681.0f);
        BuildGdx.gl.glTexEnvf(8960, 34184, 34168.0f);
        BuildGdx.gl.glTexEnvf(8960, 34200, 770.0f);
        this.setupTextureWrap(10497);
    }

    public void setupTextureDetail() {
        if (!this.isDetailTexture()) {
            return;
        }
        BuildGdx.gl.glTexEnvf(8960, 8704, 34160.0f);
        BuildGdx.gl.glTexEnvf(8960, 34161, 8448.0f);
        BuildGdx.gl.glTexEnvf(8960, 34176, 34168.0f);
        BuildGdx.gl.glTexEnvf(8960, 34192, 768.0f);
        BuildGdx.gl.glTexEnvf(8960, 34177, 5890.0f);
        BuildGdx.gl.glTexEnvf(8960, 34193, 768.0f);
        BuildGdx.gl.glTexEnvf(8960, 34162, 7681.0f);
        BuildGdx.gl.glTexEnvf(8960, 34184, 34168.0f);
        BuildGdx.gl.glTexEnvf(8960, 34200, 770.0f);
        BuildGdx.gl.glTexEnvf(8960, 34163, 2.0f);
        this.setupTextureWrap(10497);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void unbind() {
        BuildGdx.gl.glBindTexture(this.glTarget, 0);
    }

    protected boolean bind() {
        if (this.glHandle != 0) {
            BuildGdx.gl.glBindTexture(this.glTarget, this.glHandle);
            return true;
        }
        return false;
    }

    public void delete() {
        if (this.glHandle != 0) {
            if (BuildGdx.gl != null) {
                BuildGdx.gl.glDeleteTexture(this.glHandle);
            }
            this.glHandle = 0;
        }
    }

    public boolean isClamped() {
        return FlagType.Clamped.hasBit(this.flags);
    }

    public void setClamped(boolean mode) {
        this.setBit(mode, FlagType.Clamped);
    }

    public boolean isHighTile() {
        return FlagType.HighTile.hasBit(this.flags);
    }

    public void setHighTile(Hicreplctyp si) {
        this.hicr = si;
        this.setBit(si != null, FlagType.HighTile);
    }

    public boolean isSkyboxFace() {
        return FlagType.SkyboxFace.hasBit(this.flags);
    }

    public void setSkyboxFace(int facen) {
        this.skyface = (byte)facen;
        if (facen > 0) {
            this.setBit(true, FlagType.SkyboxFace);
        }
    }

    public boolean hasAlpha() {
        return FlagType.HasAlpha.hasBit(this.flags);
    }

    public void setHasAlpha(boolean mode) {
        this.setBit(mode, FlagType.HasAlpha);
    }

    public boolean isInvalidated() {
        return FlagType.Invalidated.hasBit(this.flags);
    }

    public void setInvalidated(boolean mode) {
        this.setBit(mode, FlagType.Invalidated);
    }

    public int getPal() {
        return this.palnum;
    }

    public boolean isGlowTexture() {
        return this.hicr != null && this.hicr.palnum == 254;
    }

    public boolean isDetailTexture() {
        return this.hicr != null && this.hicr.palnum == 255;
    }

    public float getXScale() {
        return this.scalex;
    }

    public float getYScale() {
        return this.scaley;
    }

    public float getAlphaCut() {
        return this.hicr != null ? this.hicr.alphacut : 0.0f;
    }

    private void setBit(boolean mode, FlagType bit) {
        this.flags = mode ? (this.flags |= bit.getBit()) : (this.flags &= ~bit.getBit());
    }

    public boolean isRequireShader() {
        return this.isRequireShader;
    }

    public String toString() {
        String out = "id = " + this.glHandle + " [" + this.width + "x" + this.height + ", ";
        out = String.valueOf(out) + "pal = " + this.palnum + ", ";
        out = String.valueOf(out) + "clamp = " + this.isClamped() + "]";
        return out;
    }

    @Override
    public int compareTo(GLTile src) {
        if (src == null) {
            return 0;
        }
        return this.palnum - src.palnum;
    }

    public static enum FlagType {
        Clamped(0),
        HighTile(1),
        SkyboxFace(2),
        HasAlpha(3),
        Invalidated(7);

        private final int bit;

        private FlagType(int bit) {
            this.bit = 1 << bit;
        }

        public int getBit() {
            return this.bit;
        }

        public boolean hasBit(int flags) {
            return (flags & this.bit) != 0;
        }
    }
}

