/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.Types.AndroidTextureBuffer;
import ru.m210projects.Build.Render.Types.DirectTextureBuffer;
import ru.m210projects.Build.Render.Types.FastTextureBuffer;
import ru.m210projects.Build.Render.Types.TextureBuffer;

public abstract class TileData {
    private static final int TEX_MAX_SIZE = 1024;
    private static TextureBuffer tmp_buffer;

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract ByteBuffer getPixels();

    public abstract int getGLType();

    public abstract int getGLInternalFormat();

    public abstract int getGLFormat();

    public abstract PixelFormat getPixelFormat();

    public abstract boolean hasAlpha();

    public abstract boolean isClamped();

    public abstract boolean isHighTile();

    public void dispose() {
    }

    public void save(String name) {
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer pixels = this.getPixels();
        int bytes = this.getPixelFormat().getLength();
        if (bytes == 1) {
            FileResource raw = BuildGdx.compat.open(String.valueOf(name) + ".raw", Compat.Path.Absolute, FileResource.Mode.Write);
            raw.writeBytes(pixels, width * height);
            raw.close();
            return;
        }
        name = String.valueOf(name) + ".png";
        Pixmap pixmap = new Pixmap(width, height, Pixmap.Format.RGB888);
        float[] color = new float[4];
        int i = 0;
        while (i < width * height) {
            int c = 0;
            while (c < bytes) {
                color[c] = (float)(pixels.get(i * bytes + c) & 0xFF) / 255.0f;
                ++c;
            }
            pixmap.setColor(color[0], color[1], color[2], 1.0f);
            int row = (int)Math.floor(i / width);
            int col = i % width;
            pixmap.drawPixel(col, row);
            ++i;
        }
        PixmapIO.writePNG(new FileHandle(name), pixmap);
        System.out.println(String.valueOf(name) + " saved!");
        pixmap.dispose();
    }

    protected int calcSize(int size) {
        int nsize = 1;
        if (GLInfo.texnpot == 0) {
            while (nsize < size) {
                nsize *= 2;
            }
            return nsize;
        }
        return size == 0 ? 1 : size;
    }

    protected static TextureBuffer getTmpBuffer(int size) {
        if (tmp_buffer == null) {
            size = 0x400000;
            try {
                tmp_buffer = BuildGdx.app.getPlatform() != BuildApplication.Platform.Android ? new FastTextureBuffer(size) : new AndroidTextureBuffer(size);
            }
            catch (Exception e) {
                e.printStackTrace();
                tmp_buffer = new DirectTextureBuffer(size);
            }
        }
        return tmp_buffer;
    }

    public static enum PixelFormat {
        Rgb(3),
        Rgba(4),
        Pal8(1),
        Pal8A(3);

        private final int bytes;

        private PixelFormat(int bytes) {
            this.bytes = bytes;
        }

        public int getLength() {
            return this.bytes;
        }
    }
}

