/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;

public class SPRITE {
    public static final int sizeof = 44;
    private static final ByteBuffer buffer = ByteBuffer.allocate(44).order(ByteOrder.LITTLE_ENDIAN);
    public int x;
    public int y;
    public int z;
    public short cstat = 0;
    public short picnum;
    public byte shade;
    public short pal;
    public short detail;
    public int clipdist = 32;
    public short xrepeat = (short)32;
    public short yrepeat = (short)32;
    public short xoffset;
    public short yoffset;
    public short sectnum;
    public short statnum;
    public short ang;
    public short owner = (short)-1;
    public short xvel;
    public short yvel;
    public short zvel;
    public short lotag;
    public short hitag;
    public short extra = (short)-1;

    public void buildSprite(Resource bb) {
        this.x = bb.readInt();
        this.y = bb.readInt();
        this.z = bb.readInt();
        this.cstat = bb.readShort();
        this.picnum = bb.readShort();
        if (!Gameutils.isValidTile(this.picnum)) {
            this.picnum = 0;
        }
        this.shade = bb.readByte();
        this.pal = (short)(bb.readByte() & 0xFF);
        this.clipdist = bb.readByte() & 0xFF;
        this.detail = bb.readByte().byteValue();
        this.xrepeat = (short)(bb.readByte() & 0xFF);
        this.yrepeat = (short)(bb.readByte() & 0xFF);
        this.xoffset = bb.readByte().byteValue();
        this.yoffset = bb.readByte().byteValue();
        this.sectnum = bb.readShort();
        if (this.sectnum < 0 || this.sectnum >= Engine.MAXSECTORS) {
            this.sectnum = 0;
        }
        this.statnum = bb.readShort();
        this.ang = bb.readShort();
        this.owner = bb.readShort();
        this.xvel = bb.readShort();
        this.yvel = bb.readShort();
        this.zvel = bb.readShort();
        this.lotag = bb.readShort();
        this.hitag = bb.readShort();
        this.extra = bb.readShort();
    }

    public byte[] getBytes() {
        buffer.clear();
        buffer.putInt(this.x);
        buffer.putInt(this.y);
        buffer.putInt(this.z);
        buffer.putShort(this.cstat);
        buffer.putShort(this.picnum);
        buffer.put(this.shade);
        buffer.put((byte)this.pal);
        buffer.put((byte)this.clipdist);
        buffer.put((byte)this.detail);
        buffer.put((byte)this.xrepeat);
        buffer.put((byte)this.yrepeat);
        buffer.put((byte)this.xoffset);
        buffer.put((byte)this.yoffset);
        buffer.putShort(this.sectnum);
        buffer.putShort(this.statnum);
        buffer.putShort(this.ang);
        buffer.putShort(this.owner);
        buffer.putShort(this.xvel);
        buffer.putShort(this.yvel);
        buffer.putShort(this.zvel);
        buffer.putShort(this.lotag);
        buffer.putShort(this.hitag);
        buffer.putShort(this.extra);
        return buffer.array();
    }

    public String toString() {
        String out = "x " + this.x + " \r\n";
        out = String.valueOf(out) + "y " + this.y + " \r\n";
        out = String.valueOf(out) + "z " + this.z + " \r\n";
        out = String.valueOf(out) + "cstat " + this.cstat + " \r\n";
        out = String.valueOf(out) + "picnum " + this.picnum + " \r\n";
        out = String.valueOf(out) + "shade " + this.shade + " \r\n";
        out = String.valueOf(out) + "pal " + this.pal + " \r\n";
        out = String.valueOf(out) + "clipdist " + this.clipdist + " \r\n";
        out = String.valueOf(out) + "detail " + this.detail + " \r\n";
        out = String.valueOf(out) + "xrepeat " + this.xrepeat + " \r\n";
        out = String.valueOf(out) + "yrepeat " + this.yrepeat + " \r\n";
        out = String.valueOf(out) + "xoffset " + this.xoffset + " \r\n";
        out = String.valueOf(out) + "yoffset " + this.yoffset + " \r\n";
        out = String.valueOf(out) + "sectnum " + this.sectnum + " \r\n";
        out = String.valueOf(out) + "statnum " + this.statnum + " \r\n";
        out = String.valueOf(out) + "ang " + this.ang + " \r\n";
        out = String.valueOf(out) + "owner " + this.owner + " \r\n";
        out = String.valueOf(out) + "xvel " + this.xvel + " \r\n";
        out = String.valueOf(out) + "yvel " + this.yvel + " \r\n";
        out = String.valueOf(out) + "zvel " + this.zvel + " \r\n";
        out = String.valueOf(out) + "lotag " + this.lotag + " \r\n";
        out = String.valueOf(out) + "hitag " + this.hitag + " \r\n";
        out = String.valueOf(out) + "extra " + this.extra + " \r\n";
        return out;
    }

    public void reset() {
        this.reset((byte)0);
        this.clipdist = 32;
        this.yrepeat = (short)32;
        this.xrepeat = (short)32;
        this.owner = (short)-1;
        this.extra = (short)-1;
    }

    public void reset(byte var) {
        this.x = var;
        this.y = var;
        this.z = var;
        this.cstat = var;
        this.picnum = var;
        this.shade = var;
        this.pal = var;
        this.clipdist = var;
        this.detail = var;
        this.xrepeat = var;
        this.yrepeat = var;
        this.xoffset = var;
        this.yoffset = var;
        this.sectnum = var;
        this.statnum = var;
        this.ang = var;
        this.owner = var;
        this.xvel = var;
        this.yvel = var;
        this.zvel = var;
        this.lotag = var;
        this.hitag = var;
        this.extra = var;
    }

    public void set(SPRITE src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
        this.cstat = src.cstat;
        this.picnum = src.picnum;
        this.shade = src.shade;
        this.pal = src.pal;
        this.clipdist = src.clipdist;
        this.detail = src.detail;
        this.xrepeat = src.xrepeat;
        this.yrepeat = src.yrepeat;
        this.xoffset = src.xoffset;
        this.yoffset = src.yoffset;
        this.sectnum = src.sectnum;
        this.statnum = src.statnum;
        this.ang = src.ang;
        this.owner = src.owner;
        this.xvel = src.xvel;
        this.yvel = src.yvel;
        this.zvel = src.zvel;
        this.lotag = src.lotag;
        this.hitag = src.hitag;
        this.extra = src.extra;
    }
}

