/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.nio.ByteBuffer;
import java.util.HashSet;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.TextureBuffer;

public class TileFont {
    public static final HashSet<TileFont> managedFont = new HashSet();
    public GLTile atlas;
    public Object ptr;
    public FontType type;
    public int charsizx;
    public int charsizy;
    public int cols;
    public int rows;
    public int sizx = -1;
    public int sizy = -1;

    public TileFont(FontType type, Object ptr, int charsizx, int charsizy, int cols, int rows) {
        this.ptr = ptr;
        this.type = type;
        this.charsizx = charsizx;
        this.charsizy = charsizy;
        this.cols = cols;
        this.rows = rows;
        this.sizx = charsizx * cols;
        this.sizy = charsizy * rows;
        managedFont.add(this);
    }

    public GLTile getGL(TextureManager textureCache, int col) {
        return textureCache.bind((Integer)this.ptr, col, 0, 0, 0);
    }

    public void uninit() {
        if (this.atlas != null) {
            this.atlas.delete();
            this.atlas = null;
        }
    }

    public void dispose() {
        this.uninit();
        managedFont.remove(this);
    }

    public static enum FontType {
        Tilemap,
        Bitmap;

    }

    public static abstract class TileFontData
    extends TileData {
        public final TextureBuffer data;
        public final int width;
        public final int height;

        public TileFontData(int width, int height) {
            this.width = width;
            this.height = height;
            this.data = this.buildAtlas(TileFontData.getTmpBuffer(width * height));
        }

        public abstract TextureBuffer buildAtlas(TextureBuffer var1);

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public ByteBuffer getPixels() {
            return this.data.getBuffer();
        }

        @Override
        public int getGLType() {
            return 5121;
        }

        @Override
        public int getGLInternalFormat() {
            return 6408;
        }

        @Override
        public int getGLFormat() {
            return 6408;
        }

        @Override
        public TileData.PixelFormat getPixelFormat() {
            return TileData.PixelFormat.Rgba;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isClamped() {
            return false;
        }

        @Override
        public boolean isHighTile() {
            return false;
        }
    }
}

