/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.DataResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;

public class WALL {
    public static final int sizeof = 32;
    private static final ByteBuffer buffer = ByteBuffer.allocate(32).order(ByteOrder.LITTLE_ENDIAN);
    public int x;
    public int y;
    public short point2;
    public short nextwall;
    public short nextsector;
    public short cstat;
    public short picnum;
    public short overpicnum;
    public byte shade;
    public short pal;
    public short xrepeat;
    public short yrepeat;
    public short xpanning;
    public short ypanning;
    public short lotag;
    public short hitag;
    public short extra;

    public WALL() {
    }

    public WALL(byte[] data) {
        this.buildWall(new DataResource(data));
    }

    public WALL(Resource data) {
        this.buildWall(data);
    }

    public void buildWall(Resource bb) {
        this.x = bb.readInt();
        this.y = bb.readInt();
        this.point2 = bb.readShort();
        if (this.point2 < 0 || this.point2 >= Engine.MAXWALLS) {
            this.point2 = 0;
        }
        this.nextwall = bb.readShort();
        if (this.nextwall < 0 || this.nextwall >= Engine.MAXWALLS) {
            this.nextwall = (short)-1;
        }
        this.nextsector = bb.readShort();
        if (this.nextsector < 0 || this.nextsector >= Engine.MAXSECTORS) {
            this.nextsector = (short)-1;
        }
        this.cstat = bb.readShort();
        this.picnum = bb.readShort();
        if (!Gameutils.isValidTile(this.picnum)) {
            this.picnum = 0;
        }
        this.overpicnum = bb.readShort();
        if (!Gameutils.isValidTile(this.overpicnum)) {
            this.overpicnum = 0;
        }
        this.shade = bb.readByte();
        this.pal = (short)(bb.readByte() & 0xFF);
        this.xrepeat = (short)(bb.readByte() & 0xFF);
        this.yrepeat = (short)(bb.readByte() & 0xFF);
        this.xpanning = (short)(bb.readByte() & 0xFF);
        this.ypanning = (short)(bb.readByte() & 0xFF);
        this.lotag = bb.readShort();
        this.hitag = bb.readShort();
        this.extra = bb.readShort();
    }

    public void set(WALL src) {
        this.x = src.x;
        this.y = src.y;
        this.point2 = src.point2;
        this.nextwall = src.nextwall;
        this.nextsector = src.nextsector;
        this.cstat = src.cstat;
        this.picnum = src.picnum;
        this.overpicnum = src.overpicnum;
        this.shade = src.shade;
        this.pal = src.pal;
        this.xrepeat = src.xrepeat;
        this.yrepeat = src.yrepeat;
        this.xpanning = src.xpanning;
        this.ypanning = src.ypanning;
        this.lotag = src.lotag;
        this.hitag = src.hitag;
        this.extra = src.extra;
    }

    public byte[] getBytes() {
        buffer.clear();
        buffer.putInt(this.x);
        buffer.putInt(this.y);
        buffer.putShort(this.point2);
        buffer.putShort(this.nextwall);
        buffer.putShort(this.nextsector);
        buffer.putShort(this.cstat);
        buffer.putShort(this.picnum);
        buffer.putShort(this.overpicnum);
        buffer.put(this.shade);
        buffer.put((byte)this.pal);
        buffer.put((byte)this.xrepeat);
        buffer.put((byte)this.yrepeat);
        buffer.put((byte)this.xpanning);
        buffer.put((byte)this.ypanning);
        buffer.putShort(this.lotag);
        buffer.putShort(this.hitag);
        buffer.putShort(this.extra);
        return buffer.array();
    }

    public String toString() {
        String out = "x " + this.x + " \r\n";
        out = String.valueOf(out) + "y " + this.y + " \r\n";
        out = String.valueOf(out) + "point2 " + this.point2 + " \r\n";
        out = String.valueOf(out) + "nextwall " + this.nextwall + " \r\n";
        out = String.valueOf(out) + "nextsector " + this.nextsector + " \r\n";
        out = String.valueOf(out) + "cstat " + this.cstat + " \r\n";
        out = String.valueOf(out) + "picnum " + this.picnum + " \r\n";
        out = String.valueOf(out) + "overpicnum " + this.overpicnum + " \r\n";
        out = String.valueOf(out) + "shade " + this.shade + " \r\n";
        out = String.valueOf(out) + "pal " + this.pal + " \r\n";
        out = String.valueOf(out) + "xrepeat " + this.xrepeat + " \r\n";
        out = String.valueOf(out) + "yrepeat " + this.yrepeat + " \r\n";
        out = String.valueOf(out) + "xpanning " + this.xpanning + " \r\n";
        out = String.valueOf(out) + "ypanning " + this.ypanning + " \r\n";
        out = String.valueOf(out) + "lotag " + this.lotag + " \r\n";
        out = String.valueOf(out) + "hitag " + this.hitag + " \r\n";
        out = String.valueOf(out) + "extra " + this.extra + " \r\n";
        return out;
    }
}

