/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.Controllers;

import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.io.File;
import java.util.List;
import java.util.Set;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import ru.m210projects.Build.Architecture.BuildController;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.desktop.Controllers.JController;

public class JControllers
extends BuildControllers {
    private boolean load;

    @Override
    protected void getControllers(List<BuildController> gamepads) {
        this.load();
        Controller[] inputs = ControllerEnvironment.getDefaultEnvironment().getControllers();
        int i = 0;
        while (i < inputs.length) {
            Controller.Type type = inputs[i].getType();
            if (type == Controller.Type.STICK || type == Controller.Type.GAMEPAD || type == Controller.Type.WHEEL || type == Controller.Type.FINGERSTICK) {
                gamepads.add(new JController(inputs[i]));
            }
            ++i;
        }
        if (gamepads.size() == 0) {
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            for (Thread thread : threadSet) {
                String name = thread.getClass().getName();
                if (!name.equals("net.java.games.input.RawInputEventQueue$QueueThread")) continue;
                thread.interrupt();
            }
        }
    }

    private void load() {
        if (this.load) {
            return;
        }
        SharedLibraryLoader loader = new SharedLibraryLoader();
        File nativesDir = null;
        try {
            if (SharedLibraryLoader.isWindows) {
                nativesDir = loader.extractFile(SharedLibraryLoader.is64Bit ? "jinput-dx8_64.dll" : "jinput-dx8.dll", null).getParentFile();
                loader.extractFileTo(SharedLibraryLoader.is64Bit ? "jinput-raw_64.dll" : "jinput-raw.dll", nativesDir);
            } else if (SharedLibraryLoader.isMac) {
                nativesDir = loader.extractFile("libjinput-osx.jnilib", null).getParentFile();
            } else if (SharedLibraryLoader.isLinux) {
                nativesDir = loader.extractFile(SharedLibraryLoader.is64Bit ? "libjinput-linux64.so" : "libjinput-linux.so", null).getParentFile();
                loader.extractFileTo(SharedLibraryLoader.is64Bit ? "libjinput-linux64.so" : "libjinput-linux.so", nativesDir);
            }
        }
        catch (Throwable ex) {
            Console.Println("Unable to extract JInput natives.", Console.OSDTEXT_RED);
            Console.Println(ex.getMessage(), Console.OSDTEXT_RED);
        }
        if (nativesDir != null) {
            System.setProperty("net.java.games.input.librarypath", nativesDir.getAbsolutePath());
        }
        this.load = true;
    }
}

