/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglClipboard;
import com.badlogic.gdx.backends.lwjgl.LwjglFiles;
import com.badlogic.gdx.utils.Clipboard;
import ru.m210projects.Build.Architecture.ApplicationFactory;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildConfiguration;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Architecture.BuildInput;
import ru.m210projects.Build.Architecture.BuildMessage;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.Render.VideoMode;
import ru.m210projects.Build.desktop.AWT.AWTGraphics;
import ru.m210projects.Build.desktop.AWT.AWTInput;
import ru.m210projects.Build.desktop.Controllers.JControllers;
import ru.m210projects.Build.desktop.DesktopMessage;
import ru.m210projects.Build.desktop.Lwjgl.LwjglGraphics;
import ru.m210projects.Build.desktop.Lwjgl.LwjglInput;
import ru.m210projects.Build.desktop.audio.ALAudio;
import ru.m210projects.Build.desktop.audio.ALSoundDrv;
import ru.m210projects.Build.desktop.audio.GdxAL;
import ru.m210projects.Build.desktop.audio.LwjglAL;

public class DesktopFactory
implements ApplicationFactory {
    private BuildConfiguration cfg;

    public DesktopFactory(BuildConfiguration cfg) {
        this.cfg = cfg;
    }

    @Override
    public BuildConfiguration getConfiguration() {
        return this.cfg;
    }

    @Override
    public BuildMessage getMessage() {
        return new DesktopMessage(false);
    }

    @Override
    public BuildAudio getAudio() {
        return new BuildAudio();
    }

    @Override
    public Files getFiles() {
        return new LwjglFiles();
    }

    @Override
    public BuildControllers getControllers() {
        return new JControllers();
    }

    @Override
    public BuildApplication.Platform getPlatform() {
        String osName = System.getProperty("os.name");
        BuildApplication.Platform platform = osName.startsWith("Windows") ? BuildApplication.Platform.Windows : (osName.startsWith("Linux") || osName.startsWith("FreeBSD") || osName.startsWith("OpenBSD") || osName.startsWith("SunOS") || osName.startsWith("Unix") || osName.indexOf("aix") > 0 ? BuildApplication.Platform.Linux : (osName.startsWith("Mac OS X") || osName.startsWith("Darwin") ? BuildApplication.Platform.MacOSX : null));
        return platform;
    }

    @Override
    public BuildFrame getFrame(BuildConfiguration config, BuildFrame.FrameType type) {
        return new BuildFrame(config){

            @Override
            public BuildGraphics getGraphics(BuildFrame.FrameType type) {
                if (type == BuildFrame.FrameType.GL) {
                    return new LwjglGraphics(DesktopFactory.this.cfg);
                }
                if (type == BuildFrame.FrameType.Canvas) {
                    return new AWTGraphics(DesktopFactory.this.cfg);
                }
                throw new UnsupportedOperationException("Unsupported frame type: " + (Object)((Object)type));
            }

            @Override
            public BuildInput getInput(BuildFrame.FrameType type) {
                if (type == BuildFrame.FrameType.GL) {
                    return new LwjglInput();
                }
                if (type == BuildFrame.FrameType.Canvas) {
                    return new AWTInput();
                }
                throw new UnsupportedOperationException("Unsupported frame type: " + (Object)((Object)type));
            }
        };
    }

    @Override
    public Application.ApplicationType getApplicationType() {
        return Application.ApplicationType.Desktop;
    }

    @Override
    public Clipboard getClipboard() {
        return new LwjglClipboard();
    }

    @Override
    public int getVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static void InitVideoModes() {
        VideoMode.initVideoModes(LwjglApplicationConfiguration.getDisplayModes(), LwjglApplicationConfiguration.getDesktopDisplayMode());
    }

    public static void InitSoundDrivers() {
        BuildAudio.registerDriver(BuildAudio.Driver.Sound, new ALSoundDrv(new ALSoundDrv.DriverCallback(){

            @Override
            public ALAudio InitDriver() throws Throwable {
                return new LwjglAL();
            }
        }, "OpenAL 1.15.1"));
        BuildAudio.registerDriver(BuildAudio.Driver.Sound, new ALSoundDrv(new ALSoundDrv.DriverCallback(){

            @Override
            public ALAudio InitDriver() throws Throwable {
                return new GdxAL();
            }
        }, "OpenAL 1.18.1"));
    }
}

