/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio.midi;

import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import ru.m210projects.Build.desktop.audio.midi.MidiMusicSource;
import ru.m210projects.Build.desktop.audio.midi.MidiReceiver;

public class MidiSequencer {
    protected final Sequencer sequencer = MidiSystem.getSequencer(false);
    private Transmitter transmitter;
    private MidiReceiver receiver;
    private MidiMusicSource currentSource;

    public MidiSequencer() throws MidiUnavailableException {
        this.sequencer.open();
        this.sequencer.addControllerEventListener(new ControllerEventListener(){

            @Override
            public void controlChange(ShortMessage message) {
                if (MidiSequencer.this.isLooping()) {
                    if ((message.getData1() == 116 || message.getData1() == 118) && message.getData2() == 0 && message.getChannel() == 0 && MidiSequencer.this.sequencer.getLoopStartPoint() == 0L) {
                        MidiSequencer.this.sequencer.setLoopStartPoint(MidiSequencer.this.sequencer.getTickPosition());
                    }
                    if ((message.getData1() == 117 || message.getData1() == 119) && message.getData2() == 127 && message.getChannel() == 0) {
                        MidiSequencer.this.sequencer.setTickPosition(MidiSequencer.this.sequencer.getLoopStartPoint());
                    }
                }
            }
        }, null);
    }

    public void setReceiver(MidiReceiver receiver) throws MidiUnavailableException {
        if (this.transmitter != null) {
            this.transmitter.close();
        }
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.transmitter = this.sequencer.getTransmitter();
        this.transmitter.setReceiver(receiver);
        this.receiver = receiver;
    }

    public void setVolume(float volume) {
        this.receiver.setVolume(volume);
    }

    public void play(MidiMusicSource source, long position) {
        this.checkSource(source);
        this.sequencer.setLoopStartPoint(0L);
        this.sequencer.setMicrosecondPosition(position);
        this.sequencer.start();
    }

    public void play(MidiMusicSource source, long position, long start, long end) {
        this.checkSource(source);
        this.sequencer.setMicrosecondPosition(position);
        this.sequencer.setLoopStartPoint(start);
        this.sequencer.setLoopEndPoint(end);
        this.sequencer.start();
    }

    public void stop() {
        if (this.isOpen()) {
            this.sequencer.stop();
        }
    }

    public void resume() {
        if (this.isOpen()) {
            this.sequencer.start();
        }
    }

    public long getPosition() {
        return this.sequencer.getMicrosecondPosition();
    }

    public void setLooping(boolean looping) {
        if (looping) {
            this.sequencer.setLoopCount(-1);
        } else {
            this.sequencer.setLoopCount(0);
        }
    }

    public boolean isLooping() {
        return this.sequencer.getLoopCount() != 0;
    }

    public boolean isPlaying(MidiMusicSource source) {
        return this.sequencer.getSequence() == source.data && this.sequencer.isRunning();
    }

    private void checkSource(MidiMusicSource source) {
        if (this.sequencer.getSequence() != source.data) {
            try {
                if (this.currentSource != null) {
                    this.currentSource.pause();
                }
                this.sequencer.setSequence(source.data);
                this.currentSource = source;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
    }

    public boolean isOpen() {
        return this.sequencer.isOpen();
    }

    public void dispose() {
        if (this.sequencer != null) {
            this.stop();
            this.sequencer.close();
        }
        if (this.transmitter != null) {
            this.transmitter.close();
        }
        if (this.receiver != null) {
            this.receiver.close();
        }
    }
}

