/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.BuildSmacker;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.BuildSmacker.BitBuffer;
import ru.m210projects.BuildSmacker.Frame;
import ru.m210projects.BuildSmacker.Header;
import ru.m210projects.BuildSmacker.HuffmanTree;
import ru.m210projects.BuildSmacker.SMKAudio;

public class SMKFile {
    private static final byte[] palmap;
    private static final short[] block_runs;
    private static final int TREE_MMAP = 0;
    private static final int TREE_MCLR = 1;
    private static final int TREE_FULL = 2;
    private static final int TREE_TYPE = 3;
    private static final int BLK_MONO = 0;
    private static final int BLK_FULL = 1;
    private static final int BLK_SKIP = 2;
    private static final int BLK_FILL = 3;
    private Header header;
    private Frame[] frames;
    private HuffmanTree[] tree;
    private HuffmanTree.Node[] audTree;
    private int currentFrame;
    private byte[] oldPalette;
    private byte[] currentPalette;
    private SMKAudio[] audio;
    private ByteBuffer frameBuffer;
    private BitBuffer bit;
    private boolean videoEnable;
    private boolean[] audioEnable = new boolean[7];

    static {
        byte[] byArray = new byte[64];
        byArray[1] = 4;
        byArray[2] = 8;
        byArray[3] = 12;
        byArray[4] = 16;
        byArray[5] = 20;
        byArray[6] = 24;
        byArray[7] = 28;
        byArray[8] = 32;
        byArray[9] = 36;
        byArray[10] = 40;
        byArray[11] = 44;
        byArray[12] = 48;
        byArray[13] = 52;
        byArray[14] = 56;
        byArray[15] = 60;
        byArray[16] = 65;
        byArray[17] = 69;
        byArray[18] = 73;
        byArray[19] = 77;
        byArray[20] = 81;
        byArray[21] = 85;
        byArray[22] = 89;
        byArray[23] = 93;
        byArray[24] = 97;
        byArray[25] = 101;
        byArray[26] = 105;
        byArray[27] = 109;
        byArray[28] = 113;
        byArray[29] = 117;
        byArray[30] = 121;
        byArray[31] = 125;
        byArray[32] = -126;
        byArray[33] = -122;
        byArray[34] = -118;
        byArray[35] = -114;
        byArray[36] = -110;
        byArray[37] = -106;
        byArray[38] = -102;
        byArray[39] = -98;
        byArray[40] = -94;
        byArray[41] = -90;
        byArray[42] = -86;
        byArray[43] = -82;
        byArray[44] = -78;
        byArray[45] = -74;
        byArray[46] = -70;
        byArray[47] = -66;
        byArray[48] = -61;
        byArray[49] = -57;
        byArray[50] = -53;
        byArray[51] = -49;
        byArray[52] = -45;
        byArray[53] = -41;
        byArray[54] = -37;
        byArray[55] = -33;
        byArray[56] = -29;
        byArray[57] = -25;
        byArray[58] = -21;
        byArray[59] = -17;
        byArray[60] = -13;
        byArray[61] = -9;
        byArray[62] = -5;
        byArray[63] = -1;
        palmap = byArray;
        block_runs = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 128, 256, 512, 1024, 2048};
    }

    public SMKFile(ByteBuffer fp) throws Exception {
        this.header = new Header(fp);
        this.audio = new SMKAudio[7];
        int mask = 0;
        int i = 0;
        while (i < 7) {
            if (this.header.isAudioExists(i)) {
                mask |= 1 << i;
            }
            ++i;
        }
        Track.Audio.setMask(mask);
        this.frames = new Frame[this.getFrames()];
        i = 0;
        while (i < this.getFrames()) {
            this.frames[i] = new Frame(fp.getInt() & 0xFFFFFFFC);
            ++i;
        }
        i = 0;
        while (i < this.getFrames()) {
            this.frames[i].flags = fp.get();
            ++i;
        }
        this.bit = new BitBuffer();
        int pos = fp.position();
        this.bit.wrap(fp);
        this.tree = new HuffmanTree[4];
        this.audTree = new HuffmanTree.Node[4];
        int i2 = 0;
        while (i2 < 4) {
            this.tree[i2] = new HuffmanTree(this.bit){

                @Override
                protected void message(String message) {
                    SMKFile.this.message(message);
                }
            };
            ++i2;
        }
        fp.position(pos + this.header.TreesSize);
        i2 = 0;
        while (i2 < this.getFrames()) {
            byte[] data = new byte[this.frames[i2].size];
            fp.get(data);
            this.frames[i2].buf = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
            ++i2;
        }
        this.currentFrame = -1;
    }

    public int setFrame(int frame) {
        if (frame >= this.getFrames()) {
            return 2;
        }
        int frameSize = this.frames[frame].size;
        if (frameSize == 0) {
            this.message("setFrame() - Warning: frame " + frame + ": frameSize is 0");
            return -1;
        }
        if (frame == this.currentFrame) {
            return this.frames[this.currentFrame].flags & 1;
        }
        this.currentFrame = frame;
        this.frames[this.currentFrame].buf.rewind();
        if (!this.decodePalette(this.currentFrame, this.videoEnable)) {
            this.message("setFrame() - Error: frame " + this.currentFrame + ": insufficient data for a palette rec");
            return -1;
        }
        int tr = this.decodeAudio(this.currentFrame);
        if (tr != -1) {
            this.message("setFrame() - Error: frame " + this.currentFrame + ": insufficient data for audio[" + tr + "] rec");
            return -1;
        }
        if (this.videoEnable) {
            this.decodeVideo(this.currentFrame);
        }
        return this.frames[this.currentFrame].flags & 1;
    }

    public byte[] getPalette() {
        if (this.currentPalette == null) {
            int palframe = -1;
            int i = 0;
            while (i < this.getFrames()) {
                if ((this.frames[i].flags & 1) != 0) {
                    palframe = i;
                    this.frames[i].buf.rewind();
                    break;
                }
                ++i;
            }
            this.decodePalette(palframe, true);
        }
        return this.currentPalette;
    }

    public int getWidth() {
        return this.header.Width;
    }

    public int getHeight() {
        return this.header.Height;
    }

    public int getFrames() {
        return this.header.Frames;
    }

    public Header.Signature getSignature() {
        return this.header.getSignature();
    }

    public SMKAudio getAudio(int num) {
        if (this.audio[num] == null && this.isAudioExists(num)) {
            this.audio[num] = new SMKAudio(this.header.getAudioRate(num), this.header.getAudioChannels(num), this.header.getAudioBits(num), this.header.AudioSize[num]);
        }
        return this.audio[num];
    }

    public boolean isAudioExists(int num) {
        return this.audioEnable[num] && this.header.isAudioExists(num);
    }

    public void setEnable(Track opt, int mask) {
        switch (opt) {
            case Video: {
                this.videoEnable = (mask & 0x80) != 0;
                break;
            }
            case Audio: {
                int i = 0;
                while (i < 7) {
                    this.audioEnable[i] = (mask & 1 << i) != 0;
                    ++i;
                }
                break;
            }
            case All: {
                this.videoEnable = (mask & 0x80) != 0;
                int i = 0;
                while (i < 7) {
                    this.audioEnable[i] = (mask & 1 << i) != 0;
                    ++i;
                }
                break;
            }
        }
    }

    public int getFrame() {
        return this.currentFrame;
    }

    public int getRate() {
        return this.header.FrameRate;
    }

    public ByteBuffer getVideoBuffer() {
        return this.frameBuffer;
    }

    public ByteBuffer getAudioBuffer(int num) {
        int totalsize = 0;
        int fr = 0;
        while (fr < this.getFrames()) {
            ByteBuffer data = this.frames[fr].buf;
            data.rewind();
            byte flags = this.frames[fr].flags;
            if ((flags & 1) != 0) {
                int pos = data.position();
                int size = 4 * (data.get() & 0xFF);
                data.position(pos + size);
            }
            int track = 0;
            while (track < 7) {
                if ((flags & 2 << track) != 0) {
                    int pos = data.position();
                    int size = data.getInt();
                    if (this.audioEnable[track]) {
                        totalsize = this.header.getAudioCompressionType(track) == Header.AudioCompression.PCM ? (totalsize += size) : (totalsize += data.getInt());
                    }
                    data.position(pos + size);
                }
                ++track;
            }
            ++fr;
        }
        if (totalsize == 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(totalsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int fr2 = 0;
        while (fr2 < this.getFrames()) {
            SMKAudio aud;
            ByteBuffer data = this.frames[fr2].buf;
            data.rewind();
            this.decodePalette(fr2, false);
            this.decodeAudio(fr2);
            if ((this.frames[fr2].flags & 2 << num) != 0 && (aud = this.audio[num]) != null) {
                bb.put(aud.buffer, 0, aud.size);
            }
            ++fr2;
        }
        bb.rewind();
        return bb;
    }

    private boolean decodePalette(int frame, boolean enabled) {
        ByteBuffer data = this.frames[frame].buf;
        if ((this.frames[frame].flags & 1) != 0) {
            int pos = data.position();
            int size = 4 * (data.get() & 0xFF);
            if (size > data.remaining()) {
                return false;
            }
            if (enabled) {
                this.decodePalette(data);
            }
            data.position(pos + size);
        }
        return true;
    }

    private void decodePalette(ByteBuffer p) {
        if (this.currentPalette == null) {
            this.oldPalette = new byte[768];
            this.currentPalette = new byte[768];
        }
        System.arraycopy(this.currentPalette, 0, this.oldPalette, 0, 768);
        int sz = 0;
        while (sz < 256) {
            if ((p.get(p.position()) & 0x80) != 0) {
                sz += (p.get() & 0x7F) + 1;
                continue;
            }
            if ((p.get(p.position()) & 0x40) != 0) {
                int j = (p.get() & 0x3F) + 1;
                int off = (p.get() & 0xFF) * 3;
                while (j-- != 0 && sz < 256) {
                    System.arraycopy(this.oldPalette, off, this.currentPalette, 3 * sz, 3);
                    off += 3;
                    ++sz;
                }
                continue;
            }
            int c = 0;
            while (c < 3) {
                this.currentPalette[3 * sz + c] = palmap[p.get() & 0x3F];
                ++c;
            }
            ++sz;
        }
    }

    private int decodeAudio(int frame) {
        ByteBuffer data = this.frames[frame].buf;
        int track = 0;
        while (track < 7) {
            if ((this.frames[frame].flags & 2 << track) != 0) {
                int pos = data.position();
                int size = data.getInt();
                if (size == 0 || size > data.remaining()) {
                    return track;
                }
                if (this.audioEnable[track]) {
                    this.decodeAudio(data, track);
                }
                data.position(pos + size);
            }
            ++track;
        }
        return -1;
    }

    private int decodeAudio(ByteBuffer data, int nTrack) {
        Arrays.fill(this.audTree, null);
        SMKAudio aud = this.getAudio(nTrack);
        switch (this.header.getAudioCompressionType(nTrack)) {
            case PCM: {
                aud.size = data.capacity();
                data.get(aud.buffer);
                break;
            }
            case DPCM: {
                int unpack;
                if (data.remaining() < 4) {
                    this.message("audio() - Error: need 4 bytes to get unpacked output buffer size");
                    return -1;
                }
                aud.size = data.getInt();
                this.bit.wrap(data);
                if (this.bit.getBit() == 0) {
                    this.message("audio() - Error: initial getBit returned 0");
                    return -1;
                }
                Header.AudioChannels channels = aud.getChannels();
                if (channels.get() - 1 != this.bit.getBit()) {
                    this.message("audio() - Error: mono/stereo mismatch");
                    return -1;
                }
                Header.AudioBits bits = aud.getBits();
                if (bits.get() != (this.bit.getBit() == 1 ? 16 : 8)) {
                    this.message("audio() - Error: 8-/16-bit mismatch");
                    return -1;
                }
                int j = 1;
                int k = 1;
                try {
                    this.audTree[0] = new HuffmanTree.Node(this.bit);
                    if (bits == Header.AudioBits.aud16bit) {
                        this.audTree[1] = new HuffmanTree.Node(this.bit);
                        k = 2;
                    }
                    if (channels == Header.AudioChannels.Stereo) {
                        this.audTree[2] = new HuffmanTree.Node(this.bit);
                        j = 2;
                        k = 2;
                        if (bits == Header.AudioBits.aud16bit) {
                            this.audTree[3] = new HuffmanTree.Node(this.bit);
                            k = 4;
                        }
                    }
                }
                catch (Exception e) {
                    this.message("audio() - Error: trees initialization failed!");
                    return -1;
                }
                if (channels == Header.AudioChannels.Stereo) {
                    unpack = this.bit.getByte();
                    if (bits == Header.AudioBits.aud16bit) {
                        aud.buffer[1] = (byte)this.bit.getByte();
                        aud.buffer[1] = (byte)(aud.buffer[1] | unpack << 8);
                    } else {
                        aud.buffer[1] = (byte)unpack;
                    }
                }
                unpack = this.bit.getByte();
                if (bits == Header.AudioBits.aud16bit) {
                    aud.buffer[0] = (byte)this.bit.getByte();
                    aud.buffer[0] = (byte)(aud.buffer[0] | unpack << 8);
                } else {
                    aud.buffer[0] = (byte)unpack;
                }
                while (k < aud.size) {
                    short value;
                    int unpack2;
                    if (bits == Header.AudioBits.aud8bit) {
                        unpack = this.audTree[0].lookup(this.bit);
                        aud.buffer[j] = (byte)(unpack + aud.buffer[j - channels.get()] & 0xFF);
                        ++j;
                        ++k;
                    } else {
                        unpack = this.audTree[0].lookup(this.bit);
                        unpack2 = this.audTree[1].lookup(this.bit);
                        value = (short)((unpack | unpack2 << 8) + aud.buffer[j - channels.get()] & 0xFF);
                        aud.buffer[j++] = (byte)(value & 0xFF);
                        aud.buffer[j++] = (byte)(value >>> 8 & 0xFF);
                        k += 2;
                    }
                    if (channels != Header.AudioChannels.Stereo) continue;
                    if (bits == Header.AudioBits.aud8bit) {
                        unpack = this.audTree[2].lookup(this.bit);
                        aud.buffer[j] = (byte)(unpack + aud.buffer[j - 2] & 0xFF);
                        ++j;
                        ++k;
                        continue;
                    }
                    unpack = this.audTree[2].lookup(this.bit);
                    unpack2 = this.audTree[3].lookup(this.bit);
                    value = (short)((unpack | unpack2 << 8) + aud.buffer[j - 2] & 0xFF);
                    aud.buffer[j++] = (byte)(value & 0xFF);
                    aud.buffer[j++] = (byte)(value >>> 8 & 0xFF);
                    k += 2;
                }
                break;
            }
        }
        return 0;
    }

    private boolean decodeVideo(int frame) {
        if (this.frameBuffer == null) {
            this.frameBuffer = ByteBuffer.wrap(new byte[this.getWidth() * this.getHeight()]).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.bit.wrap(this.frames[frame].buf);
        int i = 0;
        while (i < 4) {
            this.tree[i].reset();
            ++i;
        }
        this.frameBuffer.rewind();
        int blk = 0;
        int bw = this.getWidth() >> 2;
        int bh = this.getHeight() >> 2;
        int blocks = bw * bh;
        int stride = this.getWidth();
        block12: while (blk < blocks) {
            int type = this.tree[3].getCode(this.bit);
            int run = block_runs[type >> 2 & 0x3F];
            switch (type & 3) {
                case 0: {
                    while (run-- != 0 && blk < blocks) {
                        int clr = this.tree[1].getCode(this.bit);
                        int map = this.tree[0].getCode(this.bit);
                        int ptr = blk / bw * (stride * 4) + blk % bw * 4;
                        byte hi = (byte)(clr >> 8);
                        byte lo = (byte)(clr & 0xFF);
                        int shift = 1;
                        int i2 = 0;
                        while (i2 < 4) {
                            int k = 0;
                            while (k < 4) {
                                this.frameBuffer.put(ptr + k, (map & shift) != 0 ? hi : lo);
                                shift <<= 1;
                                ++k;
                            }
                            ptr += stride;
                            ++i2;
                        }
                        ++blk;
                    }
                    continue block12;
                }
                case 1: {
                    int ptr;
                    int mode = 0;
                    if (this.header.getSignature() == Header.Signature.SMK4) {
                        if (this.bit.getBit() != 0) {
                            mode = 1;
                        } else if (this.bit.getBit() != 0) {
                            mode = 2;
                        }
                    }
                    while (run-- != 0 && blk < blocks) {
                        ptr = blk / bw * (stride * 4) + blk % bw * 4;
                        switch (mode) {
                            case 0: {
                                int i3 = 0;
                                while (i3 < 4) {
                                    this.frameBuffer.putInt(ptr, this.tree[2].getCode(this.bit) << 16 | this.tree[2].getCode(this.bit));
                                    ptr += stride;
                                    ++i3;
                                }
                                break;
                            }
                            case 1: {
                                int j;
                                int k = 0;
                                while (k < 2) {
                                    int pix = this.tree[2].getCode(this.bit);
                                    j = 0;
                                    while (j < 2) {
                                        int i4 = 0;
                                        while (i4 < 4) {
                                            this.frameBuffer.put(ptr + i4, i4 < 2 ? (byte)pix : (byte)(pix >> 8));
                                            ++i4;
                                        }
                                        ptr += stride;
                                        ++j;
                                    }
                                    ++k;
                                }
                                break;
                            }
                            case 2: {
                                int j;
                                int i3 = 0;
                                while (i3 < 2) {
                                    int col = this.tree[2].getCode(this.bit) << 16 | this.tree[2].getCode(this.bit);
                                    j = 0;
                                    while (j < 2) {
                                        this.frameBuffer.putInt(ptr, col);
                                        ptr += stride;
                                        ++j;
                                    }
                                    ++i3;
                                }
                                break;
                            }
                        }
                        ++blk;
                    }
                    continue block12;
                }
                case 2: {
                    while (run-- != 0 && blk < blocks) {
                        ++blk;
                    }
                    continue block12;
                }
                case 3: {
                    int ptr;
                    int mode = type >> 8;
                    while (run-- != 0 && blk < blocks) {
                        ptr = blk / bw * (stride * 4) + blk % bw * 4;
                        int col = mode * 0x1010101;
                        int i5 = 0;
                        while (i5 < 4) {
                            this.frameBuffer.putInt(ptr, col);
                            ptr += stride;
                            ++i5;
                        }
                        ++blk;
                    }
                    continue block12;
                }
            }
        }
        return true;
    }

    protected void message(String message) {
        System.err.println(message);
    }

    public static enum Track {
        Video(128),
        Audio(1),
        All(255);

        private int mask;

        private Track(int mask) {
            this.mask = mask;
        }

        public int mask() {
            return this.mask;
        }

        protected void setMask(int mask) {
            this.mask = mask;
        }
    }
}

