/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDFunc;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.LSP.Factory.LSPEngine;
import ru.m210projects.LSP.Factory.LSPInput;
import ru.m210projects.LSP.Factory.LSPMenuHandler;
import ru.m210projects.LSP.Factory.LSPNetwork;
import ru.m210projects.LSP.Factory.LSPOSDFunc;
import ru.m210projects.LSP.Factory.LSPPolymost;
import ru.m210projects.LSP.Factory.LSPSliderDrawable;
import ru.m210projects.LSP.Factory.LSPSoftware;
import ru.m210projects.LSP.Fonts.FontA;
import ru.m210projects.LSP.Fonts.MenuFont;
import ru.m210projects.LSP.Fonts.StandartFont;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.LSPGroup;

public class LSPFactory
extends BuildFactory {
    private Main app;

    public LSPFactory(Main app) {
        super("stuff.dat");
        this.app = app;
    }

    @Override
    public void drawInitScreen() {
        this.app.pEngine.rotatesprite(0, 0, 65536, 0, 770, -128, 0, 26, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public BuildEngine engine() throws Exception {
        Main.gResGroup = new LSPGroup("LVART000.DAT", 135);
        Main.gMapGroup = new LSPGroup("LMART000.DAT", 36);
        BuildGdx.cache.add(Main.gResGroup);
        Console.Println("Found " + Main.gResGroup.numfiles + " files in " + Main.gResGroup.name + " archive");
        Console.Println("Found " + Main.gMapGroup.numfiles + " files in " + Main.gMapGroup.name + " archive");
        Main.engine = new LSPEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new LSPSoftware(this.app.pEngine);
        }
        return new LSPPolymost(this.app.pEngine);
    }

    @Override
    public DefScript getBaseDef(BuildEngine engine) {
        return new DefScript(engine, false);
    }

    @Override
    public BuildControls input(BuildControllers gpmanager) {
        return new LSPInput(this.app.pCfg, gpmanager);
    }

    @Override
    public OSDFunc console() {
        return new LSPOSDFunc(this.app);
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new LSPMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(3){

            @Override
            protected BuildFont init(int i) {
                if (i == 0) {
                    return new FontA(((LSPFactory)LSPFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new StandartFont(((LSPFactory)LSPFactory.this).app.pEngine);
                }
                if (i == 2) {
                    return new MenuFont(((LSPFactory)LSPFactory.this).app.pEngine);
                }
                return null;
            }
        };
    }

    @Override
    public BuildNet net() {
        return new LSPNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new LSPSliderDrawable();
    }
}

