/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.io.FileNotFoundException;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;

public class MovieFile {
    private byte[] pal;
    private byte[] buffer;
    private Frame[] frames;
    private int rate;
    private Resource fil;
    private int width;
    private int height;

    public MovieFile(String path) throws Exception {
        this.fil = BuildGdx.cache.open(path, 0);
        if (this.fil == null) {
            throw new FileNotFoundException(String.valueOf(path) + " not found!");
        }
        int size = this.fil.readInt();
        if (size != this.fil.size()) {
            throw new Exception("Wrong size");
        }
        short type = this.fil.readShort();
        if (type != -20719) {
            throw new Exception("Wrong type");
        }
        int numframes = this.fil.readShort().shortValue();
        this.width = this.fil.readShort().shortValue();
        this.height = this.fil.readShort().shortValue();
        this.rate = this.fil.readShort().shortValue();
        this.fil.readShort();
        this.fil.readShort();
        this.fil.seek(110L, Resource.Whence.Current);
        this.buffer = new byte[this.width * this.height];
        this.frames = new Frame[numframes];
        int i = 0;
        while (i < numframes) {
            this.frames[i] = new Frame(this.fil);
            if (this.pal == null) {
                int j = 0;
                while (j < this.frames[i].chunks) {
                    this.fil.seek(4L, Resource.Whence.Current);
                    if (this.fil.readShort() == 11) {
                        this.pal = new byte[768];
                        this.decode_palette(this.fil);
                    }
                    ++j;
                }
            }
            this.fil.seek(this.frames[i].offset + this.frames[i].size - 16, Resource.Whence.Set);
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int numFrames() {
        if (this.frames != null) {
            return this.frames.length;
        }
        return 0;
    }

    public byte[] getPalette() {
        return this.pal;
    }

    public int getRate() {
        return this.rate;
    }

    public void close() {
        if (this.fil != null) {
            this.fil.close();
        }
        this.buffer = null;
        this.pal = null;
        this.frames = null;
    }

    public byte[] draw(int frame) {
        Frame fr = this.frames[frame];
        this.fil.seek(fr.offset, Resource.Whence.Set);
        if (fr.type != -3590) {
            return null;
        }
        int j = 0;
        while (j < fr.chunks) {
            int chunk_size = this.fil.readInt();
            short chunk_type = this.fil.readShort();
            switch (chunk_type) {
                case 11: {
                    this.decode_palette(this.fil);
                    break;
                }
                case 12: {
                    this.decode_block_0c(this.fil);
                    break;
                }
                case 15: {
                    this.decode_block_0f(this.fil);
                    break;
                }
                case 16: {
                    this.fil.read(this.buffer, 0, chunk_size - 4);
                    break;
                }
            }
            ++j;
        }
        return this.buffer;
    }

    private void decode_palette(Resource fil) {
        fil.seek(4L, Resource.Whence.Current);
        fil.read(this.pal);
        int p = 0;
        while (p < 768) {
            int n = p++;
            this.pal[n] = (byte)(this.pal[n] << 2);
        }
    }

    private void decode_block_0c(Resource fil) {
        int line;
        int nextline = line = 320 * fil.readShort();
        int width = fil.readShort().shortValue();
        int j = 0;
        while (j < width) {
            nextline += 320;
            int v21 = fil.readByte() & 0xFF;
            if (v21 > 0) {
                int i = 0;
                while (i < v21) {
                    line += fil.readByte() & 0xFF;
                    int v20 = fil.readByte() & 0xFF;
                    if (v20 < 128) {
                        int p = 0;
                        while (p < v20) {
                            this.buffer[line + p] = fil.readByte();
                            ++p;
                        }
                        line += v20;
                    }
                    if (v20 > 128) {
                        byte col = fil.readByte();
                        int p = 0;
                        while (p < 256 - v20) {
                            this.buffer[line + p] = col;
                            ++p;
                        }
                        line += 256 - v20;
                    }
                    ++i;
                }
            }
            line = nextline;
            ++j;
        }
    }

    private void decode_block_0f(Resource fil) {
        int line = 0;
        int i = 1;
        while (i <= 200) {
            int v18 = fil.readByte() & 0xFF;
            if (v18 > 0) {
                int j = 0;
                while (j < v18) {
                    int v8 = fil.readByte() & 0xFF;
                    if (v8 > 128) {
                        int p = 0;
                        while (p < 256 - v8) {
                            this.buffer[line + p] = fil.readByte();
                            ++p;
                        }
                        line += 256 - v8;
                    }
                    if (v8 < 128) {
                        byte col = fil.readByte();
                        int p = 0;
                        while (p < v8) {
                            this.buffer[line + p] = col;
                            ++p;
                        }
                        line += v8;
                    }
                    ++j;
                }
            }
            line = 320 * i;
            ++i;
        }
    }

    private class Frame {
        public static final int sizeof = 16;
        int size;
        int type;
        int chunks;
        int offset;

        public Frame(Resource fil) {
            this.size = fil.readInt();
            this.type = fil.readShort().shortValue();
            this.chunks = fil.readShort().shortValue();
            fil.seek(8L, Resource.Whence.Current);
            this.offset = fil.position();
        }
    }
}

