/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Set {
    public static final int MAX_SET = 10;
    private static int SetCount;
    private static SetStruct[] SetList;
    private static short[] SetChan;
    private static final short[][] ActionSeq_X_9;

    static {
        SetList = new SetStruct[10];
        SetChan = new short[10];
        short[][] sArrayArray = new short[12][];
        sArrayArray[0] = new short[2];
        sArrayArray[1] = new short[]{77, 1};
        sArrayArray[2] = new short[]{78, 1};
        sArrayArray[3] = new short[2];
        short[] sArray = new short[2];
        sArray[0] = 9;
        sArrayArray[4] = sArray;
        short[] sArray2 = new short[2];
        sArray2[0] = 63;
        sArrayArray[5] = sArray2;
        short[] sArray3 = new short[2];
        sArray3[0] = 45;
        sArrayArray[6] = sArray3;
        short[] sArray4 = new short[2];
        sArray4[0] = 18;
        sArrayArray[7] = sArray4;
        short[] sArray5 = new short[2];
        sArray5[0] = 27;
        sArrayArray[8] = sArray5;
        short[] sArray6 = new short[2];
        sArray6[0] = 36;
        sArrayArray[9] = sArray6;
        sArrayArray[10] = new short[]{72, 1};
        sArrayArray[11] = new short[]{74, 1};
        ActionSeq_X_9 = sArrayArray;
    }

    public static void InitSets() {
        SetCount = 10;
    }

    public static ByteBuffer saveSet() {
        ByteBuffer bb = ByteBuffer.allocate((10 - SetCount) * 20 + 2 + 20);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)SetCount);
        int i = SetCount;
        while (i < 10) {
            SetList[i].save(bb);
            ++i;
        }
        i = 0;
        while (i < 10) {
            bb.putShort(SetChan[i]);
            ++i;
        }
        return bb;
    }

    public static void loadSet(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i = loader.SetCount = (int)bb.readShort().shortValue();
            while (i < 10) {
                if (loader.SetList[i] == null) {
                    loader.SetList[i] = new SetStruct();
                }
                loader.SetList[i].load(bb);
                ++i;
            }
            i = 0;
            while (i < 10) {
                loader.SetChan[i] = bb.readShort();
                ++i;
            }
        } else {
            SetCount = loader.SetCount;
            int i = loader.SetCount;
            while (i < 10) {
                if (SetList[i] == null) {
                    Set.SetList[i] = new SetStruct();
                }
                SetList[i].copy(loader.SetList[i]);
                ++i;
            }
            System.arraycopy(loader.SetChan, 0, SetChan, 0, 10);
        }
    }

    public static void BuildSet(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        int count;
        if ((count = --SetCount) < 0) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, (short)120);
        } else {
            x = Engine.sprite[spr].x;
            y = Engine.sprite[spr].y;
            z = Engine.sector[Engine.sprite[spr].sectnum].floorz;
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 120);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].clipdist = 110;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xrepeat = (short)87;
        Engine.sprite[spr].yrepeat = (short)96;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (SetList[count] == null) {
            Set.SetList[count] = new SetStruct();
        }
        Set.SetList[count].nState = 1;
        Set.SetList[count].nHealth = (short)8000;
        Set.SetList[count].nSprite = (short)spr;
        Set.SetList[count].nSeq = 0;
        Set.SetList[count].nTarget = (short)-1;
        Set.SetList[count].field_A = (short)90;
        Set.SetList[count].field_C = 0;
        Set.SetList[count].field_D = 0;
        Set.SetChan[count] = (short)channel;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x190000 | count);
        RunList.AddRunRec(RunList.NewRun, 0x190000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static int BuildSoul(int nSet) {
        SPRITE pSet = Engine.sprite[Set.SetList[nSet].nSprite];
        short spr = Main.engine.insertsprite(pSet.sectnum, (short)0);
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return -1;
        }
        SPRITE pSprite = Engine.sprite[spr];
        pSprite.cstat = Short.MIN_VALUE;
        pSprite.shade = (byte)-127;
        pSprite.xrepeat = 1;
        pSprite.yrepeat = 1;
        pSprite.pal = 0;
        pSprite.clipdist = 5;
        pSprite.xoffset = 0;
        pSprite.yoffset = 0;
        pSprite.picnum = Seq.GetSeqPicnum(48, 75, 0);
        pSprite.ang = (short)Random.RandomSize(11);
        pSprite.xvel = 0;
        pSprite.yvel = 0;
        pSprite.zvel = (short)(-256 - Random.RandomSize(10));
        pSprite.x = pSet.x;
        pSprite.y = pSet.y;
        pSprite.z = (Random.RandomSize(8) << 8) + 8192 + (Engine.sector[pSprite.sectnum].ceilingz - Sprites.GetSpriteHeight(spr));
        pSprite.hitag = (short)nSet;
        pSprite.lotag = (short)(RunList.HeadRun() + 1);
        pSprite.extra = 0;
        pSprite.owner = (short)RunList.AddRunRec(RunList.NewRun, 0x230000 | spr);
        return spr;
    }

    public static void FuncSet(int a1, int nDamage, int RunPtr) {
        short nSet = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nSet < 0 || nSet >= 10) {
            Main.game.ThrowError("set>=0 && set<MAX_SET");
            return;
        }
        SetStruct pSet = SetList[nSet];
        short nSprite = pSet.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pSet.nState;
        int nTarget = pSet.nTarget;
        boolean v68 = false;
        short nObject = (short)(a1 & 0xFFFF);
        block0 : switch (a1 & 0x7F0000) {
            case 131072: {
                Sprites.Gravity(nSprite);
                int nSeq = ActionSeq_X_9[nState][0] + Seq.SeqOffsets[48];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pSet.nSeq);
                Seq.MoveSequence(nSprite, nSeq, pSet.nSeq);
                if (nState == 3 && pSet.field_D != 0) {
                    pSet.nSeq = (short)(pSet.nSeq + 1);
                }
                if ((pSet.nSeq = (short)(pSet.nSeq + 1)) >= Seq.SeqSize[nSeq]) {
                    pSet.nSeq = 0;
                    v68 = true;
                }
                short nFlags = Seq.FrameFlag[pSet.nSeq + Seq.SeqBase[nSeq]];
                if (nTarget > -1 && nState < 10 && (Engine.sprite[nTarget].cstat & 0x101) == 0) {
                    pSet.nTarget = (short)-1;
                    pSet.nState = 0;
                    pSet.nSeq = 0;
                    nTarget = -1;
                }
                int hitMove = Enemy.MoveCreature(nSprite);
                Main.engine.pushmove(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, 4 * pSprite.clipdist, 5120, -5120, 0);
                if (pSprite.zvel > 4000 && (hitMove & 0x20000) != 0) {
                    Object.SetQuake(nSprite, 100);
                }
                switch (nState) {
                    case 0: {
                        if ((nSet & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            if (nTarget < 0) {
                                nTarget = Enemy.FindPlayer(nSprite, 1000);
                            }
                            if (nTarget >= 0) {
                                pSet.nState = (short)3;
                                pSet.nSeq = 0;
                                pSet.nTarget = (short)nTarget;
                                pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                                pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> 1);
                            }
                        }
                        return;
                    }
                    case 1: {
                        if (Enemy.FindPlayer(nSprite, 1000) >= 0 && (pSet.field_A = (short)(pSet.field_A - 1)) <= 0) {
                            pSet.nState = (short)2;
                            pSet.nSeq = 0;
                        }
                        return;
                    }
                    case 2: {
                        if (v68) {
                            pSet.nState = (short)7;
                            pSet.field_C = 0;
                            pSet.nSeq = 0;
                            pSprite.xvel = 0;
                            pSprite.yvel = 0;
                            pSet.nTarget = (short)Enemy.FindPlayer(nSprite, 1000);
                        }
                        return;
                    }
                    case 6: {
                        if ((nFlags & 0x80) != 0) {
                            int nBullet = Bullet.BuildBullet(nSprite, 11, 0, 0, -1, pSprite.ang, nTarget + 10000, 1);
                            Bullet.SetBulletEnemy((short)(nBullet >> 16 & 0xFFFF), nTarget);
                            pSet.field_E = (short)(pSet.field_E - 1);
                            if (pSet.field_E <= 0 || Random.RandomBit() == 0) {
                                pSet.nState = 0;
                                pSet.nSeq = 0;
                            }
                        }
                        return;
                    }
                    case 3: {
                        boolean v34;
                        if (nTarget == -1) {
                            pSet.nState = 0;
                            pSet.nSeq = 0;
                            return;
                        }
                        if ((nFlags & 0x10) != 0 && (hitMove & 0x20000) != 0) {
                            Object.SetQuake(nSprite, 100);
                        }
                        int nGoalAngle = Enemy.PlotCourseToSprite(nSprite, nTarget);
                        boolean bl = v34 = (Globals.totalmoves & 0x1F) == (nSet & 0x1F);
                        if (v34) {
                            int v33 = Random.RandomSize(3);
                            boolean bl2 = v34 = v33 == 0 || v33 == 2;
                            if (v34) {
                                pSet.field_C = 0;
                            } else {
                                if (v33 == 1) break;
                                pSet.field_D = (short)(nGoalAngle > 100 ? 1 : 0);
                            }
                        }
                        if (!v34) {
                            int nAngle = pSprite.ang & 0xFFF8;
                            pSprite.xvel = (short)(Engine.sintable[nAngle + 512 & 0x7FF] >> 1);
                            pSprite.yvel = (short)(Engine.sintable[nAngle] >> 1);
                            if (pSet.field_D != 0) {
                                pSprite.xvel = (short)(pSprite.xvel * 2);
                                pSprite.yvel = (short)(pSprite.yvel * 2);
                            }
                            switch (hitMove & 0xC000) {
                                default: {
                                    break block0;
                                }
                                case 32768: {
                                    short nNextSector = Engine.wall[hitMove & 0x3FFF].nextsector;
                                    if (nNextSector >= 0 && pSprite.z - Engine.sector[nNextSector].floorz < 55000 && pSprite.z > Engine.sector[nNextSector].ceilingz) break;
                                    pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
                                    pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                                    pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> 1);
                                    break block0;
                                }
                                case 49152: {
                                    if ((hitMove & 0x3FFF) != nTarget) break;
                                    if (Sprites.AngleDiff(pSprite.ang, Main.engine.getangle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y)) >= 64) break block0;
                                    pSet.nState = (short)4;
                                    pSet.nSeq = 0;
                                    break block0;
                                }
                            }
                            pSet.field_C = 1;
                        }
                        pSprite.xvel = 0;
                        pSprite.yvel = 0;
                        pSet.nState = (short)7;
                        pSet.nSeq = 0;
                        return;
                    }
                    case 5: {
                        if (v68) {
                            pSet.nState = 0;
                            pSet.field_A = (short)15;
                        }
                        return;
                    }
                    case 4: {
                        if (nTarget == -1) {
                            pSet.nState = 0;
                            pSet.field_A = (short)50;
                            break block0;
                        }
                        if (Enemy.PlotCourseToSprite(nSprite, nTarget) >= 768) {
                            pSet.nState = (short)3;
                            break block0;
                        }
                        if ((nFlags & 0x80) == 0) break block0;
                        Sprites.DamageEnemy(nTarget, nSprite, 5);
                        break block0;
                    }
                    case 7: {
                        if (v68) {
                            pSprite.zvel = pSet.field_C != 0 ? (short)-10000 : (short)(-Enemy.PlotCourseToSprite(nSprite, nTarget));
                            pSet.nState = (short)8;
                            pSet.nSeq = 0;
                            pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                            pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                        }
                        return;
                    }
                    case 8: {
                        if (v68) {
                            pSet.nSeq = (short)(Seq.SeqSize[nSeq] - 1);
                        }
                        if ((hitMove & 0x20000) != 0) {
                            Object.SetQuake(nSprite, 200);
                            pSet.nState = (short)9;
                            pSet.nSeq = 0;
                        }
                        return;
                    }
                    case 9: {
                        pSprite.xvel = (short)(pSprite.xvel >> 1);
                        pSprite.yvel = (short)(pSprite.yvel >> 1);
                        if (v68) {
                            pSprite.xvel = 0;
                            pSprite.yvel = 0;
                            break;
                        }
                        return;
                    }
                    case 10: {
                        if ((nFlags & 0x80) != 0) {
                            pSprite.z -= Sprites.GetSpriteHeight(nSprite);
                            Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(48, 76, 0));
                            pSprite.z += Sprites.GetSpriteHeight(nSprite);
                        }
                        if (v68) {
                            pSet.nState = (short)11;
                            pSet.nSeq = 0;
                            RunList.ChangeChannel(SetChan[nSet], 1);
                            int i = 0;
                            while (i < 20) {
                                Set.BuildSoul(nSet);
                                ++i;
                            }
                        }
                        return;
                    }
                    case 11: {
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                        return;
                    }
                }
                Enemy.PlotCourseToSprite(nSprite, nTarget);
                pSet.nState = (short)6;
                pSet.nSeq = 0;
                pSet.field_E = (short)5;
                pSprite.xvel = 0;
                pSprite.yvel = 0;
                return;
            }
            case 589824: {
                Seq.PlotSequence(nObject, ActionSeq_X_9[nState][0] + Seq.SeqOffsets[48], pSet.nSeq, ActionSeq_X_9[nState][1]);
                return;
            }
            case 655360: {
                if (nState == 5) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage != 0 && pSet.nHealth > 0) {
                    if (nState != 1) {
                        pSet.nHealth = (short)(pSet.nHealth - nDamage);
                    }
                    if (pSet.nHealth <= 0) {
                        pSprite.xvel = 0;
                        pSprite.yvel = 0;
                        pSprite.zvel = 0;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                        pSet.nHealth = 0;
                        --Globals.nCreaturesLeft;
                        if (pSet.nState < 10) {
                            pSet.nState = (short)10;
                            pSet.nSeq = 0;
                        }
                    } else if (nState == 1) {
                        pSet.nState = (short)2;
                        pSet.nSeq = 0;
                    }
                }
                return;
            }
        }
        if (nState > 0 && nTarget != -1 && (Engine.sprite[nTarget].cstat & 0x101) == 0) {
            pSet.nState = 0;
            pSet.nSeq = 0;
            pSet.field_A = (short)100;
            pSet.nTarget = (short)-1;
            pSprite.xvel = 0;
            pSprite.yvel = 0;
        }
    }

    public static void FuncSoul(int a1, int nDamage, int RunPtr) {
        short nSprite = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        SPRITE pSprite = Engine.sprite[nSprite];
        switch (a1 & 0x7F0000) {
            case 131072: {
                Seq.MoveSequence(nSprite, Seq.SeqOffsets[48] + 75, 0);
                if (pSprite.xrepeat < 32) {
                    pSprite.xrepeat = (short)(pSprite.xrepeat + 1);
                    pSprite.yrepeat = (short)(pSprite.yrepeat + 1);
                }
                pSprite.extra = (short)(pSprite.extra + ((nSprite & 0xF) + 5));
                pSprite.extra = (short)(pSprite.extra & 0x7FF);
                int vel = Engine.sintable[pSprite.extra + 512 & 0x7FF] >> 7;
                if ((Main.engine.movesprite(nSprite, Engine.sintable[pSprite.ang + 512 & 0x7FF] * vel, vel * Engine.sintable[pSprite.ang], pSprite.zvel, 5120, 0, 0) & 0x10000) != 0) {
                    short nSet = Set.SetList[pSprite.hitag].nSprite;
                    pSprite.cstat = 0;
                    pSprite.yrepeat = 1;
                    pSprite.xrepeat = 1;
                    pSprite.x = Engine.sprite[nSet].x;
                    pSprite.y = Engine.sprite[nSet].y;
                    pSprite.z = Engine.sprite[nSet].z - (Sprites.GetSpriteHeight(nSet) >> 1);
                    Main.engine.mychangespritesect(nSprite, Engine.sprite[nSet].sectnum);
                }
                return;
            }
        }
    }

    public static class SetStruct
    extends Enemy.EnemyStruct {
        public static final int size = 20;
        public short field_D;
        public short field_E;

        @Override
        public void save(ByteBuffer bb) {
            super.save(bb);
            bb.putShort(this.field_D);
            bb.putShort(this.field_E);
        }

        @Override
        public void load(Resource bb) {
            super.load(bb);
            this.field_D = bb.readShort();
            this.field_E = bb.readShort();
        }

        public void copy(SetStruct src) {
            super.copy(src);
            this.field_D = src.field_D;
            this.field_E = src.field_E;
        }
    }
}

