/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Spider {
    public static final int MAX_SPIDERS = 100;
    private static final short[][] ActionSeq_X_2;
    public static Enemy.EnemyStruct[] SpiderList;
    private static int SpiderCount;

    static {
        short[][] sArrayArray = new short[7][];
        short[] sArray = new short[2];
        sArray[0] = 16;
        sArrayArray[0] = sArray;
        short[] sArray2 = new short[2];
        sArray2[0] = 8;
        sArrayArray[1] = sArray2;
        short[] sArray3 = new short[2];
        sArray3[0] = 32;
        sArrayArray[2] = sArray3;
        short[] sArray4 = new short[2];
        sArray4[0] = 24;
        sArrayArray[3] = sArray4;
        sArrayArray[4] = new short[2];
        sArrayArray[5] = new short[]{40, 1};
        sArrayArray[6] = new short[]{41, 1};
        ActionSeq_X_2 = sArrayArray;
        SpiderList = new Enemy.EnemyStruct[100];
    }

    public static void InitSpider() {
        SpiderCount = 0;
    }

    public static ByteBuffer saveSpider() {
        ByteBuffer bb = ByteBuffer.allocate(SpiderCount * 16 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)SpiderCount);
        int i = 0;
        while (i < SpiderCount) {
            SpiderList[i].save(bb);
            ++i;
        }
        return bb;
    }

    public static void loadSpider(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.SpiderCount = bb.readShort().shortValue();
            int i = 0;
            while (i < loader.SpiderCount) {
                if (loader.SpiderList[i] == null) {
                    loader.SpiderList[i] = new Enemy.EnemyStruct();
                }
                loader.SpiderList[i].load(bb);
                ++i;
            }
        } else {
            SpiderCount = loader.SpiderCount;
            int i = 0;
            while (i < loader.SpiderCount) {
                if (SpiderList[i] == null) {
                    Spider.SpiderList[i] = new Enemy.EnemyStruct();
                }
                SpiderList[i].copy(loader.SpiderList[i]);
                ++i;
            }
        }
    }

    public static int BuildSpider(int spr, int x, int y, int z, int sectnum, int ang) {
        int count;
        if ((count = SpiderCount++) >= 100) {
            return -1;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, (short)99);
        } else {
            y = Engine.sprite[spr].y;
            z = Engine.sprite[spr].z;
            x = Engine.sprite[spr].x;
            Main.engine.changespritestat((short)spr, 99);
            ang = Engine.sprite[spr].ang;
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return -1;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].clipdist = 15;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].xrepeat = (short)40;
        Engine.sprite[spr].yrepeat = (short)40;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (SpiderList[count] == null) {
            Spider.SpiderList[count] = new Enemy.EnemyStruct();
        }
        Spider.SpiderList[count].nHealth = (short)160;
        Spider.SpiderList[count].nSeq = 0;
        Spider.SpiderList[count].nState = 0;
        Spider.SpiderList[count].nSprite = (short)spr;
        Spider.SpiderList[count].nTarget = (short)-1;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0xC0000 | count);
        Spider.SpiderList[count].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0xC0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
        return spr;
    }

    /*
     * Unable to fully structure code
     */
    public static void FuncSpider(int a1, int nDamage, int RunPtr) {
        nSpider = (short)(RunList.RunData[RunPtr].RunEvent & 65535);
        if (nSpider < 0 || nSpider >= 100) {
            Main.game.ThrowError("nSpider>=0 && nSpider<MAX_SPIDERS");
            return;
        }
        pSpider = Spider.SpiderList[nSpider];
        nSprite = pSpider.nSprite;
        pSprite = Engine.sprite[nSprite];
        nState = pSpider.nState;
        nTarget = pSpider.nTarget;
        plr = (short)(a1 & 65535);
        switch (a1 & 0x7F0000) {
            case 131072: {
                vel = 6;
                if (pSpider.nHealth != 0) {
                    if ((pSprite.cstat & 8) != 0) {
                        Main.game.pInt.setsprinterpolate(nSprite, pSprite);
                        pSprite.z = Sprites.GetSpriteHeight(nSprite) + Engine.sector[pSprite.sectnum].ceilingz;
                    } else {
                        Sprites.Gravity(nSprite);
                    }
                }
                nSeq = Spider.ActionSeq_X_2[nState][0] + Seq.SeqOffsets[16];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pSpider.nSeq);
                Seq.MoveSequence(nSprite, nSeq, pSpider.nSeq);
                pSpider.nSeq = (short)(pSpider.nSeq + 1);
                if (pSpider.nSeq >= Seq.SeqSize[nSeq]) {
                    pSpider.nSeq = 0;
                }
                nFlags = Seq.FrameFlag[pSpider.nSeq + Seq.SeqBase[nSeq]];
                if (nTarget > -1 && (Engine.sprite[pSpider.nTarget].cstat & 257) == 0) ** GOTO lbl104
                switch (nState) {
                    case 0: {
                        if ((nSpider & 31) == (Globals.totalmoves & 31)) {
                            if (nTarget < 0) {
                                nTarget = Enemy.FindPlayer(nSprite, 100);
                            }
                            if (nTarget >= 0) {
                                pSpider.nState = 1;
                                pSpider.nSeq = 0;
                                pSpider.nTarget = (short)nTarget;
                                pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 2047];
                                pSprite.yvel = Engine.sintable[pSprite.ang & 2047];
                                return;
                            }
                        }
                        ** GOTO lbl109
                    }
                    case 1: {
                        if (nTarget >= 0) {
                            vel = 7;
                        }
                    }
                    case 3: 
                    case 4: {
                        if (nState == 4 && pSpider.nSeq == 0) {
                            pSpider.nSeq = 0;
                            pSpider.nState = 1;
                        }
                        if ((pSprite.cstat & 8) != 0) {
                            pSprite.zvel = 0;
                            pSprite.z = 32 * Main.engine.getTile(pSprite.picnum).getHeight() + Engine.sector[pSprite.sectnum].ceilingz;
                            if ((Engine.sector[pSprite.sectnum].ceilingstat & 1) != 0) {
                                pSprite.cstat = (short)(pSprite.cstat ^ 8);
                                pSprite.zvel = 1;
                                pSpider.nState = (short)3;
                                pSpider.nSeq = 0;
                            }
                        }
                        if ((Globals.totalmoves & 31) == (nSpider & 31)) {
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            if (Random.RandomSize(3) != 0) {
                                pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 2047];
                                pSprite.yvel = Engine.sintable[pSprite.ang & 2047];
                            } else {
                                pSprite.yvel = 0;
                                pSprite.xvel = 0;
                            }
                            if (nState == 1 && Random.RandomBit() != 0) {
                                if ((pSprite.cstat & 8) != 0) {
                                    pSprite.cstat = (short)(pSprite.cstat ^ 8);
                                    pSprite.zvel = 1;
                                    pSprite.z = Sprites.GetSpriteHeight(nSprite) + Engine.sector[pSprite.sectnum].ceilingz;
                                } else {
                                    pSprite.zvel = (short)-5120;
                                }
                                pSpider.nState = (short)3;
                                pSpider.nSeq = 0;
                                if (Random.RandomSize(3) == 0) {
                                    Sound.D3PlayFX(Sound.StaticSound[29], nSprite);
                                }
                            }
                        }
                        ** GOTO lbl109
                    }
                    case 2: {
                        if (nTarget == -1) {
                            pSpider.nSeq = 0;
                            pSpider.nState = 0;
                            pSprite.xvel = 0;
                            pSprite.yvel = 0;
                        } else {
                            if ((nFlags & 128) != 0) {
                                Sprites.DamageEnemy(nTarget, nSprite, 3);
                                Sound.D3PlayFX(Sound.StaticSound[38], nSprite);
                            }
                            if (Enemy.PlotCourseToSprite(nSprite, nTarget) < 1024) {
                                return;
                            }
                            pSpider.nSeq = 0;
                            pSpider.nState = 1;
                        }
                        ** GOTO lbl109
                    }
                    case 5: {
                        if (pSpider.nSeq == 0) {
                            RunList.DoSubRunRec(pSprite.owner);
                            RunList.FreeRun(pSprite.lotag - 1);
                            RunList.SubRunRec(pSpider.nFunc);
                            pSprite.cstat = (short)-32768;
                            Main.engine.mydeletesprite(nSprite);
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
lbl104:
                // 1 sources

                pSpider.nTarget = (short)-1;
                pSpider.nState = 0;
                pSprite.yvel = 0;
                pSprite.xvel = 0;
                pSpider.nSeq = 0;
lbl109:
                // 5 sources

                osect = pSprite.sectnum;
                oz = pSprite.z;
                hitMove = Main.engine.movesprite(nSprite, pSprite.xvel << vel, pSprite.yvel << vel, pSprite.zvel, 1280, -1280, 0);
                sect = pSprite.sectnum;
                if (!Globals.isOriginal() && osect != sect && (Globals.SectFlag[osect] & 8192) == 0 && (Globals.SectFlag[sect] & 8192) != 0) {
                    Main.engine.changespritesect(nSprite, osect);
                    pSprite.z = oz - 2048;
                    pSpider.nState = 1;
                    pSprite.zvel = (short)-512;
                    return;
                }
                if (hitMove != 0) {
                    if ((hitMove & 65536) != 0 && pSprite.zvel < 0 && (Engine.zr_ceilhit & 49152) != 49152 && (Engine.sector[pSprite.sectnum].ceilingstat & 1) == 0) {
                        pSprite.cstat = (short)(pSprite.cstat | 8);
                        pSprite.z = Sprites.GetSpriteHeight(nSprite) + Engine.sector[pSprite.sectnum].ceilingz;
                        pSprite.zvel = 0;
                        pSpider.nState = 1;
                        pSpider.nSeq = 0;
                        return;
                    }
                    switch (hitMove & 49152) {
                        case 32768: {
                            pSprite.ang = (short)(pSprite.ang + 256 & 2031);
                            pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 2047];
                            pSprite.yvel = Engine.sintable[pSprite.ang & 2047];
                            return;
                        }
                        case 49152: {
                            if ((hitMove & 16383) == nTarget && Sprites.AngleDiff(pSprite.ang, v34 = Main.engine.getangle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y)) < 64) {
                                pSpider.nState = (short)2;
                                pSpider.nSeq = 0;
                            }
                            return;
                        }
                    }
                    if (nState == 3) {
                        pSpider.nState = 1;
                        pSpider.nSeq = 0;
                    }
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence(plr, Spider.ActionSeq_X_2[nState][0] + Seq.SeqOffsets[16], pSpider.nSeq, Spider.ActionSeq_X_2[nState][1]);
                return;
            }
            case 655360: {
                if (pSpider.nHealth <= 0) {
                    return;
                }
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage != 0 && pSpider.nHealth > 0) {
                    pSpider.nHealth = (short)(pSpider.nHealth - nDamage);
                    if (pSpider.nHealth > 0) {
                        if (plr != -1 && Engine.sprite[plr].statnum == 100) {
                            pSpider.nTarget = plr;
                        }
                        pSpider.nSeq = 0;
                        pSpider.nState = (short)4;
                    } else {
                        pSpider.nSeq = 0;
                        pSpider.nHealth = 0;
                        pSpider.nState = (short)5;
                        pSprite.cstat = (short)(pSprite.cstat & -258);
                        i = 0;
                        seq = 41;
                        while (i < 7) {
                            Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(16, seq, 0));
                            ++i;
                            ++seq;
                        }
                        --Globals.nCreaturesLeft;
                    }
                }
                return;
            }
        }
    }
}

