/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.utils.ByteArray;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Types.MemLog;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Config;
import ru.m210projects.Powerslave.Factory.PSEngine;
import ru.m210projects.Powerslave.Factory.PSFactory;
import ru.m210projects.Powerslave.Factory.PSMenuHandler;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.LoadSave;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Menus.MainMenu;
import ru.m210projects.Powerslave.Menus.MenuCorruptGame;
import ru.m210projects.Powerslave.Menus.MenuGame;
import ru.m210projects.Powerslave.Menus.NewAddon;
import ru.m210projects.Powerslave.Menus.PSMenuUserContent;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Screens.CinemaScreen;
import ru.m210projects.Powerslave.Screens.DemoScreen;
import ru.m210projects.Powerslave.Screens.GameScreen;
import ru.m210projects.Powerslave.Screens.LoadingScreen;
import ru.m210projects.Powerslave.Screens.LogoScreen2;
import ru.m210projects.Powerslave.Screens.MapScreen;
import ru.m210projects.Powerslave.Screens.MenuScreen;
import ru.m210projects.Powerslave.Screens.MovieScreen;
import ru.m210projects.Powerslave.Screens.PSLogoScreen;
import ru.m210projects.Powerslave.Screens.PrecacheScreen;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.Input;
import ru.m210projects.Powerslave.Type.MapInfo;
import ru.m210projects.Powerslave.Type.PlayerSave;
import ru.m210projects.Powerslave.Type.PlayerStruct;

public class Main
extends BuildGame {
    public static final String appdef = "psgdx.def";
    public static Main game;
    public static PSEngine engine;
    public static Config cfg;
    public PSMenuHandler menu;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static MapScreen gMap;
    public static PSLogoScreen gLogoScreen;
    public static LogoScreen2 gLogoScreen2;
    public static MovieScreen gMovieScreen;
    public static MenuScreen gMenuScreen;
    public static PrecacheScreen gPrecacheScreen;
    public static CinemaScreen gCinemaScreen;
    private final int LOGO1 = 3349;
    public Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            Main.this.resetState();
            engine.setbrightness(BuildSettings.paletteGamma.get(), Engine.palette, GLRenderer.GLInvalidateFlag.All);
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.size() == 0 || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo()) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };
    public Runnable toLogo3 = new Runnable(){

        @Override
        public void run() {
            game.changeScreen(gLogoScreen2.setCallback(Main.this.rMenu));
        }
    };
    public Runnable logo = new Runnable(){
        Runnable cutscene = new Runnable(){

            @Override
            public void run() {
                if (gMovieScreen.init("book.mov")) {
                    game.changeScreen(gMovieScreen.setCallback((this).Main.this.toLogo3));
                } else {
                    game.changeScreen(gCinemaScreen.setNum(2).setSkipping((this).Main.this.toLogo3));
                }
            }
        };

        @Override
        public void run() {
            Main.this.changeScreen(gLogoScreen.setTime(2.0f).setTile(Seq.GetSeqPicnum(59, 0, 0)).setCallback(this.cutscene).setSkipping(Main.this.toLogo3));
        }
    };

    public Main(BuildConfig bcfg, String appname, String sversion, boolean isRelease) {
        super(bcfg, appname, sversion, isRelease);
        game = this;
        cfg = (Config)bcfg;
    }

    public Main(BuildConfig bcfg, String appname, String sversion) {
        this(bcfg, appname, sversion, true);
    }

    @Override
    public BuildFactory getFactory() {
        return new PSFactory(this);
    }

    @Override
    public boolean init() throws Exception {
        Console.Println("Initializing timer");
        engine.inittimer(120);
        this.ConsoleInit();
        int i = 0;
        while (i < 8) {
            Globals.PlayerList[i] = new PlayerStruct();
            Player.sPlayerSave[i] = new PlayerSave();
            Globals.sPlayerInput[i] = new Input();
            ++i;
        }
        Sound.sndInit();
        Random.InitRandom();
        Sound.LoadFX();
        Seq.LoadSequences();
        this.InitOriginalEpisodes();
        byte[] remapbuf = new byte[256];
        int i2 = 0;
        while (i2 < 255) {
            remapbuf[i2] = (byte)(99 + (i2 & 8));
            ++i2;
        }
        engine.makepalookup(20, remapbuf, 0, 0, 0, 1);
        Palette.GrabPalette();
        Globals.nItemTextIndex = this.FindGString("ITEMS");
        Arrays.fill(Globals.nPlayerLives, (short)3);
        Globals.nBestLevel = 0;
        Main.game.pNet.ResetTimers();
        Console.Println("Initializing def-scripts...");
        Gameutils.loadGdxDef(this.baseDef, appdef, "psgdx.dat");
        if (this.pCfg.autoloadFolder) {
            Console.Println("Initializing autoload folder");
            DirectoryEntry autoload = BuildGdx.compat.checkDirectory("autoload");
            if (autoload != null) {
                for (FileEntry file : autoload.getFiles().values()) {
                    if (file.getExtension().equals("zip")) {
                        GroupResource def;
                        Group group = BuildGdx.cache.add(file.getPath());
                        if (group == null || (def = group.open(appdef)) == null) continue;
                        byte[] buf = def.getBytes();
                        this.baseDef.loadScript(file.getName(), buf);
                        def.close();
                        continue;
                    }
                    if (!file.getExtension().equals("def")) continue;
                    this.baseDef.loadScript(file);
                }
            }
        }
        LoadSave.FindSaves();
        Sound.searchCDtracks();
        FileEntry filgdx = BuildGdx.compat.checkFile(appdef);
        if (filgdx != null) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new MenuGame(this);
        this.menu.mMenus[11] = new NewAddon(this);
        this.menu.mMenus[12] = new MenuCorruptGame(this);
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gMap = new MapScreen(this);
        gLogoScreen = new PSLogoScreen(this);
        gLogoScreen2 = new LogoScreen2(this, 1.0f);
        gMovieScreen = new MovieScreen(this);
        gMenuScreen = new MenuScreen(this);
        gPrecacheScreen = new PrecacheScreen(this);
        gCinemaScreen = new CinemaScreen(this);
        gDemoScreen.demoscan();
        System.gc();
        MemLog.log("create");
        return true;
    }

    private void InitOriginalEpisodes() {
        Globals.gTrainingEpisode = new EpisodeInfo("Training");
        Globals.gTrainingEpisode.gMapInfo.add(new MapInfo("lev0.map", "Training"));
        String[] sMapName = new String[]{"Abu Simbel", "Dendur", "Kalabsh", "El Subua", "El Derr", "Abu Ghurab", "Philae", "El Kab", "Aswan", "Set Boss", "Qubbet el Hawa", "Abydos", "Edufu", "West Bank", "Luxor", "Karnak", "Saqqara", "Mittrahn", "Kilmaatikahn Boss", "Alien Mothership"};
        Globals.gOriginalEpisode = new EpisodeInfo("Original");
        int i = 0;
        while (i < 20) {
            Globals.gOriginalEpisode.gMapInfo.add(new MapInfo("lev" + (i + 1) + ".map", sMapName[i]));
            ++i;
        }
    }

    private void ConsoleInit() {
        Console.Println("Initializing on-screen display system");
        Console.setParameters(0, 0, 0, 0, 0, 0);
        Console.setVersion(String.valueOf(this.appname) + " " + this.sversion, 10, Console.OSDTEXT_GOLD);
        Console.RegisterCvar(new OSDCOMMAND("changemap", "", Globals.levelnum, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    Globals.levelnew = Integer.parseInt(Console.osd_argv[1]);
                    Console.toggle();
                } else {
                    Console.Println("changemap: not in a single-player game");
                }
            }
        }, 0, 20));
    }

    public void resetState() {
        this.menu.mClose();
        this.menu.mOpen(this.menu.mMenus[0], -1);
        PSMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        LoadSave.gAutosaveRequest = false;
        Map.bMapCrash = false;
        Globals.levelnum = 0;
        Globals.levelnew = 0;
        Globals.nBestLevel = -1;
        Globals.mUserFlag = UserFlag.None;
        Globals.boardfilename = null;
        LoadSave.lastload = null;
        Sound.StopAllSounds();
        if (Sound.MusicPlaying() && Sound.currTrack != 19) {
            Sound.StopMusic();
        }
        this.pInput.ctrlResetKeyStatus();
    }

    public int FindGString(String string) {
        int i = 0;
        while (true) {
            if (Globals.gString[i].equals(string)) {
                return i + 1;
            }
            if (Globals.gString[i].equals("EOF")) break;
            ++i;
        }
        return -1;
    }

    @Override
    public void show() {
        this.changeScreen(gLogoScreen.setTime(2.0f).setTile(3349).setCallback(this.logo).setSkipping(this.toLogo3));
    }

    @Override
    protected byte[] reportData() {
        byte[] out = null;
        String report = "Mapname: " + Globals.boardfilename;
        report = String.valueOf(report) + "\r\n";
        report = String.valueOf(report) + "UserFlag: " + (Object)((Object)Globals.mUserFlag);
        report = String.valueOf(report) + "\r\n";
        if (Globals.PlayerList[Mmulti.myconnectindex] != null && Gameutils.isValidSprite(Globals.PlayerList[Mmulti.myconnectindex].spriteId)) {
            SPRITE pSprite = Engine.sprite[Globals.PlayerList[Mmulti.myconnectindex].spriteId];
            report = String.valueOf(report) + "PlayerX " + pSprite.x;
            report = String.valueOf(report) + "\r\n";
            report = String.valueOf(report) + "PlayerY " + pSprite.y;
            report = String.valueOf(report) + "\r\n";
            report = String.valueOf(report) + "PlayerZ " + pSprite.z;
            report = String.valueOf(report) + "\r\n";
            report = String.valueOf(report) + "PlayerAng " + pSprite.ang;
            report = String.valueOf(report) + "\r\n";
            report = String.valueOf(report) + "PlayerSect: " + pSprite.sectnum;
            report = String.valueOf(report) + "\r\n";
        }
        if (Globals.mUserFlag == UserFlag.UserMap) {
            ByteArray array = new ByteArray();
            byte[] data = BuildGdx.cache.getBytes(Globals.boardfilename, 0);
            if (data != null) {
                report = String.valueOf(report) + "\r\n<------Start Map data------->\r\n";
                array.addAll(report.getBytes());
                array.addAll(data);
                array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                out = Arrays.copyOf(array.items, array.size);
            }
        } else {
            out = report.getBytes();
        }
        return out;
    }

    public void EndGame() {
        Sound.StopAllSounds();
        Sound.StopMusic();
        this.changeScreen(gLogoScreen.setTime(2.0f).setTile(3349).setCallback(this.logo).setSkipping(this.toLogo3));
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

