/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Anubis;
import ru.m210projects.Powerslave.Enemies.Fish;
import ru.m210projects.Powerslave.Enemies.LavaDude;
import ru.m210projects.Powerslave.Enemies.Lion;
import ru.m210projects.Powerslave.Enemies.Mummy;
import ru.m210projects.Powerslave.Enemies.Queen;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Enemies.Rat;
import ru.m210projects.Powerslave.Enemies.Rex;
import ru.m210projects.Powerslave.Enemies.Roach;
import ru.m210projects.Powerslave.Enemies.Scorp;
import ru.m210projects.Powerslave.Enemies.Set;
import ru.m210projects.Powerslave.Enemies.Spider;
import ru.m210projects.Powerslave.Enemies.Wasp;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Grenade;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Sector;
import ru.m210projects.Powerslave.Slide;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Switch;
import ru.m210projects.Powerslave.Type.Channel;
import ru.m210projects.Powerslave.Type.FuncProc;
import ru.m210projects.Powerslave.Type.RunData;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class RunList {
    public static int ChannelList;
    public static int ChannelLast;
    public static Channel[] channel;
    public static final int MAXRUN = 25600;
    public static int NewRun;
    public static int RunCount;
    public static int RunChain;
    public static boolean word_966BE;
    public static int nStackCount;
    public static short[] RunFree;
    public static RunData[] RunData;
    private static final FuncProc[] funclist;
    public static int[] sRunStack;

    static {
        channel = new Channel[4096];
        RunCount = -1;
        RunFree = new short[25600];
        RunData = new RunData[25600];
        funclist = new FuncProc[]{new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Object.FuncElev(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Switch.FuncSwReady(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Switch.FuncSwPause(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Switch.FuncSwStepOn(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Switch.FuncSwNotOnPause(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Switch.FuncSwPressSector(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Switch.FuncSwPressWall(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Object.FuncWallFace(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Slide.FuncSlide(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Anubis.FuncAnubis(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Player.FuncPlayer(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Bullet.FuncBullet(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Spider.FuncSpider(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Sprites.FuncCreatureChunk(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Mummy.FuncMummy(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Grenade.FuncGrenade(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Anim.FuncAnim(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Snake.FuncSnake(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Fish.FuncFish(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Lion.FuncLion(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Sprites.FuncBubble(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                LavaDude.FuncLava(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                LavaDude.FuncLavaLimb(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Object.FuncObject(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Rex.FuncRex(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Set.FuncSet(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Queen.FuncQueen(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Queen.FuncQueenHead(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Roach.FuncRoach(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Queen.FuncQueenEgg(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Wasp.FuncWasp(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Object.FuncTrap(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Fish.FuncFishLimb(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Ra.FuncRa(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Scorp.FuncScorp(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Set.FuncSoul(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Rat.FuncRat(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Sector.FuncEnergyBlock(a1, a2, RunPtr);
            }
        }, new FuncProc(){

            @Override
            public void run(int a1, int a2, int RunPtr) {
                Object.FuncSpark(a1, a2, RunPtr);
            }
        }};
        sRunStack = new int[200];
    }

    public static short GrabRun() {
        if (RunCount <= 0 || RunCount > 25600) {
            Main.game.ThrowError("RunCount >0 && RunCount<=MAXRUN");
        }
        return RunFree[--RunCount];
    }

    public static ByteBuffer saveRunList() {
        ByteBuffer bb = ByteBuffer.allocate(288788);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(RunCount);
        bb.putInt(NewRun);
        bb.putInt(RunChain);
        int i = 0;
        while (i < 25600) {
            bb.putShort(RunFree[i]);
            ++i;
        }
        i = 0;
        while (i < 25600) {
            RunData[i].save(bb);
            ++i;
        }
        bb.putInt(ChannelList);
        bb.putInt(ChannelLast);
        i = 0;
        while (i < 4096) {
            channel[i].save(bb);
            ++i;
        }
        return bb;
    }

    public static void loadRunList(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.RunCount = bb.readInt();
            loader.NewRun = bb.readInt();
            loader.RunChain = bb.readInt();
            int i = 0;
            while (i < 25600) {
                loader.RunFree[i] = bb.readShort();
                ++i;
            }
            i = 0;
            while (i < 25600) {
                if (loader.RunData[i] == null) {
                    loader.RunData[i] = new RunData();
                }
                loader.RunData[i].load(bb);
                ++i;
            }
            loader.ChannelList = bb.readInt();
            loader.ChannelLast = bb.readInt();
            i = 0;
            while (i < 4096) {
                if (loader.channel[i] == null) {
                    loader.channel[i] = new Channel();
                }
                loader.channel[i].load(bb);
                ++i;
            }
        } else {
            RunCount = loader.RunCount;
            NewRun = loader.NewRun;
            RunChain = loader.RunChain;
            System.arraycopy(loader.RunFree, 0, RunFree, 0, 25600);
            int i = 0;
            while (i < 25600) {
                if (RunData[i] == null) {
                    RunList.RunData[i] = new RunData();
                }
                RunData[i].copy(loader.RunData[i]);
                ++i;
            }
            ChannelList = loader.ChannelList;
            ChannelLast = loader.ChannelLast;
            i = 0;
            while (i < 4096) {
                if (channel[i] == null) {
                    RunList.channel[i] = new Channel();
                }
                channel[i].copy(loader.channel[i]);
                ++i;
            }
        }
    }

    public static void FreeRun(int run) {
        if (RunCount < 0 || RunCount >= 25600) {
            Main.game.ThrowError("RunCount >= 0 && RunCount<MAXRUN: " + RunCount);
        }
        if (run < 0 || run >= 25600) {
            Main.game.ThrowError("run>=0 && run<MAXRUN: " + run);
        }
        RunList.RunFree[RunList.RunCount] = (short)run;
        ++RunCount;
        RunList.RunData[run].RunNum = (short)-1;
        RunList.RunData[run].RunEvent = -1;
        RunList.RunData[run].RunPtr = (short)-1;
    }

    public static short HeadRun() {
        short run = RunList.GrabRun();
        RunList.RunData[run].RunPtr = (short)-1;
        RunList.RunData[run].RunNum = (short)-1;
        return run;
    }

    public static void InitRun() {
        RunCount = 25600;
        nStackCount = 0;
        int i = 0;
        while (i < 25600) {
            if (RunData[i] == null) {
                RunList.RunData[i] = new RunData();
            }
            RunList.RunData[i].RunEvent = -1;
            RunList.RunData[i].RunNum = (short)-1;
            RunList.RunFree[i] = i;
            RunList.RunData[i].RunPtr = (short)-1;
            i = (short)(i + 1);
        }
        short ptr = RunList.HeadRun();
        RunChain = ptr;
        NewRun = ptr;
        int i2 = 0;
        while (i2 < 8) {
            Globals.PlayerList[i2].RunFunc = (short)-1;
            ++i2;
        }
        Globals.nRadialSpr = -1;
    }

    public static void UnlinkRun(int RunNum) {
        if (RunCount < 0 || RunCount >= 25600) {
            Main.game.ThrowError("RunNum >= 0 && RunNum<MAXRUN: " + RunCount);
        }
        RunData data = RunData[RunNum];
        if (RunNum == RunChain) {
            RunChain = data.RunPtr;
        } else {
            if (data.RunNum >= 0) {
                RunList.RunData[data.RunNum].RunPtr = data.RunPtr;
            }
            if (data.RunPtr >= 0) {
                RunList.RunData[data.RunPtr].RunNum = data.RunNum;
            }
        }
    }

    public static void InsertRun(int RunLst, int RunNum) {
        if (RunLst < 0 || RunLst >= 25600) {
            Main.game.ThrowError("RunLst >= 0 && RunLst<MAXRUN: " + RunLst);
        }
        if (RunNum < 0 || RunNum >= 25600) {
            Main.game.ThrowError(" RunNum >= 0 && RunNum<MAXRUN: " + RunNum);
        }
        RunData data = RunData[RunNum];
        data.RunNum = (short)RunLst;
        data.RunPtr = RunList.RunData[RunLst].RunPtr;
        if (data.RunPtr >= 0) {
            RunList.RunData[data.RunPtr].RunNum = (short)RunNum;
        }
        RunList.RunData[RunLst].RunPtr = (short)RunNum;
    }

    public static int AddRunRec(int RunLst, int RunEvent) {
        short RunNum = RunList.GrabRun();
        RunList.RunData[RunNum].RunEvent = RunEvent;
        RunList.InsertRun(RunLst, RunNum);
        return RunNum;
    }

    public static void DoSubRunRec(int RunPtr) {
        if (RunPtr < 0 || RunPtr >= 25600) {
            Main.game.ThrowError("RunPtr>=0 && RunPtr<MAXRUN: " + RunPtr);
        }
        RunList.UnlinkRun(RunPtr);
        RunList.FreeRun(RunPtr);
    }

    public static void CleanRunRecs() {
        int NxtPtr = RunChain;
        if (NxtPtr >= 0) {
            if (NxtPtr >= 25600) {
                Main.game.ThrowError("NxtPtr<MAXRUN: " + NxtPtr);
            }
            NxtPtr = RunList.RunData[RunList.RunChain].RunPtr;
        }
        while (true) {
            int RunPtr;
            if ((RunPtr = NxtPtr) < 0) {
                return;
            }
            if (RunPtr >= 25600) break;
            NxtPtr = RunList.RunData[NxtPtr].RunPtr;
            if (RunList.RunData[RunPtr].RunEvent >> 16 >= 0) continue;
            RunList.DoSubRunRec(RunPtr);
        }
        Main.game.ThrowError("RunPtr<MAXRUN");
    }

    public static void SubRunRec(int RunPtr) {
        if (RunPtr < 0 || RunPtr >= 25600) {
            Main.game.ThrowError("RunPtr>=0 && RunPtr<MAXRUN: " + RunPtr);
        }
        RunList.RunData[RunPtr].RunEvent = -Globals.totalmoves;
    }

    public static void SendMessageToRunRec(int RunPtr, int a2, int a3) {
        int func = RunList.RunData[RunPtr].RunEvent >> 16;
        if (func >= 0 && func <= 38 && funclist[func] != null) {
            funclist[func].run(a2, a3, RunPtr);
        }
    }

    public static void ExplodeSignalRun() {
        int NxtPtr = RunChain;
        if (RunChain >= 0) {
            if (RunChain >= 25600) {
                Main.game.ThrowError("NxtPtr<MAXRUN: " + RunChain);
            }
            NxtPtr = RunList.RunData[RunList.RunChain].RunPtr;
        }
        while (true) {
            int RunPtr;
            if ((RunPtr = NxtPtr) < 0) {
                return;
            }
            if (RunPtr >= 25600) break;
            NxtPtr = RunList.RunData[NxtPtr].RunPtr;
            if (RunList.RunData[RunPtr].RunEvent < 0) continue;
            RunList.SendMessageToRunRec(RunPtr, 655360, 0);
        }
        Main.game.ThrowError("RunPtr<MAXRUN");
    }

    public static void PushMoveRun(int stack) {
        if (nStackCount < 200) {
            RunList.sRunStack[RunList.nStackCount] = stack;
            ++nStackCount;
        }
    }

    public static int PopMoveRun() {
        if (nStackCount <= 0) {
            Main.game.ThrowError(" PopMoveRun() called inappropriately");
        }
        return sRunStack[--nStackCount];
    }

    public static void SignalRun(int run, int stack) {
        int NxtPtr = run;
        if (NxtPtr == RunChain && word_966BE) {
            RunList.PushMoveRun(stack);
        } else {
            while (true) {
                int RunPtr;
                word_966BE = true;
                if (NxtPtr >= 0) {
                    if (NxtPtr >= 25600) {
                        Main.game.ThrowError("NxtPtr<MAXRUN");
                    }
                    NxtPtr = RunList.RunData[NxtPtr].RunPtr;
                }
                while ((RunPtr = NxtPtr) >= 0) {
                    if (RunPtr >= 25600) {
                        Main.game.ThrowError("RunPtr<MAXRUN");
                    }
                    NxtPtr = RunList.RunData[NxtPtr].RunPtr;
                    if (RunList.RunData[RunPtr].RunEvent < 0) continue;
                    RunList.SendMessageToRunRec(RunPtr, stack, 0);
                }
                word_966BE = false;
                if (nStackCount == 0) break;
                stack = RunList.PopMoveRun();
                NxtPtr = RunChain;
            }
        }
    }

    public static void InitChan() {
        ChannelList = -1;
        ChannelLast = -1;
        int i = 0;
        while (i < 4096) {
            if (channel[i] == null) {
                RunList.channel[i] = new Channel();
            }
            RunList.channel[i].head = RunList.HeadRun();
            RunList.channel[i].next = (short)-1;
            RunList.channel[i].field_4 = (short)-1;
            RunList.channel[i].field_6 = 0;
            ++i;
        }
    }

    public static void ChangeChannel(int ch, int a2) {
        if (RunList.channel[ch].next < 0) {
            short tmp = (short)ChannelList;
            ChannelList = ch;
            RunList.channel[ch].next = tmp;
        }
        RunList.channel[ch].field_4 = (short)a2;
        RunList.channel[ch].field_6 = (short)(RunList.channel[ch].field_6 | 2);
    }

    public static void ReadyChannel(int ch) {
        if (RunList.channel[ch].next < 0) {
            short tmp = (short)ChannelList;
            ChannelList = ch;
            RunList.channel[ch].next = tmp;
        }
        RunList.channel[ch].field_6 = (short)(RunList.channel[ch].field_6 | 1);
    }

    public static void ProcessChannels() {
        int ch1;
        do {
            int ch2 = -1;
            ch1 = -1;
            while (ChannelList >= 0) {
                Channel v2 = channel[ChannelList];
                short v3 = v2.field_6;
                short next = v2.next;
                if ((v3 & 2) != 0) {
                    v2.field_6 = (short)(v2.field_6 ^ 2);
                    RunList.SignalRun(v2.head, ChannelList | 0x10000);
                }
                if ((v3 & 1) != 0) {
                    v2.field_6 = (short)(v2.field_6 ^ 1);
                    RunList.SignalRun(v2.head, 196608);
                }
                if (v2.field_6 != 0) {
                    if (ch1 == -1) {
                        ch1 = ChannelList;
                        ch2 = ChannelList;
                    } else {
                        RunList.channel[ch2].next = (short)ChannelList;
                        ch2 = ChannelList;
                    }
                } else {
                    RunList.channel[RunList.ChannelList].next = (short)-1;
                }
                ChannelList = next;
            }
            ChannelList = ch1;
        } while (ch1 != -1);
    }

    public static int FindChannel(int ch) {
        int i = 0;
        while (i < 4096) {
            if (RunList.channel[i].field_4 == -1) {
                RunList.channel[i].field_4 = (short)ch;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int AllocChannel(int ch) {
        if (ch != 0) {
            int i = 0;
            while (i < 4096) {
                if (RunList.channel[i].field_4 == ch) {
                    return i;
                }
                ++i;
            }
        }
        return RunList.FindChannel(ch);
    }

    public static void ExecObjects() {
        RunList.ProcessChannels();
        RunList.SignalRun(RunChain, 131072);
    }
}

