/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.CommonMenus.MenuVideoMode;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlotList;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Menus.InterfaceMenu;
import ru.m210projects.Redneck.Screen;
import ru.m210projects.Redneck.Sounds;

public class RRMenuHandler
extends MenuHandler {
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int NEWGAME = 2;
    public static final int SOUNDSET = 3;
    public static final int DIFFICULTY = 4;
    public static final int HELP = 6;
    public static final int LOADGAME = 7;
    public static final int SAVEGAME = 8;
    public static final int QUIT = 9;
    public static final int QUITTITLE = 10;
    public static final int NETWORKGAME = 11;
    public static final int MULTIPLAYER = 12;
    public static final int COLORCORR = 13;
    public static final int NEWADDON = 14;
    public static final int OPTIONS = 15;
    public static final int USERCONTENT = 16;
    public static final int CORRUPTLOAD = 17;
    public static final int TRACKPLAYER = 18;
    public BuildMenu[] mMenus = new BuildMenu[19];
    private Engine engine;
    private BuildGame app;

    public RRMenuHandler(BuildGame app) {
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public void mDrawMenu() {
        if (Screen.screensize != 0) {
            Screen.vscrn(0);
        }
        if (!(this.app.pMenu.getCurrentMenu() instanceof MenuRendererSettings) && !(this.app.pMenu.getCurrentMenu() instanceof InterfaceMenu)) {
            int tile = 2542;
            Tile pic = this.engine.getTile(tile);
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)pic.getHeight() : (float)(Engine.xdim + 1) / (float)pic.getWidth();
            this.engine.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 4, 25, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        super.mDrawMenu();
    }

    @Override
    public void mClose() {
        super.mClose();
        Screen.vscrn(Globals.ud.screen_size);
    }

    @Override
    public int getShade(MenuItem item) {
        int shade = 8;
        if (item != null && item.isFocused()) {
            shade = 8 + Pragmas.mulscale(16L, Engine.sintable[32 * Engine.totalclock & 0x7FF], 16);
        }
        return shade;
    }

    @Override
    public int getPal(BuildFont font, MenuItem item) {
        if (item instanceof MenuFileBrowser) {
            return 12;
        }
        if (item != null) {
            if (!item.isEnabled()) {
                return 1;
            }
            return item.pal;
        }
        return 10;
    }

    @Override
    public void mPostDraw(MenuItem item) {
        int shade = 8 - (Engine.totalclock & 0x3F);
        if (item.isFocused()) {
            int yoff;
            int xoff;
            int py;
            int px;
            int scale;
            if (item instanceof MenuButton) {
                scale = 8192;
                px = item.x;
                py = item.y;
                xoff = 0;
                yoff = 0;
                if (item.font.equals(this.app.getFont(1))) {
                    scale /= 2;
                    xoff = -20;
                    yoff = 6;
                }
                if (item.font.equals(this.app.getFont(2))) {
                    xoff = this.engine.getTile(512).getWidth() - 4;
                    yoff = 12;
                }
                if (item.align == 1) {
                    int centre = 80;
                    this.engine.rotatesprite(160 + (centre >> 1) + 70 << 16, py + yoff << 16, scale, 0, 911 - (15 + (Engine.totalclock >> 3) & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    this.engine.rotatesprite(160 - (centre >> 1) - 70 << 16, py + yoff << 16, scale, 0, 896 + (Engine.totalclock >> 3 & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else {
                    this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 896 + (Engine.totalclock >> 3) % 7, shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            }
            if (item instanceof MenuVariants) {
                this.engine.rotatesprite(0xA00000, item.y + this.engine.getTile(512).getHeight() << 16, 8192, 0, 896 + (Engine.totalclock >> 3 & 0xF), 8 - (Engine.totalclock & 0x3F), 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            if (item instanceof MenuSwitch || item instanceof MenuSlider || item instanceof MenuTextField || item instanceof MenuConteiner) {
                scale = 8192;
                px = item.x;
                py = item.y;
                xoff = 0;
                yoff = 0;
                if (item.font.equals(this.app.getFont(1))) {
                    scale /= 2;
                    xoff = -10;
                    yoff = 6;
                }
                if (item.font.equals(this.app.getFont(2))) {
                    xoff = -20;
                    yoff = 12;
                }
                this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 896 + (Engine.totalclock >> 3 & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            if (item instanceof MenuList) {
                int py2;
                int focus;
                if (item instanceof MenuJoyList) {
                    MenuList list = (MenuList)item;
                    px = list.x;
                    focus = list.l_nFocus;
                    if (list.l_nMin < this.app.pCfg.joymap.length && focus >= this.app.pCfg.joymap.length) {
                        ++focus;
                    }
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    py2 = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    this.engine.rotatesprite(px - 10 << 16, py2 + 3 << 16, 4096, 0, 896 + (Engine.totalclock >> 3 & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else if (item instanceof MenuKeyboardList) {
                    MenuList list = (MenuList)item;
                    px = list.x;
                    focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    py2 = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    this.engine.rotatesprite(px - 10 << 16, py2 + 3 << 16, 4096, 0, 896 + (Engine.totalclock >> 3 & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else if (item instanceof MenuSlotList) {
                    MenuSlotList list = (MenuSlotList)item;
                    if (list.deleteQuestion) {
                        this.engine.rotatesprite(0xA00000, 0x870000, 8192, 0, 896 + (Engine.totalclock >> 3 & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    } else {
                        px = list.x;
                        focus = list.l_nFocus;
                        if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                            return;
                        }
                        py2 = list.y + (focus - list.l_nMin) * list.mFontOffset();
                        this.engine.rotatesprite(px + 123 << 16, py2 + 3 << 16, 4096, 0, 896 + (Engine.totalclock >> 3 & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    }
                } else if (item instanceof MenuResolutionList) {
                    MenuList list = (MenuList)item;
                    px = list.x + 4;
                    focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    py2 = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    this.engine.rotatesprite(px << 16, py2 + 6 << 16, 8192, 0, 896 + (Engine.totalclock >> 3 & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else {
                    MenuList list = (MenuList)item;
                    if (list.l_nFocus == -1 || list.l_nFocus < list.l_nMin || list.l_nFocus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    px = list.x;
                    py = list.y + (list.l_nFocus - list.l_nMin) * list.mFontOffset() + 12;
                    int centre = 80;
                    this.engine.rotatesprite(px + 160 + (centre >> 1) + 70 << 16, py << 16, 8192, 0, 911 - (15 + (Engine.totalclock >> 3) & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    this.engine.rotatesprite(px + 160 - (centre >> 1) - 70 << 16, py << 16, 8192, 0, 896 + (Engine.totalclock >> 3 & 0xF), shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            }
        }
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(65536L, Engine.ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.gMouseCursorSize, 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        this.engine.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        if (this.mCount > 1) {
            Tile pic = this.engine.getTile(9216);
            int shade = 16 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
            this.engine.rotatesprite(0, Engine.ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, pic.getWidth() - 1, 16), Engine.ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        Tile pic = this.engine.getTile(9216);
        int size = Pragmas.mulscale(pic.getWidth(), zoom, 16);
        int bx = 0;
        int by = Engine.ydim - size;
        return mx >= bx && mx < bx + size && my >= by && my < by + size;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: {
                Sounds.sound(2);
                break;
            }
            case Close: {
                Sounds.sound(243);
                break;
            }
            case UP: 
            case DW: {
                Sounds.sound(335);
                break;
            }
            case LEFT: 
            case RIGHT: 
            case ENTER: {
                if (opt == MenuHandler.MenuOpt.ENTER && item instanceof MenuConteiner && item.getClass().getEnclosingClass() == MenuVideoMode.class) break;
                if (item instanceof MenuSlider || item instanceof MenuSwitch || item instanceof MenuConteiner) {
                    Sounds.sound(0);
                }
                if (!(item instanceof MenuFileBrowser) || opt == MenuHandler.MenuOpt.ENTER) break;
                Sounds.sound(0);
                break;
            }
        }
    }
}

