/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Skull {
    public static final int SKULL_RATE = 10;
    private static final Animator DoSkullWait = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Skull.DoSkullWait(SpriteNum) != 0;
        }
    };
    public static final State[][] s_SkullWait = new State[][]{{new State(820, 10, DoSkullWait).setNext()}, {new State(821, 10, DoSkullWait).setNext()}, {new State(822, 10, DoSkullWait).setNext()}, {new State(823, 10, DoSkullWait).setNext()}, {new State(824, 10, DoSkullWait).setNext()}};
    public static final ATTRIBUTE SkullAttrib;
    private static final Animator DoSerpRing;
    public static final State[][] s_SkullRing;
    private static final Animator DoSkullJump;
    private static final State[][] s_SkullJump;
    public static final int SKULL_EXPLODE_RATE = 11;
    private static final Animator DoSkullSpawnShrap;
    public static final State[] s_SkullExplode;
    private static final int SKULL_BOB_AMT;
    public static final int BETTY_RATE = 10;
    private static final Animator DoBettyWait;
    private static final State[][] s_BettyWait;
    private static final ATTRIBUTE BettyAttrib;
    private static final Animator DoBettyJump;
    private static final State[][] s_BettyJump;
    public static final int BETTY_EXPLODE_RATE = 11;
    public static final int BETTY_EXPLODE = 817;
    private static final State[] s_BettyExplode;
    public static final int BETTY_BOB_AMT;

    static {
        short[] sArray = new short[4];
        sArray[0] = 3;
        sArray[2] = -2;
        sArray[3] = -3;
        int[] nArray = new int[10];
        nArray[0] = 115;
        nArray[4] = 116;
        nArray[5] = 117;
        SkullAttrib = new ATTRIBUTE(new short[]{60, 80, 100, 130}, sArray, 3, nArray);
        DoSerpRing = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Weapon.DoSerpRing(SpriteNum) != 0;
            }
        };
        s_SkullRing = new State[][]{{new State(820, 10, DoSerpRing).setNext()}, {new State(821, 10, DoSerpRing).setNext()}, {new State(822, 10, DoSerpRing).setNext()}, {new State(823, 10, DoSerpRing).setNext()}, {new State(824, 10, DoSerpRing).setNext()}};
        DoSkullJump = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Skull.DoSkullJump(SpriteNum) != 0;
            }
        };
        s_SkullJump = new State[][]{{new State(820, 10, DoSkullJump).setNext()}, {new State(821, 10, DoSkullJump).setNext()}, {new State(822, 10, DoSkullJump).setNext()}, {new State(823, 10, DoSkullJump).setNext()}, {new State(824, 10, DoSkullJump).setNext()}};
        DoSkullSpawnShrap = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Skull.DoSkullSpawnShrap(SpriteNum) != 0;
            }
        };
        s_SkullExplode = new State[]{new State(825, 1, null), new State(825, Gameutils.SF_QUICK_CALL, Weapon.DoDamageTest), new State(825, 11, null), new State(826, 11, null), new State(827, Gameutils.SF_QUICK_CALL, DoSkullSpawnShrap), new State(827, 11, null), new State(828, 11, null), new State(829, 11, null), new State(830, 11, null), new State(831, 11, null), new State(832, 11, null), new State(833, 11, null), new State(834, 11, null), new State(835, 11, null), new State(836, 11, null), new State(837, 11, null), new State(838, 11, null), new State(838, 11, Weapon.DoSuicide).setNext()};
        SKULL_BOB_AMT = Gameutils.Z(16);
        DoBettyWait = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Skull.DoBettyWait(SpriteNum) != 0;
            }
        };
        s_BettyWait = new State[][]{{new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}, {new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}, {new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}, {new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}, {new State(817, 10, DoBettyWait), new State(818, 10, DoBettyWait), new State(819, 10, DoBettyWait)}};
        short[] sArray2 = new short[4];
        sArray2[0] = 3;
        sArray2[2] = -2;
        sArray2[3] = -3;
        BettyAttrib = new ATTRIBUTE(new short[]{60, 80, 100, 130}, sArray2, 3, new int[10]);
        DoBettyJump = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Skull.DoBettyJump(SpriteNum) != 0;
            }
        };
        s_BettyJump = new State[][]{{new State(817, 10, DoBettyJump).setNext()}, {new State(817, 10, DoBettyJump).setNext()}, {new State(817, 10, DoBettyJump).setNext()}, {new State(817, 10, DoBettyJump).setNext()}, {new State(817, 10, DoBettyJump).setNext()}};
        s_BettyExplode = new State[]{new State(817, Gameutils.SF_QUICK_CALL, Weapon.DoDamageTest), new State(817, 11, Weapon.DoSuicide)};
        BETTY_BOB_AMT = Gameutils.Z(16);
    }

    public static void InitSkullStates() {
        SkullStateGroup[] skullStateGroupArray = SkullStateGroup.values();
        int n = skullStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            SkullStateGroup sg = skullStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
        State.InitState(s_SkullExplode);
        State.InitState(s_BettyExplode);
    }

    public static int SetupSkull(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 820, s_SkullWait[0][0]);
            u.Health = (short)4;
        }
        Sprites.ChangeState(SpriteNum, s_SkullWait[0][0]);
        u.Attrib = SkullAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_SkullExplode[0];
        u.Rot = SkullStateGroup.sg_SkullWait;
        u.ID = (short)820;
        Coolie.EnemyDefaults(SpriteNum, null, null);
        sp.clipdist = 48;
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        u.Radius = 400;
        if (Gameutils.SPRITEp_BOS(sp) > u.loz - Gameutils.Z(16)) {
            u.loz = sp.z = u.loz + Gameutils.Z(Gameutils.SPRITEp_YOFF(sp));
            sp.z += Gameutils.SPRITEp_SIZE_TOS(sp) - Gameutils.Z(3);
        } else {
            u.Counter = (short)Gameutils.RANDOM_P2(2048);
            u.sz = sp.z;
        }
        return 0;
    }

    private static int DoSkullMove(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int dax = Gameutils.MOVEx(sp.xvel, sp.ang);
        int day = Gameutils.MOVEy(sp.xvel, sp.ang);
        short daz = sp.zvel;
        u.ret = Sprites.move_missile(SpriteNum, dax, day, daz, Gameutils.Z(16), Gameutils.Z(16), Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.DoFindGroundPoint(SpriteNum);
        return 0;
    }

    public static int DoSkullBeginDeath(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int num_ord = 0;
        if (sp.owner >= 0) {
            Gameutils.pUser[sp.owner].Counter = (short)(Gameutils.pUser[sp.owner].Counter - 1);
        }
        sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        switch (sp.hitag) {
            case 1: {
                num_ord = sp.lotag != 0 ? (int)sp.lotag : 2;
                if (num_ord > 3) {
                    num_ord = 3;
                }
                int i = 0;
                while (i < num_ord) {
                    sp.ang = Gameutils.NORM_ANGLE(sp.ang + i * 1024);
                    JWeapon.InitSpriteChemBomb(SpriteNum);
                    ++i;
                }
                break;
            }
            case 2: {
                num_ord = sp.lotag != 0 ? (int)sp.lotag : 5;
                if (num_ord > 10) {
                    num_ord = 10;
                }
                int i = 0;
                while (i < num_ord) {
                    sp.ang = Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048));
                    JWeapon.InitCaltrops(SpriteNum);
                    ++i;
                }
                break;
            }
            case 3: {
                Weapon.UpdateSinglePlayKills(SpriteNum, null);
                JWeapon.InitFlashBomb(SpriteNum);
                break;
            }
            case 4: {
                num_ord = sp.lotag != 0 ? (int)sp.lotag : 5;
                if (num_ord > 10) {
                    num_ord = 10;
                }
                int i = 0;
                while (i < num_ord) {
                    sp.ang = Gameutils.NORM_ANGLE(sp.ang + i * (2048 / num_ord));
                    Weapon.InitSpriteGrenade(SpriteNum);
                    ++i;
                }
                break;
            }
            default: {
                Weapon.SpawnMineExp(SpriteNum);
                int i = 0;
                while (i < 3) {
                    sp.ang = Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048));
                    JWeapon.InitPhosphorus(SpriteNum);
                    ++i;
                }
                break block0;
            }
        }
        u.RotNum = 0;
        u.Tics = 0;
        u.ID = (short)820;
        u.Radius = Weapon.DamageData[23].radius;
        u.OverlapZ = Gameutils.Z(64);
        Sprites.change_sprite_stat(SpriteNum, 3);
        sp.shade = (byte)-40;
        Weapon.SpawnLittleExp(SpriteNum);
        Weapon.SetSuicide(SpriteNum);
        return 0;
    }

    private static int DoSkullJump(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (sp.xvel != 0) {
            Skull.DoSkullMove(SpriteNum);
        } else {
            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 384);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
            Actor.DoJump(SpriteNum);
        } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            Actor.DoFall(SpriteNum);
            if (sp.xvel != 0) {
                int dist = Gameutils.DISTANCE(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y);
                if (dist < 1000 && Sprites.SpriteOverlapZ(SpriteNum, u.tgt_sp, Gameutils.Z(32))) {
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Skull.DoSkullBeginDeath(SpriteNum);
                    return 0;
                }
                if (sp.z > u.loz - Gameutils.Z(36)) {
                    sp.z = u.loz - Gameutils.Z(36);
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Skull.DoSkullBeginDeath(SpriteNum);
                    return 0;
                }
            } else if (u.jump_speed > 200) {
                Weapon.UpdateSinglePlayKills(SpriteNum, null);
                Skull.DoSkullBeginDeath(SpriteNum);
            }
        } else {
            Weapon.UpdateSinglePlayKills(SpriteNum, null);
            Skull.DoSkullBeginDeath(SpriteNum);
        }
        return 0;
    }

    private static int DoSkullBob(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        u.Counter = (short)(u.Counter + 48 + 12 & 0x7FF);
        sp.z = u.sz + (SKULL_BOB_AMT * Engine.sintable[u.Counter] >> 14) + (MyTypes.DIV2(SKULL_BOB_AMT) * Engine.sintable[u.Counter] >> 14);
        return 0;
    }

    private static int DoSkullSpawnShrap(int SpriteNum) {
        Shrap.SpawnShrap(SpriteNum, -1);
        return 0;
    }

    private static int DoSkullWait(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int dist = Gameutils.DISTANCE(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y);
        Ai.DoActorPickClosePlayer(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Sound.PlaySound(116, sp, 0);
            u.WaitTics = (short)(Gameutils.SEC(3) + Gameutils.RANDOM_RANGE(360));
        }
        if (sp.z > u.loz) {
            if (dist < 3500) {
                sp.xvel = 0;
                u.jump_speed = (short)-600;
                Sprites.NewStateGroup(SpriteNum, SkullStateGroup.sg_SkullJump);
                Actor.DoBeginJump(SpriteNum);
            }
        } else {
            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 288);
            Skull.DoSkullBob(SpriteNum);
            if (dist < 8000) {
                sp.ang = Main.engine.getangle(Engine.sprite[u.tgt_sp].x - sp.x, Engine.sprite[u.tgt_sp].y - sp.y);
                sp.xvel = (short)(128 + (Gameutils.RANDOM_P2(65536) >> 8));
                u.jump_speed = (short)-700;
                Sprites.NewStateGroup(SpriteNum, SkullStateGroup.sg_SkullJump);
                Actor.DoBeginJump(SpriteNum);
            }
        }
        return 0;
    }

    public static int SetupBetty(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 817, s_BettyWait[0][0]);
            u.Health = (short)4;
        }
        Sprites.ChangeState(SpriteNum, s_BettyWait[0][0]);
        u.Attrib = BettyAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_BettyExplode[0];
        u.Rot = SkullStateGroup.sg_BettyWait;
        u.ID = (short)817;
        Coolie.EnemyDefaults(SpriteNum, null, null);
        sp.clipdist = 48;
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        u.Radius = 400;
        if (Gameutils.SPRITEp_BOS(sp) > u.loz - Gameutils.Z(16)) {
            u.loz = sp.z = u.loz + Gameutils.Z(Gameutils.SPRITEp_YOFF(sp));
            sp.z += Gameutils.SPRITEp_SIZE_TOS(sp) - Gameutils.Z(3);
        } else {
            u.Counter = (short)Gameutils.RANDOM_P2(2048);
            u.sz = sp.z;
        }
        return 0;
    }

    private static int DoBettyMove(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int dax = Gameutils.MOVEx(sp.xvel, sp.ang);
        int day = Gameutils.MOVEy(sp.xvel, sp.ang);
        short daz = sp.zvel;
        u.ret = Sprites.move_missile(SpriteNum, dax, day, daz, Gameutils.Z(16), Gameutils.Z(16), Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.DoFindGroundPoint(SpriteNum);
        return 0;
    }

    public static int DoBettyBeginDeath(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int num_ord = 0;
        sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        switch (sp.hitag) {
            case 1: {
                num_ord = sp.lotag != 0 ? (int)sp.lotag : 2;
                if (num_ord > 3) {
                    num_ord = 3;
                }
                int i = 0;
                while (i < num_ord) {
                    sp.ang = Gameutils.NORM_ANGLE(sp.ang + i * 1024);
                    JWeapon.InitSpriteChemBomb(SpriteNum);
                    ++i;
                }
                break;
            }
            case 2: {
                num_ord = sp.lotag != 0 ? (int)sp.lotag : 5;
                if (num_ord > 10) {
                    num_ord = 10;
                }
                int i = 0;
                while (i < num_ord) {
                    sp.ang = Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048));
                    JWeapon.InitCaltrops(SpriteNum);
                    ++i;
                }
                break;
            }
            case 3: {
                JWeapon.InitFlashBomb(SpriteNum);
                break;
            }
            case 4: {
                num_ord = sp.lotag != 0 ? (int)sp.lotag : 5;
                if (num_ord > 10) {
                    num_ord = 10;
                }
                int i = 0;
                while (i < num_ord) {
                    sp.ang = Gameutils.NORM_ANGLE(sp.ang + i * (2048 / num_ord));
                    Weapon.InitSpriteGrenade(SpriteNum);
                    ++i;
                }
                break;
            }
            default: {
                int i = 0;
                while (i < 5) {
                    sp.ang = Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048));
                    JWeapon.InitPhosphorus(SpriteNum);
                    Weapon.SpawnMineExp(SpriteNum);
                    ++i;
                }
                break block0;
            }
        }
        u.RotNum = 0;
        u.Tics = 0;
        u.ID = (short)817;
        u.Radius = Weapon.DamageData[23].radius;
        u.OverlapZ = Gameutils.Z(64);
        Sprites.change_sprite_stat(SpriteNum, 3);
        sp.shade = (byte)-40;
        Weapon.SpawnLittleExp(SpriteNum);
        Weapon.SetSuicide(SpriteNum);
        return 0;
    }

    private static int DoBettyJump(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (sp.xvel != 0) {
            Skull.DoBettyMove(SpriteNum);
        } else {
            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 384);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
            Actor.DoJump(SpriteNum);
        } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            Actor.DoFall(SpriteNum);
            if (sp.xvel != 0) {
                int dist = Gameutils.DISTANCE(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y);
                if (dist < 1000 && Sprites.SpriteOverlapZ(SpriteNum, u.tgt_sp, Gameutils.Z(32))) {
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Skull.DoBettyBeginDeath(SpriteNum);
                    return 0;
                }
                if (sp.z > u.loz - Gameutils.Z(36)) {
                    sp.z = u.loz - Gameutils.Z(36);
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Skull.DoBettyBeginDeath(SpriteNum);
                    return 0;
                }
            } else if (u.jump_speed > 200) {
                Weapon.UpdateSinglePlayKills(SpriteNum, null);
                Skull.DoBettyBeginDeath(SpriteNum);
            }
        } else {
            Weapon.UpdateSinglePlayKills(SpriteNum, null);
            Skull.DoBettyBeginDeath(SpriteNum);
        }
        return 0;
    }

    private static int DoBettyBob(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        u.Counter = (short)(u.Counter + 48 + 12 & 0x7FF);
        sp.z = u.sz + (BETTY_BOB_AMT * Engine.sintable[u.Counter] >> 14) + (MyTypes.DIV2(BETTY_BOB_AMT) * Engine.sintable[u.Counter] >> 14);
        return 0;
    }

    private static int DoBettyWait(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int dist = Gameutils.DISTANCE(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y);
        Ai.DoActorPickClosePlayer(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Sound.PlaySound(26, sp, 0);
            u.WaitTics = (short)Gameutils.SEC(3);
        }
        if (sp.z > u.loz) {
            if (dist < 3500) {
                sp.xvel = 0;
                u.jump_speed = (short)-600;
                Sprites.NewStateGroup(SpriteNum, SkullStateGroup.sg_BettyJump);
                Actor.DoBeginJump(SpriteNum);
            }
        } else {
            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 288);
            Skull.DoBettyBob(SpriteNum);
            if (dist < 8000) {
                sp.ang = Main.engine.getangle(Engine.sprite[u.tgt_sp].x - sp.x, Engine.sprite[u.tgt_sp].y - sp.y);
                sp.xvel = (short)(128 + (Gameutils.RANDOM_P2(65536) >> 8));
                u.jump_speed = (short)-700;
                Sprites.NewStateGroup(SpriteNum, SkullStateGroup.sg_BettyJump);
                Actor.DoBeginJump(SpriteNum);
            }
        }
        return 0;
    }

    public static void SkullSaveable() {
        Saveable.SaveData(DoSerpRing);
        Saveable.SaveData(DoSkullJump);
        Saveable.SaveData(DoSkullSpawnShrap);
        Saveable.SaveData(DoSkullWait);
        Saveable.SaveData(DoBettyJump);
        Saveable.SaveData(DoBettyWait);
        Saveable.SaveData(s_SkullWait);
        Saveable.SaveGroup(SkullStateGroup.sg_SkullWait);
        Saveable.SaveData(SkullAttrib);
        Saveable.SaveData(s_SkullRing);
        Saveable.SaveGroup(SkullStateGroup.sg_SkullRing);
        Saveable.SaveData(s_SkullJump);
        Saveable.SaveGroup(SkullStateGroup.sg_SkullJump);
        Saveable.SaveData(s_SkullExplode);
        Saveable.SaveData(s_BettyWait);
        Saveable.SaveGroup(SkullStateGroup.sg_BettyWait);
        Saveable.SaveData(BettyAttrib);
        Saveable.SaveData(s_BettyJump);
        Saveable.SaveGroup(SkullStateGroup.sg_BettyJump);
        Saveable.SaveData(s_BettyExplode);
    }

    static /* synthetic */ State[][] access$5() {
        return s_SkullJump;
    }

    static /* synthetic */ State[][] access$6() {
        return s_BettyWait;
    }

    static /* synthetic */ State[][] access$7() {
        return s_BettyJump;
    }

    public static enum SkullStateGroup implements Sprites.StateGroup
    {
        sg_SkullWait(s_SkullWait[0], s_SkullWait[1], s_SkullWait[2], s_SkullWait[3], s_SkullWait[4]),
        sg_SkullJump(Skull.access$5()[0], Skull.access$5()[1], Skull.access$5()[2], Skull.access$5()[3], Skull.access$5()[4]),
        sg_BettyWait(Skull.access$6()[0], Skull.access$6()[1], Skull.access$6()[2], Skull.access$6()[3], Skull.access$6()[4]),
        sg_BettyJump(Skull.access$7()[0], Skull.access$7()[1], Skull.access$7()[2], Skull.access$7()[3], Skull.access$7()[4]),
        sg_SkullRing(s_SkullRing[0], s_SkullRing[1], s_SkullRing[2], s_SkullRing[3], s_SkullRing[4]);

        private final State[][] group;
        private int index = -1;

        private SkullStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

