/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Zombie {
    private static final int ZOMBIE_RATE = 32;
    private static final int ZOMBIE_TIME_LIMIT = 400;
    public static final Animator DoZombieMove = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            short s = u.Counter3;
            u.Counter3 = (short)(s + 1);
            if (s >= 400) {
                JWeapon.InitBloodSpray(SpriteNum, true, 105);
                JWeapon.InitBloodSpray(SpriteNum, true, 105);
                JWeapon.InitBloodSpray(SpriteNum, true, 105);
                Weapon.SetSuicide(SpriteNum);
                return false;
            }
            if (u.tgt_sp != -1 && Gameutils.pUser[u.tgt_sp] != null && MyTypes.TEST(Gameutils.pUser[u.tgt_sp].Flags, Gameutils.PF_DEAD)) {
                Ai.DoActorPickClosePlayer(SpriteNum);
            }
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
                if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                    Actor.DoActorJump(SpriteNum);
                } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
                    Actor.DoActorFall(SpriteNum);
                }
            }
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
                Actor.DoActorSlide(SpriteNum);
            }
            if (u.track >= 0) {
                Track.ActorFollowTrack(SpriteNum, 6);
            } else {
                u.ActorActionFunc.invoke(SpriteNum);
            }
            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
                Actor.KeepActorOnFloor(SpriteNum);
            }
            Actor.DoActorSectorDamage(SpriteNum);
            return false;
        }
    };
    private static final State[][] s_ZombieRun = new State[][]{{new State(1094, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1095, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1096, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1097, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}, {new State(1098, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1099, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1100, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1101, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}, {new State(1102, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1103, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1104, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1105, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}, {new State(1106, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1107, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1108, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1109, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}, {new State(1110, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1111, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1112, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1113, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}};
    public static final Animator DoZombiePain = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            NullZombie.invoke(SpriteNum);
            u.WaitTics = (short)(u.WaitTics - 6);
            if (u.WaitTics <= 0) {
                Ai.InitActorDecide(SpriteNum);
            }
            return false;
        }
    };
    public static final Animator NullZombie = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            short s = u.Counter3;
            u.Counter3 = (short)(s + 1);
            if (s >= 400) {
                JWeapon.InitBloodSpray(SpriteNum, true, 105);
                JWeapon.InitBloodSpray(SpriteNum, true, 105);
                JWeapon.InitBloodSpray(SpriteNum, true, 105);
                Weapon.SetSuicide(SpriteNum);
                return false;
            }
            if (u.tgt_sp != -1 && Gameutils.pUser[u.tgt_sp] != null && MyTypes.TEST(Gameutils.pUser[u.tgt_sp].Flags, Gameutils.PF_DEAD)) {
                Ai.DoActorPickClosePlayer(SpriteNum);
            }
            if (u.WaitTics > 0) {
                u.WaitTics = (short)(u.WaitTics - 6);
            }
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
                Actor.DoActorSlide(SpriteNum);
            }
            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
                Actor.KeepActorOnFloor(SpriteNum);
            }
            Actor.DoActorSectorDamage(SpriteNum);
            return false;
        }
    };
    private static final int ZOMBIE_PAIN_RATE = 15;
    private static final State[][] s_ZombiePain = new State[][]{{new State(1094, 15, DoZombiePain), new State(1095, 15, DoZombiePain)}, {new State(1098, 15, DoZombiePain), new State(1098, 15, DoZombiePain)}, {new State(1102, 15, DoZombiePain), new State(1102, 15, DoZombiePain)}, {new State(1106, 15, DoZombiePain), new State(1106, 15, DoZombiePain)}, {new State(1110, 15, DoZombiePain), new State(1110, 15, DoZombiePain)}};
    private static final ATTRIBUTE ZombieAttrib;
    private static final Decision[] ZombieBattle;
    private static final Decision[] ZombieOffense;
    private static final Decision[] ZombieBroadcast;
    private static final Decision[] ZombieSurprised;
    private static final Decision[] ZombieEvasive;
    private static final Decision[] ZombieLostTarget;
    private static final Decision[] ZombieCloseRange;
    private static final Personality ZombiePersonality;
    private static final int ZOMBIE_STAND_RATE = 10;
    private static final State[][] s_ZombieStand;
    private static final int ZOMBIE_FALL_RATE = 25;
    private static final State[][] s_ZombieFall;
    private static final int ZOMBIE_RAIL_RATE = 14;
    public static final Animator InitEnemyRail;
    private static final State[][] s_ZombieRail;
    private static final Actor_Action_Set ZombieActionSet;

    static {
        short[] sArray = new short[4];
        sArray[0] = 4;
        sArray[3] = -2;
        int[] nArray = new int[10];
        nArray[0] = 88;
        nArray[1] = 92;
        nArray[2] = 2;
        nArray[3] = 90;
        nArray[4] = 91;
        ZombieAttrib = new ATTRIBUTE(new short[]{120, 140, 170, 200}, sArray, 3, nArray);
        ZombieBattle = new Decision[]{new Decision(399, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
        ZombieOffense = new Decision[]{new Decision(399, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
        ZombieBroadcast = new Decision[]{new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
        ZombieSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
        ZombieEvasive = new Decision[]{new Decision(400, Ai.InitActorDuck), new Decision(1024, null)};
        ZombieLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
        ZombieCloseRange = new Decision[]{new Decision(800, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
        ZombiePersonality = new Personality(ZombieBattle, ZombieOffense, ZombieBroadcast, ZombieSurprised, ZombieEvasive, ZombieLostTarget, ZombieCloseRange, ZombieCloseRange);
        s_ZombieStand = new State[][]{{new State(1094, 10, NullZombie).setNext()}, {new State(1098, 10, NullZombie).setNext()}, {new State(1102, 10, NullZombie).setNext()}, {new State(1106, 10, NullZombie).setNext()}, {new State(1110, 10, NullZombie).setNext()}};
        s_ZombieFall = new State[][]{{new State(1077, 25, DoZombieMove).setNext()}, {new State(1081, 25, DoZombieMove).setNext()}, {new State(1085, 25, DoZombieMove).setNext()}, {new State(1089, 25, DoZombieMove).setNext()}, {new State(1093, 25, DoZombieMove).setNext()}};
        InitEnemyRail = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                Weapon.InitEnemyRail(SpriteNum);
                return false;
            }
        };
        s_ZombieRail = new State[][]{{new State(1094, 28, NullZombie), new State(1094, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1094, 14, NullZombie), new State(1094, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1094, 14, DoZombieMove).setNext()}, {new State(1098, 28, NullZombie), new State(1098, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1098, 14, NullZombie), new State(1098, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1098, 14, DoZombieMove).setNext()}, {new State(1102, 28, NullZombie), new State(1102, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1102, 14, NullZombie), new State(1102, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1102, 14, DoZombieMove).setNext()}, {new State(1106, 28, NullZombie), new State(1106, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1106, 14, NullZombie), new State(1106, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1106, 14, DoZombieMove).setNext()}, {new State(1110, 28, NullZombie), new State(1110, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1110, 14, NullZombie), new State(1110, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1110, 14, DoZombieMove).setNext()}};
        ZombieActionSet = new Actor_Action_Set(ZombieStateGroup.sg_ZombieStand, ZombieStateGroup.sg_ZombieRun, null, ZombieStateGroup.sg_ZombieFall, null, null, null, ZombieStateGroup.sg_ZombieRun, ZombieStateGroup.sg_ZombieRun, null, null, ZombieStateGroup.sg_ZombiePain, ZombieStateGroup.sg_ZombieRun, null, null, null, null, new Sprites.StateGroup[]{ZombieStateGroup.sg_ZombieRail}, new short[]{1024}, new Sprites.StateGroup[]{ZombieStateGroup.sg_ZombieRail}, new short[]{1024}, null, null, null);
    }

    public static int SpawnZombie2(int Weapon2) {
        short sectnum;
        SPRITE sp = Engine.sprite[Weapon2];
        Sect_User sectu = Sector.SectUser[sp.sectnum];
        SECTOR sectp = Engine.sector[sp.sectnum];
        short owner = Engine.sprite[Weapon2].owner;
        if (owner < 0) {
            return -1;
        }
        if (sectu != null && MyTypes.DTEST(sectp.extra, Gameutils.SECTFX_LIQUID_MASK) != 0) {
            return -1;
        }
        if (Gameutils.SectorIsUnderwaterArea(sp.sectnum)) {
            return -1;
        }
        if (Gameutils.FAF_ConnectArea(sp.sectnum) && (sectnum = Main.engine.updatesectorz(sp.x, sp.y, sp.z + Gameutils.Z(10), sp.sectnum)) >= 0 && Gameutils.SectorIsUnderwaterArea(sectnum)) {
            return -1;
        }
        int newsp = Sprites.SpawnSprite(2, 1095, s_ZombieRun[0][0], sp.sectnum, sp.x, sp.y, sp.z, sp.ang, 0);
        SPRITE np = Engine.sprite[newsp];
        USER nu = Gameutils.pUser[newsp];
        nu.Counter3 = 0;
        np.owner = owner;
        nu.spal = Gameutils.pUser[owner].spal;
        np.pal = nu.spal;
        np.ang = (short)Gameutils.RANDOM_P2(2048);
        Zombie.SetupZombie(newsp);
        np.shade = (byte)-10;
        nu.Flags2 |= Gameutils.SPR2_DONT_TARGET_OWNER;
        np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
        Ai.DoActorPickClosePlayer(newsp);
        nu.Flags |= Gameutils.SPR_ACTIVE;
        nu.Flags &= ~Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        Sprites.DoActorZrange(newsp);
        return newsp;
    }

    public static void InitZombieStates() {
        ZombieStateGroup[] zombieStateGroupArray = ZombieStateGroup.values();
        int n = zombieStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZombieStateGroup sg = zombieStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
    }

    private static int SetupZombie(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        u.Health = (short)100;
        u.StateEnd = s_ZombiePain[0][0];
        u.Rot = ZombieStateGroup.sg_ZombieRun;
        sp.xrepeat = (short)47;
        sp.yrepeat = (short)33;
        u.Attrib = ZombieAttrib;
        Coolie.EnemyDefaults(SpriteNum, ZombieActionSet, ZombiePersonality);
        Sprites.ChangeState(SpriteNum, s_ZombieRun[0][0]);
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.Radius = 280;
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        return 0;
    }

    public static void ZombieSaveable() {
        Saveable.SaveData(InitEnemyRail);
        Saveable.SaveData(DoZombieMove);
        Saveable.SaveData(NullZombie);
        Saveable.SaveData(DoZombiePain);
        Saveable.SaveData(ZombiePersonality);
        Saveable.SaveData(ZombieAttrib);
        Saveable.SaveData(s_ZombieRun);
        Saveable.SaveGroup(ZombieStateGroup.sg_ZombieRun);
        Saveable.SaveData(s_ZombieStand);
        Saveable.SaveGroup(ZombieStateGroup.sg_ZombieStand);
        Saveable.SaveData(s_ZombiePain);
        Saveable.SaveGroup(ZombieStateGroup.sg_ZombiePain);
        Saveable.SaveData(s_ZombieRail);
        Saveable.SaveGroup(ZombieStateGroup.sg_ZombieRail);
        Saveable.SaveData(s_ZombieFall);
        Saveable.SaveGroup(ZombieStateGroup.sg_ZombieFall);
        Saveable.SaveData(ZombieActionSet);
    }

    static /* synthetic */ State[][] access$0() {
        return s_ZombieStand;
    }

    static /* synthetic */ State[][] access$1() {
        return s_ZombieRun;
    }

    static /* synthetic */ State[][] access$2() {
        return s_ZombieFall;
    }

    static /* synthetic */ State[][] access$3() {
        return s_ZombiePain;
    }

    static /* synthetic */ State[][] access$4() {
        return s_ZombieRail;
    }

    private static enum ZombieStateGroup implements Sprites.StateGroup
    {
        sg_ZombieStand(Zombie.access$0()[0], Zombie.access$0()[1], Zombie.access$0()[2], Zombie.access$0()[3], Zombie.access$0()[4]),
        sg_ZombieRun(Zombie.access$1()[0], Zombie.access$1()[1], Zombie.access$1()[2], Zombie.access$1()[3], Zombie.access$1()[4]),
        sg_ZombieFall(Zombie.access$2()[0], Zombie.access$2()[1], Zombie.access$2()[2], Zombie.access$2()[3], Zombie.access$2()[4]),
        sg_ZombiePain(Zombie.access$3()[0], Zombie.access$3()[1], Zombie.access$3()[2], Zombie.access$3()[3], Zombie.access$3()[4]),
        sg_ZombieRail(Zombie.access$4()[0], Zombie.access$4()[1], Zombie.access$4()[2], Zombie.access$4()[3], Zombie.access$4()[4]);

        private final State[][] group;
        private int index = -1;

        private ZombieStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

