/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Wang.Type.EpisodeInfo;
import ru.m210projects.Wang.Type.LevelInfo;

public class GameInfo {
    public String Title;
    public DirectoryEntry resDir;
    public EpisodeInfo[] episode;
    public String[] skills = new String[]{"Tiny grasshopper", "I Have No Fear", "Who Wants Wang", "No Pain, No Gain"};
    public FileEntry file;
    private boolean pack;

    public GameInfo(String title, DirectoryEntry dir, EpisodeInfo ... eps) {
        this.Title = title;
        this.resDir = dir;
        this.episode = eps;
    }

    public GameInfo(String title, Group res, EpisodeInfo ... eps) {
        this.Title = title;
        this.file = res != null ? BuildGdx.compat.checkFile(res.name) : null;
        this.resDir = this.file != null ? this.file.getParent() : null;
        this.pack = true;
        this.episode = eps;
    }

    public String getPath() {
        if (this.isPackage()) {
            return this.file.getPath();
        }
        return this.resDir.getRelativePath();
    }

    public long getChecksum() {
        if (this.isPackage()) {
            return this.file.getChecksum();
        }
        long sum = 0L;
        EpisodeInfo[] episodeInfoArray = this.episode;
        int n = this.episode.length;
        int n2 = 0;
        while (n2 < n) {
            EpisodeInfo i = episodeInfoArray[n2];
            if (i != null) {
                LevelInfo[] levelInfoArray = i.gMapInfo;
                int n3 = i.gMapInfo.length;
                int n4 = 0;
                while (n4 < n3) {
                    LevelInfo l = levelInfoArray[n4];
                    if (l != null) {
                        sum ^= this.resDir.checkFile(l.LevelName).getChecksum();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return sum;
    }

    public FileEntry getFile() {
        return this.file;
    }

    public boolean isPackage() {
        return this.pack;
    }

    public GameInfo setPackage(boolean pack) {
        this.pack = pack;
        return this;
    }

    public void setDirectory(DirectoryEntry resDir) {
        this.resDir = resDir;
    }

    public DirectoryEntry getDirectory() {
        return this.resDir;
    }

    public LevelInfo getLevel(int num) {
        if (num < 1) {
            return null;
        }
        if (num < 5) {
            return this.episode[0] != null ? this.episode[0].gMapInfo[num - 1] : null;
        }
        return this.episode[1] != null ? this.episode[1].gMapInfo[num - 5] : null;
    }

    public int getNumEpisode(int level) {
        if (level < 5) {
            return 0;
        }
        return 1;
    }

    public int getNumLevel(int level) {
        if (level < 5) {
            return level - 1;
        }
        return level - 5;
    }

    public String getMapTitle(int num) {
        LevelInfo info = this.getLevel(num);
        if (info != null) {
            return info.Description;
        }
        return null;
    }

    public String getMapPath(int num) {
        LevelInfo info = this.getLevel(num);
        if (info != null) {
            return info.LevelName;
        }
        return null;
    }
}

