/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.PrecacheAdapter;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Spellbooks;
import ru.m210projects.Witchaven.Weapons;

public class PrecacheScreen
extends PrecacheAdapter {
    public PrecacheScreen(BuildGame game) {
        super(game);
        this.addQueue("Preload floor and ceiling tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numsectors) {
                    PrecacheScreen.this.addTile(Engine.sector[i].floorpicnum);
                    PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload wall tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numwalls) {
                    PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                    if (Engine.wall[i].overpicnum >= 0) {
                        PrecacheScreen.this.addTile(Engine.wall[i].overpicnum);
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload sprite tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.MAXSPRITES) {
                    if (Engine.sprite[i].statnum < 1024) {
                        PrecacheScreen.this.cachespritenum(i);
                    }
                    ++i;
                }
                PrecacheScreen.this.addTile(330);
                PrecacheScreen.this.addTile(952);
                PrecacheScreen.this.addTile(1001);
                PrecacheScreen.this.addTile(762);
                PrecacheScreen.this.addTile(891);
                PrecacheScreen.this.addTile(797);
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload hud tiles...", new Runnable(){

            @Override
            public void run() {
                int i = Names.KNIFEREADY;
                while (i <= Names.BIGAXEDRAW10) {
                    PrecacheScreen.this.addTile(i);
                    ++i;
                }
                i = Names.THEFONT;
                while (i < Names.CRYSTALSTAFF) {
                    PrecacheScreen.this.addTile(i);
                    ++i;
                }
                PrecacheScreen.this.addTile(Names.SSTATUSBAR);
                i = 0;
                while (i < 8) {
                    PrecacheScreen.this.addTile(Spellbooks.sspellbookanim[i][0].daweaponframe);
                    ++i;
                }
                PrecacheScreen.this.addTile(650);
                PrecacheScreen.this.addTile(Names.HELMET);
                PrecacheScreen.this.addTile(Names.SSCOREBACKPIC);
                PrecacheScreen.this.addTile(Names.SHEALTHBACK);
                i = 0;
                while (i < 4) {
                    PrecacheScreen.this.addTile(Names.SKEYBLANK + i);
                    PrecacheScreen.this.addTile(Names.SCARY + i);
                    ++i;
                }
                PrecacheScreen.this.addTile(Names.SPOTIONBACKPIC);
                i = 0;
                while (i < 5) {
                    PrecacheScreen.this.addTile(Names.SPOTIONARROW + i);
                    PrecacheScreen.this.addTile(Names.SFLASKBLUE + i);
                    ++i;
                }
                PrecacheScreen.this.addTile(Names.SFLASKBLACK);
                i = 0;
                while (i < 5) {
                    PrecacheScreen.this.addTile(Weapons.spikeanimtics[i].daweaponframe);
                    ++i;
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
    }

    @Override
    protected void draw(String title, int index) {
        this.engine.clearview(77);
        this.engine.rotatesprite(0xA00000, 0x640000, 65536, 0, 500, -128, 0, 74, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        this.game.getFont(1).drawText(160, 100, Strhandler.toCharArray("Loading"), 0, 0, BuildFont.TextAlign.Center, 2, true);
        this.game.getFont(1).drawText(160, 114, Strhandler.toCharArray("please wait..."), 0, 0, BuildFont.TextAlign.Center, 2, true);
        this.game.getFont(1).drawText(160, 130, title, 0, 0, BuildFont.TextAlign.Center, 2, true);
    }

    private void cachespritenum(int i) {
        int maxc = 1;
        if (Engine.sprite[i].picnum == Names.RAT || Engine.sprite[i].picnum == Names.GUARDIAN) {
            maxc = 15;
        }
        if (Engine.sprite[i].picnum == Names.HANGMAN) {
            maxc = 40;
        }
        if (Engine.sprite[i].picnum == Names.GRONHAL || Engine.sprite[i].picnum == Names.GRONMU || Engine.sprite[i].picnum == Names.GRONSW) {
            maxc = 19;
        }
        switch (Engine.sprite[i].picnum) {
            case 917: 
            case 922: {
                maxc = 21;
                break;
            }
            case 737: {
                maxc = 24;
                break;
            }
            case 772: 
            case 777: {
                maxc = 25;
                break;
            }
            case 1201: {
                maxc = 11;
                break;
            }
            case 1070: {
                maxc = 39;
                break;
            }
            case 981: {
                maxc = 35;
                break;
            }
            case 821: {
                maxc = 19;
                break;
            }
            case 1028: {
                maxc = 20;
                break;
            }
            case 1118: 
            case 1123: {
                maxc = 18;
            }
        }
        int j = Engine.sprite[i].picnum;
        while (j < Engine.sprite[i].picnum + maxc) {
            this.addTile(j);
            ++j;
        }
    }
}

