/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Blood.Factory.BLSliderDrawable;
import ru.m210projects.Blood.Factory.BloodEngine;
import ru.m210projects.Blood.Factory.BloodInput;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Factory.BloodOSDFunc;
import ru.m210projects.Blood.Factory.BloodPolymost;
import ru.m210projects.Blood.Factory.BloodSoftware;
import ru.m210projects.Blood.Fonts.BloodFont;
import ru.m210projects.Blood.Fonts.QFNFont;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.BloodDef;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.OSDFunc;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;

public class BloodFactory
extends BuildFactory {
    private Main app;

    public BloodFactory(Main app) {
        super("BLOOD.RFF", "SOUNDS.RFF");
        this.app = app;
    }

    @Override
    public void drawInitScreen() {
        this.app.pEngine.rotatesprite(0, 0, 65536, 0, 2046, -128, 0, 26, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public BuildEngine engine() throws Exception {
        Engine.TRANSLUSCENT1 = 0.33f;
        Engine.TRANSLUSCENT2 = 0.66f;
        Engine.MAXWALLS = 9600;
        VERSION.versionInit();
        Main.engine = new BloodEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new BloodSoftware(this.app.pEngine);
        }
        return new BloodPolymost(this.app.pEngine);
    }

    @Override
    public DefScript getBaseDef(BuildEngine engine) {
        return new BloodDef(engine, false);
    }

    @Override
    public BuildControls input(BuildControllers gpmanager) {
        return new BloodInput(this.app.pCfg, gpmanager);
    }

    @Override
    public OSDFunc console() {
        return new BloodOSDFunc(this.app.pEngine);
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new BloodMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(5){

            @Override
            protected BuildFont init(int i) {
                if (i == 0) {
                    return VERSION.hasQFN ? new QFNFont(((BloodFactory)BloodFactory.this).app.pEngine, 4096, 0) : new BloodFont(((BloodFactory)BloodFactory.this).app.pEngine, 4096, 0);
                }
                if (i == 1) {
                    return VERSION.hasQFN ? new QFNFont(((BloodFactory)BloodFactory.this).app.pEngine, 4192, 1) : new BloodFont(((BloodFactory)BloodFactory.this).app.pEngine, 4192, 1);
                }
                if (i == 2) {
                    return VERSION.hasQFN ? new QFNFont(((BloodFactory)BloodFactory.this).app.pEngine, 4288, 2) : new BloodFont(((BloodFactory)BloodFactory.this).app.pEngine, 4288, 1);
                }
                if (i == 3) {
                    return VERSION.hasQFN ? new QFNFont(((BloodFactory)BloodFactory.this).app.pEngine, 4384, 3) : new BloodFont(((BloodFactory)BloodFactory.this).app.pEngine, 4384, 1);
                }
                if (i == 4) {
                    return VERSION.hasQFN ? new QFNFont(((BloodFactory)BloodFactory.this).app.pEngine, 4480, 4) : new BloodFont(((BloodFactory)BloodFactory.this).app.pEngine, 4480, 1);
                }
                return null;
            }
        };
    }

    @Override
    public BuildNet net() {
        return new BloodNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new BLSliderDrawable();
    }
}

