/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.GIBFX;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.THINKFX;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class Gib {
    THINKFX[] kThinkFX;
    int nThinkFX;
    GIBFX[] kGibFX;
    int nGibFx;
    int nSoundId;
    public static final THINKFX[] kThinkFXHuman = new THINKFX[]{new THINKFX(425, 1454, 917504, 300, 900), new THINKFX(425, 1454, 917504, 300, 900), new THINKFX(425, 1267, 917504, 300, 900), new THINKFX(425, 1267, 917504, 300, 900), new THINKFX(425, 1268, 917504, 300, 900), new THINKFX(425, 1269, 917504, 300, 900), new THINKFX(425, 1456, 917504, 300, 900)};
    public static final THINKFX[] kThinkFXMime = new THINKFX[]{new THINKFX(425, 2405, 917504, 300, 900), new THINKFX(425, 2405, 917504, 300, 900), new THINKFX(425, 2404, 917504, 300, 900), new THINKFX(425, 1268, 32768, 300, 900), new THINKFX(425, 1269, 32768, 300, 900), new THINKFX(425, 1456, 32768, 300, 900)};
    public static final THINKFX[] kThinkFXHound = new THINKFX[]{new THINKFX(425, 1326, 917504, 300, 900), new THINKFX(425, 1268, 32768, 300, 900), new THINKFX(425, 1269, 32768, 300, 900), new THINKFX(425, 1456, 32768, 300, 900)};
    public static final THINKFX[] kThinkFXGargoyle = new THINKFX[]{new THINKFX(425, 1369, 917504, 300, 900), new THINKFX(425, 1361, 917504, 300, 900), new THINKFX(425, 1268, 32768, 300, 900), new THINKFX(425, 1269, 32768, 300, 900), new THINKFX(425, 1456, 32768, 300, 900)};
    public static final THINKFX[] kThinkFXZombie = new THINKFX[]{new THINKFX(427, 3405, 917504, 0, 0)};
    public static final GIBFX[] kGibFXGlassT = new GIBFX[]{new GIBFX(18, 0, 65536, 3, 200, 400), new GIBFX(31, 0, 32768, 5, 200, 400)};
    public static final GIBFX[] kGibFXGlassS = new GIBFX[]{new GIBFX(18, 0, 65536, 8, 200, 400)};
    public static final GIBFX[] kGibFXBurnShard = new GIBFX[]{new GIBFX(16, 0, 65536, 12, 500, 1000)};
    public static final GIBFX[] kGibFXWoodShard = new GIBFX[]{new GIBFX(17, 0, 65536, 12, 500, 1000)};
    public static final GIBFX[] kGibFXMetalShard = new GIBFX[]{new GIBFX(30, 0, 65536, 12, 500, 1000)};
    public static final GIBFX[] kGibFXFireSpark = new GIBFX[]{new GIBFX(14, 0, 65536, 8, 500, 1000)};
    public static final GIBFX[] kGibFXShockSpark = new GIBFX[]{new GIBFX(15, 0, 65536, 8, 500, 1000)};
    public static final GIBFX[] kGibFXBloodChunks = new GIBFX[]{new GIBFX(13, 0, 65536, 8, 90, 600)};
    public static final GIBFX[] kGibFXFlames2 = new GIBFX[]{new GIBFX(56, 0, 65536, 8, 100, 0)};
    public static final GIBFX[] kGibFXFlames1 = new GIBFX[]{new GIBFX(32, 0, 65536, 8, 100, 0)};
    public static final GIBFX[] kGibFXBubblesS = new GIBFX[]{new GIBFX(25, 0, 65536, 8, 200, 400)};
    public static final GIBFX[] kGibFXBubblesM = new GIBFX[]{new GIBFX(24, 0, 65536, 8, 200, 400)};
    public static final GIBFX[] kGibFXBubblesL = new GIBFX[]{new GIBFX(23, 0, 65536, 8, 200, 400)};
    public static final GIBFX[] kGibFXIcicles = new GIBFX[]{new GIBFX(31, 0, 65536, 15, 200, 400)};
    public static final GIBFX[] kGibFXGlassCombo1 = new GIBFX[]{new GIBFX(18, 0, 65536, 15, 200, 400), new GIBFX(31, 0, 65536, 10, 200, 400)};
    public static final GIBFX[] kGibFXGlassCombo2 = new GIBFX[]{new GIBFX(18, 0, 65536, 5, 200, 400), new GIBFX(20, 0, 53248, 5, 200, 400), new GIBFX(21, 0, 53248, 5, 200, 400), new GIBFX(19, 0, 53248, 5, 200, 400), new GIBFX(22, 0, 53248, 5, 200, 400)};
    public static final GIBFX[] kGibFXWoodCombo = new GIBFX[]{new GIBFX(16, 0, 65536, 8, 500, 1000), new GIBFX(17, 0, 65536, 8, 500, 1000), new GIBFX(14, 0, 65536, 8, 500, 1000)};
    public static final GIBFX[] kGibFXMedicCombo = new GIBFX[]{new GIBFX(18, 0, 32768, 7, 200, 400), new GIBFX(30, 0, 65536, 7, 500, 1000), new GIBFX(13, 0, 65536, 10, 90, 600), new GIBFX(14, 0, 32768, 7, 500, 1000)};
    public static final GIBFX[] kGibFXFlareSpark = new GIBFX[]{new GIBFX(28, 0, 32768, 15, 128, -128)};
    public static final GIBFX[] kGibFXBloodBits = new GIBFX[]{new GIBFX(13, 0, 45056, 8, 90, 600)};
    public static final GIBFX[] kGibFXRockShards = new GIBFX[]{new GIBFX(46, 0, 65536, 10, 300, 800), new GIBFX(31, 0, 32768, 10, 200, 1000)};
    public static final GIBFX[] kGibFXPaperCombo1 = new GIBFX[]{new GIBFX(47, 0, 65536, 12, 300, 600), new GIBFX(14, 0, 65536, 8, 500, 1000)};
    public static final GIBFX[] kGibFXPlantCombo1 = new GIBFX[]{new GIBFX(44, 0, 45056, 8, 400, 800), new GIBFX(45, 0, 45056, 8, 300, 800), new GIBFX(14, 0, 45056, 6, 500, 1000)};
    public static final GIBFX[] kGibFXShockGibs1 = new GIBFX[]{new GIBFX(49, 0, 65536, 4, 80, 300)};
    public static final GIBFX[] kGibFXShockGibs2 = new GIBFX[]{new GIBFX(50, 0, 65536, 4, 80, 0)};
    public static final GIBFX[] kGibFXShockGibs3 = new GIBFX[]{new GIBFX(50, 0, 65536, 20, 800, -40), new GIBFX(15, 0, 65536, 15, 400, 10)};
    public static final int kGibMax = 31;
    public static final Gib[] gGIBInfo = new Gib[]{new Gib(kGibFXGlassT, 2, null, 0, 300), new Gib(kGibFXGlassS, 1, null, 0, 300), new Gib(kGibFXBurnShard, 1, null, 0, 0), new Gib(kGibFXWoodShard, 1, null, 0, 0), new Gib(kGibFXMetalShard, 1, null, 0, 0), new Gib(kGibFXFireSpark, 1, null, 0, 0), new Gib(kGibFXShockSpark, 1, null, 0, 0), new Gib(kGibFXBloodChunks, 1, null, 0, 0), new Gib(kGibFXBubblesS, 1, null, 0, 0), new Gib(kGibFXBubblesM, 1, null, 0, 0), new Gib(kGibFXBubblesL, 1, null, 0, 0), new Gib(kGibFXIcicles, 1, null, 0, 0), new Gib(kGibFXGlassCombo1, 2, null, 0, 300), new Gib(kGibFXGlassCombo2, 5, null, 0, 300), new Gib(kGibFXWoodCombo, 3, null, 0, 0), new Gib(null, 0, kThinkFXHuman, 7, 0), new Gib(kGibFXMedicCombo, 4, null, 0, 0), new Gib(kGibFXFlareSpark, 1, null, 0, 0), new Gib(kGibFXBloodBits, 1, null, 0, 0), new Gib(kGibFXRockShards, 2, null, 0, 0), new Gib(kGibFXPaperCombo1, 2, null, 0, 0), new Gib(kGibFXPlantCombo1, 3, null, 0, 0), new Gib(kGibFXShockGibs1, 1, null, 0, 0), new Gib(kGibFXShockGibs2, 1, null, 0, 0), new Gib(kGibFXShockGibs3, 2, null, 0, 0), new Gib(kGibFXFlames1, 1, null, 0, 0), new Gib(kGibFXFlames2, 1, null, 0, 0), new Gib(null, 0, kThinkFXZombie, 1, 0), new Gib(null, 0, kThinkFXMime, 6, 0), new Gib(null, 0, kThinkFXHound, 4, 0), new Gib(null, 0, kThinkFXGargoyle, 5, 0)};
    public static Vector3 startVel = new Vector3();
    public static Vector3 startPos = new Vector3();

    public Gib(GIBFX[] kGibFX, int nGibFx, THINKFX[] kThinkFX, int nThinkFX, int nSoundId) {
        this.kThinkFX = kThinkFX;
        this.nThinkFX = nThinkFX;
        this.kGibFX = kGibFX;
        this.nGibFx = nGibFx;
        this.nSoundId = nSoundId;
    }

    public static void actGenerateGibs(SPRITE pSprite, int nGibType, Vector3 startPos, Vector3 startVel) {
        if (pSprite == null) {
            Main.game.dassert("pSprite != null");
        }
        if (nGibType < 0 || nGibType >= 31) {
            Main.game.dassert("nGibType >= 0 && nGibType < kGibMax");
        }
        if (pSprite.sectnum >= 0 && pSprite.sectnum < Engine.numsectors) {
            Gib pGib = gGIBInfo[nGibType];
            int nGib = 0;
            while (nGib < pGib.nGibFx) {
                GIBFX pGibFX = pGib.kGibFX[nGib];
                if (pGibFX.Chance <= 0) {
                    Main.game.dassert("pGibFX.Chance > 0");
                }
                Gib.actGenerateGibFX(pSprite, pGibFX, startPos, startVel);
                ++nGib;
            }
            int nThink = 0;
            while (nThink < pGib.nThinkFX) {
                THINKFX pGibThing = pGib.kThinkFX[nThink];
                if (pGibThing.Chance <= 0) {
                    Main.game.dassert("pGibThing.Chance > 0");
                }
                Gib.actGenerateThinkFX(pSprite, pGibThing, startPos, startVel);
                ++nThink;
            }
        }
    }

    public static void actGenerateGibFX(SPRITE pSprite, GIBFX pGibFX, Vector3 startPos, Vector3 startVel) {
        if (!Main.cfg.gParentalLock || Globals.pGameInfo.nGameType > 0 || pGibFX.nType != 13) {
            int x = pSprite.x;
            int y = pSprite.y;
            int z = pSprite.z;
            if (startPos != null) {
                x = (int)startPos.x;
                y = (int)startPos.y;
                z = (int)startPos.z;
            }
            Main.engine.getzsofslope(pSprite.sectnum, x, y, Globals.zofslope);
            int quantity = Gib.gibCalcQuantity(pGibFX.Chance, pGibFX.Quantity);
            int fz = Globals.zofslope[1] - z;
            int cz = z - Globals.zofslope[0];
            Gameutils.GetSpriteExtents(pSprite);
            int i = 0;
            while (i < quantity) {
                SPRITE pSpawn;
                if (startPos == null && (pSprite.cstat & 0x30) == 0) {
                    int nAngle = Gameutils.Random(2048);
                    x = pSprite.x + Pragmas.mulscale(Trig.Cos(nAngle), pSprite.clipdist << 2, 30);
                    y = pSprite.y + Pragmas.mulscale(Trig.Sin(nAngle), pSprite.clipdist << 2, 30);
                    z = Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop);
                }
                if ((pSpawn = Actor.actSpawnEffect(pGibFX.nType, pSprite.sectnum, x, y, z, 0)) != null) {
                    if (pSpawn.pal < 0) {
                        pSpawn.pal = pSprite.pal;
                    }
                    if (startVel != null) {
                        Actor.sprXVel[pSpawn.xvel] = Gameutils.BiRandom(pGibFX.Velocity) + (int)startVel.x / 2;
                        Actor.sprYVel[pSpawn.xvel] = Gameutils.BiRandom(pGibFX.Velocity) + (int)startVel.y / 2;
                        Actor.sprZVel[pSpawn.xvel] = (int)startVel.z - Gameutils.Random(pGibFX.zVelocity);
                    } else {
                        int vel = Pragmas.divscale(pGibFX.Velocity, 120L, 18);
                        int zvel = Pragmas.divscale(pGibFX.zVelocity, 120L, 18);
                        Actor.sprXVel[pSpawn.xvel] = Gameutils.BiRandom(vel);
                        Actor.sprYVel[pSpawn.xvel] = Gameutils.BiRandom(vel);
                        if ((pSprite.cstat & 0x30) == 16) {
                            Actor.sprZVel[pSpawn.xvel] = Gameutils.BiRandom(zvel);
                        } else if (fz <= cz || cz >= 16384) {
                            if (fz >= cz || fz >= 16384) {
                                if (zvel >= 0) {
                                    Actor.sprZVel[pSpawn.xvel] = Gameutils.BiRandom(zvel);
                                } else {
                                    zvel = Pragmas.divscale(Pragmas.klabs(pGibFX.zVelocity), 120L, 18);
                                    Actor.sprZVel[pSpawn.xvel] = -Gameutils.Random(zvel);
                                }
                            } else {
                                zvel = Pragmas.divscale(Pragmas.klabs(pGibFX.zVelocity), 120L, 18);
                                Actor.sprZVel[pSpawn.xvel] = -Gameutils.Random(zvel);
                            }
                        } else {
                            Actor.sprZVel[pSpawn.xvel] = 0L;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static void actGenerateThinkFX(SPRITE pSprite, THINKFX pGibThing, Vector3 startPos, Vector3 startVel) {
        if ((!Main.cfg.gParentalLock || Globals.pGameInfo.nGameType > 0 || pGibThing.nType < 425 || pGibThing.nType > 425 && pGibThing.nType != 427) && (pGibThing.Chance == 65536 || Gameutils.Chance(pGibThing.Chance >> 1))) {
            int z;
            int y;
            int x;
            Gameutils.GetSpriteExtents(pSprite);
            if (startPos != null) {
                x = (int)startPos.x;
                y = (int)startPos.y;
                z = (int)startPos.z;
            } else {
                int nAngle = Gameutils.Random(2048);
                x = pSprite.x + Pragmas.mulscale(Trig.Cos(nAngle), pSprite.clipdist << 2, 30);
                y = pSprite.y + Pragmas.mulscale(Trig.Sin(nAngle), pSprite.clipdist << 2, 30);
                z = Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop);
            }
            Main.engine.getzsofslope(pSprite.sectnum, x, y, Globals.zofslope);
            int fz = Globals.zofslope[1] - z;
            int cz = z - Globals.zofslope[0];
            SPRITE pSpawn = Actor.actSpawnThing(pSprite.sectnum, x, y, z, pGibThing.nType);
            if (pSpawn == null) {
                Main.game.dassert("pSpawn != null");
            }
            if (pGibThing.nTile > -1) {
                pSpawn.picnum = (short)pGibThing.nTile;
            }
            if (startVel != null) {
                Actor.sprXVel[pSpawn.xvel] = Gameutils.BiRandom(pGibThing.Velocity) + (int)startVel.x;
                Actor.sprYVel[pSpawn.xvel] = Gameutils.BiRandom(pGibThing.Velocity) + (int)startVel.y;
                Actor.sprZVel[pSpawn.xvel] = (int)startVel.z - Gameutils.Random(pGibThing.zVelocity);
            } else {
                int vel = Pragmas.divscale(pGibThing.Velocity, 120L, 18);
                int zvel = Pragmas.divscale(pGibThing.zVelocity, 120L, 18);
                Actor.sprXVel[pSpawn.xvel] = Gameutils.BiRandom(vel);
                Actor.sprYVel[pSpawn.xvel] = Gameutils.BiRandom(vel);
                Actor.sprZVel[pSpawn.xvel] = (pSprite.cstat & 0x30) == 16 ? (long)Gameutils.BiRandom(Pragmas.divscale(pGibThing.zVelocity, 120L, 18)) : (fz <= cz || cz >= 16384 ? (fz >= cz || fz >= 16384 ? (long)Gameutils.BiRandom(zvel) : (long)(-Gameutils.Random(zvel))) : 0L);
            }
        }
    }

    public static int gibCalcQuantity(int Chance, int Quantity) {
        int out = Quantity;
        if (Chance < 65536) {
            int i = 0;
            while (i < Quantity) {
                if (!Gameutils.Chance(Chance / 2)) {
                    --out;
                }
                ++i;
            }
        }
        return out;
    }

    public static void walGenerateGib(int nWall, int nGibType, Vector3 startVel) {
        if (nWall < 0 || nWall >= Engine.numwalls) {
            Main.game.dassert("nWall >= 0 && nWall < numwalls");
        }
        if (nGibType < 0 || nGibType >= 31) {
            Main.game.dassert("nGibType >= 0 && nGibType < kGibMax");
        }
        WALL pWall = Engine.wall[nWall];
        int cx = (Engine.wall[pWall.point2].x + pWall.x) / 2;
        int cy = (Engine.wall[pWall.point2].y + pWall.y) / 2;
        short nSector = Main.engine.sectorofwall((short)nWall);
        Main.engine.getzsofslope(nSector, cx, cy, Globals.zofslope);
        int floorz = Globals.zofslope[1];
        int ceilz = Globals.zofslope[0];
        if (pWall.nextsector != -1) {
            Main.engine.getzsofslope(pWall.nextsector, cx, cy, Globals.zofslope);
        }
        int nextfloorz = Globals.zofslope[1];
        int nextceilz = Globals.zofslope[0];
        int cz = ceilz;
        if (ceilz < nextceilz) {
            cz = nextceilz;
        }
        int fz = floorz;
        if (floorz >= nextfloorz) {
            fz = nextfloorz;
        }
        int dx = Engine.wall[pWall.point2].x - pWall.x;
        int dy = Engine.wall[pWall.point2].y - pWall.y;
        int dz = fz - cz;
        Gib pGib = gGIBInfo[nGibType];
        SOUND.sfxCreate3DSound(cx, cy, fz + cz >> 1, pGib.nSoundId, nSector);
        int nGib = 0;
        while (nGib < pGib.nGibFx) {
            GIBFX pGibFX = pGib.kGibFX[nGib];
            if (pGibFX.Chance <= 0) {
                Main.game.dassert("pGibFX.Chance > 0");
            }
            Gib.walGenerateGibFX(nWall, pGibFX, cz, dx, dy, dz, startVel);
            ++nGib;
        }
    }

    public static void walGenerateGibFX(int nWall, GIBFX pGibFX, int cz, int dx, int dy, int dz, Vector3 startVel) {
        if (nWall < 0 || nWall >= Engine.numwalls) {
            Main.game.dassert("nWall >= 0 && nWall < numwalls");
        }
        WALL pWall = Engine.wall[nWall];
        short nSector = Main.engine.sectorofwall((short)nWall);
        int quantity = Gib.gibCalcQuantity(pGibFX.Chance, pGibFX.Quantity);
        int i = 0;
        while (i < quantity) {
            int wallz = cz + Gameutils.Random(dz);
            int wally = pWall.y + Gameutils.Random(dy);
            int wallx = pWall.x + Gameutils.Random(dx);
            SPRITE pSpawn = Actor.actSpawnEffect(pGibFX.nType, nSector, wallx, wally, wallz, 0);
            if (pSpawn != null) {
                if (pSpawn.pal < 0) {
                    pSpawn.pal = (byte)pWall.pal;
                }
                if (startVel != null) {
                    Actor.sprXVel[pSpawn.xvel] = Gameutils.BiRandom(Pragmas.divscale((int)startVel.x, 120L, 18));
                    Actor.sprYVel[pSpawn.xvel] = Gameutils.BiRandom(Pragmas.divscale((int)startVel.y, 120L, 18));
                    Actor.sprZVel[pSpawn.xvel] = -Gameutils.Random(Pragmas.divscale((int)startVel.z, 120L, 18));
                } else {
                    Actor.sprXVel[pSpawn.xvel] = Gameutils.BiRandom(Pragmas.divscale(pGibFX.Velocity, 120L, 18));
                    Actor.sprYVel[pSpawn.xvel] = Gameutils.BiRandom(Pragmas.divscale(pGibFX.Velocity, 120L, 18));
                    Actor.sprZVel[pSpawn.xvel] = -Gameutils.Random(Pragmas.divscale(pGibFX.zVelocity, 120L, 18));
                }
            }
            ++i;
        }
    }
}

