/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import java.util.HashMap;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Types.Seq.SeqFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;

public class SeqType {
    private static HashMap<Integer, SeqType> pSEQs = new HashMap();
    private final int kSeqLoop = 1;
    private final int kSeqRemove = 2;
    private final int kSEQSig = 441533779;
    protected int nFrames;
    protected int ticksPerFrame;
    protected int soundId;
    protected byte flags;
    protected SeqFrame[] frame;

    public static SeqType getInstance(int nSeqId) {
        Resource data;
        SeqType pSequence = pSEQs.get(nSeqId);
        if (pSequence == null && (data = BuildGdx.cache.open(nSeqId, "SEQ")) != null) {
            pSequence = new SeqType(data);
            pSEQs.put(nSeqId, pSequence);
            data.close();
        }
        return pSequence;
    }

    public static void flushCache() {
        pSEQs.clear();
    }

    public SeqType(Resource bb) {
        short version;
        int signature = bb.readInt();
        if (signature != 441533779) {
            System.err.println("Invalid sequence");
        }
        if (((version = bb.readShort().shortValue()) & 0xFF00) != 768) {
            System.err.println("Obsolete sequence version");
        }
        this.nFrames = bb.readShort().shortValue();
        this.ticksPerFrame = bb.readShort().shortValue();
        this.soundId = bb.readShort().shortValue();
        this.flags = bb.readByte();
        bb.seek(3L, Resource.Whence.Current);
        this.frame = new SeqFrame[this.nFrames];
        int i = 0;
        while (i < this.nFrames) {
            this.frame[i] = new SeqFrame(bb);
            ++i;
        }
    }

    public int getFrames() {
        return this.nFrames;
    }

    public SeqFrame getFrame(int num) {
        if (num < 0 || num >= this.nFrames) {
            return null;
        }
        return this.frame[num];
    }

    public int getTicks() {
        return this.ticksPerFrame;
    }

    public int getSound() {
        return this.soundId;
    }

    public boolean isLooping() {
        return (this.flags & 1) != 0;
    }

    public boolean isRemovable() {
        return (this.flags & 2) != 0;
    }

    public void Preload() {
        if (this.nFrames > 0) {
            int i = 0;
            while (i < this.nFrames) {
                Tile.tilePreloadTile(this.frame[i].nTile);
                ++i;
            }
        }
    }
}

