/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Gameutils;

public class BufferResource
extends ByteArrayOutputStream {
    private static byte[] tmpbuf = new byte[1024];

    public int writeBytes(Object array) {
        int len = 0;
        if (array instanceof byte[]) {
            len = ((byte[])array).length;
        } else if (array instanceof ByteBuffer) {
            len = ((ByteBuffer)array).capacity();
        } else if (array instanceof short[]) {
            len = ((short[])array).length;
        } else if (array instanceof int[]) {
            len = ((int[])array).length;
        } else if (array instanceof char[]) {
            len = ((char[])array).length;
        } else if (array instanceof String) {
            len = ((String)array).getBytes().length;
        } else {
            throw new UnsupportedOperationException("Couldn't write. \r\n + Not implemented!");
        }
        if (len != 0) {
            return this.writeBytes(array, len);
        }
        return -1;
    }

    public int writeBytes(Object obj, int len) {
        int var = -1;
        try {
            byte[] data = null;
            if (obj instanceof Byte) {
                int rem = len;
                while (rem > 0) {
                    int l = Math.min(rem, tmpbuf.length);
                    Gameutils.fill(tmpbuf, 0, l, ((Byte)obj).byteValue());
                    this.write(tmpbuf, 0, l);
                    rem -= l;
                }
                return len;
            }
            if (obj instanceof byte[]) {
                data = (byte[])obj;
            } else if (obj instanceof char[]) {
                data = new byte[len];
                char[] src = (char[])obj;
                int i = 0;
                while (i < Math.min(len, src.length)) {
                    data[i] = (byte)src[i];
                    ++i;
                }
            } else if (obj instanceof ByteBuffer) {
                ByteBuffer buf = (ByteBuffer)obj;
                buf.rewind();
                if (!buf.isDirect()) {
                    data = buf.array();
                } else {
                    data = new byte[Math.min(len, buf.capacity())];
                    buf.get(data);
                }
            } else if (obj instanceof short[]) {
                var = 0;
                short[] shortArr = (short[])obj;
                len = Math.min(len, shortArr.length);
                int i = 0;
                while (i < len) {
                    var += this.writeShort(shortArr[i]);
                    ++i;
                }
            } else if (obj instanceof int[]) {
                var = 0;
                int[] intArr = (int[])obj;
                len = Math.min(len, intArr.length);
                int i = 0;
                while (i < len) {
                    var += this.writeInt(intArr[i]);
                    ++i;
                }
            } else if (obj instanceof String) {
                data = ((String)obj).getBytes();
            } else {
                throw new UnsupportedOperationException("Couldn't write to file. \r\n + Not implemented!");
            }
            if (data != null) {
                len = Math.min(len, data.length);
                this.write(data, 0, len);
                var = len;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't write to file \r\n" + e.getMessage());
        }
        return var;
    }

    public int writeBoolean(boolean value) {
        return this.writeByte(value ? 1 : 0);
    }

    public int writeByte(int value) {
        BufferResource.tmpbuf[0] = (byte)value;
        this.write(tmpbuf, 0, 1);
        return 1;
    }

    public int writeShort(int value) {
        BufferResource.tmpbuf[0] = (byte)(value >>> 0 & 0xFF);
        BufferResource.tmpbuf[1] = (byte)(value >>> 8 & 0xFF);
        this.write(tmpbuf, 0, 2);
        return 2;
    }

    public int writeInt(int value) {
        BufferResource.tmpbuf[0] = (byte)(value >>> 0 & 0xFF);
        BufferResource.tmpbuf[1] = (byte)(value >>> 8 & 0xFF);
        BufferResource.tmpbuf[2] = (byte)(value >>> 16 & 0xFF);
        BufferResource.tmpbuf[3] = (byte)(value >>> 24 & 0xFF);
        this.write(tmpbuf, 0, 4);
        return 4;
    }

    public int writeLong(long value) {
        BufferResource.tmpbuf[0] = (byte)(value >>> 0 & 0xFFL);
        BufferResource.tmpbuf[1] = (byte)(value >>> 8 & 0xFFL);
        BufferResource.tmpbuf[2] = (byte)(value >>> 16 & 0xFFL);
        BufferResource.tmpbuf[3] = (byte)(value >>> 24 & 0xFFL);
        BufferResource.tmpbuf[4] = (byte)(value >>> 32 & 0xFFL);
        BufferResource.tmpbuf[5] = (byte)(value >>> 40 & 0xFFL);
        BufferResource.tmpbuf[6] = (byte)(value >>> 48 & 0xFFL);
        BufferResource.tmpbuf[7] = (byte)(value >>> 56 & 0xFFL);
        this.write(tmpbuf, 0, 8);
        return 8;
    }

    @Override
    public int size() {
        return this.count;
    }

    public byte[] getBytes() {
        return this.buf;
    }
}

