/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.StringUtils;

public class ZipGroup
extends Group {
    private static byte[] readbuf = new byte[1024];
    private ZipFile zfile;

    public ZipGroup(String path) throws IOException {
        if (path != null && !path.isEmpty()) {
            this.zfile = new ZipFile(path);
            ArrayList<? extends ZipEntry> zfilelist = new ArrayList<ZipEntry>(Collections.list(this.zfile.entries()));
            this.numfiles = zfilelist.size();
            if (this.numfiles != 0) {
                int i = 0;
                while (i < this.numfiles) {
                    ZipEntry entry = zfilelist.get(i);
                    ZipResource res = new ZipResource(entry);
                    if (res.size > 0) {
                        this.add(res);
                    }
                    ++i;
                }
            }
            this.numfiles = this.filelist.size();
            this.type = Cache1D.PackageType.Zip;
        }
    }

    public void removeFolders() {
        List<GroupResource> list = this.getList();
        this.filelist.clear();
        this.lookup.clear();
        for (GroupResource res : list) {
            int point;
            int index = res.filenamext.lastIndexOf(File.separator);
            if (index != -1) {
                res.filenamext = res.filenamext.substring(index + 1);
            }
            res.filename = (point = res.filenamext.lastIndexOf(46)) != -1 ? res.filenamext.substring(0, point) : res.filenamext;
            this.add(res);
        }
    }

    @Override
    protected boolean open(GroupResource res) {
        ZipResource zres = (ZipResource)res;
        return zres != null && zres.open() != null;
    }

    @Override
    public int position() {
        return 0;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.zfile.close();
            this.zfile = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ZipResource
    extends GroupResource {
        private ZipInputStream bis;
        private final ZipEntry entry;

        public ZipResource(ZipEntry entry) throws IOException {
            super(ZipGroup.this);
            this.handleName(entry.getName());
            String fileid = entry.getComment();
            if (fileid != null && !fileid.isEmpty() && !(fileid = fileid.replaceAll("[^0-9]", "")).isEmpty()) {
                this.fileid = Integer.parseInt(fileid);
            }
            this.entry = entry;
            this.size = (int)entry.getSize();
            if (ZipGroup.this.debug && this.size > 0) {
                System.out.println("\t" + this.filenamext + ", size: " + this.size);
            }
        }

        @Override
        protected void handleName(String fullname) {
            int point;
            this.filenamext = Strhandler.toLowerCase(StringUtils.toUnicode(fullname));
            if (this.filenamext.contains("/")) {
                this.filenamext = this.filenamext.replace("/", File.separator);
            }
            if ((point = this.filenamext.lastIndexOf(46)) != -1) {
                this.fileformat = this.filenamext.substring(point + 1);
                this.filename = this.filenamext.substring(0, point);
            } else {
                this.fileformat = "";
                this.filename = this.filenamext;
            }
        }

        public ZipResource open() {
            if (ZipGroup.this.zfile == null) {
                Console.Println("Group is closed!", Console.OSDTEXT_RED);
                return null;
            }
            try {
                if (this.bis == null) {
                    this.bis = new ZipInputStream(ZipGroup.this.zfile.getInputStream(this.entry));
                } else if (this.buffer == null) {
                    this.bis.reinit();
                }
                this.seek(0L, Resource.Whence.Set);
                return this;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void close() {
            this.seek(0L, Resource.Whence.Set);
            this.flush();
            try {
                this.bis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int seek(long offset, Resource.Whence whence) {
            Group group = this.parent;
            synchronized (group) {
                block10: {
                    if (this.buffer != null) {
                        switch (whence) {
                            case Set: {
                                this.buffer.position((int)offset);
                                break;
                            }
                            case Current: {
                                this.buffer.position(this.buffer.position() + (int)offset);
                                break;
                            }
                            case End: {
                                this.buffer.position(this.size + (int)offset);
                            }
                        }
                        return this.position();
                    }
                    if (ZipGroup.this.zfile != null) break block10;
                    return -1;
                }
                return this.bis.seek(offset, whence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offset, int len) {
            Group group = this.parent;
            synchronized (group) {
                block9: {
                    block8: {
                        block7: {
                            if (this.position() < this.size) break block7;
                            return -1;
                        }
                        len = Math.min(len, this.size - this.position());
                        if (this.buffer != null) {
                            this.buffer.get(buf, offset, len);
                            return len;
                        }
                        if (ZipGroup.this.zfile != null) break block8;
                        return -1;
                    }
                    len = this.bis.read(buf, offset, len);
                    if (len != -1) break block9;
                    return -1;
                }
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf) {
            Group group = this.parent;
            synchronized (group) {
                return this.read(buf, 0, buf.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer bb, int offset, int len) {
            Group group = this.parent;
            synchronized (group) {
                int var = -1;
                bb.position(offset);
                int p = 0;
                while (len > 0) {
                    var = this.read(readbuf, 0, Math.min(len, readbuf.length));
                    if (var == -1) {
                        return p;
                    }
                    bb.put(readbuf, 0, var);
                    len -= var;
                    p += var;
                }
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Byte readByte() {
            Group group = this.parent;
            synchronized (group) {
                block7: {
                    int len;
                    block6: {
                        len = 1;
                        if (len <= this.size - this.position()) break block6;
                        return null;
                    }
                    if (this.buffer != null) {
                        return this.buffer.get();
                    }
                    if (ZipGroup.this.zfile != null && this.bis.read(readbuf, 0, len) == len) break block7;
                    return null;
                }
                return readbuf[0];
            }
        }

        @Override
        public Boolean readBoolean() {
            Byte var = this.readByte();
            if (var != null) {
                if (var == 1) {
                    return true;
                }
                return false;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Short readShort() {
            Group group = this.parent;
            synchronized (group) {
                block7: {
                    int len;
                    block6: {
                        len = 2;
                        if (len <= this.remaining()) break block6;
                        return null;
                    }
                    if (this.buffer != null) {
                        return this.buffer.getShort();
                    }
                    if (ZipGroup.this.zfile != null && this.bis.read(readbuf, 0, len) == len) break block7;
                    return null;
                }
                return (short)(((readbuf[1] & 0xFF) << 8) + (readbuf[0] & 0xFF));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer readInt() {
            Group group = this.parent;
            synchronized (group) {
                block7: {
                    int len;
                    block6: {
                        len = 4;
                        if (len <= this.remaining()) break block6;
                        return null;
                    }
                    if (this.buffer != null) {
                        return this.buffer.getInt();
                    }
                    if (ZipGroup.this.zfile != null && this.bis.read(readbuf, 0, len) == len) break block7;
                    return null;
                }
                return ((readbuf[3] & 0xFF) << 24) + ((readbuf[2] & 0xFF) << 16) + ((readbuf[1] & 0xFF) << 8) + (readbuf[0] & 0xFF);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long readLong() {
            Group group = this.parent;
            synchronized (group) {
                block7: {
                    int len;
                    block6: {
                        len = 8;
                        if (len <= this.remaining()) break block6;
                        return null;
                    }
                    if (this.buffer != null) {
                        return this.buffer.getLong();
                    }
                    if (ZipGroup.this.zfile != null && this.bis.read(readbuf, 0, len) == len) break block7;
                    return null;
                }
                return (((long)readbuf[7] & 0xFFL) << 56) + (((long)readbuf[6] & 0xFFL) << 48) + (((long)readbuf[5] & 0xFFL) << 40) + (((long)readbuf[4] & 0xFFL) << 32) + (((long)readbuf[3] & 0xFFL) << 24) + (((long)readbuf[2] & 0xFFL) << 16) + (((long)readbuf[1] & 0xFFL) << 8) + ((long)readbuf[0] & 0xFFL);
            }
        }

        @Override
        public Float readFloat() {
            Integer i = this.readInt();
            if (i != null) {
                return Float.valueOf(Float.intBitsToFloat(i));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readString(int len) {
            Group group = this.parent;
            synchronized (group) {
                byte[] data;
                block4: {
                    data = new byte[len];
                    if (this.read(data) == len) break block4;
                    return null;
                }
                return new String(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int position() {
            Group group = this.parent;
            synchronized (group) {
                if (this.buffer != null) {
                    return this.buffer.position();
                }
                return this.bis.position();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toMemory() {
            Group group = this.parent;
            synchronized (group) {
                if (this.isClosed()) {
                    this.parent.open(this);
                }
                if (this.buffer == null) {
                    byte[] tmp = this.getBytes();
                    if (tmp == null) {
                        return;
                    }
                    this.buffer = ByteBuffer.allocateDirect(this.size);
                    this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.buffer.put(tmp);
                }
                this.buffer.rewind();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] getBytes() {
            Group group = this.parent;
            synchronized (group) {
                if (this.isClosed()) {
                    this.parent.open(this);
                }
                if (this.buffer != null) {
                    byte[] data = new byte[this.buffer.capacity()];
                    this.buffer.rewind();
                    this.buffer.get(data);
                    return data;
                }
                int size = this.size();
                if (size > 0 && ZipGroup.this.zfile != null) {
                    int opos = this.position();
                    if (this.bis.seek(0L, Resource.Whence.Set) == -1) {
                        Console.Println("Error seeking to resource!");
                        return null;
                    }
                    byte[] data = new byte[size];
                    if (this.bis.read(data) == -1) {
                        Console.Println("Error loading resource!");
                        return null;
                    }
                    this.bis.seek(opos, Resource.Whence.Set);
                    return data;
                }
                return null;
            }
        }

        @Override
        public boolean isClosed() {
            return this.bis == null && this.buffer == null;
        }

        @Override
        public int remaining() {
            return this.size() - this.position();
        }

        @Override
        public boolean hasRemaining() {
            return this.position() < this.size();
        }

        private class ZipInputStream
        extends BufferedInputStream {
            private static final int DEFAULT_BUFFER_SIZE = 8192;

            public ZipInputStream(InputStream in) {
                super(in, 8192);
            }

            private void reinit() throws IOException {
                this.in = ZipGroup.this.zfile.getInputStream(ZipResource.this.entry);
                this.buf = new byte[8192];
                this.pos = 0;
                this.count = 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public int seek(long offset, Resource.Whence whence) {
                Group group = ZipResource.this.parent;
                synchronized (group) {
                    try {
                        switch (whence) {
                            case End: {
                                offset += (long)ZipResource.this.size;
                            }
                            case Set: {
                                int pos;
                                if (offset < 0L) {
                                    return -1;
                                }
                                if (this.isClosed()) {
                                    this.reinit();
                                }
                                if ((long)(pos = this.position()) < offset) {
                                    this.skip(offset - (long)pos);
                                    break;
                                }
                                if ((long)pos <= offset) break;
                                this.reinit();
                                this.skip(offset);
                                break;
                            }
                            case Current: {
                                if (offset == 0L) break;
                                int opos = this.position();
                                if ((long)opos < (long)opos + offset) {
                                    this.skip(offset);
                                    break;
                                }
                                this.reinit();
                                this.skip((long)opos + offset);
                                break;
                            }
                        }
                        return ZipResource.this.size - this.available();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return -1;
                    }
                }
            }

            private boolean isClosed() {
                if (this.in == null) {
                    return true;
                }
                try {
                    return this.available() == 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int position() {
                Group group = ZipResource.this.parent;
                synchronized (group) {
                    try {
                        return ZipResource.this.size - this.available();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return -1;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b) {
                Group group = ZipResource.this.parent;
                synchronized (group) {
                    return this.read(b, 0, b.length);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b, int off, int len) {
                Group group = ZipResource.this.parent;
                synchronized (group) {
                    int var = -1;
                    try {
                        var = super.read(b, off, len);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return var;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long skip(long n) throws IOException {
                Group group = ZipResource.this.parent;
                synchronized (group) {
                    long n1 = 0L;
                    long sum = 0L;
                    while (sum != n) {
                        n1 = super.skip(n - n1);
                        sum += n1;
                    }
                    return sum;
                }
            }
        }
    }
}

