/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Input;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildController;
import ru.m210projects.Build.Input.TestController;
import ru.m210projects.Build.OnSceenDisplay.Console;

public abstract class BuildControllers {
    public static final int MAXBUTTONS = 64;
    public static final int MAXPOV = 4;
    public static final int MAXAXIS = 12;
    private List<BuildController> gamepads;
    private float deadZone = 0.01f;
    private boolean TestGamepad = false;

    public BuildControllers init() {
        this.gamepads = new ArrayList<BuildController>();
        this.getControllers(this.gamepads);
        if (this.TestGamepad) {
            this.gamepads.add(new TestController());
        }
        if (this.gamepads.size() == 0) {
            Console.Println("No gamepads found.", Console.OSDTEXT_YELLOW);
        } else {
            int i = 0;
            while (i < this.gamepads.size()) {
                BuildController c = this.gamepads.get(i);
                Console.Println("Found controller: \"" + c.getName() + "\" [buttons: " + c.getButtonCount() + " axises: " + c.getAxisCount() + " povs: " + c.getPovCount() + "]", Console.OSDTEXT_YELLOW);
                ++i;
            }
        }
        return this;
    }

    protected abstract void getControllers(List<BuildController> var1);

    public int getControllers() {
        return this.gamepads.size();
    }

    public boolean isValidDevice(int deviceIndex) {
        return this.gamepads.size() > 0 && deviceIndex >= 0 && deviceIndex < this.gamepads.size();
    }

    public String getControllerName(int num) {
        return this.gamepads.get(num).getName();
    }

    public void setDeadZone(float value) {
        this.deadZone = value;
    }

    public boolean buttonPressed() {
        int i = 0;
        while (i < this.gamepads.size()) {
            if (this.gamepads.get(i).buttonPressed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getButtonCount(int num) {
        int size = this.getControllers();
        if (size > 0 && size > num) {
            return this.gamepads.get(num).getButtonCount();
        }
        return 0;
    }

    public void handler() {
        int i = 0;
        while (i < this.gamepads.size()) {
            this.gamepads.get(i).update();
            ++i;
        }
    }

    public void resetButtonStatus() {
        int i = 0;
        while (i < this.gamepads.size()) {
            this.gamepads.get(i).resetButtonStatus();
            ++i;
        }
    }

    public boolean buttonStatusOnce(int deviceIndex, int buttonCode) {
        return this.gamepads.get(deviceIndex).buttonStatusOnce(buttonCode);
    }

    public boolean buttonPressed(int deviceIndex, int buttonCode) {
        return this.gamepads.get(deviceIndex).buttonPressed(buttonCode);
    }

    public boolean buttonStatus(int deviceIndex, int buttonCode) {
        return this.gamepads.get(deviceIndex).buttonStatus(buttonCode);
    }

    public Vector2 getStickValue(int deviceIndex, int aCode1, int aCode2) {
        return this.gamepads.get(deviceIndex).getStickValue(aCode1, aCode2, this.deadZone);
    }
}

