/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Input;

import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.InputCallback;
import ru.m210projects.Build.Strhandler;

public class KeyInput {
    public static final int KEYFIFOSIZ = 64;
    public byte[] keystatus = new byte[257];
    public byte[] keyfifo = new byte[64];
    public byte keyfifoplc;
    public byte keyfifoend;
    public int locmessagelen;
    public static final char[] lockeybuf = new char[40];
    public boolean[] hitkey = new boolean[256];
    public static char[] gdxscantoasc;
    public static char[] gdxscantoascwithshift;

    static {
        char[] cArray = new char[128];
        cArray[7] = 48;
        cArray[8] = 49;
        cArray[9] = 50;
        cArray[10] = 51;
        cArray[11] = 52;
        cArray[12] = 53;
        cArray[13] = 54;
        cArray[14] = 55;
        cArray[15] = 56;
        cArray[16] = 57;
        cArray[17] = 42;
        cArray[29] = 97;
        cArray[30] = 98;
        cArray[31] = 99;
        cArray[32] = 100;
        cArray[33] = 101;
        cArray[34] = 102;
        cArray[35] = 103;
        cArray[36] = 104;
        cArray[37] = 105;
        cArray[38] = 106;
        cArray[39] = 107;
        cArray[40] = 108;
        cArray[41] = 109;
        cArray[42] = 110;
        cArray[43] = 111;
        cArray[44] = 112;
        cArray[45] = 113;
        cArray[46] = 114;
        cArray[47] = 115;
        cArray[48] = 116;
        cArray[49] = 117;
        cArray[50] = 118;
        cArray[51] = 119;
        cArray[52] = 120;
        cArray[53] = 121;
        cArray[54] = 122;
        cArray[55] = 44;
        cArray[56] = 46;
        cArray[62] = 32;
        cArray[68] = 96;
        cArray[69] = 45;
        cArray[70] = 61;
        cArray[71] = 91;
        cArray[72] = 93;
        cArray[73] = 92;
        cArray[74] = 59;
        cArray[75] = 39;
        cArray[76] = 47;
        cArray[81] = 43;
        gdxscantoasc = cArray;
        char[] cArray2 = new char[128];
        cArray2[7] = 41;
        cArray2[8] = 33;
        cArray2[9] = 64;
        cArray2[10] = 35;
        cArray2[11] = 36;
        cArray2[12] = 37;
        cArray2[13] = 94;
        cArray2[14] = 38;
        cArray2[15] = 42;
        cArray2[16] = 40;
        cArray2[17] = 42;
        cArray2[29] = 65;
        cArray2[30] = 66;
        cArray2[31] = 67;
        cArray2[32] = 68;
        cArray2[33] = 69;
        cArray2[34] = 70;
        cArray2[35] = 71;
        cArray2[36] = 72;
        cArray2[37] = 73;
        cArray2[38] = 74;
        cArray2[39] = 75;
        cArray2[40] = 76;
        cArray2[41] = 77;
        cArray2[42] = 78;
        cArray2[43] = 79;
        cArray2[44] = 80;
        cArray2[45] = 81;
        cArray2[46] = 82;
        cArray2[47] = 83;
        cArray2[48] = 84;
        cArray2[49] = 85;
        cArray2[50] = 86;
        cArray2[51] = 87;
        cArray2[52] = 88;
        cArray2[53] = 89;
        cArray2[54] = 90;
        cArray2[55] = 60;
        cArray2[56] = 62;
        cArray2[62] = 32;
        cArray2[68] = 126;
        cArray2[69] = 95;
        cArray2[70] = 43;
        cArray2[71] = 123;
        cArray2[72] = 125;
        cArray2[73] = 124;
        cArray2[74] = 58;
        cArray2[75] = 34;
        cArray2[76] = 63;
        cArray2[81] = 43;
        gdxscantoascwithshift = cArray2;
    }

    public int getKey(int key) {
        return this.keystatus[key];
    }

    public void setKey(int key, int state) {
        this.keystatus[key] = (byte)state;
        if (state != 0) {
            this.keyfifo[this.keyfifoend] = (byte)key;
            this.keyfifo[this.keyfifoend + 1 & 0x3F] = (byte)state;
            this.keyfifoend = (byte)(this.keyfifoend + 2 & 0x3F);
        }
    }

    public void resetKeyStatus() {
        Arrays.fill(this.keystatus, (byte)0);
    }

    public int handleevents() {
        int kb;
        BuildGdx.input.processMessages();
        BuildGdx.input.cursorHandler();
        int rv = 0;
        boolean keyPressed = false;
        if (BuildGdx.input.isKeyPressed(-1)) {
            kb = 1;
            while (kb < 256) {
                if (kb == 224) {
                    kb = 237;
                }
                if (BuildGdx.input.isKeyPressed(kb)) {
                    keyPressed = true;
                    if (!this.hitkey[kb]) {
                        this.keystatus[256] = 1;
                        this.setKey(kb, 1);
                        this.hitkey[kb] = true;
                    }
                } else {
                    this.setKey(kb, 0);
                    this.hitkey[kb] = false;
                }
                ++kb;
            }
        } else {
            kb = 1;
            while (kb < 256) {
                if (kb == 224) {
                    kb = 237;
                }
                this.keystatus[kb] = 0;
                this.hitkey[kb] = false;
                ++kb;
            }
        }
        kb = 0;
        while (kb < 10) {
            int index = 226 + kb;
            if (BuildGdx.input.isButtonPressed(kb)) {
                keyPressed = true;
                if (!this.hitkey[index]) {
                    this.keystatus[256] = 1;
                    this.setKey(index, 1);
                    this.hitkey[index] = true;
                }
            } else {
                this.setKey(index, 0);
                this.hitkey[index] = false;
            }
            ++kb;
        }
        int wheel = BuildGdx.input.getDWheel();
        if (wheel > 0) {
            keyPressed = true;
            if (!this.hitkey[224]) {
                this.keystatus[256] = 1;
                this.setKey(224, 1);
                this.hitkey[224] = true;
            }
        } else if (wheel < 0) {
            keyPressed = true;
            if (!this.hitkey[225]) {
                this.keystatus[256] = 1;
                this.setKey(225, 1);
                this.hitkey[225] = true;
            }
        } else {
            this.setKey(224, 0);
            this.hitkey[224] = false;
            this.setKey(225, 0);
            this.hitkey[225] = false;
        }
        if (!keyPressed) {
            this.keystatus[256] = 0;
        }
        return rv;
    }

    public boolean keyStatusOnce(int keyId) {
        if (keyId > 0 && this.getKey(keyId) == 1) {
            this.setKey(keyId, 0);
            return true;
        }
        return false;
    }

    public boolean keyStatus(int keyId) {
        return keyId > 0 && this.getKey(keyId) == 1;
    }

    public boolean keyPressed(int kb) {
        return this.hitkey[kb];
    }

    public void keyPressed(int kb, boolean press) {
        this.hitkey[kb] = press;
    }

    public void initMessageInput(String text) {
        this.keyfifoend = 0;
        this.keyfifoplc = 0;
        if (text == null) {
            this.locmessagelen = 0;
            KeyInput.lockeybuf[this.locmessagelen] = '\u0000';
        } else if (!text.isEmpty() && !text.equals("Empty")) {
            int len = 0;
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) != '\u0000') {
                    KeyInput.lockeybuf[len++] = text.charAt(i);
                }
                ++i;
            }
            this.locmessagelen = len;
        }
    }

    public char[] getMessageBuffer() {
        return lockeybuf;
    }

    public int getMessageLength() {
        return this.locmessagelen;
    }

    public int putMessage(int maxsize, boolean cursor, boolean overtype, boolean specialSymbols) {
        while (this.keyfifoplc != this.keyfifoend) {
            int ch = this.keyfifo[this.keyfifoplc] & 0xFF;
            byte keystate = this.keyfifo[this.keyfifoplc + 1 & 0x3F];
            this.keyfifoplc = (byte)(this.keyfifoplc + 2 & 0x3F);
            if (keystate == 0) continue;
            if (ch == 131) {
                this.keystatus[131] = 0;
                this.locmessagelen = 0;
                return -1;
            }
            if (ch == 67) {
                this.keystatus[67] = 0;
                if (this.locmessagelen == 0) break;
                --this.locmessagelen;
                KeyInput.lockeybuf[this.locmessagelen] = '\u0000';
            }
            if (ch == 66) {
                this.keystatus[66] = 0;
                return 1;
            }
            if (this.locmessagelen >= maxsize - 1 || ch >= 128 || (ch = specialSymbols && BuildGdx.input.isKeyPressed(59) || BuildGdx.input.isKeyPressed(60) ? gdxscantoascwithshift[ch] : gdxscantoasc[ch]) == 0 || !specialSymbols && (specialSymbols || !Strhandler.isalpha((char)ch) && !Strhandler.isdigit((char)ch) && ch != 32)) continue;
            KeyInput.lockeybuf[this.locmessagelen++] = (char)ch;
        }
        if (cursor) {
            KeyInput.lockeybuf[this.locmessagelen] = (Engine.totalclock & 0x20) != 0 ? 95 : 0;
        }
        return 0;
    }

    public int putMessage(InputCallback callback, boolean cursor) {
        while (this.keyfifoplc != this.keyfifoend) {
            int ch = this.keyfifo[this.keyfifoplc] & 0xFF;
            byte keystate = this.keyfifo[this.keyfifoplc + 1 & 0x3F];
            this.keyfifoplc = (byte)(this.keyfifoplc + 2 & 0x3F);
            if (keystate == 0) continue;
            return callback.run(ch);
        }
        if (cursor) {
            KeyInput.lockeybuf[this.locmessagelen] = (Engine.totalclock & 0x20) != 0 ? 95 : 0;
        }
        return 0;
    }
}

