/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Input;

import com.badlogic.gdx.math.Vector2;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildController;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;

public class TestController
implements BuildController {
    protected String controllerName = "Test controller";
    protected boolean[] buttonStatus;
    protected boolean[] hitButton;
    protected int buttonsNum = 10;
    protected int allButtonsCount;
    protected boolean buttonPressed = false;
    protected Vector2 stickVector = new Vector2();

    public TestController() {
        this.allButtonsCount = this.buttonsNum + 4 + 2;
        this.buttonStatus = new boolean[this.allButtonsCount];
        this.hitButton = new boolean[this.allButtonsCount];
    }

    @Override
    public Vector2 getStickValue(int aCode1, int aCode2, float deadZone) {
        float lx = this.getAxis(aCode1);
        float ly = this.getAxis(aCode2);
        float mag = (float)Math.sqrt(lx * lx + ly * ly);
        float nlx = lx / mag;
        float nly = ly / mag;
        float nlm = 0.0f;
        if (mag > deadZone) {
            if (mag > 1.0f) {
                mag = 1.0f;
            }
            nlm = (mag -= deadZone) / (1.0f - deadZone);
            float x1 = nlx * nlm;
            float y1 = nly * nlm;
            return this.stickVector.set(x1, y1);
        }
        mag = 0.0f;
        nlm = 0.0f;
        return this.stickVector.set(0.0f, 0.0f);
    }

    @Override
    public void update() {
        this.buttonPressed = false;
        int i = 0;
        while (i < this.buttonsNum) {
            if (this.getTestButton(i)) {
                this.buttonPressed = true;
                if (!this.hitButton[i]) {
                    Engine.getInput().setKey(256, 1);
                    this.buttonStatus[i] = true;
                    this.hitButton[i] = true;
                }
            } else {
                this.buttonStatus[i] = false;
                this.hitButton[i] = false;
            }
            ++i;
        }
    }

    private boolean getTestButton(int i) {
        if (i == 0 && BuildGdx.input.isKeyPressed(39)) {
            return true;
        }
        return i == 1 && BuildGdx.input.isKeyPressed(40);
    }

    private float getAxis(int value) {
        if (BuildGdx.input.isKeyPressed(59)) {
            value -= 2;
        }
        if (value == 0) {
            if (BuildGdx.input.isKeyPressed(19)) {
                return -1.0f;
            }
            if (BuildGdx.input.isKeyPressed(20)) {
                return 1.0f;
            }
        }
        if (value == 1) {
            if (BuildGdx.input.isKeyPressed(21)) {
                return -1.0f;
            }
            if (BuildGdx.input.isKeyPressed(22)) {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean buttonPressed() {
        return this.buttonPressed;
    }

    @Override
    public boolean buttonStatus(int buttonCode) {
        return buttonCode >= 0 && buttonCode < this.allButtonsCount && this.buttonStatus[buttonCode];
    }

    @Override
    public void resetButtonStatus() {
        Arrays.fill(this.buttonStatus, false);
    }

    @Override
    public boolean buttonPressed(int buttonCode) {
        if (buttonCode >= 0 && buttonCode < this.allButtonsCount) {
            return this.hitButton[buttonCode];
        }
        return false;
    }

    @Override
    public boolean buttonStatusOnce(int buttonCode) {
        if (buttonCode >= 0 && buttonCode < this.allButtonsCount && this.buttonStatus[buttonCode]) {
            this.buttonStatus[buttonCode] = false;
            return true;
        }
        return false;
    }

    @Override
    public int getButtonCount() {
        return this.allButtonsCount;
    }

    @Override
    public int getAxisCount() {
        return 1;
    }

    @Override
    public int getPovCount() {
        return 0;
    }

    @Override
    public String getName() {
        return this.controllerName;
    }
}

