/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import java.util.ArrayList;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class MenuAudio
extends BuildMenu {
    public MenuButton mApplyChanges;
    public MenuConteiner sSoundDrv;
    public MenuConteiner sMusicDrv;
    public MenuConteiner sResampler;
    public MenuSlider sSound;
    public MenuSlider sVoices;
    public MenuSwitch sSoundSwitch;
    public MenuSlider sMusic;
    public MenuSwitch sMusicSwitch;
    public MenuConteiner sMusicType;
    public int snddriver;
    public int middriver;
    public int resampler;
    public int osnddriver;
    public int omiddriver;
    public int oresampler;
    public int voices;
    public int ovoices;
    public int cdaudio;
    public int ocdaudio;
    private AudioListener listener;

    public MenuAudio(BuildGame app, int posx, int posy, int width, int menuHeight, int separatorHeight, BuildFont menuItems) {
        final BuildConfig cfg = app.pCfg;
        this.addItem(this.getTitle(app, "Audio setup"), false);
        this.sSoundDrv = new MenuConteiner("Sound driver", menuItems, posx, posy += menuHeight, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuAudio.this.snddriver = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    ArrayList<String> names = new ArrayList<String>();
                    BuildAudio.getDeviceslList(BuildAudio.Driver.Sound, names);
                    this.list = new char[names.size()][];
                    int i = 0;
                    while (i < this.list.length) {
                        this.list[i] = ((String)names.get(i)).toCharArray();
                        ++i;
                    }
                }
                MenuAudio.this.snddriver = MenuAudio.this.osnddriver = cfg.snddrv;
                this.num = MenuAudio.this.osnddriver;
                this.list[this.num] = BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) ? BuildGdx.audio.getSound().getName().toCharArray() : "initialization failed".toCharArray();
            }
        };
        this.sMusicDrv = new MenuConteiner("Midi driver", menuItems, posx, posy += menuHeight, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuAudio.this.middriver = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    ArrayList<String> names = new ArrayList<String>();
                    BuildAudio.getDeviceslList(BuildAudio.Driver.Music, names);
                    this.list = new char[names.size()][];
                    int i = 0;
                    while (i < this.list.length) {
                        this.list[i] = ((String)names.get(i)).toCharArray();
                        ++i;
                    }
                }
                MenuAudio.this.middriver = MenuAudio.this.omiddriver = cfg.middrv;
                this.num = MenuAudio.this.omiddriver;
                this.list[this.num] = BuildGdx.audio.IsInited(BuildAudio.Driver.Music) ? BuildGdx.audio.getMusic().getName().toCharArray() : "initialization failed".toCharArray();
            }
        };
        this.sResampler = new MenuConteiner("Resampler", menuItems, posx, posy += menuHeight, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuAudio.this.resampler = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[BuildGdx.audio.getSound().getNumResamplers()][];
                    int i = 0;
                    while (i < this.list.length) {
                        this.list[i] = BuildGdx.audio.getSound().getSoftResamplerName(i).toCharArray();
                        ++i;
                    }
                }
                if (cfg.resampler_num < 0 || cfg.resampler_num >= BuildGdx.audio.getSound().getNumResamplers()) {
                    cfg.resampler_num = 0;
                }
                MenuAudio.this.resampler = MenuAudio.this.oresampler = cfg.resampler_num;
                this.num = MenuAudio.this.oresampler;
            }
        };
        int oposy = posy += separatorHeight;
        posy += menuHeight;
        this.sSound = new MenuSlider(app.pSlider, "Sound volume", menuItems, posx, posy += menuHeight, width, (int)(cfg.soundVolume * 256.0f), 0, 256, 16, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.soundVolume = (float)slider.value / 256.0f;
                BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, cfg.soundVolume);
                if (MenuAudio.this.listener != null) {
                    MenuAudio.this.listener.SoundVolumeChange();
                }
            }
        }, false){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!cfg.noSound && BuildGdx.audio.IsInited(BuildAudio.Driver.Sound));
                super.draw(handler);
            }
        };
        this.sVoices = new MenuSlider(app.pSlider, "Voices", menuItems, posx, posy += menuHeight, width, 0, 8, 256, 8, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                MenuAudio.this.voices = slider.value;
                if (MenuAudio.this.listener != null) {
                    MenuAudio.this.listener.VoicesChange();
                }
            }
        }, true){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!cfg.noSound && BuildGdx.audio.IsInited(BuildAudio.Driver.Sound));
                super.draw(handler);
            }

            @Override
            public void open() {
                MenuAudio.this.voices = MenuAudio.this.ovoices = cfg.maxvoices;
                this.value = MenuAudio.this.ovoices;
            }
        };
        this.sSoundSwitch = new MenuSwitch("Sound", menuItems, posx, oposy += menuHeight, width, !cfg.noSound, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.noSound = !sw.value;
                MenuAudio.this.sSound.mCheckEnableItem(!cfg.noSound);
                MenuAudio.this.sVoices.mCheckEnableItem(!cfg.noSound);
                if (MenuAudio.this.listener != null) {
                    if (sw.value) {
                        MenuAudio.this.listener.SoundOn();
                    } else {
                        MenuAudio.this.listener.SoundOff();
                    }
                }
            }
        }, null, null);
        oposy = posy += separatorHeight;
        posy += menuHeight;
        this.sMusic = new MenuSlider(app.pSlider, "Music volume", menuItems, posx, posy += menuHeight, width, (int)(cfg.musicVolume * 256.0f), 0, 256, 8, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.musicVolume = (float)slider.value / 256.0f;
                BuildGdx.audio.setVolume(BuildAudio.Driver.Music, cfg.musicVolume);
                if (MenuAudio.this.listener != null) {
                    MenuAudio.this.listener.MusicVolumeChange();
                }
            }
        }, false){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!cfg.muteMusic && BuildGdx.audio.IsInited(BuildAudio.Driver.Music));
                super.draw(handler);
            }
        };
        this.sMusicSwitch = new MenuSwitch("Music", menuItems, posx, oposy += menuHeight, width, !cfg.muteMusic, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                boolean bl = cfg.muteMusic = !sw.value;
                if (cfg.muteMusic) {
                    BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
                } else {
                    BuildGdx.audio.setVolume(BuildAudio.Driver.Music, cfg.musicVolume);
                }
                MenuAudio.this.sMusic.mCheckEnableItem(!cfg.muteMusic);
                if (MenuAudio.this.listener != null) {
                    if (sw.value) {
                        MenuAudio.this.listener.MusicOn();
                    } else {
                        MenuAudio.this.listener.MusicOff();
                    }
                }
            }
        }, null, null){

            @Override
            public void draw(MenuHandler handler) {
                this.value = !cfg.muteMusic;
                super.draw(handler);
            }
        };
        this.sMusicType = new MenuConteiner("Music type", menuItems, posx, posy += menuHeight, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuAudio.this.cdaudio = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = MenuAudio.this.getMusicTypeList();
                }
                MenuAudio.this.ocdaudio = this.num = cfg.musicType;
                MenuAudio.this.cdaudio = this.num;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!cfg.muteMusic);
                super.draw(handler);
            }
        };
        MenuProc callback = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                if (MenuAudio.this.snddriver != MenuAudio.this.osnddriver || MenuAudio.this.voices != MenuAudio.this.ovoices || MenuAudio.this.resampler != MenuAudio.this.oresampler) {
                    if (MenuAudio.this.listener != null) {
                        MenuAudio.this.listener.PreDrvChange(BuildAudio.Driver.Sound);
                    }
                    int olddrv = BuildGdx.audio.getDriver(BuildAudio.Driver.Sound);
                    if (MenuAudio.this.snddriver != MenuAudio.this.osnddriver) {
                        BuildGdx.audio.setDriver(BuildAudio.Driver.Sound, MenuAudio.this.snddriver);
                    }
                    if (MenuAudio.this.voices != MenuAudio.this.ovoices) {
                        cfg.maxvoices = MenuAudio.this.voices;
                    }
                    if (MenuAudio.this.resampler != MenuAudio.this.oresampler) {
                        cfg.resampler_num = MenuAudio.this.resampler;
                    }
                    if (MenuAudio.this.SoundRestart(cfg.maxvoices, cfg.resampler_num)) {
                        cfg.snddrv = MenuAudio.this.osnddriver = MenuAudio.this.snddriver;
                        MenuAudio.this.sSoundDrv.list[MenuAudio.this.sSoundDrv.num] = BuildGdx.audio.getSound().getName().toCharArray();
                        MenuAudio.this.ovoices = MenuAudio.this.voices;
                        MenuAudio.this.oresampler = MenuAudio.this.resampler;
                        MenuAudio.this.sResampler.list = new char[BuildGdx.audio.getSound().getNumResamplers()][];
                        int i = 0;
                        while (i < MenuAudio.this.sResampler.list.length) {
                            MenuAudio.this.sResampler.list[i] = BuildGdx.audio.getSound().getSoftResamplerName(i).toCharArray();
                            ++i;
                        }
                        if (cfg.resampler_num < 0 || cfg.resampler_num >= BuildGdx.audio.getSound().getNumResamplers()) {
                            cfg.resampler_num = 0;
                        }
                        MenuAudio.this.resampler = MenuAudio.this.oresampler = cfg.resampler_num;
                        MenuAudio.this.sResampler.num = MenuAudio.this.oresampler;
                    } else {
                        MenuAudio.this.sSoundDrv.list[MenuAudio.this.sSoundDrv.num] = "initialization failed".toCharArray();
                        BuildGdx.audio.setDriver(BuildAudio.Driver.Sound, olddrv);
                    }
                } else {
                    if (MenuAudio.this.listener != null) {
                        MenuAudio.this.listener.PreDrvChange(BuildAudio.Driver.Music);
                    }
                    if (MenuAudio.this.middriver != MenuAudio.this.omiddriver) {
                        int olddrv = BuildGdx.audio.getDriver(BuildAudio.Driver.Music);
                        BuildGdx.audio.setDriver(BuildAudio.Driver.Music, MenuAudio.this.middriver);
                        if (MenuAudio.this.MusicRestart()) {
                            cfg.middrv = MenuAudio.this.omiddriver = MenuAudio.this.middriver;
                            MenuAudio.this.sMusicDrv.list[MenuAudio.this.sMusicDrv.num] = BuildGdx.audio.getMusic().getName().toCharArray();
                        } else {
                            MenuAudio.this.sMusicDrv.list[MenuAudio.this.sMusicDrv.num] = "initialization failed".toCharArray();
                            BuildGdx.audio.setDriver(BuildAudio.Driver.Music, olddrv);
                        }
                    }
                    if (MenuAudio.this.cdaudio != MenuAudio.this.ocdaudio) {
                        cfg.musicType = MenuAudio.this.cdaudio;
                        MenuAudio.this.ocdaudio = MenuAudio.this.cdaudio;
                    }
                }
                if (MenuAudio.this.listener != null) {
                    MenuAudio.this.listener.PostDrvChange();
                }
            }
        };
        this.mApplyChanges = new MenuButton("Apply changes", menuItems, 0, posy += 2 * separatorHeight, 320, 1, 0, null, -1, callback, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuAudio.this.snddriver != MenuAudio.this.osnddriver || MenuAudio.this.middriver != MenuAudio.this.omiddriver || MenuAudio.this.resampler != MenuAudio.this.oresampler || MenuAudio.this.voices != MenuAudio.this.ovoices || MenuAudio.this.cdaudio != MenuAudio.this.ocdaudio);
                super.draw(handler);
            }

            @Override
            public void mCheckEnableItem(boolean nEnable) {
                this.flags = nEnable ? 7 : 3;
            }
        };
        this.addItem(this.sSoundDrv, true);
        this.addItem(this.sMusicDrv, false);
        this.addItem(this.sResampler, false);
        this.addItem(this.sSoundSwitch, false);
        this.addItem(this.sSound, false);
        this.addItem(this.sVoices, false);
        this.addItem(this.sMusicSwitch, false);
        this.addItem(this.sMusic, false);
        this.addItem(this.sMusicType, false);
        this.addItem(this.mApplyChanges, false);
    }

    protected char[][] getMusicTypeList() {
        char[][] list = new char[][]{"midi".toCharArray(), "external".toCharArray(), "cd audio".toCharArray()};
        return list;
    }

    protected void setListener(AudioListener listener) {
        this.listener = listener;
    }

    protected void removeListener() {
        this.listener = null;
    }

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract boolean SoundRestart(int var1, int var2);

    public abstract boolean MusicRestart();

    public class AudioAdapter
    implements AudioListener {
        @Override
        public void PreDrvChange(BuildAudio.Driver drv) {
        }

        @Override
        public void PostDrvChange() {
        }

        @Override
        public void SoundVolumeChange() {
        }

        @Override
        public void VoicesChange() {
        }

        @Override
        public void SoundOn() {
        }

        @Override
        public void SoundOff() {
        }

        @Override
        public void MusicVolumeChange() {
        }

        @Override
        public void MusicOn() {
        }

        @Override
        public void MusicOff() {
        }
    }

    public static interface AudioListener {
        public void PreDrvChange(BuildAudio.Driver var1);

        public void PostDrvChange();

        public void SoundVolumeChange();

        public void VoicesChange();

        public void SoundOn();

        public void SoundOff();

        public void MusicVolumeChange();

        public void MusicOn();

        public void MusicOff();
    }
}

