/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class MenuJoystick
extends BuildMenu {
    public MenuConteiner mJoyDevices;
    public MenuButton mJoyKey;
    public MenuConteiner mJoyTurn;
    public MenuConteiner mJoyLook;
    public MenuConteiner mJoyStrafe;
    public MenuConteiner mJoyMove;
    public MenuSlider mDeadZone;
    public MenuSlider mLookSpeed;
    public MenuSlider mTurnSpeed;
    public MenuSwitch mInvert;
    public MenuJoyList mList;
    public MenuText mText;
    public MenuText mText2;
    public BuildMenu joyButtons;

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract String keyNames(int var1);

    public MenuJoystick(final BuildGame app, int posx, int posy, int width, int menuHeight, int separatorHeight, BuildFont style, int list_len) {
        this.addItem(this.getTitle(app, "Joystick setup"), false);
        final BuildConfig cfg = app.pCfg;
        this.joyButtons = this.getJoyButtonsMenu(this, app, width, style, posx, posy, list_len);
        this.mJoyDevices = new MenuConteiner("Device", style, posx, posy, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                cfg.gJoyDevice = item.num - 1;
            }
        }){

            @Override
            public void open() {
                int controllers = app.pInput.ctrlGetControllers();
                if (this.list == null) {
                    if (controllers > 0) {
                        this.list = new char[controllers + 1][];
                        this.list[0] = "Disabled".toCharArray();
                        int i = 0;
                        while (i < controllers) {
                            this.list[i + 1] = app.pInput.ctrlGetControllerName(i).toCharArray();
                            ++i;
                        }
                    } else {
                        this.list = new char[][]{"No joystick devices found".toCharArray()};
                    }
                }
                int min = 0;
                int max = Math.max(0, controllers);
                int val = cfg.gJoyDevice + 1;
                this.num = val < min ? min : (val > max ? max : val);
            }
        };
        this.mJoyKey = new MenuButton("Configure buttons", style, posx, posy += separatorHeight, width, 1, 0, this.joyButtons, -1, null, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(app.pInput.ctrlGetControllers() > 0 && app.pInput.ctrlIsValidDevice(MenuJoystick.this.mJoyDevices.num - 1));
                super.draw(handler);
            }
        };
        char[][] StickName = new char[][]{"Stick1_Y".toCharArray(), "Stick1_X".toCharArray(), "Stick2_Y".toCharArray(), "Stick2_X".toCharArray()};
        this.mJoyTurn = new MenuConteiner("Turn axis", style, posx, posy += separatorHeight, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                cfg.gJoyTurnAxis = item.num;
            }
        }){

            @Override
            public void open() {
                this.num = cfg.gJoyTurnAxis;
            }
        };
        this.mJoyTurn.list = StickName;
        this.mJoyLook = new MenuConteiner("Look axis", style, posx, posy += menuHeight, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                cfg.gJoyLookAxis = item.num;
            }
        }){

            @Override
            public void open() {
                this.num = cfg.gJoyLookAxis;
            }
        };
        this.mJoyLook.list = StickName;
        this.mJoyStrafe = new MenuConteiner("Strafe axis", style, posx, posy += menuHeight, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                cfg.gJoyStrafeAxis = item.num;
            }
        }){

            @Override
            public void open() {
                this.num = cfg.gJoyStrafeAxis;
            }
        };
        this.mJoyStrafe.list = StickName;
        this.mJoyMove = new MenuConteiner("Move axis", style, posx, posy += menuHeight, width, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                cfg.gJoyMoveAxis = item.num;
            }
        }){

            @Override
            public void open() {
                this.num = cfg.gJoyMoveAxis;
            }
        };
        this.mJoyMove.list = StickName;
        posy += 5;
        this.mDeadZone = new MenuSlider(app.pSlider, "Dead zone", style, posx, posy += menuHeight, width, cfg.gJoyDeadZone, 0, 65536, 2048, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.gJoyDeadZone = slider.value;
                app.pInput.ctrlSetDeadZone((float)cfg.gJoyDeadZone / 65536.0f);
            }
        }, true);
        this.mDeadZone.digitalMax = 65536.0f;
        this.mLookSpeed = new MenuSlider(app.pSlider, "Look speed", style, posx, posy += menuHeight, width, cfg.gJoyLookSpeed, 0, 999424, 4096, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.gJoyLookSpeed = slider.value;
            }
        }, true);
        this.mLookSpeed.digitalMax = 65536.0f;
        this.mTurnSpeed = new MenuSlider(app.pSlider, "Turn speed", style, posx, posy += menuHeight, width, cfg.gJoyTurnSpeed, 0, 999424, 4096, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.gJoyTurnSpeed = slider.value;
            }
        }, true);
        this.mTurnSpeed.digitalMax = 65536.0f;
        this.mInvert = new MenuSwitch("Invert look axis", style, posx, posy += separatorHeight, width, cfg.gJoyInvert, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.gJoyInvert = sw.value;
            }
        }, "Yes", "No");
        this.addItem(this.mJoyDevices, true);
        this.addItem(this.mJoyKey, false);
        this.addItem(this.mJoyTurn, false);
        this.addItem(this.mJoyLook, false);
        this.addItem(this.mJoyStrafe, false);
        this.addItem(this.mJoyMove, false);
        this.addItem(this.mDeadZone, false);
        this.addItem(this.mLookSpeed, false);
        this.addItem(this.mTurnSpeed, false);
        this.addItem(this.mInvert, false);
    }

    public BuildMenu getJoyButtonsMenu(MenuJoystick parent, final BuildGame app, int width, BuildFont style, int posx, int posy, int list_len) {
        BuildMenu menu = new BuildMenu();
        menu.addItem(parent.getTitle(app, "Config. buttons"), false);
        final BuildConfig cfg = app.pCfg;
        final BuildControllers gpmanager = app.pInput.ctrlGetGamepadManager();
        MenuProc callback = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuJoyList item = (MenuJoyList)pItem;
                if (item.l_set == 0) {
                    item.l_pressedId = null;
                    item.l_set = 1;
                } else if (item.l_set == 1) {
                    switch (item.l_pressedId) {
                        case UP: 
                        case DW: 
                        case LEFT: 
                        case RIGHT: 
                        case ENTER: 
                        case ESC: {
                            item.l_set = 0;
                            int kb = 0;
                            while (kb < gpmanager.getButtonCount(cfg.gJoyDevice)) {
                                if (gpmanager.buttonPressed(cfg.gJoyDevice, kb)) {
                                    if (item.l_nFocus < cfg.joymap.length) {
                                        cfg.setButton(cfg.joymap[item.l_nFocus], kb);
                                    } else {
                                        cfg.setButton(cfg.keymap[item.l_nFocus - cfg.joymap.length], kb);
                                    }
                                }
                                ++kb;
                            }
                            break;
                        }
                        default: {
                            if (!gpmanager.isValidDevice(cfg.gJoyDevice)) break;
                            int kb = 0;
                            while (kb < gpmanager.getButtonCount(cfg.gJoyDevice)) {
                                if (gpmanager.buttonStatus(cfg.gJoyDevice, kb)) {
                                    if (item.l_nFocus < cfg.joymap.length) {
                                        cfg.setButton(cfg.joymap[item.l_nFocus], kb);
                                    } else {
                                        cfg.setButton(cfg.keymap[item.l_nFocus - cfg.joymap.length], kb);
                                    }
                                    item.l_set = 0;
                                }
                                ++kb;
                            }
                            break block0;
                        }
                    }
                }
                app.pInput.ctrlResetKeyStatus();
                if (item.l_nFocus == BuildConfig.GameKeys.Show_Console.getNum()) {
                    Console.setCaptureKey(cfg.gpadkeys[item.l_nFocus], 3);
                }
            }
        };
        this.mList = new MenuJoyList(app, style, posx, posy, width, list_len, callback){

            @Override
            public String getKeyName(int keycode) {
                return MenuJoystick.this.keyNames(keycode);
            }
        };
        posy += this.mList.mFontOffset() * list_len;
        this.mText = new MenuText("UP/DOWN = Select action", style, 160, posy += 2 * this.mList.mFontOffset(), 1);
        this.mText2 = new MenuText("Enter = modify  Delete = clear", style, 160, posy += this.mList.mFontOffset(), 1);
        menu.addItem(this.mList, true);
        menu.addItem(this.mText, false);
        menu.addItem(this.mText2, false);
        return menu;
    }
}

