/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Strhandler;

public abstract class MenuFileBrowser
extends MenuItem {
    protected StringList[] list = new StringList[2];
    private Comparator<String> fileComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int c;
            Object o1 = MenuFileBrowser.this.fileUnit.get(s1);
            Object o2 = MenuFileBrowser.this.fileUnit.get(s2);
            ExtProp p1 = MenuFileBrowser.this.getPropertie(o1);
            ExtProp p2 = MenuFileBrowser.this.getPropertie(o2);
            if (p1 != null && p2 != null && (c = p2.priority - p1.priority) != 0) {
                return c;
            }
            if (o1 instanceof FileEntry && o2 instanceof FileEntry) {
                return ((FileEntry)o1).compareTo((FileEntry)o2);
            }
            return s1.compareTo(s2);
        }
    };
    protected HashMap<String, Object> fileUnit = new HashMap();
    protected HashMap<String, ExtProp> extensionProperties = new HashMap();
    protected HashMap<Class<?>, ExtProp> classProperties = new HashMap();
    private final int DIRECTORY = 0;
    private final int FILE = 1;
    public String back = "..";
    protected char[] dirs = "Directories".toCharArray();
    protected char[] ffs = "Files".toCharArray();
    private int touchY;
    private int[] scrollX = new int[2];
    public boolean[] scrollTouch = new boolean[2];
    protected int[] l_nMin;
    protected int[] l_nFocus;
    protected final int nListItems;
    protected final int nItemHeight;
    public String path;
    protected int currColumn;
    protected DirectoryEntry currDir;
    private BuildEngine draw;
    private SliderDrawable slider;
    private int nBackground = 0;
    private int scrollerHeight;
    protected BuildFont topFont;
    protected BuildFont pathFont;
    public int topPal;
    public int pathPal;
    public int listPal;
    public int backgroundPal;
    public int transparent = 1;
    private long checkDirectory;
    protected char[] buffer = new char[40];

    public void registerExtension(String ext, int pal, int priority) {
        this.extensionProperties.put(ext, new ExtProp(pal, priority));
    }

    public void registerClass(Class<?> cl, int pal, int priority) {
        this.classProperties.put(cl, new ExtProp(pal, priority));
    }

    public MenuFileBrowser(BuildGame app, BuildFont font, BuildFont topFont, BuildFont pathFont, int x, int y, int width, int nItemHeight, int nListItems, int nBackground) {
        super(null, font);
        this.list[0] = new StringList();
        this.list[1] = new StringList();
        this.flags = 7;
        this.draw = app.pEngine;
        this.slider = app.pSlider;
        this.x = x;
        this.y = y;
        this.width = width;
        this.nItemHeight = nItemHeight;
        this.nListItems = nListItems;
        this.topFont = topFont;
        this.pathFont = pathFont;
        this.nBackground = nBackground;
        this.l_nMin = new int[2];
        this.l_nFocus = new int[2];
        this.currColumn = 1;
        this.init();
        this.changeDir(BuildGdx.compat.getDirectory(Compat.Path.Game));
    }

    public abstract void init();

    public abstract void handleFile(FileEntry var1);

    public abstract void invoke(Object var1);

    public abstract void handleDirectory(DirectoryEntry var1);

    public String getFileName() {
        return (String)this.list[1].get(this.l_nFocus[1]);
    }

    public DirectoryEntry getDirectory() {
        return this.currDir;
    }

    public int mFontOffset() {
        return this.font.getHeight() + this.nItemHeight;
    }

    private void changeDir(DirectoryEntry dir) {
        if (!dir.checkCacheList() && this.currDir == dir) {
            return;
        }
        this.list[0].clear();
        this.fileUnit.clear();
        this.list[1].clear();
        this.currDir = dir;
        this.path = File.separator;
        if (dir.getRelativePath() != null) {
            this.path = String.valueOf(this.path) + this.currDir.getRelativePath();
        }
        for (DirectoryEntry sdir : dir.getDirectories().values()) {
            if (sdir.getName().equals("<userdir>")) continue;
            this.list[0].add(Strhandler.toLowerCase(sdir.getName()));
        }
        Collections.sort(this.list[0]);
        if (dir.getParent() != null) {
            this.list[0].add(0, this.back);
        }
        this.handleDirectory(dir);
        for (FileEntry file : dir.getFiles().values()) {
            if (this.extensionProperties.get(file.getExtension()) == null) continue;
            this.handleFile(file);
        }
        this.sortFiles();
        this.l_nMin[0] = 0;
        this.l_nFocus[0] = 0;
        this.l_nMin[1] = 0;
        this.l_nFocus[1] = 0;
    }

    public void addFile(Object file, String name) {
        this.fileUnit.put(name, file);
        this.list[1].add(name);
    }

    public void sortFiles() {
        Collections.sort(this.list[1], this.fileComparator);
    }

    protected void drawHeader(int x1, int x2, int y) {
        this.topFont.drawText(x1, y, this.dirs, -32, this.topPal, BuildFont.TextAlign.Left, 2, this.fontShadow);
        this.topFont.drawText(x2, y, this.ffs, -32, this.topPal, BuildFont.TextAlign.Left, 2, this.fontShadow);
    }

    protected void drawPath(int x, int y) {
        this.brDrawText(this.pathFont, Strhandler.toCharArray("path: " + this.path), x, y, -32, this.pathPal, 0, this.x + this.width);
    }

    @Override
    public void draw(MenuHandler handler) {
        int shade;
        int pal;
        int yColNames = this.y + 3;
        int yPath = yColNames + this.topFont.getHeight() + 2;
        int yList = yPath + this.pathFont.getHeight() + 2;
        int scrollerWidth = this.slider.getScrollerWidth();
        this.draw.rotatesprite(this.x << 16, this.y << 16, 65536, 0, this.nBackground, 127, this.backgroundPal, 0x1A | this.transparent, 0, 0, Gameutils.coordsConvertXScaled(this.x + this.width, Gameutils.ConvertType.Normal), Gameutils.coordsConvertYScaled(yList + this.nListItems * this.mFontOffset() + 6));
        int px = this.x + 3;
        this.drawHeader(px, this.x - 3 + this.width - this.topFont.getWidth(this.ffs), yColNames);
        this.drawPath(px += scrollerWidth + 3, yPath);
        int py = yList;
        int i = this.l_nMin[0];
        while (i >= 0 && i < this.l_nMin[0] + this.nListItems && i < this.list[0].size()) {
            pal = this.listPal;
            shade = handler.getShade(this.currColumn == 0 && i == this.l_nFocus[0] ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            if (this.currColumn == 0 && i == this.l_nFocus[0]) {
                pal = handler.getPal(this.font, this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            }
            this.text = Strhandler.toCharArray((String)this.list[0].get(i));
            this.brDrawText(this.font, this.text, px, py, shade, pal, 0, this.x + this.width / 2 - 4);
            py += this.mFontOffset();
            ++i;
        }
        py = yList;
        i = this.l_nMin[1];
        while (i >= 0 && i < this.l_nMin[1] + this.nListItems && i < this.list[1].size()) {
            int itemPal;
            pal = this.listPal;
            if (this.currColumn == 1 && i == this.l_nFocus[1]) {
                pal = handler.getPal(this.font, this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            }
            shade = handler.getShade(this.currColumn == 1 && i == this.l_nFocus[1] ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            String name = (String)this.list[1].get(i);
            this.text = this.toChars(name);
            Object obj = this.fileUnit.get(name);
            ExtProp p = this.getPropertie(obj);
            if (p != null && (itemPal = p.pal) != 0) {
                pal = itemPal;
            }
            px = this.x + this.width - this.font.getWidth(this.text) - scrollerWidth - 5;
            this.brDrawText(this.font, this.text, px, py, shade, pal, this.x + this.width / 2 + 4, this.x + this.width);
            py += this.mFontOffset();
            ++i;
        }
        this.scrollerHeight = this.nListItems * this.mFontOffset();
        int nList = Gameutils.BClipLow(this.list[1].size() - this.nListItems, 1);
        int posy = yList + (this.scrollerHeight - this.slider.getScrollerHeight()) * this.l_nMin[1] / nList;
        this.scrollX[1] = this.x + this.width - scrollerWidth - 1;
        this.slider.drawScrollerBackground(this.scrollX[1], yList, this.scrollerHeight, 0, 0);
        this.slider.drawScroller(this.scrollX[1], posy, handler.getShade(this.currColumn == 1 ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null), 0);
        nList = Gameutils.BClipLow(this.list[0].size() - this.nListItems, 1);
        posy = yList + (this.scrollerHeight - this.slider.getScrollerHeight()) * this.l_nMin[0] / nList;
        this.scrollX[0] = this.x + 2;
        this.slider.drawScrollerBackground(this.scrollX[0], yList, this.scrollerHeight, 0, 0);
        this.slider.drawScroller(this.scrollX[0], posy, handler.getShade(this.currColumn == 0 ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null), 0);
        if (System.currentTimeMillis() - this.checkDirectory >= 2000L) {
            if (this.currDir.checkCacheList()) {
                this.refreshList();
            }
            this.checkDirectory = System.currentTimeMillis();
        }
    }

    protected void brDrawText(BuildFont font, char[] text, int x, int y, int shade, int pal, int x1, int x2) {
        int tptr = 0;
        int tx = 0;
        while (tptr < text.length && text[tptr] != '\u0000') {
            x = tx + x > x1 && tx + x <= x2 ? (x += font.drawChar(x, y, text[tptr], shade, pal, 2, this.fontShadow)) : (x += font.getWidth(text[tptr]));
            ++tptr;
        }
    }

    protected char[] toChars(String text) {
        int symbols = 0;
        int pos = text.length() - 1;
        int len = Math.min(text.length(), this.buffer.length - 1);
        Arrays.fill(this.buffer, '\u0000');
        while (pos >= 1 && symbols < len - 1 && text.charAt(pos - 1) != File.separatorChar) {
            ++symbols;
            --pos;
        }
        text.getChars(pos, pos + symbols + 1, this.buffer, 0);
        return this.buffer;
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case MWUP: {
                if (this.l_nMin[this.currColumn] > 0) {
                    int n = this.currColumn;
                    this.l_nMin[n] = this.l_nMin[n] - 1;
                }
                return false;
            }
            case MWDW: {
                if (this.l_nMin[this.currColumn] < this.list[this.currColumn].size() - this.nListItems) {
                    int n = this.currColumn;
                    this.l_nMin[n] = this.l_nMin[n] + 1;
                }
                return false;
            }
            case UP: {
                int n = this.currColumn;
                this.l_nFocus[n] = this.l_nFocus[n] - 1;
                if (this.l_nFocus[this.currColumn] >= 0 && this.l_nFocus[this.currColumn] < this.l_nMin[this.currColumn] && this.l_nMin[this.currColumn] > 0) {
                    int n2 = this.currColumn;
                    this.l_nMin[n2] = this.l_nMin[n2] - 1;
                }
                if (this.l_nFocus[this.currColumn] < 0) {
                    this.l_nFocus[this.currColumn] = this.list[this.currColumn].size() - 1;
                    this.l_nMin[this.currColumn] = this.list[this.currColumn].size() - this.nListItems;
                    if (this.l_nMin[this.currColumn] < 0) {
                        this.l_nMin[this.currColumn] = 0;
                    }
                }
                return false;
            }
            case DW: {
                int n = this.currColumn;
                this.l_nFocus[n] = this.l_nFocus[n] + 1;
                if (this.l_nFocus[this.currColumn] >= this.l_nMin[this.currColumn] + this.nListItems && this.l_nFocus[this.currColumn] < this.list[this.currColumn].size()) {
                    int n3 = this.currColumn;
                    this.l_nMin[n3] = this.l_nMin[n3] + 1;
                }
                if (this.l_nFocus[this.currColumn] >= this.list[this.currColumn].size()) {
                    this.l_nFocus[this.currColumn] = 0;
                    this.l_nMin[this.currColumn] = 0;
                }
                return false;
            }
            case LEFT: {
                if (this.list[0].size() > 0) {
                    this.currColumn = 0;
                }
                return false;
            }
            case RIGHT: {
                if (this.list[1].size() > 0) {
                    this.currColumn = 1;
                }
                return false;
            }
            case ENTER: 
            case LMB: {
                if (opt == MenuHandler.MenuOpt.LMB && this.scrollTouch[1] || this.scrollTouch[0]) {
                    if (this.list[this.currColumn].size() <= this.nListItems) {
                        return false;
                    }
                    int nList = Gameutils.BClipLow(this.list[this.currColumn].size() - this.nListItems, 1);
                    int nRange = this.scrollerHeight;
                    int py = this.y + 3 + this.pathFont.getHeight() + 2 + this.topFont.getHeight() + 2;
                    this.l_nFocus[this.currColumn] = -1;
                    this.l_nMin[this.currColumn] = Gameutils.BClipRange((this.touchY - py) * nList / nRange, 0, nList);
                    return false;
                }
                if (this.list[0].size() > 0 && this.currColumn == 0) {
                    if (this.l_nFocus[0] == -1) {
                        return false;
                    }
                    String dirName = (String)this.list[0].get(this.l_nFocus[0]);
                    if (dirName.equals(this.back)) {
                        this.changeDir(this.currDir.getParent());
                    } else {
                        this.changeDir(this.currDir.checkDirectory(dirName));
                    }
                } else if (this.list[1].size() > 0 && this.currColumn == 1) {
                    if (this.l_nFocus[1] == -1) {
                        return false;
                    }
                    this.invoke(this.fileUnit.get(this.getFileName()));
                }
                Engine.getInput().resetKeyStatus();
                return false;
            }
            case ESC: 
            case RMB: {
                return true;
            }
            case BSPACE: {
                if (this.currDir.getParent() != null) {
                    this.changeDir(this.currDir.getParent());
                }
                return false;
            }
            case PGUP: {
                int n = this.currColumn;
                this.l_nFocus[n] = this.l_nFocus[n] - (this.nListItems - 1);
                if (this.l_nFocus[this.currColumn] >= 0 && this.l_nFocus[this.currColumn] < this.l_nMin[this.currColumn] && this.l_nMin[this.currColumn] > 0) {
                    int n4 = this.currColumn;
                    this.l_nMin[n4] = this.l_nMin[n4] - (this.nListItems - 1);
                }
                if (this.l_nFocus[this.currColumn] < 0 || this.l_nMin[this.currColumn] < 0) {
                    this.l_nFocus[this.currColumn] = 0;
                    this.l_nMin[this.currColumn] = 0;
                }
                return false;
            }
            case PGDW: {
                int n = this.currColumn;
                this.l_nFocus[n] = this.l_nFocus[n] + (this.nListItems - 1);
                if (this.l_nFocus[this.currColumn] >= this.l_nMin[this.currColumn] + this.nListItems && this.l_nFocus[this.currColumn] < this.list[this.currColumn].size()) {
                    int n5 = this.currColumn;
                    this.l_nMin[n5] = this.l_nMin[n5] + (this.nListItems - 1);
                }
                if (this.l_nFocus[this.currColumn] >= this.list[this.currColumn].size() || this.l_nMin[this.currColumn] > this.list[this.currColumn].size() - this.nListItems) {
                    this.l_nFocus[this.currColumn] = this.list[this.currColumn].size() - 1;
                    if (this.list[this.currColumn].size() >= this.nListItems) {
                        this.l_nMin[this.currColumn] = this.list[this.currColumn].size() - this.nListItems;
                    } else if (this.l_nFocus[this.currColumn] >= this.l_nMin[this.currColumn] + this.nListItems) {
                        this.l_nMin[this.currColumn] = this.list[this.currColumn].size() - 1;
                    }
                }
                return false;
            }
            case HOME: {
                this.l_nFocus[this.currColumn] = 0;
                this.l_nMin[this.currColumn] = 0;
                return false;
            }
            case END: {
                this.l_nFocus[this.currColumn] = this.list[this.currColumn].size() - 1;
                if (this.list[this.currColumn].size() >= this.nListItems) {
                    this.l_nMin[this.currColumn] = this.list[this.currColumn].size() - this.nListItems;
                } else if (this.l_nFocus[this.currColumn] >= this.l_nMin[this.currColumn] + this.nListItems) {
                    this.l_nMin[this.currColumn] = this.list[this.currColumn].size() - 1;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        this.currColumn = mx >= this.x + this.width / 2 ? 1 : 0;
        if (!BuildGdx.input.isTouched()) {
            this.scrollTouch[0] = false;
            this.scrollTouch[1] = false;
        }
        this.touchY = my;
        if (mx > this.scrollX[this.currColumn] && mx < this.scrollX[this.currColumn] + this.slider.getScrollerWidth()) {
            this.scrollTouch[this.currColumn] = BuildGdx.input.isTouched();
            return true;
        }
        if (!this.scrollTouch[0] && !this.scrollTouch[1] && this.list[this.currColumn].size() > 0) {
            int py = this.y + 3 + this.pathFont.getHeight() + 2 + this.topFont.getHeight() + 2;
            int i = this.l_nMin[this.currColumn];
            while (i >= 0 && i < this.l_nMin[this.currColumn] + this.nListItems && i < this.list[this.currColumn].size()) {
                if (mx > this.x && mx < this.scrollX[1] && my > py && my < py + this.font.getHeight()) {
                    this.l_nFocus[this.currColumn] = i;
                    return true;
                }
                py += this.mFontOffset();
                ++i;
            }
        }
        return false;
    }

    private ExtProp getPropertie(Object obj) {
        if (obj instanceof FileEntry) {
            return this.extensionProperties.get(((FileEntry)obj).getExtension());
        }
        if (obj != null) {
            return this.classProperties.get(obj.getClass());
        }
        return null;
    }

    public void refreshList() {
        DirectoryEntry dir = this.currDir;
        this.currDir = null;
        this.changeDir(dir);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        int i = 0;
        while (i < 2) {
            this.l_nMin[i] = 0;
            this.l_nFocus[i] = 0;
            ++i;
        }
    }

    private class ExtProp {
        int pal;
        int priority;

        public ExtProp(int pal, int priority) {
            this.pal = pal;
            this.priority = priority;
        }
    }

    private class StringList
    extends LinkedList<String> {
        private static final long serialVersionUID = 1L;

        private StringList() {
        }
    }
}

