/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Types.Tile;

public abstract class PrecacheAdapter
extends ScreenAdapter {
    private byte[] tiles;
    private int currentIndex = 0;
    private List<PrecacheQueue> queues = new ArrayList<PrecacheQueue>();
    protected Runnable toLoad;
    protected boolean revalidate;
    protected BuildNet net;
    protected Engine engine;
    protected BuildGame game;
    protected MenuHandler menu;
    protected Runnable glpreload = new Runnable(){

        @Override
        public void run() {
            GLRenderer gl = PrecacheAdapter.this.engine.glrender();
            if (gl != null) {
                gl.preload();
            }
            BuildGdx.app.postRunnable(PrecacheAdapter.this.toLoad);
            PrecacheAdapter.this.toLoad = null;
        }
    };

    public void addQueue(String name, Runnable runnable) {
        if (!this.game.pCfg.gPrecache) {
            return;
        }
        this.queues.add(new PrecacheQueue(name, runnable));
    }

    public void clearQueue() {
        this.queues.clear();
    }

    public PrecacheAdapter(BuildGame game) {
        this.game = game;
        this.engine = game.pEngine;
        this.net = game.pNet;
        this.menu = game.pMenu;
        this.tiles = new byte[Engine.MAXTILES >> 3];
    }

    public ScreenAdapter init(boolean revalidate, Runnable toLoad) {
        this.toLoad = toLoad;
        this.revalidate = revalidate;
        return this;
    }

    @Override
    public void show() {
        this.net.ready2send = false;
        this.currentIndex = 0;
        Arrays.fill(this.tiles, (byte)0);
    }

    public void addTile(int tile) {
        Tile pic = this.engine.getTile(tile);
        if (pic.getType() != Tile.AnimType.None) {
            int frames;
            int i = frames = pic.getFrames();
            while (i >= 0) {
                if (pic.getType() == Tile.AnimType.Backward) {
                    int n = tile - i >> 3;
                    this.tiles[n] = (byte)(this.tiles[n] | 1 << (tile - i & 7));
                } else {
                    int n = tile + i >> 3;
                    this.tiles[n] = (byte)(this.tiles[n] | 1 << (tile + i & 7));
                }
                --i;
            }
        } else {
            int n = tile >> 3;
            this.tiles[n] = (byte)(this.tiles[n] | Engine.pow2char[tile & 7]);
        }
    }

    protected abstract void draw(String var1, int var2);

    @Override
    public void render(float delta) {
        this.engine.clearview(0);
        if (this.currentIndex >= this.queues.size()) {
            this.draw("Getting ready...", -1);
            if (this.toLoad != null) {
                BuildGdx.app.postRunnable(this.glpreload);
            }
        } else {
            PrecacheQueue current = this.queues.get(this.currentIndex);
            this.draw(current.name, this.currentIndex);
            BuildGdx.app.postRunnable(current.runnable);
            ++this.currentIndex;
        }
        this.engine.sampletimer();
        this.engine.nextpage();
    }

    protected void doprecache(int method) {
        GLRenderer gl = this.engine.glrender();
        int i = 0;
        while (i < Engine.MAXTILES) {
            if (this.tiles[i >> 3] == 0) {
                i += 7;
            } else {
                Tile pic = this.engine.getTile(i);
                if ((this.tiles[i >> 3] & Engine.pow2char[i & 7]) != 0 && (this.revalidate || pic.data == null)) {
                    if (pic.data == null) {
                        this.engine.loadtile(i);
                    }
                    if (gl != null) {
                        gl.precache(i, 0, method);
                    }
                }
            }
            ++i;
        }
        Arrays.fill(this.tiles, (byte)0);
    }

    @Override
    public void pause() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        this.game.updateColorCorrection();
    }

    private class PrecacheQueue {
        private String name;
        private Runnable runnable;

        public PrecacheQueue(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }
    }
}

