/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class IndexedTexShader {
    private GLTile palette;
    private GLTile[] palookup;
    private ShaderProgram shaderProg;
    private TextureManager cache;
    private boolean glfog = false;
    private boolean isBinded;
    private int paletteloc;
    private int numshadesloc;
    private int visibilityloc;
    private int palookuploc;
    private int shadeloc;
    private int alphaloc;
    private int draw255loc;
    private int fogenableloc;
    private int fogstartloc;
    private int fogendloc;
    private int fogcolourloc;

    public IndexedTexShader(TextureManager cache) throws Exception {
        String fragment = "uniform sampler2D u_texture;uniform sampler2D u_palette;uniform sampler2D u_palookup;uniform int u_shade;uniform float u_numshades;uniform float u_visibility;uniform float u_alpha;uniform int u_draw255;uniform int u_fogenable;uniform vec4 u_fogcolour;uniform float u_fogstart;uniform float u_fogend;varying float v_dist;float fog(float dist) {\tif(u_fogenable == 1)\t\treturn clamp(1.0 - (u_fogend - dist) / (u_fogend - u_fogstart), 0.0, 1.0);\telse return 0.0;}float getpalookup(int dashade) {\tfloat davis = v_dist * u_visibility;   if(u_fogenable != -1) davis = u_visibility / 64.0;\tfloat shade = (min(max(float(dashade) + davis, 0.0), u_numshades - 1.0));\treturn shade / 64.0;}void main(){\tfloat fi = texture2D(u_texture, gl_TexCoord[0].xy).r;\tif(fi == 1.0)\t{\t\tif(u_draw255 == 0) discard;\t\tfi -= 0.5 / 256.0;\t}\tfloat index = texture2D(u_palookup, vec2(fi, getpalookup(u_shade))).r;\tif(index == 1.0) index -= 0.5 / 256.0;\tvec4 src = vec4(texture2D(u_palette, vec2(index, 0.0)).rgb, u_alpha);   if(u_fogenable == -1) \t\tgl_FragColor = src; \telse gl_FragColor = mix(src, u_fogcolour, fog(v_dist));}";
        String vertex = " varying float v_dist;void main(){\tgl_Position = gl_ModelViewProjectionMatrix * gl_Vertex; /*ftransform();*/\tgl_ClipVertex = gl_ModelViewMatrix * gl_Vertex; v_dist = gl_ClipVertex.z / gl_ClipVertex.w;\tgl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;}";
        this.shaderProg = new ShaderProgram(vertex, fragment);
        if (!this.shaderProg.isCompiled()) {
            throw new Exception("Shader compile error: " + this.shaderProg.getLog());
        }
        this.palookup = new GLTile[256];
        this.cache = cache;
        this.paletteloc = this.shaderProg.getUniformLocation("u_palette");
        this.numshadesloc = this.shaderProg.getUniformLocation("u_numshades");
        this.visibilityloc = this.shaderProg.getUniformLocation("u_visibility");
        this.palookuploc = this.shaderProg.getUniformLocation("u_palookup");
        this.shadeloc = this.shaderProg.getUniformLocation("u_shade");
        this.alphaloc = this.shaderProg.getUniformLocation("u_alpha");
        this.draw255loc = this.shaderProg.getUniformLocation("u_draw255");
        this.fogenableloc = this.shaderProg.getUniformLocation("u_fogenable");
        this.fogstartloc = this.shaderProg.getUniformLocation("u_fogstart");
        this.fogendloc = this.shaderProg.getUniformLocation("u_fogend");
        this.fogcolourloc = this.shaderProg.getUniformLocation("u_fogcolour");
    }

    public void dispose() {
        int i = 0;
        while (i < 256) {
            if (this.palookup[i] != null) {
                this.palookup[i].delete();
            }
            ++i;
        }
        if (this.palette != null) {
            this.palette.delete();
        }
        this.shaderProg.dispose();
        BuildGdx.gl.glActiveTexture(33984);
    }

    public void changePalette(byte[] pal) {
        PaletteData dat = new PaletteData(pal);
        if (this.palette != null) {
            this.palette.update(dat, false);
        } else {
            this.palette = this.cache.newTile(dat, 0, false);
        }
        this.palette.unsafeSetFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, true);
    }

    protected GLTile getpalookup(int pal) {
        if (this.palookup[pal] == null || this.palookup[pal].isInvalidated()) {
            if (Engine.palookup[pal] == null) {
                return this.palookup[0];
            }
            LookupData dat = new LookupData(Engine.palookup[pal]);
            if (this.palookup[pal] != null) {
                this.palookup[pal].setInvalidated(false);
                this.palookup[pal].update(dat, false);
            } else {
                this.palookup[pal] = this.cache.newTile(dat, 0, false);
            }
            this.palookup[pal].unsafeSetFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, true);
        }
        return this.palookup[pal];
    }

    public void invalidatepalookup(int pal) {
        if (this.palookup[pal] != null) {
            this.palookup[pal].setInvalidated(true);
        }
    }

    public void bind() {
        this.shaderProg.begin();
        this.isBinded = true;
        BuildGdx.gl.glActiveTexture(33984);
    }

    public void unbind() {
        this.shaderProg.end();
        this.isBinded = false;
        BuildGdx.gl.glActiveTexture(33984);
    }

    public boolean isBinded() {
        return this.isBinded;
    }

    public void setShaderParams(int pal, int shade) {
        this.shaderProg.setUniformf(this.numshadesloc, (float)Engine.numshades);
        BuildGdx.gl.glActiveTexture(33985);
        this.palette.bind();
        this.shaderProg.setUniformi(this.paletteloc, 1);
        BuildGdx.gl.glActiveTexture(33986);
        this.getpalookup(pal).bind();
        this.shaderProg.setUniformi(this.palookuploc, 2);
        this.shaderProg.setUniformi(this.shadeloc, shade);
        BuildGdx.gl.glActiveTexture(33984);
    }

    public void shaderTransparent(float alpha) {
        this.shaderProg.setUniformf(this.alphaloc, alpha);
    }

    public void shaderDrawLastIndex(boolean draw) {
        this.shaderProg.setUniformi(this.draw255loc, draw ? 1 : 0);
    }

    public void setVisibility(int vis) {
        this.shaderProg.setUniformf(this.visibilityloc, (float)vis / 64.0f);
    }

    public void setFogParams(boolean enable, float start, float end, float[] fogcolor) {
        boolean binded = this.isBinded();
        if (!binded) {
            this.bind();
        }
        if (!this.glfog) {
            this.shaderProg.setUniformi(this.fogenableloc, -1);
        } else {
            this.shaderProg.setUniformi(this.fogenableloc, enable ? 1 : 0);
            if (enable) {
                this.shaderProg.setUniformf(this.fogstartloc, start);
                this.shaderProg.setUniformf(this.fogendloc, end);
                this.shaderProg.setUniform4fv(this.fogcolourloc, fogcolor, 0, 4);
            }
        }
        if (!binded) {
            this.unbind();
        }
    }

    public ShaderProgram getShaderProgram() {
        return this.shaderProg;
    }

    private class LookupData
    extends ShaderData {
        public LookupData(byte[] data) {
            super(data, 256, 64, 1);
        }

        @Override
        public int getGLFormat() {
            return 6409;
        }
    }

    private class PaletteData
    extends ShaderData {
        public PaletteData(byte[] data) {
            super(data, 256, 1, 3);
        }
    }

    private abstract class ShaderData
    extends DummyTileData {
        public ShaderData(byte[] buf, int w, int h, int bytes) {
            super(w, h);
            int len = w * h * bytes;
            this.data.clear();
            this.data.putBytes(buf, 0, len);
        }

        @Override
        public int getGLInternalFormat() {
            return 6407;
        }

        @Override
        public int getGLFormat() {
            return 6407;
        }

        @Override
        public TileData.PixelFormat getPixelFormat() {
            return TileData.PixelFormat.Rgb;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }
    }
}

